/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.resources;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.jst.jsf.common.internal.resource.ContentTypeResolver;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.IWorkspaceJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResourceChangeListener;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResourceContainer;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceFragmentIdentifier;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifier;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifierFactory;
import org.eclipse.jst.jsf.designtime.internal.resources.WorkspaceJSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.WorkspaceJSFResourceContainer;
import org.eclipse.jst.jsf.designtime.internal.resources.WorkspaceJSFResourceLocator;
import org.eclipse.jst.jsf.designtime.tests.resources.ChangeTester;
import org.eclipse.jst.jsf.test.util.junit4.BugRegressionTest;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.eclipse.jst.jsf.test.util.mock.MockContainer;
import org.eclipse.jst.jsf.test.util.mock.MockContentTypeManager;
import org.eclipse.jst.jsf.test.util.mock.MockProject;
import org.eclipse.jst.jsf.test.util.mock.MockResource;
import org.eclipse.jst.jsf.test.util.mock.MockResourceChangeEventFactory;
import org.eclipse.jst.jsf.test.util.mock.MockVirtualComponentQuery;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NoPluginEnvironment.class})
public class TestWorkspaceBasedResourceLocator {
    private WorkspaceJSFResourceLocator _locator;
    private MockWorkspaceContext _context;
    private MockProject _project;
    private MockContainer _webContentFolder;
    private IFolder _resourceRoot;
    private MockResourceChangeEventFactory _eventFactory;
    private ResourceIdentifierFactory _resourceIdFactory;
    private ChangeTester<JSFResourceChangeListener.JSFResourceChangedEvent, JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE> _changeTester;

    @Before
    public void setUp() throws Exception {
        this._context = new MockWorkspaceContext();
        File file = new File("./testdata/TestProject.zip");
        junit.framework.Assert.assertTrue((boolean)file.exists());
        ZipFile zipFile = new ZipFile(file);
        this._project = this._context.loadProject((IPath)new Path("TestProjectTaglibDescriptor"), zipFile, "Test2/");
        this._project.loadAllMembers();
        this._webContentFolder = (MockContainer)this._context.getResource(this._project.getFullPath().append("/WebContent"));
        Assert.assertNotNull((Object)this._webContentFolder);
        this._resourceRoot = this._webContentFolder.getFolder((IPath)new Path("resources"));
        this._locator = new WorkspaceJSFResourceLocator(Collections.EMPTY_LIST, new CopyOnWriteArrayList(), (AbstractVirtualComponentQuery)new MockVirtualComponentQuery((IContainer)this._project.getFolder("/WebContent")), new ContentTypeResolver((IContentTypeManager)new MockContentTypeManager()), (IWorkspace)this._context.getWorkspace());
        this._eventFactory = new MockResourceChangeEventFactory(this._context);
        this._resourceIdFactory = new ResourceIdentifierFactory();
        this._changeTester = new ChangeTester<JSFResourceChangeListener.JSFResourceChangedEvent, JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE>(this._context, this._eventFactory, this._resourceRoot){
            private JSFResourceChangeListener _listener;

            @Override
            protected void installListener() {
                this._events.clear();
                this._listener = new JSFResourceChangeListener(){

                    public void changed(JSFResourceChangeListener.JSFResourceChangedEvent event) {
                        _events.add(event);
                    }
                };
                TestWorkspaceBasedResourceLocator.this._locator.addListener(this._listener);
            }

            @Override
            protected boolean isChangeType(JSFResourceChangeListener.JSFResourceChangedEvent event, JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE type) {
                return event.getChangeType() == type;
            }

            @Override
            protected void removeListener() {
                TestWorkspaceBasedResourceLocator.this._locator.removeListener(this._listener);
            }
        };
    }

    @Test
    public void testLocate() {
        this._locator.start((IProject)this._project);
        List foundResources = (List)this._locator.locate((Object)this._project);
        junit.framework.Assert.assertEquals((int)3, (int)foundResources.size());
        HashSet<String> foundResourceIds = new HashSet<String>();
        for (IJSFResourceFragment res : foundResources) {
            foundResourceIds.add(res.getId().toString());
        }
        junit.framework.Assert.assertTrue((boolean)foundResourceIds.contains("mylib333"));
        junit.framework.Assert.assertTrue((boolean)foundResourceIds.contains("mylib333/tag1.xhtml"));
    }

    @Test
    public void testResourceChangeContents_File() throws ResourceIdentifierFactory.InvalidIdentifierException {
        this._locator.start((IProject)this._project);
        IJSFResourceFragment changeThis = this.findById(this._locator, "mylib333/tag1.xhtml");
        this._changeTester.fireResourceFileContentsChange("mylib333/tag1.xhtml");
        this._changeTester.assertNumEvents(1);
        JSFResourceChangeListener.JSFResourceChangedEvent event = this._changeTester.getEvent(0);
        junit.framework.Assert.assertEquals((Object)JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.CHANGED, (Object)event.getChangeType());
        junit.framework.Assert.assertEquals((Object)changeThis, (Object)event.getOldValue());
        junit.framework.Assert.assertEquals((Object)changeThis, (Object)event.getNewValue());
    }

    @Test
    public void testRemoveChange_File() throws ResourceIdentifierFactory.InvalidIdentifierException {
        this._locator.start((IProject)this._project);
        IJSFResourceFragment changeThis = this.findById(this._locator, "mylib333/tag1.xhtml");
        junit.framework.Assert.assertEquals((int)3, (int)((List)this._locator.locate((Object)this._project)).size());
        this._changeTester.fireResourceFileDelete("mylib333/tag1.xhtml");
        this._changeTester.assertNumEvents(1);
        JSFResourceChangeListener.JSFResourceChangedEvent event = this._changeTester.getEvent(0);
        junit.framework.Assert.assertEquals((Object)JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.REMOVED, (Object)event.getChangeType());
        junit.framework.Assert.assertEquals((Object)changeThis, (Object)event.getOldValue());
        junit.framework.Assert.assertEquals(null, (Object)event.getNewValue());
        junit.framework.Assert.assertEquals((int)2, (int)((List)this._locator.locate((Object)this._project)).size());
    }

    @Test
    public void testAddChange_File_ExistingLib() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)3, (int)((List)this._locator.locate((Object)this._project)).size());
        this._changeTester.fireResourceFileAdd("mylib333/tag2.xhtml");
        this._changeTester.assertNumEvents(1);
        JSFResourceChangeListener.JSFResourceChangedEvent event = this._changeTester.getEvent(0);
        junit.framework.Assert.assertEquals((Object)JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED, (Object)event.getChangeType());
        junit.framework.Assert.assertNull((Object)event.getOldValue());
        Assert.assertNotNull((Object)event.getNewValue());
        junit.framework.Assert.assertEquals((int)4, (int)((List)this._locator.locate((Object)this._project)).size());
    }

    @Test
    public void testAddChange_Folder_NewLib() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)3, (int)((List)this._locator.locate((Object)this._project)).size());
        this._changeTester.fireResourceFolderAdd("mylib999");
        this._changeTester.assertNumEvents(1);
        JSFResourceChangeListener.JSFResourceChangedEvent event = this._changeTester.getEvent(0);
        junit.framework.Assert.assertEquals((Object)JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED, (Object)event.getChangeType());
        junit.framework.Assert.assertNull((Object)event.getOldValue());
        Assert.assertNotNull((Object)event.getNewValue());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.CONTAINER, (Object)event.getNewValue().getType());
        JSFResourceContainer newValue = (JSFResourceContainer)event.getNewValue();
        junit.framework.Assert.assertTrue((boolean)(newValue instanceof WorkspaceJSFResourceContainer));
        IContainer resource = ((WorkspaceJSFResourceContainer)newValue).getResource();
        junit.framework.Assert.assertEquals((int)2, (int)resource.getType());
        junit.framework.Assert.assertEquals((String)"mylib999", (String)resource.getName());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.CONTAINER, (Object)newValue.getType());
        junit.framework.Assert.assertEquals((int)4, (int)((List)this._locator.locate((Object)this._project)).size());
    }

    @Test
    public void testMoveChange_Folder_Rename() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)3, (int)((List)this._locator.locate((Object)this._project)).size());
        this._changeTester.fireResourceFolderRename("mylib333", "mylib1111");
        this._changeTester.assertNumEvents(3);
        JSFResourceChangeListener.JSFResourceChangedEvent event = this._changeTester.getSingleEvent(JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED);
        junit.framework.Assert.assertEquals((Object)JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED, (Object)event.getChangeType());
        junit.framework.Assert.assertNull((Object)event.getOldValue());
        Assert.assertNotNull((Object)event.getNewValue());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.CONTAINER, (Object)event.getNewValue().getType());
        JSFResourceContainer newValue = (JSFResourceContainer)event.getNewValue();
        junit.framework.Assert.assertTrue((boolean)(newValue instanceof WorkspaceJSFResourceContainer));
        IContainer resource = ((WorkspaceJSFResourceContainer)newValue).getResource();
        junit.framework.Assert.assertEquals((int)2, (int)resource.getType());
        junit.framework.Assert.assertEquals((String)"mylib1111", (String)resource.getName());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.CONTAINER, (Object)newValue.getType());
        List<JSFResourceChangeListener.JSFResourceChangedEvent> events = this._changeTester.getEvent(JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.REMOVED);
        junit.framework.Assert.assertEquals((int)2, (int)events.size());
        JSFResourceChangeListener.JSFResourceChangedEvent event2 = events.get(0);
        Assert.assertNotNull((Object)event2.getOldValue());
        junit.framework.Assert.assertNull((Object)event2.getNewValue());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.CONTAINER, (Object)event2.getOldValue().getType());
        JSFResourceContainer oldValue = (JSFResourceContainer)event2.getOldValue();
        junit.framework.Assert.assertTrue((boolean)(oldValue instanceof WorkspaceJSFResourceContainer));
        IContainer resource2 = ((WorkspaceJSFResourceContainer)oldValue).getResource();
        junit.framework.Assert.assertEquals((int)2, (int)resource2.getType());
        junit.framework.Assert.assertEquals((String)"mylib333", (String)resource2.getName());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.CONTAINER, (Object)oldValue.getType());
        event2 = events.get(1);
        Assert.assertNotNull((Object)event2.getOldValue());
        junit.framework.Assert.assertNull((Object)event2.getNewValue());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.RESOURCE, (Object)event2.getOldValue().getType());
        oldValue = (IWorkspaceJSFResourceFragment)event2.getOldValue();
        resource2 = oldValue.getResource();
        junit.framework.Assert.assertEquals((int)1, (int)resource2.getType());
        junit.framework.Assert.assertEquals((String)"tag1.xhtml", (String)resource2.getName());
        junit.framework.Assert.assertEquals((int)3, (int)((List)this._locator.locate((Object)this._project)).size());
    }

    @Test
    public void testMoveChange_File_Rename() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)3, (int)((List)this._locator.locate((Object)this._project)).size());
        this._changeTester.fireResourceFileRename("mylib333/tag1.xhtml", "mylib333/tag2.xhtml");
        this._changeTester.assertNumEvents(2);
        JSFResourceChangeListener.JSFResourceChangedEvent event = this._changeTester.getSingleEvent(JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED);
        junit.framework.Assert.assertEquals((Object)JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED, (Object)event.getChangeType());
        junit.framework.Assert.assertNull((Object)event.getOldValue());
        Assert.assertNotNull((Object)event.getNewValue());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.RESOURCE, (Object)event.getNewValue().getType());
        JSFResource newValue = (JSFResource)event.getNewValue();
        junit.framework.Assert.assertTrue((boolean)(newValue instanceof WorkspaceJSFResource));
        IResource resource = ((WorkspaceJSFResource)newValue).getResource();
        junit.framework.Assert.assertEquals((int)1, (int)resource.getType());
        junit.framework.Assert.assertEquals((String)"tag2.xhtml", (String)resource.getName());
        junit.framework.Assert.assertEquals((String)"mylib333/tag2.xhtml", (String)newValue.getId().toString());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.RESOURCE, (Object)newValue.getType());
        event = this._changeTester.getSingleEvent(JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.REMOVED);
        junit.framework.Assert.assertEquals((Object)JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.REMOVED, (Object)event.getChangeType());
        Assert.assertNotNull((Object)event.getOldValue());
        junit.framework.Assert.assertNull((Object)event.getNewValue());
        junit.framework.Assert.assertEquals((Object)IJSFResourceFragment.Type.RESOURCE, (Object)event.getOldValue().getType());
        JSFResource oldValue = (JSFResource)event.getOldValue();
        junit.framework.Assert.assertTrue((boolean)(oldValue instanceof WorkspaceJSFResource));
        resource = ((WorkspaceJSFResource)oldValue).getResource();
        junit.framework.Assert.assertEquals((int)1, (int)resource.getType());
        junit.framework.Assert.assertEquals((String)"tag1.xhtml", (String)resource.getName());
        junit.framework.Assert.assertEquals((String)"mylib333/tag1.xhtml", (String)oldValue.getId().toString());
        junit.framework.Assert.assertEquals((int)3, (int)((List)this._locator.locate((Object)this._project)).size());
    }

    @Test
    @BugRegressionTest(bugNumber=312358L)
    public void testResourceRootDoesntExist() {
        ((MockResource)this._resourceRoot).setExists(false);
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)1, (int)this._context.getWorkspace().getListeners().size());
        ((MockResource)this._resourceRoot).setExists(true);
        this._changeTester.fireResourceFolderAdd("");
        this._changeTester.assertNumEvents(1);
        this._changeTester.fireResourceFolderAdd("ezcomp");
        this._changeTester.assertNumEvents(1);
        List<JSFResourceChangeListener.JSFResourceChangedEvent> events = this._changeTester.getEvent(JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED);
        junit.framework.Assert.assertEquals((int)1, (int)events.size());
        JSFResourceChangeListener.JSFResourceChangedEvent event = events.get(0);
        ResourceFragmentIdentifier id = event.getNewValue().getId();
        junit.framework.Assert.assertTrue((event.getNewValue().getType() == IJSFResourceFragment.Type.CONTAINER ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"ezcomp", (String)id.getLibraryName());
    }

    @Test
    @BugRegressionTest(bugNumber=312358L)
    public void testRemoveResourceRootAndAdd() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)1, (int)this._context.getWorkspace().getListeners().size());
        this._changeTester.fireResourceFolderDelete("");
        this._changeTester.assertNumEvents(3);
        junit.framework.Assert.assertEquals((int)1, (int)this._context.getWorkspace().getListeners().size());
        this._changeTester.fireResourceFolderAdd("");
        this._changeTester.assertNumEvents(1);
        JSFResourceChangeListener.JSFResourceChangedEvent event = this._changeTester.getSingleEvent(JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED);
        junit.framework.Assert.assertEquals((String)"", (String)event.getNewValue().getId().toString());
        this._changeTester.fireResourceFolderAdd("ezcomp");
        this._changeTester.assertNumEvents(1);
        event = this._changeTester.getSingleEvent(JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED);
        junit.framework.Assert.assertEquals((String)"ezcomp", (String)event.getNewValue().getId().toString());
    }

    @Test
    @BugRegressionTest(bugNumber=312358L)
    public void testAddNoneResourceFolderToWebContent() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)1, (int)this._context.getWorkspace().getListeners().size());
        this._changeTester.fireResourceFolderAdd("../foobar");
        this._changeTester.assertNumEvents(0);
    }

    @Test
    @BugRegressionTest(bugNumber=312358L)
    public void testRemoveRecursiveFolder() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)1, (int)this._context.getWorkspace().getListeners().size());
        this._changeTester.fireResourceFileDeleteRecusive("");
        this._changeTester.assertNumEvents(3);
        List<JSFResourceChangeListener.JSFResourceChangedEvent> events = this._changeTester.getEvent(JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.REMOVED);
        junit.framework.Assert.assertEquals((int)3, (int)events.size());
        HashSet<String> ids = new HashSet<String>();
        for (JSFResourceChangeListener.JSFResourceChangedEvent event : events) {
            ids.add(event.getOldValue().getId().toString());
        }
        junit.framework.Assert.assertTrue((boolean)ids.contains(""));
        junit.framework.Assert.assertTrue((boolean)ids.contains("mylib333"));
        junit.framework.Assert.assertTrue((boolean)ids.contains("mylib333/tag1.xhtml"));
        junit.framework.Assert.assertEquals((int)3, (int)ids.size());
    }

    @Test
    @BugRegressionTest(bugNumber=314145L)
    public void testRenameFileInRootFolder() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)1, (int)this._context.getWorkspace().getListeners().size());
        this._changeTester.fireResourceFileRename("../t11.jsp", "../t11.jspx");
        this._changeTester.assertNumEvents(0);
    }

    @Test
    @BugRegressionTest(bugNumber=318478L)
    public void testAddInvalidResource() {
        this._locator.start((IProject)this._project);
        junit.framework.Assert.assertEquals((int)1, (int)this._context.getWorkspace().getListeners().size());
        this._changeTester.fireResourceFolderAdd("mylib");
        this._changeTester.assertNumEvents(1);
        this._changeTester.fireResourceFolderAdd("mylib/invalidDir");
        this._changeTester.assertNumEvents(1);
        this._changeTester.fireResourceFileAdd("mylib/invalidDir/file.css");
        this._changeTester.assertNumEvents(0);
    }

    private IJSFResourceFragment findById(WorkspaceJSFResourceLocator locator, String id) throws ResourceIdentifierFactory.InvalidIdentifierException {
        ResourceIdentifier resId = this._resourceIdFactory.createLibraryResource(id);
        Assert.assertNotNull((Object)resId);
        List located = (List)this._locator.locate((Object)this._project);
        for (IJSFResourceFragment res : located) {
            if (!res.getId().equals((Object)resId)) continue;
            return res;
        }
        return null;
    }
}

