/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.SearchTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public class JavaSearchTests
extends AbstractJavaSearchTests
implements IJavaScriptSearchConstants {
    static /* synthetic */ Class class$0;

    public JavaSearchTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaSearchTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaSearchTests.buildModelTestSuite(clazz);
    }

    protected void copyDirectory(File sourceDir, File targetDir) throws IOException {
        if (!targetDir.exists()) {
            super.copyDirectory(sourceDir, targetDir);
        }
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        if (JAVA_PROJECT == null) {
            JAVA_PROJECT = this.setUpJavaProject("JSSearch");
        }
    }

    public void tearDownSuite() throws Exception {
        if (JAVA_SEARCH_SUITES == null) {
            this.deleteProject("JSSearch");
        } else {
            JAVA_SEARCH_SUITES.remove(((Object)((Object)this)).getClass());
            if (JAVA_SEARCH_SUITES.size() == 0) {
                this.deleteProject("JSSearch");
            }
        }
        super.tearDownSuite();
    }

    public void test00() throws CoreException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("JSSearch", "src", "p", "A.js");
        IFunction constructor = compilationUnit.getFunction("A", new String[]{"QX;"});
        this.search((IJavaScriptElement)constructor, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.js any A(any) [A]", this.resultCollector);
    }

    public void test01() throws CoreException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("JSSearch", "src", "p", "A.js");
        IFunction constructor = compilationUnit.getFunction("A", new String[]{"QX;"});
        this.search((IJavaScriptElement)constructor, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.js any A(any) [A]", this.resultCollector);
    }

    public void test02() throws CoreException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("JSSearch", "src", "p", "A.js");
        IFunction constructor = compilationUnit.getFunction("A", new String[]{"QX;"});
        this.search((IJavaScriptElement)constructor, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.js any main(any) [A(0)]", this.resultCollector);
    }

    public void test03() throws CoreException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("JSSearch", "src", "p", "A.js");
        IField field = compilationUnit.getField("x");
        this.search((IJavaScriptElement)field, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.js x [x]", this.resultCollector);
    }

    public void test04() throws CoreException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("JSSearch", "src", "p", "A.js");
        IField field = compilationUnit.getField("x");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.js any A(any) [x]", this.resultCollector);
    }

    public void test05() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "cls1.js").getType("MyClass");
        IFunction method = type.getFunction("someMethod", new String[0]);
        this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/cls1.js any MyClass_someMethod() [MyClass_someMethod]", this.resultCollector);
    }

    public void test06() throws CoreException {
        IFunction method = this.getCompilationUnit("JSSearch", "src", "a6", "A.js").getFunction("m", new String[0]);
        this.searchDeclarationsOfAccessedFields((IJavaScriptElement)method, this.resultCollector);
        this.assertSearchResults("src/a6/A.js a6.P.f [P.prototype.f=1]", this.resultCollector);
    }

    public void testCoreException() throws CoreException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("JSSearch", "src", "p", "A.js");
        IFunction method = compilationUnit.getFunction("A", new String[]{"QX;"});
        SearchRequestor result = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                throw new CoreException((IStatus)new JavaModelStatus(-1, "test"));
            }
        };
        try {
            this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), result);
        }
        catch (CoreException e) {
            JavaSearchTests.assertEquals((String)"Unexpected CoreException has been thrown", (String)"test", (String)e.getStatus().getMessage());
            return;
        }
        JavaSearchTests.assertTrue((String)"CoreException should have been thrown", (boolean)false);
    }

    public void testDeclarationOfAccessedFields1() throws CoreException {
        IFunction method = this.getCompilationUnit("JSSearch", "src", "a5", "B.js").getType("C").getFunction("i", new String[0]);
        this.searchDeclarationsOfAccessedFields((IJavaScriptElement)method, this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testDeclarationOfReferencedTypes02() throws CoreException {
        IFunction method = this.getCompilationUnit("JSSearch", "src", "a7", "X.js").getType("X").getFunction("foo", new String[0]);
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)method, this.resultCollector);
        this.assertSearchResults("src/a7/X.java a7.MyException [MyException]", this.resultCollector);
    }

    public void testDeclarationOfReferencedTypes03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JSSearch", "src", "c1", "A.js");
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)unit, this.resultCollector);
        this.assertSearchResults("src/c1/I.java c1.I [I]", this.resultCollector);
    }

    public void testDeclarationOfReferencedTypes04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JSSearch", "src", "c1", "B.js");
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)unit, this.resultCollector);
        this.assertSearchResults("src/c1/I.java c1.I [I]", this.resultCollector);
    }

    public void testDeclarationOfReferencedTypes05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JSSearch", "src", "c2", "A.js");
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)unit, this.resultCollector);
        this.assertSearchResults("src/c3/C.java c3.C [C]", this.resultCollector);
    }

    public void testDeclarationOfReferencedTypes06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JSSearch", "src", "d1", "X.js");
        IType innerType = unit.getType("X").getType("Inner");
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)innerType, this.resultCollector);
        this.assertSearchResults("src/d2/Y.java d2.Y [Y]", this.resultCollector);
    }

    public void testDeclarationOfReferencedTypes07() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "r7");
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)pkg, this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testDeclarationOfReferencedTypes08() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "r7");
        AbstractJavaSearchTests.JavaSearchResultCollector result = new AbstractJavaSearchTests.JavaSearchResultCollector(){

            public void beginReporting() {
                this.results.append("Starting search...");
            }

            public void endReporting() {
                this.results.append("\nDone searching.");
            }
        };
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)pkg, result);
        this.assertSearchResults("Starting search...\nDone searching.", result);
    }

    public void testDeclarationOfReferencedTypes09() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("JavaSearch15/src/p3/X.js");
        AbstractJavaSearchTests.JavaSearchResultCollector result = new AbstractJavaSearchTests.JavaSearchResultCollector(){

            public void beginReporting() {
                this.results.append("Starting search...");
            }

            public void endReporting() {
                this.results.append("\nDone searching.");
            }
        };
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)cu, result);
        this.assertSearchResults("Starting search...\n" + this.getExternalJCLPathString("1.5") + " java.lang.Object\n" + "Done searching.", result);
    }

    public void testDeclarationsOfSentMessages01() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("JSSearch", "src", "", "Test.js");
        this.searchDeclarationsOfSentMessages((IJavaScriptElement)cu, this.resultCollector);
        this.assertSearchResults("src/p/X.java void p.X.foo(int, String, X) [foo(int i, String s, X x)]\nsrc/p/Y.java void p.Y.bar() [bar()]\nsrc/p/Z.java void p.Z.foo(int, String, X) [foo(int i, String s, X x)]\nsrc/p/A.java void p.A.foo(int, String, X) [foo()]", this.resultCollector);
    }

    public void testDeclarationsOfSentMessages02() throws CoreException {
        IFunction method = this.getCompilationUnit("JSSearch", "src", "a5", "B.js").getType("C").getFunction("i", new String[0]);
        this.searchDeclarationsOfSentMessages((IJavaScriptElement)method, this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testFieldDeclaration01() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "A.js").getType("A");
        IField field = type.getField("x");
        this.search((IJavaScriptElement)field, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.java p.A.x [x]", this.resultCollector);
    }

    public void testFieldDeclaration02() throws CoreException {
        IType type = this.getClassFile("JSSearch", "MyJar.jar", "p1", "A.class").getType();
        IField field = type.getField("field");
        this.search((IJavaScriptElement)field, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("MyJar.jar p1.A.field [No source]", this.resultCollector);
    }

    public void testFieldDeclaration03() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "B.js").getType("B");
        IField field = type.getField("open");
        this.search((IJavaScriptElement)field, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/B.java B.open [open]", this.resultCollector);
    }

    public void testFieldDeclaration04() throws CoreException {
        this.search("class*path", 4, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/c5/Test.java c5.Test.class_path [class_path]", this.resultCollector);
    }

    public void testFieldReference01() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p8", "A.js").getType("A");
        IField field = type.getField("g");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p8/A.java void p8.A.m() [g]\nsrc/p8/A.java void p8.B.m() [g]", this.resultCollector);
    }

    public void testFieldReference02() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p9", "X.js").getType("X");
        IField field = type.getField("f");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p9/X.java void p9.X.m() [f]", this.resultCollector);
    }

    public void testFieldReference03() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "q8", "EclipseTest.js").getType("EclipseTest");
        IField field = type.getField("test");
        this.resultCollector.showPotential = false;
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope());
        this.assertSearchResults("src/q8/EclipseTest.java void q8.EclipseTest.main(String[]) [test]");
    }

    public void testFieldReference04() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "a2", "X.js").getType("X");
        IField field = type.getField("length");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/a2/X.java void a2.X.foo() [length]", this.resultCollector);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFieldReference05() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "b1", "A.js").getType("A");
        IField field = type.getField("x");
        Hashtable options = JavaScriptCore.getOptions();
        String currentOption = (String)options.get("org.eclipse.wst.jsdt.core.compiler.compliance");
        options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.4");
        JavaScriptCore.setOptions((Hashtable)options);
        try {
            this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
            this.assertSearchResults("src/b1/B.java void b1.B.foo() [x]", this.resultCollector);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            options.put("org.eclipse.wst.jsdt.core.compiler.compliance", currentOption);
            JavaScriptCore.setOptions((Hashtable)options);
            throw throwable;
        }
        {
            Object var5_7 = null;
            options.put("org.eclipse.wst.jsdt.core.compiler.compliance", currentOption);
        }
        JavaScriptCore.setOptions((Hashtable)options);
    }

    public void testFieldReference06() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "c4", "X.js").getType("X");
        IField field = type.getField("x");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/c4/X.java int c4.X.foo() [x]", this.resultCollector);
    }

    public void testFieldReference07() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "s5", "A.js").getType("A");
        IField field = type.getField("b");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/s5/A.java void s5.A.method() [b]", this.resultCollector);
    }

    public void testFieldReference08() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "A.js").getType("A");
        IField field = type.getField("x");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/Test.java void Test.main(String[]) [x]\nsrc/p/A.java p.A(X) [x]", this.resultCollector);
    }

    public void testFieldReference09() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "A.js").getType("A");
        IField field = type.getField("x");
        this.search((IJavaScriptElement)field, 4, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/Test.java void Test.main(String[]) [x]", this.resultCollector);
    }

    public void testFieldReference10() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "A.js").getType("A");
        IField field = type.getField("x");
        this.search((IJavaScriptElement)field, 5, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.java p.A(X) [x]", this.resultCollector);
    }

    public void testFieldReference11() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p5", "A.js").getType("A");
        IField field = type.getField("x");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p5/A.java void p5.A.k() [x]\nsrc/p5/A.java void p5.A.k() [x]\nsrc/p5/A.java void p5.A.k() [x]", this.resultCollector);
    }

    public void testFieldReference12() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "A.js").getType("A");
        IField field = type.getField("DEBUG");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.java void p.A.foo() [DEBUG]", this.resultCollector);
    }

    public void testFieldReference13() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "O.js").getType("O");
        IField field = type.getField("y");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/O.java void O$I.y() [y]", this.resultCollector);
    }

    public void testFieldReference14() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "D.js").getType("D");
        IField field = type.getField("h");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/D.java void void D.g():<anonymous>#1.run() [h]", this.resultCollector);
    }

    public void testFieldReference15() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p6", "A.js").getType("A");
        IField field = type.getField("f");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p6/A.java void p6.A.m() [f]\nsrc/p6/A.java void p6.B.m() [f]\nsrc/p6/A.java void p6.B.m() [f]", this.resultCollector);
        type = this.getCompilationUnit("JSSearch", "src", "p6", "A.js").getType("AA");
        field = type.getField("f");
        this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p6/A.java void p6.B.m() [f]", this.resultCollector);
    }

    public void testFieldReference16() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "a4", "X.js").getType("X");
        IField field = type.getField("field");
        this.search((IJavaScriptElement)field, 4, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/a4/X.java void a4.X.foo() [field]", this.resultCollector);
        this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search((IJavaScriptElement)field, 5, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/a4/X.java void a4.X.foo() [field]", this.resultCollector);
    }

    public void testFieldReference17() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "a8", "A.js").getType("A");
        IField field = type.getField("a");
        this.search((IJavaScriptElement)field, 5, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testFieldReference18() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "s3", "A.js").getType("A");
        IField field = type.getField("field");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/s3/A.java int s3.A.bar() [field]", this.resultCollector);
    }

    public void testFieldReference19() throws CoreException {
        this.search("d6.X.CONSTANT", 4, 2, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.getPackageFragment("JSSearch", "src", "d6")}), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/d6/Y.java d6.Y.T [CONSTANT]", this.resultCollector);
    }

    public void testFieldReference20() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "s4", "X.js").getType("X");
        IField field = type.getField("x");
        this.resultCollector.showInsideDoc = true;
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/s4/X.java int s4.X.foo() [x] OUTSIDE_JAVADOC\nsrc/s4/X.java void s4.X.bar() [x] INSIDE_JAVADOC", this.resultCollector);
    }

    public void testInterfaceImplementors1() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "I.js").getType("I");
        this.search((IJavaScriptElement)type, 1, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/InterfaceImplementors.java InterfaceImplementors [p.I]\nsrc/p/X.java p.X [I]", this.resultCollector);
        type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search((IJavaScriptElement)type, 1, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/Y.java p.Y [X]", this.resultCollector);
    }

    public void testInterfaceImplementors2() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "r2", "I.js").getType("I");
        this.search((IJavaScriptElement)type, 1, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/r2/X.java r2.X.field:<anonymous>#1 [I]", this.resultCollector);
    }

    public void testLocalVariableDeclaration1() throws CoreException {
        ILocalVariable localVar = this.getLocalVariable("/JavaSearch/src/f1/X.js", "var1 = 1;", "var1");
        this.search((IJavaScriptElement)localVar, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/f1/X.java void f1.X.foo1().var1 [var1]", this.resultCollector);
    }

    public void testLocalVariableDeclaration2() throws CoreException {
        ILocalVariable localVar = this.getLocalVariable("/JavaSearch/src/f1/X.js", "var2 = new X();", "var2");
        this.search((IJavaScriptElement)localVar, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/f1/X.java void f1.X.foo2().var2 [var2]", this.resultCollector);
    }

    public void testLocalVariableOccurrences1() throws CoreException {
        ILocalVariable localVar = this.getLocalVariable("/JavaSearch/src/f1/X.js", "var1 = 1;", "var1");
        this.search((IJavaScriptElement)localVar, 3, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/f1/X.java void f1.X.foo1().var1 [var1]\nsrc/f1/X.java void f1.X.foo1() [var1]", this.resultCollector);
    }

    public void testLocalVariableOccurrences2() throws CoreException {
        ILocalVariable localVar = this.getLocalVariable("/JavaSearch/src/f1/X.js", "var2 = new X();", "var2");
        this.search((IJavaScriptElement)localVar, 3, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/f1/X.java void f1.X.foo2().var2 [var2]\nsrc/f1/X.java void f1.X.foo2() [var2]", this.resultCollector);
    }

    public void testLocalVariableReference1() throws CoreException {
        ILocalVariable localVar = this.getLocalVariable("/JavaSearch/src/f1/X.js", "var1 = 1;", "var1");
        this.search((IJavaScriptElement)localVar, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/f1/X.java void f1.X.foo1() [var1]", this.resultCollector);
    }

    public void testLocalVariableReference2() throws CoreException {
        ILocalVariable localVar = this.getLocalVariable("/JavaSearch/src/f1/X.js", "var2 = new X();", "var2");
        this.search((IJavaScriptElement)localVar, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/f1/X.java void f1.X.foo2() [var2]", this.resultCollector);
    }

    public void testLocalVariableReference3() throws CoreException {
        IClassFile classFile = this.getClassFile("JSSearch", "test48725.jar", "p48725", "X.class");
        ILocalVariable localVar = (ILocalVariable)this.codeSelect((ISourceReference)classFile, "local = 1;", "local")[0];
        this.search((IJavaScriptElement)localVar, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("test48725.jar int p48725.<anonymous>.bar()", this.resultCollector);
    }

    public void testMethodDeclaration01() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        IFunction method = type.getFunction("foo", new String[]{"I", "QString;", "QX;"});
        this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/X.java void p.X.foo(int, String, X) [foo]\nsrc/p/Z.java void p.Z.foo(int, String, X) [foo]", this.resultCollector);
    }

    public void testMethodDeclaration02() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "e2", "X.js").getType("X");
        this.search("foo(String, String)", 1, 0, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type}), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/e2/X.java void e2.X.foo(String, String) [foo]", this.resultCollector);
    }

    public void testMethodDeclaration03() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X").getType("Inner");
        IFunction method = type.getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/X.java String p.X$Inner.foo() [foo]", this.resultCollector);
    }

    public void testMethodDeclaration04() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        this.search("foo", 1, 0, SearchEngine.createHierarchyScope((IType)type), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/p/X.java void p.X.foo(int, String, X) [foo]\nsrc/p/Z.java void p.Z.foo(int, String, X) [foo]", this.resultCollector);
    }

    public void testMethodDeclaration05() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        IFunction method = type.getFunction("foo", new String[]{"I", "QString;", "QX;"});
        this.search((IJavaScriptElement)method, 0, SearchEngine.createHierarchyScope((IType)type), this.resultCollector);
        this.assertSearchResults("src/p/X.java void p.X.foo(int, String, X) [foo]\nsrc/p/Z.java void p.Z.foo(int, String, X) [foo]", this.resultCollector);
    }

    public void testMethodDeclaration06() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "d3", "A.js").getType("B");
        IFunction method = type.getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 0, SearchEngine.createHierarchyScope((IType)type), this.resultCollector);
        this.assertSearchResults("src/d3/A.java void d3.B.foo() [foo]", this.resultCollector);
    }

    public void testMethodDeclaration07() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type.getPackageFragment()});
        this.search("main(String[])", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/p/A.java void p.A.main(String[]) [main]", this.resultCollector);
    }

    public void testMethodDeclaration08() throws CoreException {
        IType type = this.getClassFile("JSSearch", "MyJar.jar", "p1", "A.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"Ljava.lang.String;"});
        this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("MyJar.jar boolean p1.A.foo(java.lang.String) [No source]", this.resultCollector);
    }

    public void testMethodDeclaration09() throws CoreException {
        this.search("foo24346", 1, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/c6/X.java void c6.X.x:<anonymous>#1.foo24346() [foo24346]", this.resultCollector);
    }

    public void testMethodDeclaration10() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "e8", "A.js").getType("A");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type.getPackageFragment()});
        this.search("m() int", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/e8/A.java void e8.A.m() [m]", this.resultCollector);
    }

    public void testMethodDeclaration11() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JSSearch", "otherSrc()", "", "X92210.js");
        JavaSearchTests.assertNotNull((String)"Should have found an unit", (Object)unit);
        IJavaScriptElement root = unit.getAncestor(3);
        JavaSearchTests.assertNotNull((String)"Should have found package fragment root", (Object)root);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{root});
        this.search("foo", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("otherSrc()/X92210.java void X92210.foo() [foo]", this.resultCollector);
    }

    public void testMethodReference01() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "q5", "AQ.js").getType("I");
        IFunction method = type.getFunction("k", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/q5/AQ.java void q5.T.m() [k()]", this.resultCollector);
    }

    public void testMethodReference02() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "q6", "CD.js").getType("AQ");
        IFunction method = type.getFunction("k", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/q6/CD.java void q6.AQE.k() [k()]", this.resultCollector);
    }

    public void testMethodReference03() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "q7", "AQ.js").getType("I");
        IFunction method = type.getFunction("k", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/q7/AQ.java void q7.D.h() [k()]", this.resultCollector);
    }

    public void testMethodReference04() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "b2", "Y.js").getType("Y");
        IFunction method = type.getFunction("foo", new String[]{"QX.Inner;"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/b2/Z.java void b2.Z.bar() [foo(inner)]", this.resultCollector);
    }

    public void testMethodReference05() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch/src/e9/A.js").getType("A").getFunction("foo", new String[0]).getType("", 1);
        IFunction method = type.getFunction("bar", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/e9/A.java void e9.A.foo() [bar()]", this.resultCollector);
    }

    public void testMethodReference06() throws CoreException {
        IFunction method = this.getCompilationUnit("JavaSearch/src/f3/X.js").getType("X").getFunction("bar", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/f3/X.java void void f3.X.foo():<anonymous>#2.foobar() [bar()]\nsrc/f3/X.java void void f3.X.foo():Y#2.foobar() [bar()]", this.resultCollector);
    }

    public void testMethodReference07() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        IFunction method = type.getFunction("foo", new String[]{"I", "QString;", "QX;"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/Test.java void Test.main(String[]) [foo(1, \"a\", y)]\nsrc/p/Z.java void p.Z.foo(int, String, X) [foo(i, s, new Y(true))]", this.resultCollector);
    }

    public void testMethodReference08() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "Y.js").getType("Y");
        IFunction method = type.getFunction("bar", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/Test.java void Test.main(String[]) [bar()]", this.resultCollector);
    }

    public void testMethodReference09() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        IFunction method = type.getFunction("bar", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testMethodReference10() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X").getType("Inner");
        IFunction method = type.getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.java void p.A.foo(int, String, X) [foo()]", this.resultCollector);
    }

    public void testMethodReference11() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "sd", "AQ.js").getType("AQ");
        IFunction method = type.getFunction("k", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/sd/AQ.java void sd.AQE.k() [k()]", this.resultCollector);
    }

    public void testMethodReference12() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "CA.js").getType("CA");
        IFunction method = type.getFunction("m", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/CA.java void CA$CB.f() [m()]\nsrc/CA.java void CA$CB$CC.f() [m()]", this.resultCollector);
    }

    public void testMethodReference13() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "PR_1GGNOTF.js").getType("PR_1GGNOTF");
        IFunction method = type.getFunction("method", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/PR_1GGNOTF.java void void PR_1GGNOTF.method2():<anonymous>#1.run() [method()]", this.resultCollector);
    }

    public void testMethodReference14() throws CoreException {
        IType type = this.getClassFile("JSSearch", this.getSystemJsPathString(), "java.lang", "Object.class").getType();
        IFunction method = type.getFunction("clone", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/E.java Object E.foo() [clone()]", this.resultCollector);
    }

    public void testMethodReference15() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "s4", "X.js").getType("X");
        IFunction method = type.getFunction("foo", new String[0]);
        this.resultCollector.showInsideDoc = true;
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/s4/X.java void s4.X.bar() [foo()] INSIDE_JAVADOC\nsrc/s4/X.java void s4.X.fred() [foo()] OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testMethodReference16() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/p2/X.js").getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QE;"});
        this.search((IJavaScriptElement)method, 2, ERASURE_RULE, this.getJavaSearchScope15(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/p2/Y.java void p2.Y.bar() [foo(this)]", this.resultCollector);
    }

    public void testMethodReference17() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch/src/b111416/X.js").getType("X");
        IFunction method = type.getFunction("open", new String[]{"QString;"});
        this.resultCollector.showAccuracy = true;
        this.search((IJavaScriptElement)method, 2, ERASURE_RULE, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/b111416/X.java void b111416.X.foo() [open(\"\")] EXACT_MATCH", this.resultCollector);
    }

    public void testOrPattern() throws CoreException {
        IFunction leftMethod = this.getCompilationUnit("JSSearch", "src", "q9", "I.js").getType("I").getFunction("m", new String[0]);
        SearchPattern leftPattern = this.createPattern((IJavaScriptElement)leftMethod, 3);
        IFunction rightMethod = this.getCompilationUnit("JSSearch", "src", "q9", "I.js").getType("A1").getFunction("m", new String[0]);
        SearchPattern rightPattern = this.createPattern((IJavaScriptElement)rightMethod, 3);
        SearchPattern orPattern = SearchPattern.createOrPattern((SearchPattern)leftPattern, (SearchPattern)rightPattern);
        this.resultCollector.showAccuracy = true;
        this.search(orPattern, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/e8/A.java void e8.A.m() [m] POTENTIAL_MATCH\nsrc/q9/I.java void q9.I.m() [m] EXACT_MATCH\nsrc/q9/I.java void q9.A1.m() [m] EXACT_MATCH", this.resultCollector);
    }

    public void testPackageDeclaration1() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "p");
        this.search((IJavaScriptElement)pkg, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p p", this.resultCollector);
    }

    public void testPackageDeclaration2() throws CoreException {
        this.search("p3*", 2, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/p3 p3\nsrc/p3/p2 p3.p2\nsrc/p3/p2/p p3.p2.p", this.resultCollector);
    }

    public void testPackageDeclaration3() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", this.getSystemJsPathString(), "java.lang");
        this.search((IJavaScriptElement)pkg, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults(this.getExternalJCLPath("") + " java.lang", this.resultCollector);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageDeclaration4() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("JSSearch");
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        try {
            int cpLength = originalCP.length;
            IIncludePathEntry[] newCP = new IIncludePathEntry[cpLength + 1];
            System.arraycopy(originalCP, 0, newCP, 0, cpLength);
            newCP[cpLength] = JavaScriptCore.newLibraryEntry((IPath)new Path("/JavaSearch/corrupt.jar"), null, null);
            project.setRawIncludepath(newCP, null);
            this.search("r9", 2, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
            this.assertSearchResults("src/r9 r9", this.resultCollector);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            project.setRawIncludepath(originalCP, null);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        project.setRawIncludepath(originalCP, null);
    }

    /*
     * Exception decompiling
     */
    public void testPackageDeclarationBug117020() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 115->119)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testPackageReference1() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "q2");
        this.search((IJavaScriptElement)pkg, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/q1/B.java void q1.B.m(AA) [q2]", this.resultCollector);
    }

    public void testPackageReference2() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "b8");
        this.search((IJavaScriptElement)pkg, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/b9/Foo.java [b8]", this.resultCollector);
    }

    public void testPackageReference3() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "test47989.jar", "p1");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{pkg.getParent()});
        this.search((IJavaScriptElement)pkg, 2, scope, this.resultCollector);
        this.assertSearchResults("test47989.jar java.lang.Object p2.Y.foo()", this.resultCollector);
    }

    public void testPackageReference4() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "p");
        this.search((IJavaScriptElement)pkg, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/InterfaceImplementors.java InterfaceImplementors [p]\nsrc/Test.java void Test.main(String[]) [p]\nsrc/Test.java void Test.main(String[]) [p]\nsrc/Test.java void Test.main(String[]) [p]\nsrc/Test.java void Test.main(String[]) [p]\nsrc/Test.java void Test.main(String[]) [p]\nsrc/Test.java void Test.main(String[]) [p]\nsrc/Test.java void Test.main(String[]) [p]\nsrc/TypeReferenceInImport/X.java [p]", this.resultCollector);
    }

    public void testPackageReference5() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "p3.p2.p");
        this.search((IJavaScriptElement)pkg, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/PackageReference/A.java [p3.p2.p]\nsrc/PackageReference/B.java [p3.p2.p]\nsrc/PackageReference/C.java PackageReference.C [p3.p2.p]\nsrc/PackageReference/D.java PackageReference.D.x [p3.p2.p]\nsrc/PackageReference/E.java PackageReference.E.x [p3.p2.p]\nsrc/PackageReference/F.java p3.p2.p.X PackageReference.F.foo() [p3.p2.p]\nsrc/PackageReference/G.java void PackageReference.G.foo(p3.p2.p.X) [p3.p2.p]\nsrc/PackageReference/H.java void PackageReference.H.foo() [p3.p2.p]\nsrc/PackageReference/I.java void PackageReference.I.foo() [p3.p2.p]\nsrc/PackageReference/J.java void PackageReference.J.foo() [p3.p2.p]", this.resultCollector);
    }

    public void testPackageReference6() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "p3.p2");
        this.search((IJavaScriptElement)pkg, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/PackageReference/K.java [p3.p2]", this.resultCollector);
    }

    public void testPackageReference7() throws CoreException {
        this.search("*p2.*", 2, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/PackageReference/A.java [p3.p2.p]\nsrc/PackageReference/B.java [p3.p2.p]\nsrc/PackageReference/C.java PackageReference.C [p3.p2.p]\nsrc/PackageReference/D.java PackageReference.D.x [p3.p2.p]\nsrc/PackageReference/E.java PackageReference.E.x [p3.p2.p]\nsrc/PackageReference/F.java p3.p2.p.X PackageReference.F.foo() [p3.p2.p]\nsrc/PackageReference/G.java void PackageReference.G.foo(p3.p2.p.X) [p3.p2.p]\nsrc/PackageReference/H.java void PackageReference.H.foo() [p3.p2.p]\nsrc/PackageReference/I.java void PackageReference.I.foo() [p3.p2.p]\nsrc/PackageReference/J.java void PackageReference.J.foo() [p3.p2.p]", this.resultCollector);
    }

    public void testPackageReference8() throws CoreException {
        this.search("*", 2, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.resultCollector.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPotentialMatchInBinary1() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("JSSearch");
        IIncludePathEntry[] classpath = project.getRawIncludepath();
        try {
            int length = classpath.length;
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[length + 1];
            System.arraycopy(classpath, 0, newClasspath, 0, length);
            newClasspath[length] = JavaScriptCore.newLibraryEntry((IPath)new Path("/JavaSearch/AbortCompilation.jar"), null, null);
            project.setRawIncludepath(newClasspath, null);
            this.resultCollector.showAccuracy = true;
            this.search("MissingFieldType.*", 4, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
            this.assertSearchResults("AbortCompilation.jar AbortCompilation.MissingFieldType.field [No source] POTENTIAL_MATCH\nAbortCompilation.jar AbortCompilation.MissingFieldType.missing [No source] POTENTIAL_MATCH\nAbortCompilation.jar AbortCompilation.MissingFieldType.otherField [No source] POTENTIAL_MATCH", this.resultCollector);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            project.setRawIncludepath(classpath, null);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        project.setRawIncludepath(classpath, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPotentialMatchInBinary2() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("JSSearch");
        IIncludePathEntry[] classpath = project.getRawIncludepath();
        try {
            int length = classpath.length;
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[length + 1];
            System.arraycopy(classpath, 0, newClasspath, 0, length);
            newClasspath[length] = JavaScriptCore.newLibraryEntry((IPath)new Path("/JavaSearch/AbortCompilation.jar"), null, null);
            project.setRawIncludepath(newClasspath, null);
            this.resultCollector.showAccuracy = true;
            this.search("MissingArgumentType.foo*", 1, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
            this.assertSearchResults("AbortCompilation.jar void AbortCompilation.MissingArgumentType.foo() [No source] POTENTIAL_MATCH\nAbortCompilation.jar void AbortCompilation.MissingArgumentType.foo(java.util.EventListener) [No source] POTENTIAL_MATCH\nAbortCompilation.jar void AbortCompilation.MissingArgumentType.foo2() [No source] POTENTIAL_MATCH", this.resultCollector);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            project.setRawIncludepath(classpath, null);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        project.setRawIncludepath(classpath, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPotentialMatchInBinary3() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("JSSearch");
        IIncludePathEntry[] classpath = project.getRawIncludepath();
        try {
            int length = classpath.length;
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[length + 1];
            System.arraycopy(classpath, 0, newClasspath, 0, length);
            newClasspath[length] = JavaScriptCore.newLibraryEntry((IPath)new Path("/JavaSearch/AbortCompilation.jar"), null, null);
            project.setRawIncludepath(newClasspath, null);
            this.resultCollector.showAccuracy = true;
            this.search("Missing*", 0, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
            this.assertSearchResults("AbortCompilation.jar AbortCompilation.EnclosingType$MissingEnclosingType [No source] EXACT_MATCH\nAbortCompilation.jar AbortCompilation.MissingArgumentType [No source] EXACT_MATCH\nAbortCompilation.jar AbortCompilation.MissingFieldType [No source] EXACT_MATCH", this.resultCollector);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            project.setRawIncludepath(classpath, null);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        project.setRawIncludepath(classpath, null);
    }

    public void testSearchScope01() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("JSSearch", "src", "a9", "A.js");
        IType type = cu.getType("C");
        IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        JavaSearchTests.assertTrue((String)"a9.C should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)type));
        JavaSearchTests.assertTrue((String)"a9.A should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)cu.getType("A")));
        JavaSearchTests.assertTrue((String)"a9.B should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)cu.getType("B")));
        JavaSearchTests.assertTrue((String)"a9/A.java should be included in hierarchy scope", (boolean)scope.encloses(cu.getUnderlyingResource().getFullPath().toString()));
    }

    public void testSearchScope02() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "b3", "X.js").getType("X");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type});
        this.search((IJavaScriptElement)type, 2, scope, this.resultCollector);
        this.assertSearchResults("src/b3/X.java b3.X.field [X]\nsrc/b3/X.java Object b3.X.foo() [X]\nsrc/b3/X.java b3.X$Y.field2 [X]\nsrc/b3/X.java Object b3.X$Y.foo2() [X]", this.resultCollector);
    }

    public void testSearchScope03() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "b3", "X.js").getType("X");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type.getField("field")});
        this.search((IJavaScriptElement)type, 2, scope, this.resultCollector);
        this.assertSearchResults("src/b3/X.java b3.X.field [X]", this.resultCollector);
    }

    public void testSearchScope04() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "b3", "X.js").getType("X");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type.getType("Y")});
        this.search((IJavaScriptElement)type, 2, scope, this.resultCollector);
        this.assertSearchResults("src/b3/X.java b3.X$Y.field2 [X]\nsrc/b3/X.java Object b3.X$Y.foo2() [X]", this.resultCollector);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSearchScope05() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceLocation = new File(workspace.getRoot().getLocation().toOSString());
        File minimalJar = new File(workspaceLocation, "JavaSearch/MyJar.jar");
        File externalJar = new File(workspaceLocation.getParentFile().getCanonicalFile(), "MyJar.jar");
        IJavaScriptProject project = this.getJavaProject("JSSearch");
        IIncludePathEntry[] classpath = project.getRawIncludepath();
        try {
            this.copy(minimalJar, externalJar);
            int length = classpath.length;
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[length];
            System.arraycopy(classpath, 0, newClasspath, 0, length - 1);
            String externalPath = externalJar.getAbsolutePath();
            newClasspath[length - 1] = JavaScriptCore.newLibraryEntry((IPath)new Path(externalPath), (IPath)new Path(externalPath), null, (boolean)false);
            project.setRawIncludepath(newClasspath, null);
            IPackageFragment pkg = this.getPackageFragment("JSSearch", externalPath, "p0");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{pkg});
            this.search("X", 0, 0, scope, (SearchRequestor)this.resultCollector);
            this.assertSearchResults(externalJar + " p0.X", this.resultCollector);
            IClassFile classFile = pkg.getClassFile("X.class");
            scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{classFile});
            this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            this.search((IJavaScriptElement)classFile.getType(), 0, scope, this.resultCollector);
            this.assertSearchResults(String.valueOf(externalJar.getCanonicalPath()) + " p0.X", this.resultCollector);
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            Util.delete((File)externalJar);
            project.setRawIncludepath(classpath, null);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        Util.delete((File)externalJar);
        project.setRawIncludepath(classpath, null);
    }

    public void testTypeDeclaration01() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        this.search((IJavaScriptElement)type, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/X.java p.X [X]", this.resultCollector);
    }

    public void testTypeDeclaration02() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JavaSearch15", "src", "p1");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{pkg});
        this.search("Y", 0, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/p1/Y.java p1.Y [Y]", this.resultCollector);
    }

    public void testTypeDeclaration03() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "d8");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{pkg});
        this.search("A", 0, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/d8/A.java d8.A [A]", this.resultCollector);
    }

    public void testTypeDeclaration04() throws CoreException {
        IType type = this.getClassFile("JSSearch", "MyJar.jar", "p1", "A.class").getType();
        this.search((IJavaScriptElement)type, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("MyJar.jar p1.A [No source]", this.resultCollector);
    }

    public void testTypeDeclaration05() throws CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("JSSearch", "test20631.jar");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{root});
        this.search("Y", 0, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("test20631.jar Y", this.resultCollector);
    }

    public void testTypeDeclaration06() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p3", "X.js").getType("X");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type.getPackageFragment()});
        this.search("X", 0, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/p3/X.java p3.X [X]", this.resultCollector);
    }

    public void testTypeDeclaration07() throws CoreException {
        IType type = this.getClassFile("JSSearch", "MyJar.jar", "p0", "X.class").getType();
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type.getPackageFragment()});
        this.search("X", 0, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("MyJar.jar p0.X [No source]", this.resultCollector);
    }

    public void testTypeDeclaration08() throws CoreException {
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.getPackageFragment("JSSearch", "src", "b4")});
        this.search("*.A.B", 0, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/b4/A.java b4.A$B [B]", this.resultCollector);
    }

    public void testTypeDeclaration09() throws CoreException {
        this.search("X?Z", 0, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/r5/XYZ.java r5.XYZ [XYZ]", this.resultCollector);
    }

    public void testTypeDeclaration10() throws CoreException {
        this.search("AbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyz", 0, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/c9/X.java c9.AbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyz [AbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyz]", this.resultCollector);
    }

    public void testTypeDeclaration11() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "f2");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{pkg});
        this.search("Y", 0, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/f2/X.java Object f2.X.foo1():Y#1 [Y]", this.resultCollector);
    }

    public void testTypeDeclaration12() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch/src/f2/X.js").getType("X").getFunction("foo1", new String[0]).getType("Y", 1);
        IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
        this.search((IJavaScriptElement)type, 0, scope, this.resultCollector);
        this.assertSearchResults("src/f2/X.java Object f2.X.foo1():Y#1 [Y]", this.resultCollector);
    }

    public void testTypeOccurence1() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "r", "A.js").getType("A").getType("X");
        this.search((IJavaScriptElement)type, 3, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/r/A.java A r.A.m() [X]\nsrc/r/A.java r.A$X [X]\nsrc/r/A.java r.A$X(X) [X]\nsrc/r/A.java r.A$X(X) [X]\nsrc/r/A.java r.B.ax [A.X]\nsrc/r/A.java r.B.ax [X]", this.resultCollector);
    }

    public void testTypeOccurence2() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "r8", "B.js").getType("B");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type.getPackageFragment()});
        this.search((IJavaScriptElement)type, 3, scope, this.resultCollector);
        this.assertSearchResults("src/r8/A.java [B]", this.resultCollector);
    }

    public void testTypeOccurence3() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "e4", "A.js").getType("A").getType("Inner");
        this.search((IJavaScriptElement)type, 3, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/e4/A.java e4.A$Inner [Inner]\nsrc/e5/A1.java [e4.A.Inner]\nsrc/e5/A1.java e5.A1.a [e4.A.Inner]\nsrc/e5/A1.java e5.A1.a1 [e4.A.Inner]\nsrc/e5/A1.java e5.A1.a2 [Inner]\nsrc/e5/A1.java e5.A1.a3 [Inner]", this.resultCollector);
    }

    public void testTypeOccurence4() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "q3", "A$B.js").getType("A$B");
        this.search((IJavaScriptElement)type, 3, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/q3/A$B.java q3.A$B [A$B]\nsrc/q4/C.java Object q4.C.foo() [q3.A$B]", this.resultCollector);
    }

    public void testTypeReference01() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "X.js").getType("X");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/X.java AA() [X]", this.resultCollector);
    }

    public void testTypeReference02() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "d7", "A.js").getType("A");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/d7/A.java d7.A.A [A]\nsrc/d7/A.java A d7.A.A(A) [A]\nsrc/d7/A.java A d7.A.A(A) [A]", this.resultCollector);
    }

    public void testTypeReference03() throws CoreException {
        SearchPattern pattern = this.createPattern("x31985", 0, 2, false);
        this.resultCollector.showAccuracy = true;
        this.search(pattern, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/e3/X31985.java e3.X31985.CONSTANT [X31985] EXACT_MATCH\nsrc/e3/Y31985.java Object e3.Y31985.foo() [X31985] EXACT_MATCH", this.resultCollector);
    }

    public void testTypeReference04() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "otherSrc()", "", "X31997.js").getType("X31997");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("otherSrc()/Y31997.java Y31997 [X31997]", this.resultCollector);
    }

    public void testTypeReference05() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "test48261.jar", "p", "X.js").getType("X");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type.getPackageFragment().getParent()});
        this.search((IJavaScriptElement)type, 2, scope, this.resultCollector);
        this.assertSearchResults("test48261.jar p.X$Y(java.lang.String)", this.resultCollector);
    }

    public void testTypeReference06() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/p1/X.js").getType("X");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope15("p1", true), this.resultCollector);
        this.assertSearchResults("src/p1/Y.java Object p1.Y.foo() [X]", this.resultCollector);
    }

    public void testTypeReference07() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.java p.A.x [X]\nsrc/p/A.java p.A(X) [X]\nsrc/p/A.java void p.A.foo(int, String, X) [X]\nsrc/p/X.java p.X() [X]\nsrc/p/X.java void p.X.foo(int, String, X) [X]\nsrc/p/Y.java p.Y [X]\nsrc/p/Z.java void p.Z.foo(int, String, X) [X]", this.resultCollector);
    }

    public void testTypeReference08() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "Test.js").getType("Test");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/Test.java Test.static {} [Test]\nsrc/Test.java Test.static {} [Test]\nsrc/Test.java Test.{} [Test]", this.resultCollector);
    }

    public void testTypeReference09() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "TypeReferenceAsSingleNameReference.js").getType("TypeReferenceAsSingleNameReference");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/TypeReferenceAsSingleNameReference.java void TypeReferenceAsSingleNameReference.hasReference() [TypeReferenceAsSingleNameReference]\nsrc/TypeReferenceAsSingleNameReference.java void TypeReferenceAsSingleNameReference.hasReference() [TypeReferenceAsSingleNameReference]", this.resultCollector);
    }

    public void testTypeReference10() throws CoreException {
        this.resultCollector.showAccuracy = true;
        this.search("BMember", 0, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("References to type BMember", "src/MemberTypeReference/Azz.java void MemberTypeReference.Azz.poo() [BMember] EXACT_MATCH\nsrc/MemberTypeReference/Azz.java MemberTypeReference.Azz$AzzMember [BMember] EXACT_MATCH\nsrc/MemberTypeReference/Azz.java MemberTypeReference.X.val [BMember] EXACT_MATCH\nsrc/MemberTypeReference/B.java void MemberTypeReference.B.foo() [BMember] EXACT_MATCH", this.resultCollector);
        this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.resultCollector.showAccuracy = true;
        this.search("AzzMember", 0, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("References to type AzzMember", "src/MemberTypeReference/Azz.java MemberTypeReference.X.val [AzzMember] EXACT_MATCH\nsrc/MemberTypeReference/B.java void MemberTypeReference.B.foo() [AzzMember] EXACT_MATCH", this.resultCollector);
        this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.resultCollector.showAccuracy = true;
        this.search("BMember", 4, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("References to field BMember", "", this.resultCollector);
    }

    public void testTypeReference11() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "a", "A.js").getType("A").getType("X");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/a/A.java a.B.ax [A.X]\nsrc/a/A.java a.B.sx [S.X]", this.resultCollector);
    }

    public void testTypeReference12() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "ObjectMemberTypeReference", "A.js").getType("A").getType("Object");
        this.resultCollector.showAccuracy = true;
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/ObjectMemberTypeReference/A.java void ObjectMemberTypeReference.A.foo() [Object] EXACT_MATCH", this.resultCollector);
    }

    public void testTypeReference13() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "A.js").getType("A");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/Test.java void Test.main(String[]) [p.A]\nsrc/Test.java void Test.main(String[]) [p.A]\nsrc/p/A.java void p.A.foo() [A]", this.resultCollector);
    }

    public void testTypeReference14() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p4", "A.js").getType("A");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p4/A.java p4.A.A [A]\nsrc/p4/A.java p4.X [p4.A]\nsrc/p4/A.java void p4.X.x() [p4.A]", this.resultCollector);
    }

    public void testTypeReference15() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "", "W.js").getType("W");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/W.java int W.m() [W]", this.resultCollector);
    }

    public void testTypeReference16() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "b7", "X.js").getType("SubClass");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/b7/X.java void b7.Test.main(String[]) [SubClass]", this.resultCollector);
    }

    public void testTypeReference17() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p", "X.js").getType("X");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/p/A.java p.A.x [X]\nsrc/p/A.java p.A(X) [X]\nsrc/p/A.java void p.A.foo(int, String, X) [X]\nsrc/p/X.java p.X() [X]\nsrc/p/X.java void p.X.foo(int, String, X) [X]\nsrc/p/Y.java p.Y [X]\nsrc/p/Z.java void p.Z.foo(int, String, X) [X]", this.resultCollector);
    }

    public void testTypeReference18() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "NoReference", "A.js").getType("A");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testTypeReference19() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p2", "Z.js").getType("Z");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/TypeReferenceInImport/X.java [p2.Z]", this.resultCollector);
    }

    public void testTypeReference20() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "r6", "A.js").getType("A");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/r6/B.java [r6.A]\nsrc/r6/B.java [r6.A]\nsrc/r6/B.java [r6.A]\nsrc/r6/B.java [r6.A]\nsrc/r6/B.java [r6.A]\nsrc/r6/B.java [r6.A]", this.resultCollector);
    }

    public void testTypeReference21() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "TypeReferenceInArray", "A.js").getType("A");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/TypeReferenceInArray/A.java TypeReferenceInArray.A.a [A]\nsrc/TypeReferenceInArray/A.java TypeReferenceInArray.A.b [TypeReferenceInArray.A]", this.resultCollector);
    }

    public void testTypeReference22() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "s1", "X.js").getType("X");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/s1/Y.java s1.Y.f [X]", this.resultCollector);
    }

    public void testTypeReference23() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "p7", "A.js").getType("A");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testTypeReference24() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "a7", "X.js").getType("MyException");
        this.resultCollector.showAccuracy = true;
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/a7/X.java void a7.X.foo() [MyException] EXACT_MATCH", this.resultCollector);
    }

    public void testTypeReference25() throws CoreException {
        this.search("Zork", 0, 2, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.getPackageFragment("JSSearch", "src", "b5")}), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/b5/A.java [Zork]\nsrc/b5/A.java b5.A.{} [Zork]\nsrc/b5/A.java b5.A.{} [Zork]\nsrc/b5/A.java b5.A.{} [Zork]", this.resultCollector);
    }

    public void testTypeReference26() throws CoreException {
        this.search("p.Zork", 0, 2, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.getPackageFragment("JSSearch", "src", "b5")}), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/b5/A.java b5.A.{} [Zork]\nsrc/b5/A.java b5.A.{} [Zork]\nsrc/b5/A.java b5.A.{} [Zork]", this.resultCollector);
    }

    public void testTypeReference27() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "r3", "A21485.js").getType("A21485");
        this.resultCollector.showAccuracy = true;
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/r4/B21485.java [r3.A21485] EXACT_MATCH\nsrc/r4/B21485.java r4.B21485 [A21485] POTENTIAL_MATCH", this.resultCollector);
    }

    public void testTypeReference28() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "s3", "A.js").getType("B");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/s3/A.java Object s3.A.foo() [B]", this.resultCollector);
    }

    public void testTypeReference29() throws CoreException {
        this.search("p24741.*", 0, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("test24741.jar q24741.B", this.resultCollector);
    }

    public void testTypeReference30() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "d4");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{pkg});
        SearchPattern pattern = this.createPattern("Y", 0, 2, false);
        this.search(pattern, scope, this.resultCollector);
        this.assertSearchResults("src/d4/X.java Object d4.X.foo() [Y]", this.resultCollector);
    }

    public void testTypeReference31() throws CoreException {
        this.search("d5.X", 0, 2, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.getPackageFragment("JSSearch", "src", "d5")}), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/d5/Y.java d5.Y.T [d5.X]\nsrc/d5/Y.java d5.Y.c [d5.X]\nsrc/d5/Y.java d5.Y.o [d5.X]", this.resultCollector);
    }

    public void testTypeReference32() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "d9.p1", "A.js").getType("A");
        IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        this.search((IJavaScriptElement)type, 2, scope, this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testTypeReference33() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "e1", "A29366.js").getType("A29366");
        this.resultCollector.showAccuracy = true;
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/e1/A29366.java void e1.A29366.foo() [A29366] EXACT_MATCH", this.resultCollector);
    }

    public void testTypeReference34() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "e6", "A.js").getType("A");
        this.resultCollector.showAccuracy = true;
        this.search("B36479", 0, 2, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{type}), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/e6/A.java Object e6.A.foo() [B36479] POTENTIAL_MATCH", this.resultCollector);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTypeReference35() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("JSSearch");
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        try {
            int cpLength = originalCP.length;
            IIncludePathEntry[] newCP = new IIncludePathEntry[cpLength + 1];
            System.arraycopy(originalCP, 0, newCP, 0, cpLength);
            newCP[cpLength] = JavaScriptCore.newLibraryEntry((IPath)new Path("/JavaSearch/corrupt.jar"), null, null);
            project.setRawIncludepath(newCP, null);
            IType type = this.getCompilationUnit("JSSearch", "src", "e7", "A.js").getType("A");
            this.resultCollector.showAccuracy = true;
            this.search((IJavaScriptElement)type, 2, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}), this.resultCollector);
            this.assertSearchResults("src/e7/A.java e7.A.a [A] EXACT_MATCH", this.resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            project.setRawIncludepath(originalCP, null);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        project.setRawIncludepath(originalCP, null);
    }

    public void testTypeReference36() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JSSearch", "src", "f2");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{pkg});
        this.resultCollector.showContext = true;
        this.search("Y", 0, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/f2/X.java Object f2.X.foo1() [\t\treturn new <Y>();]", this.resultCollector);
    }

    public void testTypeReference37() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch/src/f2/X.js").getType("X");
        IFunction method = type.getFunction("foo1", new String[0]);
        IType localType = method.getType("Y", 1);
        IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
        this.resultCollector.showContext = true;
        this.search((IJavaScriptElement)localType, 2, scope, this.resultCollector);
        this.assertSearchResults("src/f2/X.java Object f2.X.foo1() [\t\treturn new <Y>();]", this.resultCollector);
    }

    public void testTypeReference38() throws CoreException {
        IType type = this.getCompilationUnit("JSSearch", "src", "s4", "X.js").getType("X");
        this.resultCollector.showInsideDoc = true;
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/s4/X.java void s4.X.bar() [X] INSIDE_JAVADOC\nsrc/s4/X.java void s4.X.bar() [X] INSIDE_JAVADOC\nsrc/s4/X.java void s4.X.bar() [X] INSIDE_JAVADOC\nsrc/s4/X.java void s4.X.fred() [X] OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testEnum01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "e1", "Team.js").getType("Team");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/a1/Author.java [e1.Team]\nsrc/a1/Author.java [e1.Team]\nsrc/a1/Author.java Team[] a1.Author.name() [Team]\nsrc/a1/Test.java [e1.Team]\nsrc/e1/Test.java void e1.Test.main(String[]) [Team]\nsrc/e1/Test.java void e1.Test.main(String[]) [Team]\nsrc/e1/Test.java Location e1.Test.location(Team) [Team]", this.resultCollector);
    }

    public void testEnum02() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "e1", "Team.js").getType("Team");
        IFunction method = type.getFunction("Team", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope15("e1", false), this.resultCollector);
        this.assertSearchResults("src/e1/Team.java e1.Team.FREDERIC [FREDERIC]", this.resultCollector);
    }

    public void testEnum03() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "e1", "Team.js").getType("Team");
        IFunction method = type.getFunction("Team", new String[]{"I"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope15("e1", false), this.resultCollector);
        this.assertSearchResults("src/e1/Team.java e1.Team.PHILIPPE [PHILIPPE(37)]\nsrc/e1/Team.java e1.Team.DAVID [DAVID(27)]\nsrc/e1/Team.java e1.Team.JEROME [JEROME(33)]\nsrc/e1/Team.java e1.Team.OLIVIER [OLIVIER(35)]\nsrc/e1/Team.java e1.Team.KENT [KENT(40)]", this.resultCollector);
    }

    public void testEnum04() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "e1", "Team.js").getType("Team");
        IFunction method = type.getFunction("age", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope15("e1", false), this.resultCollector);
        this.assertSearchResults("src/e1/Test.java void e1.Test.main(String[]) [age()]", this.resultCollector);
    }

    public void testEnum05() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "e1", "Team.js").getType("Team");
        IFunction method = type.getFunction("isManager", new String[0]);
        this.search((IJavaScriptElement)method, 3, this.getJavaSearchScope15("e1", false), this.resultCollector);
        this.assertSearchResults("src/e1/Team.java boolean e1.Team.PHILIPPE:<anonymous>#1.isManager() [isManager]\nsrc/e1/Team.java boolean e1.Team.isManager() [isManager]\nsrc/e1/Test.java void e1.Test.main(String[]) [isManager()]", this.resultCollector);
    }

    public void testEnum06() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "e1", "Team.js").getType("Team");
        IFunction method = type.getFunction("setRole", new String[]{"Z"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope15("e1", false), this.resultCollector);
        this.assertSearchResults("src/e1/Test.java void e1.Test.main(String[]) [setRole(t.isManager())]", this.resultCollector);
    }

    public void testVarargs01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "v1", "X.js").getType("X");
        IFunction method = type.getFunction("vargs", new String[]{"I", "I"});
        this.search((IJavaScriptElement)method, 3, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/v1/X.java void v1.X.vargs(int, int) [vargs]\nsrc/v1/X.java void v1.X.bar() [vargs(1, 2)]", this.resultCollector);
    }

    public void testVarargs02() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "v1", "X.js").getType("X");
        IFunction method = type.getFunction("vargs", new String[]{"I", "[I"});
        this.search((IJavaScriptElement)method, 3, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/v1/X.java void v1.X.vargs(int, int ...) [vargs]\nsrc/v1/X.java void v1.X.bar() [vargs(1, 2, 3)]\nsrc/v1/X.java void v1.X.bar() [vargs(1, 2, 3, 4, 5, 6)]", this.resultCollector);
    }

    public void testVarargs03() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "v1", "X.js").getType("X");
        IFunction method = type.getFunction("vargs", new String[]{"[QString;"});
        this.search((IJavaScriptElement)method, 3, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/v1/X.java void v1.X.vargs(String ...) [vargs]\nsrc/v1/X.java void v1.X.bar() [vargs(\"x\", \"a\",\"'b\", \"c\")]", this.resultCollector);
    }

    public void testVarargs04() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "v1", "X.js").getType("X");
        IFunction method = type.getFunction("vargs", new String[]{"QString;", "[Z"});
        this.search((IJavaScriptElement)method, 3, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/v1/X.java void v1.X.vargs(String, boolean ...) [vargs]\nsrc/v1/X.java void v1.X.bar() [vargs(\"x\", false, true)]", this.resultCollector);
    }

    public void testVarargs05() throws CoreException {
        this.search("vargs", 1, 0, this.getJavaSearchScope15(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/v1/X.java void v1.X.vargs(int, int) [vargs]\nsrc/v1/X.java void v1.X.vargs(int, int ...) [vargs]\nsrc/v1/X.java void v1.X.vargs(String ...) [vargs]\nsrc/v1/X.java void v1.X.vargs(String, boolean ...) [vargs]", this.resultCollector);
    }

    public void testVarargs06() throws CoreException {
        this.search("vargs", 1, 2, this.getJavaSearchScope15(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/v1/X.java void v1.X.bar() [vargs(1, 2)]\nsrc/v1/X.java void v1.X.bar() [vargs(1, 2, 3)]\nsrc/v1/X.java void v1.X.bar() [vargs(1, 2, 3, 4, 5, 6)]\nsrc/v1/X.java void v1.X.bar() [vargs(\"x\", \"a\",\"'b\", \"c\")]\nsrc/v1/X.java void v1.X.bar() [vargs(\"x\", false, true)]", this.resultCollector);
    }

    public void testAnnotationType01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "a1", "Author.js").getType("Author");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/a1/Test.java a1.Test [Author]\nsrc/a1/Test.java a1.Test.t [Author]\nsrc/a1/Test.java void a1.Test.foo() [Author]", this.resultCollector);
    }

    public void testAnnotationType02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15", "src", "a1", "Test.js");
        IType type = this.selectType(unit, "Author");
        this.search((IJavaScriptElement)type, 0, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/a1/Author.java a1.Author [Author]", this.resultCollector);
    }

    public void testAutoBoxing01() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearch15/src/p/X.js", "package p;\npublic class X {\n\tvoid foo(int x) {}\n\tvoid bar() {\n\t\tfoo(new Integer(0));\n\t}\n}\n");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])this.workingCopies);
        IFunction method = this.workingCopies[0].getType("X").getFunction("foo", new String[]{"I"});
        this.search((IJavaScriptElement)method, 2, scope);
        this.assertSearchResults("src/p/X.java void p.X.bar() [foo(new Integer(0))]");
    }

    public void testStaticImportField01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "s1.pack.age", "S.js").getType("S");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s1/A.java [s1.pack.age.S]\nsrc/s1/A.java [s1.pack.age.S]\nsrc/s1/A.java [s1.pack.age.S]\nsrc/s1/B.java [s1.pack.age.S]\nsrc/s1/B.java [s1.pack.age.S]\nsrc/s1/C.java [s1.pack.age.S]\nsrc/s1/C.java [s1.pack.age.S]\nsrc/s1/D.java [s1.pack.age.S]");
    }

    public void testStaticImportField02() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "s1.pack.age", "S.js").getType("S");
        IField field = type.getField("out");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s1/A.java [out]\nsrc/s1/B.java void s1.B.foo() [out]\nsrc/s1/C.java [out]\nsrc/s1/C.java void s1.C.foo() [out]");
    }

    public void testStaticImportField03() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "s1.pack.age", "S.js").getType("S");
        IType member = type.getType("M");
        this.search((IJavaScriptElement)member, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s1/A.java [s1.pack.age.S.M]\nsrc/s1/B.java [s1.pack.age.S.M]\nsrc/s1/C.java [s1.pack.age.S.M]\nsrc/s1/D.java [s1.pack.age.S.M]\nsrc/s1/D.java void s1.D.foo() [M]\nsrc/s1/D.java void s1.D.foo() [M]");
    }

    public void testStaticImportField04() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "s1.pack.age", "S.js").getType("S");
        IType member = type.getType("M");
        IField field = member.getField("in");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s1/A.java [in]\nsrc/s1/B.java void s1.B.foo() [in]\nsrc/s1/C.java [in]\nsrc/s1/C.java void s1.C.foo() [in]\nsrc/s1/D.java void s1.D.foo() [in]");
    }

    public void testStaticImportMethod01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "s2.pack.age", "S.js").getType("S");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s2/A.java [s2.pack.age.S]\nsrc/s2/A.java [s2.pack.age.S]\nsrc/s2/A.java [s2.pack.age.S]\nsrc/s2/B.java [s2.pack.age.S]\nsrc/s2/B.java [s2.pack.age.S]\nsrc/s2/C.java [s2.pack.age.S]\nsrc/s2/C.java [s2.pack.age.S]\nsrc/s2/D.java [s2.pack.age.S]");
    }

    public void testStaticImportMethod02() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "s2.pack.age", "S.js").getType("S");
        IFunction method = type.getFunction("out", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s2/A.java [s2.pack.age.S.out]\nsrc/s2/B.java void s2.B.foo() [out()]\nsrc/s2/C.java [s2.pack.age.S.out]\nsrc/s2/C.java void s2.C.foo() [out()]");
    }

    public void testStaticImportMethod03() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "s2.pack.age", "S.js").getType("S");
        IType member = type.getType("M");
        this.search((IJavaScriptElement)member, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s2/A.java [s2.pack.age.S.M]\nsrc/s2/B.java [s2.pack.age.S.M]\nsrc/s2/C.java [s2.pack.age.S.M]\nsrc/s2/D.java [s2.pack.age.S.M]\nsrc/s2/D.java void s2.D.foo() [M]\nsrc/s2/D.java void s2.D.foo() [M]");
    }

    public void testStaticImportMethod04() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15", "src", "s2.pack.age", "S.js").getType("S");
        IType member = type.getType("M");
        IFunction method = member.getFunction("in", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s2/A.java [s2.pack.age.S.M.in]\nsrc/s2/B.java void s2.B.foo() [in()]\nsrc/s2/C.java [s2.pack.age.S.M.in]\nsrc/s2/C.java void s2.C.foo() [in()]\nsrc/s2/D.java void s2.D.foo() [in()]");
    }

    public void testStaticImportPackage01() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JavaSearch15", "src", "s1.pack.age");
        this.search((IJavaScriptElement)pkg, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s1/A.java [s1.pack.age]\nsrc/s1/A.java [s1.pack.age]\nsrc/s1/A.java [s1.pack.age]\nsrc/s1/B.java [s1.pack.age]\nsrc/s1/B.java [s1.pack.age]\nsrc/s1/C.java [s1.pack.age]\nsrc/s1/C.java [s1.pack.age]\nsrc/s1/D.java [s1.pack.age]");
    }

    public void testStaticImportPackage02() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JavaSearch15", "src", "s2.pack.age");
        this.search((IJavaScriptElement)pkg, 2, this.getJavaSearchScope15(), this.resultCollector);
        this.assertSearchResults("src/s2/A.java [s2.pack.age]\nsrc/s2/A.java [s2.pack.age]\nsrc/s2/A.java [s2.pack.age]\nsrc/s2/B.java [s2.pack.age]\nsrc/s2/B.java [s2.pack.age]\nsrc/s2/C.java [s2.pack.age]\nsrc/s2/C.java [s2.pack.age]\nsrc/s2/D.java [s2.pack.age]");
    }

    public void testCamelCaseTypePattern01() throws CoreException {
        this.search("RE", 0, 0, 128, this.getJavaSearchScope());
        this.assertSearchResults("src/a3/References.java a3.References [References]\n" + this.getSystemJsPathString() + " java.lang.RuntimeException");
    }

    public void testCamelCaseTypePattern02() throws CoreException {
        this.search("RException", 0, 0, 128, this.getJavaSearchScope());
        this.assertSearchResults(this.getSystemJsPathString() + " java.lang.RuntimeException");
    }

    public void testCamelCaseTypePattern03() throws CoreException {
        this.search("RuntimeException", 0, 0, 128, this.getJavaSearchScope());
        this.assertSearchResults(this.getSystemJsPathString() + " java.lang.RuntimeException");
    }

    public void testCamelCaseTypePattern04() throws CoreException {
        this.search("RUNTIMEEXCEPTION", 0, 0, 128, this.getJavaSearchScope());
        this.assertSearchResults(this.getSystemJsPathString() + " java.lang.RuntimeException");
    }

    public void testCamelCaseTypePattern05() throws CoreException {
        this.search("R*E*", 0, 0, 128, this.getJavaSearchScope());
        this.assertSearchResults("src/a3/References.java a3.References [References]\n" + this.getSystemJsPathString() + " java.lang.RuntimeException");
    }

    public void testCamelCaseTypePattern06() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, 0, "CNS".toCharArray(), 128, 0, this.getJavaSearchScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "java.lang.CloneNotSupportedException", (Object)requestor);
    }

    public void testCamelCaseTypePattern07() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, 0, "AA".toCharArray(), 128, 0, this.getJavaSearchScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "AA\nc9.AbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnopqrstuvwxyz\nd8.AA\np6.AA\nq1.AA", (Object)requestor);
    }

    public void testCamelCaseTypePattern08() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, 0, "aa".toCharArray(), 128, 0, this.getJavaSearchScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "AA\nd8.AA\np6.AA\nq1.AA", (Object)requestor);
    }

    public void testCamelCaseTypePattern09() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, 0, "aa".toCharArray(), 129, 0, this.getJavaSearchScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "AA\nd8.AA\np6.AA\nq1.AA", (Object)requestor);
    }

    public void testBug160323() throws CoreException {
        AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

            public String toString() {
                return this.toFullyQualifiedNamesString();
            }
        };
        new SearchEngine().searchAllTypeNames(null, 0, null, 1, 0, this.getJavaSearchScope(), (TypeNameMatchRequestor)collector, 3, null);
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, 0, null, 1, 0, this.getJavaSearchScope(), (TypeNameRequestor)requestor, 3, null);
        JavaSearchTests.assertEquals((String)"We should get some types!", (int)requestor.size(), (int)collector.size());
        JavaSearchTests.assertEquals((String)"Found types sounds not to be correct", (String)requestor.toString(), (String)collector.toString());
    }
}

