/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestPerformance
extends AbstractPsychoPathTest {
    private static final String COUNT = "count";
    private static final double FUDGE_FACTOR = 1.8;
    private static boolean CHATTY = true;
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public TestPerformance() {
        this.factory.setNamespaceAware(true);
    }

    public void testLinearPerformance() throws Exception {
        this.checkPerformance("count(for $elem in //* return 'hej')", 1, 1000, 15, new DocBuilder(){

            public Document createDocument(int complexity) throws ParserConfigurationException {
                Document document = TestPerformance.this.factory.newDocumentBuilder().newDocument();
                Element root = document.createElementNS("urn:x-root", "xr:Root");
                int count = 1;
                document.appendChild(root);
                int i = 0;
                while (i < complexity) {
                    Element child = root.getOwnerDocument().createElementNS("urn:x-child-" + (i % 5 + 1), "c" + (i % 5 + 1) + ":UpperChild" + (i + 1));
                    root.appendChild(child);
                    count += TestPerformance.this.addChildren(child, 3) + 1;
                    ++i;
                }
                document.setUserData(TestPerformance.COUNT, count, null);
                return document;
            }
        });
    }

    public void testDeepPerformance() throws Exception {
        this.checkPerformance("count(for $elem in //* return 'hej')", 0, 1000, 15, new DocBuilder(){

            public Document createDocument(int complexity) throws ParserConfigurationException {
                TestPerformance.this.factory.setNamespaceAware(true);
                Document document = TestPerformance.this.factory.newDocumentBuilder().newDocument();
                Element root = document.createElementNS("urn:x-root", "xr:Root");
                document.appendChild(root);
                int count = 1;
                Element current = root;
                int i = 0;
                while (i < complexity) {
                    Element child = root.getOwnerDocument().createElementNS("urn:x-child-" + (i % 5 + 1), "c" + (i % 5 + 1) + ":UpperChild" + (i + 1));
                    current.appendChild(child);
                    count += TestPerformance.this.addChildren(child, 2) + 1;
                    current = child;
                    ++i;
                }
                document.setUserData(TestPerformance.COUNT, count, null);
                return document;
            }
        });
    }

    public void testExplosivePerformance() throws Exception {
        this.checkPerformance("count(for $elem in //* return 'hej')", 2, 11, 1, new DocBuilder(){

            public Document createDocument(int complexity) throws ParserConfigurationException {
                TestPerformance.this.factory.setNamespaceAware(true);
                Document document = TestPerformance.this.factory.newDocumentBuilder().newDocument();
                Element root = document.createElementNS("urn:x-root", "xr:Root");
                document.appendChild(root);
                int count = TestPerformance.this.addChildren(root, complexity);
                document.setUserData(TestPerformance.COUNT, count + 1, null);
                return document;
            }
        });
    }

    public void checkPerformance(String xpath, int low, int high, int step, DocBuilder builder) throws Exception {
        DefaultDynamicContext dc = this.setupDynamicContext(null);
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        Document smallDoc = builder.createDocument(low);
        int referenceNodeCount = (Integer)smallDoc.getUserData(COUNT);
        long time = this.timeEvaluation((DynamicContext)dc, path, smallDoc, referenceNodeCount);
        StringBuilder sb = new StringBuilder();
        this.log(sb, "First iteration " + time + " \u00b5s for " + referenceNodeCount + " nodes");
        long timePerComplexity = (long)(1.8 * (double)time / (double)referenceNodeCount);
        this.log(sb, "Expected bound of " + timePerComplexity + " \u00b5s per unit");
        int violations = 0;
        int i = low + 1;
        while (i <= high) {
            Document compareDoc = builder.createDocument(i);
            int nodeCount = (Integer)compareDoc.getUserData(COUNT);
            if (CHATTY) {
                System.out.println("Complexity " + i + " (going to " + high + "): Trying " + nodeCount + " nodes");
            }
            long measured = this.timeEvaluation((DynamicContext)dc, path, compareDoc, nodeCount);
            long actualTime = measured / (long)nodeCount;
            if (CHATTY) {
                System.out.println("At " + nodeCount + " units, time per unit " + actualTime + " \u00b5s");
            }
            if (actualTime > timePerComplexity) {
                this.log(sb, "At " + nodeCount + " units, the time per unit " + actualTime + " \u00b5s was too high, indicating non-linear complexity");
                if (++violations >= 3) {
                    TestPerformance.fail((String)sb.toString());
                }
            }
            i += step;
        }
    }

    private void log(StringBuilder sb, String string) {
        if (CHATTY) {
            System.out.println(string);
        }
        sb.append(string).append("\n");
    }

    private long timeEvaluation(DynamicContext dc, XPath path, Document bigDoc, long expected) throws DynamicError {
        long before = System.nanoTime();
        DefaultEvaluator eval = new DefaultEvaluator(dc, bigDoc);
        String count = eval.evaluate((XPathNode)path).first().string_value();
        TestPerformance.assertEquals((String)("" + expected), (String)count);
        long after = System.nanoTime();
        return (after - before) / 1000L;
    }

    private int addChildren(Element parent, int depth) {
        int count = 0;
        int i = 0;
        while (i < depth * 2) {
            ++count;
            Element child = parent.getOwnerDocument().createElementNS("urn:x-child-" + (i + 1), "c" + (i + 1) + ":Child" + (i + 1));
            parent.appendChild(child);
            count += this.addChildren(child, depth - 2);
            ++i;
        }
        return count;
    }

    public static void main(String[] args) throws Exception {
        TestPerformance tp = new TestPerformance();
        tp.setUp();
        try {
            tp.testLinearPerformance();
        }
        catch (Exception exception) {}
        tp.tearDown();
    }

    static interface DocBuilder {
        public Document createDocument(int var1) throws ParserConfigurationException;
    }
}

