/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.ejb.archiveoperations.IEjbClientProjectCreationDataModelProperties;
import org.eclipse.jst.j2ee.ejb.internal.plugin.EjbPlugin;
import org.eclipse.jst.j2ee.project.facet.JavaUtilityProjectCreationOperation;
import org.eclipse.jst.j2ee.project.facet.UtilityProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EjbClientProjectCreationOperation
extends JavaUtilityProjectCreationOperation
implements IEjbClientProjectCreationDataModelProperties {
    public EjbClientProjectCreationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus stat = OK_STATUS;
        String projectName = this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        String earProjectName = this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.EAR_PROJECT_NAME");
        String javaSourceFolder = this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.SOURCE_FOLDER");
        String defaultOutputFolder = this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.DEFAULT_OUTPUT_FOLDER");
        IRuntime runtime = (IRuntime)this.model.getProperty("IJavaUtilityProjectCreationDataModelProperties.RUNTIME");
        IDataModel dm = null;
        try {
            dm = DataModelFactory.createDataModel((IDataModelProvider)new UtilityProjectCreationDataModelProvider());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel javadm = map.getFacetDataModel("jst.java");
            IDataModel utildm = map.getFacetDataModel("jst.utility");
            javadm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
            javadm.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", (Object)javaSourceFolder);
            if (defaultOutputFolder == null || defaultOutputFolder.length() == 0) {
                defaultOutputFolder = javaSourceFolder;
            }
            javadm.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)defaultOutputFolder);
            if (this.model.isPropertySet("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
                utildm.setProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", this.model.getProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR"));
            }
            if (this.model.isPropertySet("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ")) {
                utildm.setProperty("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI", this.model.getProperty("IEjbClientProjectCreationDataModelProperties.CLIENT_URI "));
            }
            utildm.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earProjectName);
            utildm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
            dm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
            FacetProjectCreationOperation op = new FacetProjectCreationOperation(dm);
            try {
                stat = op.execute(monitor, null);
            }
            catch (ExecutionException e) {
                EjbPlugin.logError(e);
            }
        }
        finally {
            if (dm != null) {
                dm.dispose();
            }
        }
        return stat;
    }
}

