/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ElementCSSInlineStyle;

public final class DOMStyleUtil {
    public static String getInlineStyleProperty(Element original, String cssProperty) {
        String oldstyle;
        if (original instanceof ElementCSSInlineStyle) {
            CSSStyleDeclaration styledecl = ((ElementCSSInlineStyle)((Object)original)).getStyle();
            if (styledecl == null && original.getAttribute("style") == null) {
                return null;
            }
            if (styledecl != null) {
                return styledecl.getPropertyValue(cssProperty);
            }
        }
        if ((oldstyle = original.getAttribute("style")) == null || oldstyle.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(oldstyle, ";");
        while (tokenizer.hasMoreTokens()) {
            String propertyName;
            int index;
            String token = tokenizer.nextToken().trim();
            if (token.length() == 0 || (index = token.indexOf(58)) == -1 || !cssProperty.equals(propertyName = token.substring(0, index).trim())) continue;
            return token.substring(index + 1).trim();
        }
        return null;
    }

    public static void insertStyle(Element original, Map map) {
        String oldstyle;
        if (original instanceof ElementCSSInlineStyle) {
            CSSStyleDeclaration styledecl = ((ElementCSSInlineStyle)((Object)original)).getStyle();
            if (styledecl == null && original.getAttribute("style") == null) {
                original.setAttribute("style", "");
                styledecl = ((ElementCSSInlineStyle)((Object)original)).getStyle();
            }
            if (styledecl != null) {
                for (String key : map.keySet()) {
                    String value = (String)map.get(key);
                    if (value == null) {
                        styledecl.removeProperty(key);
                        continue;
                    }
                    styledecl.setProperty(key, value, null);
                }
                return;
            }
        }
        if ((oldstyle = original.getAttribute("style")) == null) {
            oldstyle = "";
        }
        StringTokenizer tokenizer = new StringTokenizer(oldstyle, ";");
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() == 0) continue;
            int index = token.indexOf(58);
            if (index == -1) {
                buffer.append(token).append("; ");
                continue;
            }
            String propertyName = token.substring(0, index).trim();
            if (map.containsKey(propertyName)) {
                String propertyValue = (String)map.remove(propertyName);
                if (propertyValue == null) continue;
                buffer.append(propertyName).append(": ").append(propertyValue).append("; ");
                continue;
            }
            buffer.append(token).append("; ");
        }
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            if (value == null) continue;
            buffer.append(key).append(": ").append(value).append("; ");
        }
        original.setAttribute("style", buffer.toString());
    }

    public static boolean supportStyleAttribute(IDOMElement ele) {
        CMElementDeclaration decl = CMUtil.getElementDeclaration((Element)ele);
        return decl != null && decl.getAttributes().getNamedItem("style") != null;
    }

    private DOMStyleUtil() {
    }
}

