/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class AnnotationArrayCellEditor
extends DialogCellEditor {
    private Method method;
    private Object[] values;
    private List<Object> originalValues;
    private List<Object> updatedValues;
    private AnnotationArrayDialog annotationArrayDialog;
    private int browse_button_count = 0;
    boolean cancelled;

    public AnnotationArrayCellEditor(Composite parent, Object[] values) {
        super(parent, 0);
        this.values = (Object[])values.clone();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        this.annotationArrayDialog = new AnnotationArrayDialog(cellEditorWindow.getShell(), this.values);
        int returnValue = this.annotationArrayDialog.open();
        if (returnValue == 0) {
            this.cancelled = false;
            return this.annotationArrayDialog.getResult();
        }
        if (returnValue == 1) {
            this.cancelled = true;
        }
        return this.values;
    }

    public void setMethod(Method method) {
        this.method = method;
        if (this.updatedValues != null) {
            this.updatedValues.clear();
        }
    }

    protected void updateContents(Object value) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            if (values.length > 0) {
                this.getDefaultLabel().setText("[]{...}");
            } else {
                this.getDefaultLabel().setText("[]{}");
            }
        }
    }

    protected Object doGetValue() {
        if (this.cancelled || this.updatedValues == null) {
            return this.originalValues != null ? this.originalValues.toArray() : new Object[]{};
        }
        return this.updatedValues.toArray();
    }

    protected void doSetValue(Object value) {
        super.doSetValue(value);
        this.values = (Object[])value;
    }

    private class AnnotationArrayDialog
    extends SelectionStatusDialog {
        private Button addButton;
        private Button removeButton;
        private Button upButton;
        private Button downButton;
        private Table arrayValuesTable;
        private TableViewer arrayValuesTableViewer;
        private Map<String, Control> controls;

        public AnnotationArrayDialog(Shell parent, Object[] values) {
            super(parent);
            this.controls = new HashMap<String, Control>();
            this.setValues(values);
            this.setTitle(JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_EDIT_ARRAY_VALUES_TITLE);
        }

        private void setValues(Object[] values) {
            try {
                AnnotationArrayCellEditor.this.originalValues = new ArrayList();
                AnnotationArrayCellEditor.this.updatedValues = new ArrayList();
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation;
                    IMemberValuePair[] memberValuePairs;
                    Object value = objectArray[n2];
                    if (value instanceof IAnnotation && (memberValuePairs = (annotation = (IAnnotation)value).getMemberValuePairs()).length > 0) {
                        ArrayList aList = new ArrayList();
                        IMemberValuePair[] iMemberValuePairArray = memberValuePairs;
                        int n3 = memberValuePairs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                            String memberName = memberValuePair.getMemberName();
                            Object memberValue = memberValuePair.getValue();
                            HashMap<String, Object> mvps = new HashMap<String, Object>();
                            if (memberValuePair.getValueKind() == 9) {
                                mvps.put(memberName, memberValue);
                            }
                            if (memberValuePair.getValueKind() == 11) {
                                mvps.put(memberName, memberValuePair.getValue() + ".class");
                            }
                            aList.add(mvps);
                            ++n4;
                        }
                        AnnotationArrayCellEditor.this.originalValues.add(aList);
                        AnnotationArrayCellEditor.this.updatedValues.add(aList);
                    }
                    if (value.equals(Class.class)) {
                        AnnotationArrayCellEditor.this.originalValues.add(value);
                        AnnotationArrayCellEditor.this.updatedValues.add(value);
                    }
                    if (value instanceof String) {
                        String string = (String)value;
                        AnnotationArrayCellEditor.this.originalValues.add(string);
                        AnnotationArrayCellEditor.this.updatedValues.add(string);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme.getStatus());
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite mainComposite = (Composite)super.createDialogArea(parent);
            GridLayout gridLayout = new GridLayout(3, false);
            mainComposite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(4, 1, false, false);
            gridData.widthHint = 800;
            mainComposite.setLayoutData((Object)gridData);
            Composite typeComposite = new Composite(mainComposite, 0);
            gridLayout = new GridLayout(3, false);
            typeComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(4, 1, true, true);
            typeComposite.setLayoutData((Object)gridData);
            final Class<?> componentType = AnnotationArrayCellEditor.this.method.getReturnType().getComponentType();
            if (componentType.isAnnotation()) {
                Method[] methods;
                Label compontTypeLabel = new Label(typeComposite, 0);
                compontTypeLabel.setText("@" + componentType.getName());
                gridData = new GridData(4, 4, true, true);
                gridData.horizontalSpan = 3;
                compontTypeLabel.setLayoutData((Object)gridData);
                Method[] methodArray = methods = componentType.getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    Label label = new Label(typeComposite, 0);
                    label.setText(String.valueOf(method.getName()) + ":");
                    this.createEntryFields(method, typeComposite);
                    ++n2;
                }
            } else {
                Label label = new Label(typeComposite, 0);
                label.setText(AnnotationArrayCellEditor.this.method.getReturnType().getSimpleName());
                this.createEntryFields(AnnotationArrayCellEditor.this.method, typeComposite);
            }
            Composite buttonComposite = new Composite(mainComposite, 0);
            gridLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)gridLayout);
            this.addButton = new Button(buttonComposite, 8);
            this.addButton.setText(JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_ADD_LABEL);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Set entrySet = AnnotationArrayDialog.this.controls.entrySet();
                    Iterator iterator = entrySet.iterator();
                    ArrayList aList = new ArrayList();
                    while (iterator.hasNext()) {
                        HashMap<String, Object> memberValuePairs;
                        Method method;
                        Map.Entry entry = iterator.next();
                        if (entry.getValue() instanceof Text) {
                            Text textField = (Text)entry.getValue();
                            method = (Method)textField.getData();
                            if (textField.getText().trim().length() > 0) {
                                if (componentType.isAnnotation()) {
                                    memberValuePairs = new HashMap();
                                    memberValuePairs.put(method.getName(), textField.getText());
                                    aList.add(memberValuePairs);
                                } else {
                                    AnnotationArrayCellEditor.this.updatedValues.add(textField.getText());
                                }
                            }
                        }
                        if (!(entry.getValue() instanceof Button)) continue;
                        Button button = (Button)entry.getValue();
                        method = (Method)button.getData();
                        if (componentType.isAnnotation()) {
                            memberValuePairs = new HashMap<String, Object>();
                            memberValuePairs.put(method.getName(), button.getSelection());
                            aList.add(memberValuePairs);
                            continue;
                        }
                        AnnotationArrayCellEditor.this.updatedValues.add(button.getSelection());
                    }
                    if (aList.size() > 0) {
                        AnnotationArrayCellEditor.this.updatedValues.add(aList);
                    }
                    AnnotationArrayDialog.this.arrayValuesTableViewer.refresh();
                }
            });
            gridData = new GridData(4, 4, true, false);
            this.addButton.setLayoutData((Object)gridData);
            this.removeButton = new Button(buttonComposite, 8);
            this.removeButton.setText(JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_REMOVE_LABEL);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ISelection selection = AnnotationArrayDialog.this.arrayValuesTableViewer.getSelection();
                    if (selection != null && !selection.isEmpty()) {
                        int index = AnnotationArrayDialog.this.arrayValuesTable.getSelectionIndex();
                        AnnotationArrayCellEditor.this.updatedValues.remove(index);
                        AnnotationArrayDialog.this.arrayValuesTableViewer.refresh();
                    }
                }
            });
            gridData = new GridData(4, 4, true, false);
            this.removeButton.setLayoutData((Object)gridData);
            this.upButton = new Button(buttonComposite, 8);
            this.upButton.setText(JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_UP_LABEL);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AnnotationArrayDialog.this.moveSelectedElememtUp(AnnotationArrayDialog.this.getSelectedElement(), AnnotationArrayDialog.this.getTableViewer());
                }
            });
            gridData = new GridData(4, 4, true, false);
            this.upButton.setLayoutData((Object)gridData);
            this.downButton = new Button(buttonComposite, 8);
            this.downButton.setText(JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_DOWN_LABEL);
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AnnotationArrayDialog.this.moveSelectedElememtDown(AnnotationArrayDialog.this.getSelectedElement(), AnnotationArrayDialog.this.getTableViewer());
                }
            });
            gridData = new GridData(4, 4, true, false);
            this.downButton.setLayoutData((Object)gridData);
            Composite valuesComposite = new Composite(mainComposite, 0);
            gridLayout = new GridLayout(1, false);
            valuesComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = 200;
            valuesComposite.setLayoutData((Object)gridData);
            Label valuesLabel = new Label(valuesComposite, 0);
            valuesLabel.setText(String.valueOf(AnnotationArrayCellEditor.this.method.getName()) + ":");
            this.arrayValuesTableViewer = new TableViewer(valuesComposite, 2820);
            this.arrayValuesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof List) {
                        String annotationName = AnnotationArrayCellEditor.this.method.getReturnType().getComponentType().getSimpleName();
                        annotationName = String.valueOf(annotationName) + "(";
                        List valuesList = (List)element;
                        Iterator valuesIterator = valuesList.iterator();
                        while (valuesIterator.hasNext()) {
                            Map valuesMap = (Map)valuesIterator.next();
                            Set entrySet = valuesMap.entrySet();
                            for (Map.Entry entry : entrySet) {
                                Object value = entry.getValue();
                                boolean isString = value instanceof String && !value.toString().endsWith(".class");
                                annotationName = isString ? String.valueOf(annotationName) + (String)entry.getKey() + "=\"" + value + "\"" : String.valueOf(annotationName) + (String)entry.getKey() + "=" + value;
                            }
                            if (!valuesIterator.hasNext()) continue;
                            annotationName = String.valueOf(annotationName) + ", ";
                        }
                        annotationName = String.valueOf(annotationName) + ")";
                        return annotationName;
                    }
                    return element.toString();
                }

                public Image getImage(Object element) {
                    Class<?> returnType = AnnotationArrayCellEditor.this.method.getReturnType();
                    if (returnType.getComponentType().isAnnotation()) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.annotation_obj.gif");
                    }
                    if (returnType.equals(Class.class)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                    }
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
            });
            this.arrayValuesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    int index = AnnotationArrayDialog.this.arrayValuesTable.getSelectionIndex();
                    int itemCount = AnnotationArrayDialog.this.arrayValuesTable.getItemCount();
                    if (index == 0 && itemCount <= 1) {
                        AnnotationArrayDialog.this.upButton.setEnabled(false);
                        AnnotationArrayDialog.this.downButton.setEnabled(false);
                    }
                    if (index == 0 && itemCount > 1) {
                        AnnotationArrayDialog.this.upButton.setEnabled(false);
                        AnnotationArrayDialog.this.downButton.setEnabled(true);
                    }
                    if (index > 0 && index < itemCount - 1) {
                        AnnotationArrayDialog.this.upButton.setEnabled(true);
                        AnnotationArrayDialog.this.downButton.setEnabled(true);
                    }
                    if (index > 0 && index == itemCount - 1) {
                        AnnotationArrayDialog.this.upButton.setEnabled(true);
                        AnnotationArrayDialog.this.downButton.setEnabled(false);
                    }
                    if (index != -1) {
                        AnnotationArrayDialog.this.removeButton.setEnabled(true);
                    } else {
                        AnnotationArrayDialog.this.removeButton.setEnabled(false);
                    }
                }
            });
            this.arrayValuesTableViewer.setContentProvider((IContentProvider)new ArrayValuesContentProvider());
            this.arrayValuesTable = this.arrayValuesTableViewer.getTable();
            gridData = new GridData(4, 4, true, true);
            this.arrayValuesTable.setLayoutData((Object)gridData);
            this.arrayValuesTableViewer.setInput((Object)AnnotationArrayCellEditor.this.values);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return mainComposite;
        }

        public void createEntryFields(Method method, Composite typeComposite) {
            Text text;
            Class<?> returnType = method.getReturnType();
            Object defaultValue = method.getDefaultValue();
            GridData gridData = new GridData(4, 0x1000000, true, false);
            if (returnType.equals(String.class) || returnType.isArray() && returnType.getComponentType().equals(String.class)) {
                text = new Text(typeComposite, 2048);
                text.setData((Object)method);
                gridData.horizontalSpan = 2;
                text.setLayoutData((Object)gridData);
                if (defaultValue != null) {
                    if (defaultValue instanceof String[] && ((String[])defaultValue).length == 1) {
                        String[] values = (String[])defaultValue;
                        text.setText(values[0]);
                    } else {
                        text.setText(defaultValue.toString().trim());
                    }
                }
                this.controls.put(method.getName(), (Control)text);
            }
            if (returnType.equals(Class.class) || returnType.isArray() && returnType.getComponentType().equals(Class.class)) {
                text = new Text(typeComposite, 2048);
                text.setData((Object)method);
                gridData = new GridData(4, 0x1000000, true, false);
                text.setLayoutData((Object)gridData);
                if (defaultValue != null) {
                    Class classValue = (Class)defaultValue;
                    text.setText(String.valueOf(classValue.getCanonicalName()) + ".class");
                }
                Button browseClassButton = new Button(typeComposite, 8);
                browseClassButton.setText(this.getBrowseButtonLabel());
                browseClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IType type;
                        Object[] types;
                        SelectionDialog dialog = AnnotationArrayDialog.this.getClassSelectionDialog();
                        dialog.setTitle(JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_SELECT_CLASS_TITLE);
                        if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0 && (type = (IType)types[0]).isBinary()) {
                            text.setText(type.getClassFile().getElementName());
                        }
                    }
                });
                AnnotationArrayCellEditor annotationArrayCellEditor = AnnotationArrayCellEditor.this;
                annotationArrayCellEditor.browse_button_count = annotationArrayCellEditor.browse_button_count + 1;
                this.controls.put(method.getName(), (Control)text);
            }
            if (returnType.equals(Boolean.TYPE)) {
                Button checkbox = new Button(typeComposite, 32);
                checkbox.setData((Object)method);
                gridData.horizontalSpan = 2;
                checkbox.setLayoutData((Object)gridData);
                if (defaultValue != null) {
                    checkbox.setSelection(((Boolean)defaultValue).booleanValue());
                }
                this.controls.put(method.getName(), (Control)checkbox);
            }
        }

        private String getBrowseButtonLabel() {
            switch (AnnotationArrayCellEditor.this.browse_button_count) {
                case 0: {
                    return JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_BROWSE_LABEL0;
                }
                case 1: {
                    return JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_BROWSE_LABEL1;
                }
                case 2: {
                    return JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_BROWSE_LABEL2;
                }
                case 3: {
                    return JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_BROWSE_LABEL3;
                }
                case 4: {
                    return JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_BROWSE_LABEL4;
                }
                case 5: {
                    return JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_BROWSE_LABEL5;
                }
            }
            return JAXWSUIMessages.ANNOTATION_ARRAY_CELL_EDITOR_BROWSE_LABEL0;
        }

        public Object getSelectedElement() {
            IStructuredSelection selection = (IStructuredSelection)this.arrayValuesTableViewer.getSelection();
            return selection.getFirstElement();
        }

        private TableViewer getTableViewer() {
            return this.arrayValuesTableViewer;
        }

        public void moveSelectedElememtUp(Object selected, TableViewer tableViewer) {
            int selectionIndex = tableViewer.getTable().getSelectionIndex();
            if (selectionIndex > 0) {
                AnnotationArrayCellEditor.this.updatedValues.remove(selected);
                AnnotationArrayCellEditor.this.updatedValues.add(selectionIndex - 1, selected);
                tableViewer.refresh();
                tableViewer.reveal(selected);
                tableViewer.setSelection((ISelection)new StructuredSelection(selected));
            }
        }

        public void moveSelectedElememtDown(Object selected, TableViewer tableViewer) {
            int itemCount;
            int selectionIndex = tableViewer.getTable().getSelectionIndex();
            if (selectionIndex < (itemCount = tableViewer.getTable().getItemCount()) - 1) {
                AnnotationArrayCellEditor.this.updatedValues.remove(selected);
                AnnotationArrayCellEditor.this.updatedValues.add(selectionIndex + 1, selected);
                tableViewer.refresh();
                tableViewer.reveal(selected);
                tableViewer.setSelection((ISelection)new StructuredSelection(selected));
            }
        }

        public SelectionDialog getClassSelectionDialog() {
            try {
                return JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false, (String)"* ");
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme.getStatus());
                return null;
            }
        }

        public Object[] getResult() {
            return AnnotationArrayCellEditor.this.updatedValues.toArray();
        }

        protected void computeResult() {
        }

        private class ArrayValuesContentProvider
        implements IStructuredContentProvider {
            public Object[] getElements(Object inputElement) {
                return AnnotationArrayCellEditor.this.updatedValues.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

