/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.annotations.core.AnnotationDefinition;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.actions.AnnotationsViewFilterAction;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsColumnLabelProvider;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsValuesColumnLabelProvider;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsValuesEditingSupport;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsViewCategoryFilter;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsViewContentProvider;
import org.eclipse.jst.ws.internal.jaxws.ui.widgets.ClasspathComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class AnnotationsView
extends ViewPart
implements INullSelectionListener,
IPartListener2 {
    private static final String VIEW_ID = "org.eclipse.jst.ws.jaxws.ui.views.AnnotationsView";
    private PageBook pageBook;
    private Tree annotationTree;
    private Composite notAvaiableComposite;
    private ClasspathComposite setupClasspathComposite;
    private TreeViewer annotationTreeViewer;
    private AnnotationsViewFilterAction annotationsViewFilterAction;

    public void createPartControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.annotationTree = new Tree((Composite)this.pageBook, 68356);
        this.annotationTreeViewer = new TreeViewer(this.annotationTree);
        this.annotationTreeViewer.setContentProvider((IContentProvider)new AnnotationsViewContentProvider());
        this.annotationTreeViewer.getTree().setHeaderVisible(true);
        this.annotationTreeViewer.getTree().setLinesVisible(true);
        TreeViewerColumn annotationsViewerColumn = new TreeViewerColumn(this.annotationTreeViewer, 0);
        annotationsViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationsColumnLabelProvider());
        TreeColumn annotationsColumn = annotationsViewerColumn.getColumn();
        annotationsColumn.setWidth(400);
        annotationsColumn.setMoveable(false);
        annotationsColumn.setText(JAXWSUIMessages.ANNOTATIONS_VIEW_ANNOTATIONS_COLUMN_NAME);
        TreeViewerColumn valuesViewerColumn = new TreeViewerColumn(this.annotationTreeViewer, 0);
        valuesViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationsValuesColumnLabelProvider(this.annotationTreeViewer));
        valuesViewerColumn.setEditingSupport((EditingSupport)new AnnotationsValuesEditingSupport(this, this.annotationTreeViewer));
        TreeColumn valuesColumn = valuesViewerColumn.getColumn();
        valuesColumn.setWidth(400);
        valuesColumn.setMoveable(false);
        valuesColumn.setAlignment(16384);
        valuesColumn.setText(JAXWSUIMessages.ANNOTATIONS_VIEW_ANNOTATIONS_VALUES_COLUMN_NAME);
        this.startListeningForSelectionChanges();
        this.getViewSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
        this.contributeToActionBars();
        this.notAvaiableComposite = new Composite((Composite)this.pageBook, 0);
        GridLayout gridLayout = new GridLayout();
        this.notAvaiableComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        this.notAvaiableComposite.setLayoutData((Object)gridData);
        this.notAvaiableComposite.setBackground(this.getBackgroundColor(parent));
        Label label = new Label(this.notAvaiableComposite, 0);
        label.setBackground(this.getBackgroundColor(parent));
        label.setText(JAXWSUIMessages.ANNOTATIONS_VIEW_ANNOTATIONS_NOT_AVAILABLE_ON_SELECTION);
        this.annotationTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object obj1, Object obj2) {
                if (obj1 instanceof Class && ((Class)obj1).isAnnotation() && obj2 instanceof Class && ((Class)obj2).isAnnotation()) {
                    return ((Class)obj1).getCanonicalName().compareTo(((Class)obj2).getCanonicalName());
                }
                if (obj1 instanceof Method && obj2 instanceof Method) {
                    return ((Method)obj1).getName().compareTo(((Method)obj2).getName());
                }
                return super.compare(viewer, obj1, obj2);
            }
        });
        this.setupClasspathComposite = new ClasspathComposite((Composite)this.pageBook, 0);
        this.pageBook.showPage((Control)this.notAvaiableComposite);
    }

    private Color getBackgroundColor(Composite parent) {
        if (Display.getDefault().getHighContrast()) {
            return parent.getDisplay().getSystemColor(22);
        }
        return parent.getDisplay().getSystemColor(1);
    }

    private void startListeningForSelectionChanges() {
        this.getViewSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    private void stopListeningForSelectionChanges() {
        this.getViewSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IWorkbenchPage workbenchPage = this.getViewSite().getWorkbenchWindow().getActivePage();
        if (workbenchPage == null) {
            return;
        }
        IWorkbenchPartReference workbenchPartReference = workbenchPage.getActivePartReference();
        if (workbenchPartReference == null || workbenchPartReference.getId().equals(this.getViewSite().getId()) || !workbenchPartReference.getId().equals("org.eclipse.jdt.ui.CompilationUnitEditor")) {
            return;
        }
        IEditorPart editorPart = workbenchPage.getActiveEditor();
        IFileEditorInput fileEditorInput = (IFileEditorInput)editorPart.getEditorInput();
        if (selection instanceof TextSelection) {
            TextSelection txtSelection = (TextSelection)selection;
            ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)fileEditorInput.getFile());
            if (compilationUnit != null) {
                this.updateView((IJavaElement)compilationUnit, (ITextSelection)txtSelection);
            }
        }
    }

    public void updateView(IJavaElement javaElement, ITextSelection textSelection) {
        TreePath[] expandedTreePaths = this.annotationTreeViewer.getExpandedTreePaths();
        IJavaProject javaProject = javaElement.getJavaProject();
        if (!this.checkClasspath(javaProject)) {
            this.annotationTreeViewer.setInput(null);
            this.pageBook.showPage((Control)this.setupClasspathComposite);
            return;
        }
        this.pageBook.showPage((Control)this.annotationTree);
        int offset = textSelection.getOffset();
        try {
            ICompilationUnit compilationUnit = null;
            if (javaElement instanceof ICompilationUnit) {
                compilationUnit = (ICompilationUnit)javaElement;
                javaElement = compilationUnit.getElementAt(offset);
            }
            if (javaElement == null) {
                return;
            }
            if (javaElement.getElementType() == 11) {
                if (javaElement.getResource().getName().equals("package-info.java")) {
                    this.setInput(javaElement);
                } else {
                    this.annotationTreeViewer.setInput(null);
                }
            }
            if (javaElement.getElementType() == 13) {
                this.annotationTreeViewer.setInput(null);
            }
            if (javaElement.getElementType() == 7) {
                IType type = (IType)javaElement;
                if (!type.isMember()) {
                    this.setInput((IJavaElement)type);
                } else {
                    this.annotationTreeViewer.setInput(null);
                }
            }
            if (javaElement.getElementType() == 8) {
                IField field = (IField)javaElement;
                if (!field.getDeclaringType().isMember()) {
                    this.setInput((IJavaElement)field);
                } else {
                    this.annotationTreeViewer.setInput(null);
                }
            }
            if (javaElement.getElementType() == 9) {
                IMethod method = (IMethod)javaElement;
                if (!method.getDeclaringType().isMember()) {
                    ILocalVariable localVariable = AnnotationUtils.getLocalVariable((IMethod)method, (int)offset);
                    if (localVariable != null) {
                        this.setInput((IJavaElement)localVariable);
                    } else {
                        this.setInput((IJavaElement)method);
                    }
                } else {
                    this.annotationTreeViewer.setInput(null);
                }
            }
            this.annotationTreeViewer.refresh();
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        this.annotationTreeViewer.setExpandedTreePaths(expandedTreePaths);
    }

    private void setInput(IJavaElement javaElement) {
        if (this.annotationTreeViewer.getInput() == null) {
            this.annotationTreeViewer.setInput((Object)javaElement);
        } else if (!this.annotationTreeViewer.getInput().equals(javaElement)) {
            this.annotationTreeViewer.setInput((Object)javaElement);
        }
    }

    private boolean checkClasspath(IJavaProject javaProject) {
        ViewerFilter[] viewerFilters;
        ArrayList categories = new ArrayList();
        categories.addAll(AnnotationsManager.getAnnotationCategories());
        ViewerFilter[] viewerFilterArray = viewerFilters = this.annotationTreeViewer.getFilters();
        int n = viewerFilters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter viewerFilter = viewerFilterArray[n2];
            if (viewerFilter instanceof AnnotationsViewCategoryFilter) {
                categories.removeAll(((AnnotationsViewCategoryFilter)viewerFilter).getCategories());
            }
            ++n2;
        }
        boolean jwsReady = true;
        try {
            for (String category : categories) {
                List annotationDefinitions = AnnotationsManager.getAnnotationsByCategory((String)category);
                String className = ((AnnotationDefinition)annotationDefinitions.get(0)).getAnnotationClassName();
                if (javaProject.findType(className) != null) continue;
                jwsReady = false;
                this.setupClasspathComposite.updateLibraryLabel(category);
                break;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return jwsReady;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart workbenchPart = partRef.getPart(false);
        if (partRef.getId().equals("org.eclipse.jdt.ui.CompilationUnitEditor")) {
            this.javaEditorActivated((IEditorPart)workbenchPart);
        } else if (partRef.getId().equals(this.getViewSite().getId())) {
            this.annotationsViewActivated();
        } else {
            this.clearAnnotationsView();
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(this.getViewSite().getId())) {
            this.startListeningForSelectionChanges();
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(this.getViewSite().getId())) {
            this.stopListeningForSelectionChanges();
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(VIEW_ID)) {
            this.annotationsViewFilterAction.init();
        }
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals("org.eclipse.jdt.ui.CompilationUnitEditor")) {
            IWorkbenchPage workbenchPage;
            IWorkbenchWindow workbenchWindow;
            if (this.getViewSite() != null && (workbenchWindow = this.getViewSite().getWorkbenchWindow()) != null && (workbenchPage = workbenchWindow.getActivePage()) != null) {
                IEditorPart editorPart = workbenchPage.getActiveEditor();
                try {
                    if (editorPart == null || !(editorPart.getEditorInput() instanceof IFileEditorInput) || !IDE.getEditorDescriptor((IFile)((IFileEditorInput)editorPart.getEditorInput()).getFile()).getId().equals("org.eclipse.jdt.ui.CompilationUnitEditor")) {
                        this.clearAnnotationsView();
                    }
                }
                catch (PartInitException pie) {
                    JAXWSUIPlugin.log(pie.getStatus());
                }
            }
        } else if (partRef.getId().equals(VIEW_ID)) {
            this.annotationsViewFilterAction.saveState();
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private void clearAnnotationsView() {
        this.annotationTreeViewer.setInput(null);
        this.annotationTreeViewer.refresh();
        this.pageBook.showPage((Control)this.notAvaiableComposite);
    }

    private void javaEditorActivated(IEditorPart editorPart) {
        ITextEditor textEditor = (ITextEditor)editorPart;
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        IJavaElement javaElement = (IJavaElement)editorPart.getEditorInput().getAdapter(IJavaElement.class);
        if (javaElement != null) {
            this.pageBook.showPage((Control)this.annotationTree);
            this.updateView(javaElement, (ITextSelection)selection);
            this.selectionChanged((IWorkbenchPart)editorPart, selection);
        }
    }

    private void annotationsViewActivated() {
        try {
            IFile file;
            IEditorDescriptor editorDescriptor;
            IEditorInput editorInput;
            IEditorPart editorPart = this.getViewSite().getPage().getActiveEditor();
            if (editorPart != null && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput && (editorDescriptor = IDE.getEditorDescriptor((IFile)(file = ((IFileEditorInput)editorInput).getFile()))).getId().equals("org.eclipse.jdt.ui.CompilationUnitEditor")) {
                this.javaEditorActivated(editorPart);
            }
        }
        catch (PartInitException pie) {
            JAXWSUIPlugin.log(pie.getStatus());
        }
    }

    public void dispose() {
        super.dispose();
        this.stopListeningForSelectionChanges();
        this.getViewSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        this.annotationsViewFilterAction = new AnnotationsViewFilterAction(this, (StructuredViewer)this.annotationTreeViewer, JAXWSUIMessages.ANNOTATIONS_VIEW_FILTER_ACTION_NAME);
        manager.add((IAction)this.annotationsViewFilterAction);
    }

    public void setFocus() {
        this.annotationTreeViewer.getControl().setFocus();
    }

    public void refreshLabels() {
        this.annotationTreeViewer.refresh();
    }

    public void refresh() {
        Display display = this.annotationTreeViewer.getControl().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
                    IEditorPart editorPart = workbenchPage.getActiveEditor();
                    try {
                        ITextEditor txtEditor;
                        IFileEditorInput fileEditorInput;
                        ICompilationUnit compilationUnit;
                        if (editorPart != null && editorPart.getEditorInput() instanceof IFileEditorInput && IDE.getEditorDescriptor((IFile)((IFileEditorInput)editorPart.getEditorInput()).getFile()).getId().equals("org.eclipse.jdt.ui.CompilationUnitEditor") && (compilationUnit = JavaCore.createCompilationUnitFrom((IFile)(fileEditorInput = (IFileEditorInput)(txtEditor = (ITextEditor)workbenchPage.getActiveEditor()).getEditorInput()).getFile())) != null) {
                            if (!compilationUnit.isConsistent()) {
                                compilationUnit.makeConsistent((IProgressMonitor)new NullProgressMonitor());
                            }
                            AnnotationsView.this.updateView((IJavaElement)compilationUnit, (ITextSelection)txtEditor.getSelectionProvider().getSelection());
                        }
                    }
                    catch (JavaModelException jme) {
                        JAXWSUIPlugin.log(jme.getStatus());
                    }
                    catch (PartInitException pie) {
                        JAXWSUIPlugin.log(pie.getStatus());
                    }
                }
            });
        }
    }
}

