/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.utility.model.event.TreeEvent;
import org.eclipse.jpt.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ReflectiveChangeListener;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;

public class ReflectiveTreeChangeListenerTests
extends TestCase {
    public ReflectiveTreeChangeListenerTests(String name) {
        super(name);
    }

    private TreeChangeListener buildZeroArgumentListener(Object target) {
        return ReflectiveChangeListener.buildTreeChangeListener((Object)target, (String)"nodeAddedZeroArgument", (String)"nodeRemovedZeroArgument", (String)"treeClearedZeroArgument", (String)"treeChangedZeroArgument");
    }

    private TreeChangeListener buildSingleArgumentListener(Object target) {
        return ReflectiveChangeListener.buildTreeChangeListener((Object)target, (String)"nodeAddedSingleArgument", (String)"nodeRemovedSingleArgument", (String)"treeClearedSingleArgument", (String)"treeChangedSingleArgument");
    }

    public void testNodeAddedZeroArgumentNamedTree() {
        TestModel testModel = new TestModel("root");
        Target target = new Target(testModel, "strings", new String[]{"root", "child"});
        testModel.addTreeChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.addNode("root", "child");
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)target.nodeAddedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedSingleArgumentFlag);
    }

    public void testNodeAddedSingleArgumentNamedTree() {
        TestModel testModel = new TestModel("root");
        Target target = new Target(testModel, "strings", new String[]{"root", "child"});
        testModel.addTreeChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.addNode("root", "child");
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)target.nodeAddedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedSingleArgumentFlag);
    }

    public void testNodeRemovedZeroArgumentNamedTree() {
        TestModel testModel = new TestModel("root");
        testModel.addNode("root", "child");
        Target target = new Target(testModel, "strings", new String[]{"root", "child"});
        testModel.addTreeChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.removeNode("child");
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)target.nodeRemovedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedSingleArgumentFlag);
    }

    public void testNodeRemovedSingleArgumentNamedTree() {
        TestModel testModel = new TestModel("root");
        testModel.addNode("root", "child");
        Target target = new Target(testModel, "strings", new String[]{"root", "child"});
        testModel.addTreeChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.removeNode("child");
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)target.nodeRemovedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedSingleArgumentFlag);
    }

    public void testTreeClearedZeroArgumentNamedTree() {
        TestModel testModel = new TestModel("root");
        testModel.addNode("root", "child");
        testModel.addNode("child", "grandchild");
        Target target = new Target(testModel, "strings", new String[0]);
        testModel.addTreeChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.clearTree();
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)target.treeClearedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedSingleArgumentFlag);
    }

    public void testTreeClearedSingleArgumentNamedTree() {
        TestModel testModel = new TestModel("root");
        testModel.addNode("root", "child");
        testModel.addNode("child", "grandchild");
        Target target = new Target(testModel, "strings", new String[0]);
        testModel.addTreeChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.clearTree();
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)target.treeClearedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedSingleArgumentFlag);
    }

    public void testTreeChangedZeroArgumentNamedTree() {
        TestModel testModel = new TestModel("root");
        testModel.addNode("root", "child");
        Target target = new Target(testModel, "strings", new String[]{"root", "another child"});
        testModel.addTreeChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.replaceNode("child", "another child");
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)target.treeChangedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedSingleArgumentFlag);
    }

    public void testTreeChangedSingleArgumentNamedTree() {
        TestModel testModel = new TestModel("root");
        testModel.addNode("root", "child");
        Target target = new Target(testModel, "strings", new String[]{"root", "another child"});
        testModel.addTreeChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.replaceNode("child", "another child");
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeAddedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.nodeRemovedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeClearedSingleArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertFalse((boolean)target.treeChangedZeroArgumentFlag);
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)target.treeChangedSingleArgumentFlag);
    }

    public void testListenerMismatch() {
        TestModel testModel = new TestModel("root");
        testModel.addNode("root", "child");
        Target target = new Target(testModel, "strings", new String[]{"root", "child"});
        TreeChangeListener listener = ReflectiveChangeListener.buildTreeChangeListener((Object)target, (String)"treeEventSingleArgument");
        testModel.addCollectionChangeListener("bogus collection", (CollectionChangeListener)listener);
        boolean exCaught = false;
        try {
            testModel.changeCollection();
            ReflectiveTreeChangeListenerTests.fail((String)("listener mismatch: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ReflectiveTreeChangeListenerTests.assertTrue((boolean)exCaught);
    }

    class Target {
        TestModel testModel;
        String treeName;
        List<String> path;
        boolean nodeAddedZeroArgumentFlag = false;
        boolean nodeAddedSingleArgumentFlag = false;
        boolean nodeRemovedZeroArgumentFlag = false;
        boolean nodeRemovedSingleArgumentFlag = false;
        boolean treeClearedZeroArgumentFlag = false;
        boolean treeClearedSingleArgumentFlag = false;
        boolean treeChangedZeroArgumentFlag = false;
        boolean treeChangedSingleArgumentFlag = false;
        boolean treeEventSingleArgumentFlag = false;

        Target(TestModel testModel, String treeName, String[] path) {
            this.testModel = testModel;
            this.treeName = treeName;
            this.path = Arrays.asList(path);
        }

        void nodeAddedZeroArgument() {
            this.nodeAddedZeroArgumentFlag = true;
        }

        void nodeAddedSingleArgument(TreeAddEvent e) {
            this.nodeAddedSingleArgumentFlag = true;
            ReflectiveTreeChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveTreeChangeListenerTests.assertEquals((String)this.treeName, (String)e.getTreeName());
            ReflectiveTreeChangeListenerTests.assertEquals(this.path, (Object)CollectionTools.list((Iterable)e.getPath()));
        }

        void nodeRemovedZeroArgument() {
            this.nodeRemovedZeroArgumentFlag = true;
        }

        void nodeRemovedSingleArgument(TreeRemoveEvent e) {
            this.nodeRemovedSingleArgumentFlag = true;
            ReflectiveTreeChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveTreeChangeListenerTests.assertEquals((String)this.treeName, (String)e.getTreeName());
            ReflectiveTreeChangeListenerTests.assertEquals(this.path, (Object)CollectionTools.list((Iterable)e.getPath()));
        }

        void treeClearedZeroArgument() {
            this.treeClearedZeroArgumentFlag = true;
        }

        void treeClearedSingleArgument(TreeClearEvent e) {
            this.treeClearedSingleArgumentFlag = true;
            ReflectiveTreeChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveTreeChangeListenerTests.assertEquals((String)this.treeName, (String)e.getTreeName());
        }

        void treeChangedZeroArgument() {
            this.treeChangedZeroArgumentFlag = true;
        }

        void treeChangedSingleArgument(TreeChangeEvent e) {
            this.treeChangedSingleArgumentFlag = true;
            ReflectiveTreeChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveTreeChangeListenerTests.assertEquals((String)this.treeName, (String)e.getTreeName());
        }

        void treeEventSingleArgument(TreeEvent e) {
            this.treeChangedSingleArgumentFlag = true;
            ReflectiveTreeChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveTreeChangeListenerTests.assertEquals((String)this.treeName, (String)e.getTreeName());
        }

        void collectionChangedDoubleArgument(TreeChangeEvent e, Object o) {
            ReflectiveTreeChangeListenerTests.fail((String)("bogus event: " + e + " - object: " + o));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestModel
    extends AbstractModel {
        private final String root;
        private Map<String, Collection<String>> childrenLists = new HashMap<String, Collection<String>>();
        private Map<String, String> parents = new HashMap<String, String>();
        public static final String STRINGS_TREE = "strings";

        TestModel(String root) {
            if (root == null) {
                throw new NullPointerException();
            }
            this.root = root;
            this.childrenLists.put(root, new ArrayList());
            this.parents.put(root, null);
        }

        String getRoot() {
            return this.root;
        }

        private List<String> path(String node) {
            String temp = node;
            ArrayList<String> reversePath = new ArrayList<String>();
            do {
                reversePath.add(temp);
            } while ((temp = this.parents.get(temp)) != null);
            return CollectionTools.reverse(reversePath);
        }

        Iterator<String> strings() {
            return new CloneIterator<String>(this.childrenLists.keySet()){

                protected void remove(String s) {
                    TestModel.this.removeNode(s);
                }
            };
        }

        void addNode(String parent, String child) {
            if (parent == null || child == null) {
                throw new NullPointerException();
            }
            Collection<String> children = this.childrenLists.get(parent);
            if (children == null) {
                throw new IllegalStateException("cannot add a child to a non-existent parent");
            }
            if (this.childrenLists.get(child) != null) {
                throw new IllegalStateException("cannot add a child that is already in the tree");
            }
            children.add(child);
            this.childrenLists.put(child, new ArrayList());
            this.parents.put(child, parent);
            this.fireNodeAdded(STRINGS_TREE, this.path(child));
        }

        void removeNode(String node) {
            if (node == null) {
                throw new NullPointerException();
            }
            Collection<String> children = this.childrenLists.get(node);
            if (children == null) {
                throw new IllegalStateException("node is not in tree");
            }
            List<String> path = this.path(node);
            for (String s : children) {
                this.removeNode(s);
            }
            this.childrenLists.remove(node);
            this.parents.remove(node);
            this.fireNodeRemoved(STRINGS_TREE, path);
        }

        void replaceNode(String oldNode, String newNode) {
            if (oldNode == null || newNode == null) {
                throw new NullPointerException();
            }
            Collection<String> children = this.childrenLists.remove(oldNode);
            if (children == null) {
                throw new IllegalStateException("old node is not in tree");
            }
            this.childrenLists.put(newNode, children);
            for (String child : children) {
                this.parents.put(child, newNode);
            }
            String parent = this.parents.remove(oldNode);
            this.parents.put(newNode, parent);
            this.fireTreeChanged(STRINGS_TREE, this.path(newNode));
        }

        void clearTree() {
            this.childrenLists.clear();
            this.childrenLists.put(this.root, new ArrayList());
            this.parents.clear();
            this.parents.put(this.root, null);
            this.fireTreeCleared(STRINGS_TREE);
        }

        void changeCollection() {
            this.fireCollectionChanged("bogus collection", Collections.emptySet());
        }
    }
}

