/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class ValueListAdapterTests
extends TestCase {
    private Junk junk;
    private SimplePropertyValueModel<Junk> junkHolder;
    private ValueListAdapter<Junk> junkHolder2;

    public ValueListAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.junk = new Junk("foo");
        this.junkHolder = new SimplePropertyValueModel((Object)this.junk);
        this.junkHolder2 = new ValueListAdapter(this.junkHolder, new String[]{"stuff"});
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testWrappedPVM() {
        Junk junk2 = new Junk("bar");
        LocalListener l = new LocalListener(this.junkHolder2, (Object)this.junk, (Object)junk2);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        this.junkHolder.setValue((Object)junk2);
        ValueListAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    public void testHasPropertyChangeListeners() throws Exception {
        ValueListAdapterTests.assertFalse((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueListAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        ValueListAdapterTests.assertTrue((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueListAdapterTests.assertTrue((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
        this.junkHolder2.removeChangeListener((ChangeListener)l);
        ValueListAdapterTests.assertFalse((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueListAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
    }

    public void testHasStateChangeListeners() throws Exception {
        ValueListAdapterTests.assertFalse((boolean)this.junk.hasAnyListChangeListeners("stuff"));
        ValueListAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyStateChangeListeners());
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        ValueListAdapterTests.assertTrue((boolean)this.junk.hasAnyListChangeListeners("stuff"));
        ValueListAdapterTests.assertTrue((boolean)this.junkHolder2.hasAnyStateChangeListeners());
        this.junkHolder2.removeStateChangeListener((StateChangeListener)l);
        ValueListAdapterTests.assertFalse((boolean)this.junk.hasAnyListChangeListeners("stuff"));
        ValueListAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyStateChangeListeners());
    }

    public void testListAdd() {
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        this.junk.addStuff("bar");
        ValueListAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    public void testListRemove() {
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        this.junk.removeStuff("foo");
        ValueListAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    public void testListReplace() {
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        this.junk.replaceStuff("foo", "bar");
        ValueListAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    private class Junk
    extends AbstractModel {
        private List<String> stuff = new ArrayList<String>();
        public static final String STUFF_LIST = "stuff";

        public Junk(String stuffItem) {
            this.stuff.add(stuffItem);
        }

        public void addStuff(String stuffItem) {
            this.addItemToList(stuffItem, this.stuff, STUFF_LIST);
        }

        public void removeStuff(String stuffItem) {
            this.removeItemFromList(stuffItem, this.stuff, STUFF_LIST);
        }

        public void replaceStuff(String oldStuffItem, String newStuffItem) {
            this.replaceItemInList(oldStuffItem, newStuffItem, this.stuff, STUFF_LIST);
        }

        public String toString() {
            return "Junk(" + this.stuff + ")";
        }
    }

    class LocalListener
    extends ChangeAdapter {
        private boolean eventReceived = false;
        private final Object source;
        private final Object oldValue;
        private final Object newValue;

        LocalListener(Object source) {
            this(source, null, null);
        }

        LocalListener(Object source, Object oldValue, Object newValue) {
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void propertyChanged(PropertyChangeEvent e) {
            this.eventReceived = true;
            ValueListAdapterTests.assertEquals((Object)this.source, (Object)e.getSource());
            ValueListAdapterTests.assertEquals((Object)this.oldValue, (Object)e.getOldValue());
            ValueListAdapterTests.assertEquals((Object)this.newValue, (Object)e.getNewValue());
            ValueListAdapterTests.assertEquals((String)"value", (String)e.getPropertyName());
        }

        public void stateChanged(StateChangeEvent e) {
            this.eventReceived = true;
            ValueListAdapterTests.assertEquals((Object)this.source, (Object)e.getSource());
        }

        boolean eventReceived() {
            return this.eventReceived;
        }
    }
}

