/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EOperationImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.java.adapters.IJavaMethodAdapter;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.ReadAdaptor;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodImpl
extends EOperationImpl
implements Method {
    protected String signature;
    protected static final boolean ABSTRACT_EDEFAULT = false;
    protected static final int ABSTRACT_EFLAG = 1024;
    protected static final boolean NATIVE_EDEFAULT = false;
    protected static final int NATIVE_EFLAG = 2048;
    protected static final boolean SYNCHRONIZED_EDEFAULT = false;
    protected static final int SYNCHRONIZED_EFLAG = 4096;
    protected static final boolean FINAL_EDEFAULT = false;
    protected static final int FINAL_EFLAG = 8192;
    protected static final boolean CONSTRUCTOR_EDEFAULT = false;
    protected static final int CONSTRUCTOR_EFLAG = 16384;
    protected static final boolean STATIC_EDEFAULT = false;
    protected static final int STATIC_EFLAG = 32768;
    protected static final JavaVisibilityKind JAVA_VISIBILITY_EDEFAULT = JavaVisibilityKind.PUBLIC_LITERAL;
    private transient boolean isGenerated = false;
    protected JavaVisibilityKind javaVisibility = JAVA_VISIBILITY_EDEFAULT;
    protected EList parameters = null;
    protected EList javaExceptions = null;
    protected Block source = null;
    private static final int NOT_REFLECTED = 0;
    private static final int REFLECTED_BASE = 1;
    private static final int REFLECTED_GENERATED = 2;
    protected int reflectionStatus = 0;

    protected MethodImpl() {
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.Literals.METHOD;
    }

    public boolean isAbstractGen() {
        return (this.eFlags & 0x400) != 0;
    }

    @Override
    public void setAbstract(boolean newAbstract) {
        boolean oldAbstract;
        boolean bl = oldAbstract = (this.eFlags & 0x400) != 0;
        this.eFlags = newAbstract ? (this.eFlags |= 0x400) : (this.eFlags &= 0xFFFFFBFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldAbstract, newAbstract));
        }
    }

    public boolean isNativeGen() {
        return (this.eFlags & 0x800) != 0;
    }

    @Override
    public void setNative(boolean newNative) {
        boolean oldNative;
        boolean bl = oldNative = (this.eFlags & 0x800) != 0;
        this.eFlags = newNative ? (this.eFlags |= 0x800) : (this.eFlags &= 0xFFFFF7FF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldNative, newNative));
        }
    }

    public boolean isSynchronizedGen() {
        return (this.eFlags & 0x1000) != 0;
    }

    @Override
    public void setSynchronized(boolean newSynchronized) {
        boolean oldSynchronized;
        boolean bl = oldSynchronized = (this.eFlags & 0x1000) != 0;
        this.eFlags = newSynchronized ? (this.eFlags |= 0x1000) : (this.eFlags &= 0xFFFFEFFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldSynchronized, newSynchronized));
        }
    }

    public boolean isFinalGen() {
        return (this.eFlags & 0x2000) != 0;
    }

    @Override
    public void setFinal(boolean newFinal) {
        boolean oldFinal;
        boolean bl = oldFinal = (this.eFlags & 0x2000) != 0;
        this.eFlags = newFinal ? (this.eFlags |= 0x2000) : (this.eFlags &= 0xFFFFDFFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldFinal, newFinal));
        }
    }

    public boolean isConstructorGen() {
        return (this.eFlags & 0x4000) != 0;
    }

    @Override
    public void setConstructor(boolean newConstructor) {
        boolean oldConstructor;
        boolean bl = oldConstructor = (this.eFlags & 0x4000) != 0;
        this.eFlags = newConstructor ? (this.eFlags |= 0x4000) : (this.eFlags &= 0xFFFFBFFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, oldConstructor, newConstructor));
        }
    }

    public boolean isStaticGen() {
        return (this.eFlags & 0x8000) != 0;
    }

    @Override
    public void setStatic(boolean newStatic) {
        boolean oldStatic;
        boolean bl = oldStatic = (this.eFlags & 0x8000) != 0;
        this.eFlags = newStatic ? (this.eFlags |= 0x8000) : (this.eFlags &= 0xFFFF7FFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, oldStatic, newStatic));
        }
    }

    @Override
    public JavaClass getContainingJavaClass() {
        return this.getJavaClass();
    }

    @Override
    public boolean isAbstract() {
        this.reflectValues();
        return this.isAbstractGen();
    }

    @Override
    public boolean isConstructor() {
        this.reflectValues();
        return this.isConstructorGen();
    }

    @Override
    public boolean isFinal() {
        this.reflectValues();
        return this.isFinalGen();
    }

    @Override
    public boolean isNative() {
        this.reflectValues();
        return this.isNativeGen();
    }

    @Override
    public boolean isStatic() {
        this.reflectValues();
        return this.isStaticGen();
    }

    @Override
    public boolean isSynchronized() {
        this.reflectValues();
        return this.isSynchronizedGen();
    }

    @Override
    public EList getJavaExceptions() {
        this.reflectValues();
        return this.getJavaExceptionsGen();
    }

    @Override
    public JavaVisibilityKind getJavaVisibility() {
        this.reflectValues();
        return this.getJavaVisibilityGen();
    }

    @Override
    public EList getParameters() {
        this.reflectValues();
        return this.getParametersGen();
    }

    public EClassifier getEType() {
        this.reflectValues();
        return super.getEType();
    }

    @Override
    public String getMethodElementSignature() {
        StringBuffer sb = new StringBuffer(75);
        sb.append(this.getName());
        sb.append("(");
        EList params = this.getParameters();
        int parmSize = params.size();
        int commaTest = 0;
        int j = 0;
        while (j < parmSize) {
            if (j > commaTest) {
                sb.append(",");
            }
            JavaParameter param = (JavaParameter)params.get(j);
            sb.append(((JavaHelpers)param.getEType()).getQualifiedName());
            ++j;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public JavaParameter getParameter(String parameterName) {
        EList parms = this.getParameters();
        int parmSize = parms.size();
        int j = 0;
        while (j < parmSize) {
            JavaParameter parm = (JavaParameter)parms.get(j);
            if (parm.getName().equals(parameterName)) {
                return parm;
            }
            ++j;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectValues() {
        ReadAdaptor readAdaptor = null;
        MethodImpl methodImpl = this;
        synchronized (methodImpl) {
            if ((this.reflectionStatus & 1) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = readAdaptor.reflectValuesIfNecessary();
            MethodImpl methodImpl2 = this;
            synchronized (methodImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 1;
                }
            }
        }
    }

    public synchronized ReadAdaptor getReadAdapter() {
        return (ReadAdaptor)EcoreUtil.getRegisteredAdapter((EObject)this, (Object)"JavaReflection");
    }

    public synchronized void setReflected(boolean reflected) {
        if (!reflected) {
            this.reflectionStatus = 0;
        }
    }

    @Override
    public JavaHelpers getReturnType() {
        return (JavaHelpers)this.getEType();
    }

    @Override
    public String getSignature() {
        if (this.signature == null) {
            this.signature = this.doGetSignature();
        }
        return this.signature;
    }

    protected String doGetSignature() {
        StringBuffer sb = new StringBuffer();
        switch (this.getJavaVisibility().getValue()) {
            case 0: {
                sb.append("Public ");
                break;
            }
            case 2: {
                sb.append("Protected ");
                break;
            }
            case 1: {
                sb.append("Private ");
                break;
            }
            case 3: {
                sb.append("Package ");
            }
        }
        if (this.isAbstract()) {
            sb.append("abstract ");
        }
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isFinal()) {
            sb.append("final ");
        }
        if (this.isSynchronized()) {
            sb.append("synchronized ");
        }
        if (this.isNative()) {
            sb.append("native ");
        }
        if (this.isVoid()) {
            sb.append("void ");
        } else {
            sb.append(String.valueOf(this.getReturnType().getQualifiedName()) + " ");
        }
        sb.append(String.valueOf(this.getContainingJavaClass().getJavaName()) + ".");
        sb.append(String.valueOf(this.getName()) + "(");
        EList params = this.getParameters();
        int parmSize = params.size();
        int j = 0;
        while (j < parmSize) {
            JavaParameter param = (JavaParameter)params.get(j);
            sb.append(((JavaHelpers)param.getEType()).getQualifiedName());
            if (j < params.size() - 1) {
                sb.append(",");
            }
            ++j;
        }
        sb.append(")");
        EList exceptions = this.getJavaExceptions();
        if (exceptions.size() > 0) {
            sb.append(" throws ");
            int k = 0;
            while (k < exceptions.size()) {
                JavaClass exception = (JavaClass)exceptions.get(k);
                sb.append(exception.getJavaName());
                if (k < exceptions.size() - 1) {
                    sb.append(",");
                }
                ++k;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectGenerated() {
        ReadAdaptor readAdaptor = null;
        MethodImpl methodImpl = this;
        synchronized (methodImpl) {
            if ((this.reflectionStatus & 2) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = ((IJavaMethodAdapter)((Object)readAdaptor)).reflectGeneratedIfNecessary();
            MethodImpl methodImpl2 = this;
            synchronized (methodImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 3;
                }
            }
        }
    }

    @Override
    public boolean isGenerated() {
        this.reflectGenerated();
        return this.isGenerated;
    }

    public boolean isGeneratedGen() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVoid() {
        return this.getReturnType() == null || "void".equals(this.getReturnType().getName());
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 24: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetJavaClass((JavaClass)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 22: {
                return ((InternalEList)this.getParameters()).basicRemove((Object)otherEnd, msgs);
            }
            case 24: {
                JavaClass newContainer = null;
                ReadAdaptor readAdaptor = this.getReadAdapter();
                if (readAdaptor instanceof JavaReflectionAdaptor && otherEnd instanceof JavaClass) {
                    newContainer = ((JavaReflectionAdaptor)readAdaptor).createJavaClassRef(((JavaClass)otherEnd).getJavaName());
                }
                return this.basicSetJavaClass(newContainer, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 24: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 31, JavaClass.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 15: {
                return this.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.isNative() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.isSynchronized() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return this.isFinal() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return this.isConstructor() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 20: {
                return this.isStatic() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 21: {
                return this.getJavaVisibility();
            }
            case 22: {
                return this.getParameters();
            }
            case 23: {
                return this.getJavaExceptions();
            }
            case 24: {
                return this.getJavaClass();
            }
            case 25: {
                if (resolve) {
                    return this.getSource();
                }
                return this.basicGetSource();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 15: {
                this.setAbstract((Boolean)newValue);
                return;
            }
            case 16: {
                this.setNative((Boolean)newValue);
                return;
            }
            case 17: {
                this.setSynchronized((Boolean)newValue);
                return;
            }
            case 18: {
                this.setFinal((Boolean)newValue);
                return;
            }
            case 19: {
                this.setConstructor((Boolean)newValue);
                return;
            }
            case 20: {
                this.setStatic((Boolean)newValue);
                return;
            }
            case 21: {
                this.setJavaVisibility((JavaVisibilityKind)((Object)newValue));
                return;
            }
            case 22: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.getJavaExceptions().clear();
                this.getJavaExceptions().addAll((Collection)newValue);
                return;
            }
            case 24: {
                this.setJavaClass((JavaClass)newValue);
                return;
            }
            case 25: {
                this.setSource((Block)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 15: {
                this.setAbstract(false);
                return;
            }
            case 16: {
                this.setNative(false);
                return;
            }
            case 17: {
                this.setSynchronized(false);
                return;
            }
            case 18: {
                this.setFinal(false);
                return;
            }
            case 19: {
                this.setConstructor(false);
                return;
            }
            case 20: {
                this.setStatic(false);
                return;
            }
            case 21: {
                this.setJavaVisibility(JAVA_VISIBILITY_EDEFAULT);
                return;
            }
            case 22: {
                this.getParameters().clear();
                return;
            }
            case 23: {
                this.getJavaExceptions().clear();
                return;
            }
            case 24: {
                this.setJavaClass(null);
                return;
            }
            case 25: {
                this.setSource(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 15: {
                return (this.eFlags & 0x400) != 0;
            }
            case 16: {
                return (this.eFlags & 0x800) != 0;
            }
            case 17: {
                return (this.eFlags & 0x1000) != 0;
            }
            case 18: {
                return (this.eFlags & 0x2000) != 0;
            }
            case 19: {
                return (this.eFlags & 0x4000) != 0;
            }
            case 20: {
                return (this.eFlags & 0x8000) != 0;
            }
            case 21: {
                return this.javaVisibility != JAVA_VISIBILITY_EDEFAULT;
            }
            case 22: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
            case 23: {
                return this.javaExceptions != null && !this.javaExceptions.isEmpty();
            }
            case 24: {
                return this.getJavaClass() != null;
            }
            case 25: {
                return this.source != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public JavaParameter[] listParametersWithoutReturn() {
        EList v = this.getParameters();
        JavaParameter[] result = new JavaParameter[v.size()];
        v.toArray(result);
        return result;
    }

    public EList eContents() {
        BasicEList results = new BasicEList();
        results.addAll((Collection)this.getParametersGen());
        return results;
    }

    @Override
    public void setIsGenerated(boolean generated) {
        this.isGenerated = generated;
    }

    @Override
    public void setReturnType(JavaHelpers type) {
        this.setEType((EClassifier)type);
    }

    public JavaVisibilityKind getJavaVisibilityGen() {
        return this.javaVisibility;
    }

    @Override
    public void setJavaVisibility(JavaVisibilityKind newJavaVisibility) {
        JavaVisibilityKind oldJavaVisibility = this.javaVisibility;
        JavaVisibilityKind javaVisibilityKind = this.javaVisibility = newJavaVisibility == null ? JAVA_VISIBILITY_EDEFAULT : newJavaVisibility;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldJavaVisibility, (Object)this.javaVisibility));
        }
    }

    @Override
    public JavaClass getJavaClass() {
        if (this.eContainerFeatureID() != 24) {
            return null;
        }
        return (JavaClass)this.eContainer();
    }

    public NotificationChain basicSetJavaClass(JavaClass newJavaClass, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newJavaClass, 24, msgs);
        return msgs;
    }

    @Override
    public void setJavaClass(JavaClass newJavaClass) {
        if (newJavaClass != this.eInternalContainer() || this.eContainerFeatureID() != 24 && newJavaClass != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newJavaClass)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newJavaClass != null) {
                msgs = ((InternalEObject)newJavaClass).eInverseAdd((InternalEObject)this, 31, JavaClass.class, msgs);
            }
            if ((msgs = this.basicSetJavaClass(newJavaClass, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)newJavaClass, (Object)newJavaClass));
        }
    }

    @Override
    public Block getSource() {
        if (this.source != null && this.source.eIsProxy()) {
            InternalEObject oldSource = (InternalEObject)this.source;
            this.source = (Block)this.eResolveProxy(oldSource);
            if (this.source != oldSource && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 25, (Object)oldSource, (Object)this.source));
            }
        }
        return this.source;
    }

    public Block basicGetSource() {
        return this.source;
    }

    @Override
    public void setSource(Block newSource) {
        Block oldSource = this.source;
        this.source = newSource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 25, (Object)oldSource, (Object)this.source));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (abstract: ");
        result.append((this.eFlags & 0x400) != 0);
        result.append(", native: ");
        result.append((this.eFlags & 0x800) != 0);
        result.append(", synchronized: ");
        result.append((this.eFlags & 0x1000) != 0);
        result.append(", final: ");
        result.append((this.eFlags & 0x2000) != 0);
        result.append(", constructor: ");
        result.append((this.eFlags & 0x4000) != 0);
        result.append(", static: ");
        result.append((this.eFlags & 0x8000) != 0);
        result.append(", javaVisibility: ");
        result.append((Object)this.javaVisibility);
        result.append(')');
        return result.toString();
    }

    public EList getParametersGen() {
        if (this.parameters == null) {
            this.parameters = new EObjectContainmentEList(JavaParameter.class, (InternalEObject)this, 22);
        }
        return this.parameters;
    }

    public EList getJavaExceptionsGen() {
        if (this.javaExceptions == null) {
            this.javaExceptions = new EObjectResolvingEList(JavaClass.class, (InternalEObject)this, 23);
        }
        return this.javaExceptions;
    }

    public EList<EObject> eCrossReferences() {
        return ECrossReferenceEList.createECrossReferenceEList((EObject)this);
    }

    public void setEType(EClassifier newEType) {
        ReadAdaptor readAdaptor;
        Object newContainer = newEType;
        if (this.eType != null && newEType == null && (readAdaptor = this.getReadAdapter()) instanceof JavaReflectionAdaptor) {
            newContainer = ((JavaReflectionAdaptor)readAdaptor).createJavaClassRef(((JavaHelpers)this.eType).getJavaName());
        }
        super.setEType(newContainer);
    }

    public NotificationChain setEType(EClassifier newEType, NotificationChain msgs) {
        ReadAdaptor readAdaptor;
        Object newContainer = newEType;
        if (this.eType != null && newEType == null && (readAdaptor = this.getReadAdapter()) instanceof JavaReflectionAdaptor) {
            newContainer = ((JavaReflectionAdaptor)readAdaptor).createJavaClassRef(((JavaHelpers)this.eType).getJavaName());
        }
        return super.setEType(newContainer, msgs);
    }
}

