/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation.ValidationTestsSetUp;
import org.eclipse.jst.ws.jaxws.utils.resources.StringInputStreamAdapter;

public class WsValidationTest
extends ValidationTestsSetUp {
    private IType wsType;

    public void setUp() throws Exception {
        super.setUp();
        this.wsType = this.testProject.createType(this.testPack, "Ws.java", "@javax.jws.WebService(serviceName=\"WsName\") public class Ws {}");
        this.testProject.build(10);
        WsValidationTest.assertNotNull((String)"Web service not found", (Object)this.findWs("test.Ws"));
    }

    public void testServiceNameIsNCName() throws CoreException {
        this.assertNoValidationErrors(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(serviceName=\"---\") public class Ws {}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 48);
        markerAttributes.put("charEnd", 53);
        markerAttributes.put("lineNumber", 2);
        markerAttributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.wsType.getResource(), markerData);
    }

    public void testPortNameIsNCName() throws CoreException {
        this.assertNoValidationErrors(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(portName=\"---\") public class Ws {}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 45);
        markerAttributes.put("charEnd", 50);
        markerAttributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.wsType.getResource(), markerData);
    }

    public void testTargetNsIsUri() throws CoreException {
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(targetNamespace=\"^^^\") public class Ws {}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 52);
        markerAttributes.put("charEnd", 57);
        markerAttributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.wsType.getResource(), markerData);
    }

    public void testSEIExists() throws CoreException {
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(endpointInterface=\"com.sap.demo.Test\") public class Ws {}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 54);
        markerAttributes.put("charEnd", 73);
        markerAttributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.wsType.getResource(), markerData);
    }

    public void testNameMissingIfSeiReferenced() throws CoreException {
        IType sei = this.testProject.createType(this.testPack, "Sei.java", "@javax.jws.WebService(name=\"SeiName\") public interface Sei {}");
        WsValidationTest.assertNotNull((Object)sei);
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(endpointInterface=\"test.Sei\") public class Ws {}");
        this.assertNoValidationErrors(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(name=\"Test\", endpointInterface=\"test.Sei\") public class Ws {}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 41);
        markerAttributes.put("charEnd", 47);
        markerAttributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.wsType.getResource(), markerData);
    }

    public void testWsdlLocationInProject() throws CoreException {
        IFile file = this.testProject.getProject().getFolder("WebContent").getFile("Test.wsdl");
        file.create((InputStream)new StringInputStreamAdapter(""), true, null);
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(name=\"Test\", wsdlLocation=\"Test.wsdl\") public class Ws {}");
        this.testProject.build(15);
        this.assertNoValidationErrors(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(name=\"Test\", wsdlLocation=\"Test1.wsdl\") public class Ws {}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 62);
        markerAttributes.put("charEnd", 74);
        markerAttributes.put("severity", 1);
        markerAttributes.put("message", MessageFormat.format(JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_UNABLE_TO_LOCATE, "Test1.wsdl"));
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.wsType.getResource(), markerData);
    }

    public void testWsdlLocationInWebInfCorrect() throws CoreException {
        IFolder webInf = this.testProject.getProject().getFolder("WebContent").getFolder("WEB-INF");
        IFile file = webInf.getFile("Test.wsdl");
        file.create((InputStream)new StringInputStreamAdapter(""), true, null);
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(name=\"Test\", wsdlLocation=\"WEB-INF/Test.wsdl\") public class Ws {}");
        this.assertNoValidationErrors(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
    }

    public void testWsdlLocationEmpty() throws CoreException {
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(name=\"Test\", wsdlLocation=\"\") public class Ws {}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 62);
        markerAttributes.put("charEnd", 64);
        markerAttributes.put("severity", 2);
        markerAttributes.put("message", MessageFormat.format(JAXWSCoreMessages.EMPTY_ATTRIBUTE_VALUE, "WebService", "wsdlLocation"));
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.wsType.getResource(), markerData);
    }

    public void testWsdlLocationAbsoluteUrl() throws CoreException, MalformedURLException {
        IFile file = this.testProject.getProject().getFile("Test.wsdl");
        file.create((InputStream)new StringInputStreamAdapter(""), true, null);
        String fileUrl = file.getLocation().toFile().toURI().toURL().toString();
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(name=\"Test\", wsdlLocation=\"" + fileUrl + "\") public class Ws {}");
        this.testProject.build(15);
        this.assertNoValidationErrors(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
    }

    public void testEndpointImplementsSei() throws CoreException {
        IType seiType = this.testProject.createType(this.testPack, "Sei.java", "@javax.jws.WebService public interface Sei {public void test();public int second(int a, int b, String c);}");
        this.setContents(this.wsType.getCompilationUnit(), "@javax.jws.WebService(endpointInterface=\"test.Sei\") public class Ws {public void test() {}}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 54);
        markerAttributes.put("charEnd", 64);
        markerAttributes.put("lineNumber", 2);
        markerAttributes.put("severity", 2);
        markerAttributes.put("message", MessageFormat.format(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_MUST_IMPLEMENT, "Sei.second(int, int, String)"));
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this.wsType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.wsType.getResource(), markerData);
        IServiceEndpointInterface sei = this.findSei("test.Sei");
        WsValidationTest.assertNotNull((Object)sei);
        this.assertNoValidationErrors(seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
    }
}

