/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.annotations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.ILocator;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationImpl;

public class AnnotationsBaseImplTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void setUp() throws CoreException, IOException, AnnotationGeneratorException {
        this.setUpWitoutRemove();
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
    }

    public void setUpWitoutRemove() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
    }

    public void setUpWitoutRemove2() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("EndpointAnnInspector.src", "EndpointAnnInspector");
    }

    public void testBaseAnnotattionFunctionality() {
        AnnotationImpl ann = new AnnotationImpl("com.spa.test.MyAnnotation", new HashSet());
        AnnotationsBaseImplTest.assertEquals((String)ann.getAnnotationName(), (String)"com.spa.test.MyAnnotation");
        AnnotationsBaseImplTest.assertEquals((String)ann.getSimpleAnnotationName(), (String)"MyAnnotation");
        ann = new AnnotationImpl("MyNewAnnotation", new HashSet());
        AnnotationsBaseImplTest.assertEquals((String)ann.getAnnotationName(), (String)"MyNewAnnotation");
        AnnotationsBaseImplTest.assertEquals((String)ann.getSimpleAnnotationName(), (String)"MyNewAnnotation");
    }

    public void testAddAnnotation() throws Exception {
        IMethod[] methods;
        this.setUp();
        IValue qv = AnnotationFactory.createQualifiedNameValue((String)"full.qualified.Name");
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)qv));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)this.endpoint);
        Collection annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationsBaseImplTest.assertNotNull((Object)annotations);
        AnnotationsBaseImplTest.assertTrue((annotations.size() == 1 ? 1 : 0) != 0);
        IAnnotation tmpAnn = (IAnnotation)annotations.iterator().next();
        AnnotationWriter.getInstance().remove(tmpAnn);
        annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationsBaseImplTest.assertTrue((annotations.size() == 0 ? 1 : 0) != 0);
        IMethod[] iMethodArray = methods = this.endpoint.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getRawParameterNames() != null && method.getRawParameterNames().length > 0) {
                IAnnotation annM = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotationMethod", pv, (IJavaElement)method);
                AnnotationWriter.getInstance().setAppliedElement(annM, (IJavaElement)method);
                AnnotationsBaseImplTest.assertEquals((String)"full.qualified.Name", (String)annM.getPropertyValue("param"));
                AnnotationsBaseImplTest.assertNull((Object)annM.getPropertyValue("paramNotExists"));
                Collection annotationsM = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
                IAnnotation annotatM = (IAnnotation)annotationsM.iterator().next();
                AnnotationsBaseImplTest.assertEquals((String)"qualified.Name", (String)annotatM.getPropertyValue("param"));
                IValue sv = AnnotationFactory.createStringValue((String)"New String Value");
                annM.getParamValuePairs().add(AnnotationFactory.createParamValuePairValue((String)"NewParam", (IValue)sv));
                AnnotationWriter.getInstance().update(annM);
                annotationsM = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
                AnnotationsBaseImplTest.assertTrue((annotationsM.size() == 1 ? 1 : 0) != 0);
                annotatM = (IAnnotation)annotationsM.iterator().next();
                AnnotationsBaseImplTest.assertEquals((String)"New String Value", (String)annotatM.getPropertyValue("NewParam"));
                AnnotationsBaseImplTest.assertEquals((String)"qualified.Name", (String)annotatM.getPropertyValue("param"));
                AnnotationWriter.getInstance().remove(annotatM);
                annotationsM = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
                AnnotationsBaseImplTest.assertTrue((annotationsM.size() == 0 ? 1 : 0) != 0);
                IValue sv3 = AnnotationFactory.createStringValue((String)"New String Value3");
                annM.getParamValuePairs().clear();
                annM.getParamValuePairs().add(AnnotationFactory.createParamValuePairValue((String)"NewParam", (IValue)sv3));
                AnnotationWriter.getInstance().update(annM);
                annotationsM = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
                AnnotationsBaseImplTest.assertTrue((annotationsM.size() == 1 ? 1 : 0) != 0);
                annotatM = (IAnnotation)annotationsM.iterator().next();
                AnnotationsBaseImplTest.assertEquals((String)"New String Value3", (String)annotatM.getPropertyValue("NewParam"));
                AnnotationWriter.getInstance().remove(annM);
                annotationsM = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
                AnnotationsBaseImplTest.assertTrue((annotationsM.size() == 0 ? 1 : 0) != 0);
                int i = 0;
                while (i < method.getRawParameterNames().length) {
                    ITypeParameter param = method.getTypeParameter(method.getRawParameterNames()[i]);
                    IValue svParam = AnnotationFactory.createStringValue((String)"String Valu Param");
                    HashSet<IParamValuePair> pvParam = new HashSet<IParamValuePair>();
                    pvParam.add(AnnotationFactory.createParamValuePairValue((String)"ParamAtribute", (IValue)svParam));
                    IAnnotation annP = AnnotationFactory.createAnnotation((String)"ParamAnnotation", pvParam, (IJavaElement)param);
                    AnnotationWriter.getInstance().setAppliedElement(annP, (IJavaElement)param);
                    AnnotationWriter.getInstance().remove(annP);
                    ++i;
                }
            }
            ++n2;
        }
    }

    public void testAnnotattionUpdate() throws Exception {
        this.setUp();
        IValue sv = AnnotationFactory.createStringValue((String)"StringValue");
        HashSet<IParamValuePair> spv = new HashSet<IParamValuePair>();
        spv.add(AnnotationFactory.createParamValuePairValue((String)"stringParam", (IValue)sv));
        IAnnotation typeAnnotation = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyTypeAnnotation", spv, (IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().setAppliedElement(typeAnnotation, (IJavaElement)this.endpoint);
        Collection typeAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationsBaseImplTest.assertNotNull((Object)typeAnnotations);
        AnnotationsBaseImplTest.assertTrue((typeAnnotations.size() == 1 ? 1 : 0) != 0);
        IAnnotation tempTypeAnnotation = (IAnnotation)typeAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertEquals((String)tempTypeAnnotation.getPropertyValue("stringParam"), (String)"StringValue");
        IValue newSV = AnnotationFactory.createStringValue((String)"NewStringValue");
        HashSet<IParamValuePair> newSPV = new HashSet<IParamValuePair>();
        newSPV.add(AnnotationFactory.createParamValuePairValue((String)"stringParam", (IValue)newSV));
        AnnotationImpl newTypeAnnotation = new AnnotationImpl("org.eclipse.test.MyTypeAnnotation", newSPV);
        newTypeAnnotation.setAppliedElementWithoutSave((IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().update((IAnnotation)newTypeAnnotation);
        typeAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationsBaseImplTest.assertNotNull((Object)typeAnnotations);
        AnnotationsBaseImplTest.assertTrue((typeAnnotations.size() == 1 ? 1 : 0) != 0);
        tempTypeAnnotation = (IAnnotation)typeAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertEquals((String)tempTypeAnnotation.getPropertyValue("stringParam"), (String)"NewStringValue");
        newSV = AnnotationFactory.createStringValue((String)"NewestStringValue");
        newSPV = new HashSet();
        newSPV.add(AnnotationFactory.createParamValuePairValue((String)"newestStringParam", (IValue)newSV));
        newTypeAnnotation = new AnnotationImpl("org.eclipse.test.MyTypeAnnotation", newSPV);
        newTypeAnnotation.setAppliedElementWithoutSave((IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().update((IAnnotation)newTypeAnnotation);
        typeAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationsBaseImplTest.assertNotNull((Object)typeAnnotations);
        AnnotationsBaseImplTest.assertTrue((typeAnnotations.size() == 1 ? 1 : 0) != 0);
        tempTypeAnnotation = (IAnnotation)typeAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertNull((Object)tempTypeAnnotation.getPropertyValue("stringParam"));
        AnnotationsBaseImplTest.assertEquals((String)tempTypeAnnotation.getPropertyValue("newestStringParam"), (String)"NewestStringValue");
        IMethod firstMethod = this.endpoint.getMethods()[0];
        IValue iv = AnnotationFactory.createIntegerValue((String)"10");
        HashSet<IParamValuePair> ipv = new HashSet<IParamValuePair>();
        ipv.add(AnnotationFactory.createParamValuePairValue((String)"integerParam", (IValue)iv));
        IAnnotation methodAnnotation = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyMethodAnnotation", ipv, (IJavaElement)firstMethod);
        AnnotationWriter.getInstance().setAppliedElement(methodAnnotation, (IJavaElement)firstMethod);
        Collection methodAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(firstMethod);
        AnnotationsBaseImplTest.assertNotNull((Object)methodAnnotations);
        AnnotationsBaseImplTest.assertTrue((methodAnnotations.size() == 1 ? 1 : 0) != 0);
        IAnnotation tempMethodAnnotation = (IAnnotation)methodAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertEquals((String)tempMethodAnnotation.getPropertyValue("integerParam"), (String)"10");
        IValue newIV = AnnotationFactory.createIntegerValue((String)"11");
        HashSet<IParamValuePair> newIPV = new HashSet<IParamValuePair>();
        newIPV.add(AnnotationFactory.createParamValuePairValue((String)"integerParam", (IValue)newIV));
        AnnotationImpl newMethodAnnotation = new AnnotationImpl("org.eclipse.test.MyMethodAnnotation", newIPV);
        newMethodAnnotation.setAppliedElementWithoutSave((IJavaElement)firstMethod);
        AnnotationWriter.getInstance().update((IAnnotation)newMethodAnnotation);
        methodAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(firstMethod);
        AnnotationsBaseImplTest.assertNotNull((Object)methodAnnotations);
        AnnotationsBaseImplTest.assertTrue((methodAnnotations.size() == 1 ? 1 : 0) != 0);
        tempMethodAnnotation = (IAnnotation)methodAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertEquals((String)tempMethodAnnotation.getPropertyValue("integerParam"), (String)"11");
        newIV = AnnotationFactory.createIntegerValue((String)"100");
        newIPV = new HashSet();
        newIPV.add(AnnotationFactory.createParamValuePairValue((String)"newestIntegerParam", (IValue)newIV));
        newMethodAnnotation = new AnnotationImpl("org.eclipse.test.MyMethodAnnotation", newIPV);
        newMethodAnnotation.setAppliedElementWithoutSave((IJavaElement)firstMethod);
        AnnotationWriter.getInstance().update((IAnnotation)newMethodAnnotation);
        methodAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(firstMethod);
        AnnotationsBaseImplTest.assertNotNull((Object)methodAnnotations);
        AnnotationsBaseImplTest.assertTrue((methodAnnotations.size() == 1 ? 1 : 0) != 0);
        tempMethodAnnotation = (IAnnotation)methodAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertNull((Object)tempMethodAnnotation.getPropertyValue("integerParam"));
        AnnotationsBaseImplTest.assertEquals((String)tempMethodAnnotation.getPropertyValue("newestIntegerParam"), (String)"100");
        ITypeParameter typeParameter = firstMethod.getTypeParameter("annotatedParam");
        IValue bv = AnnotationFactory.createBooleanValue((boolean)true);
        HashSet<IParamValuePair> bpv = new HashSet<IParamValuePair>();
        bpv.add(AnnotationFactory.createParamValuePairValue((String)"booleanParam", (IValue)bv));
        IAnnotation parameterAnnotation = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyParameterAnnotation", bpv, (IJavaElement)typeParameter);
        AnnotationWriter.getInstance().setAppliedElement(parameterAnnotation, (IJavaElement)typeParameter);
        Collection parameterAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(typeParameter);
        AnnotationsBaseImplTest.assertNotNull((Object)parameterAnnotations);
        AnnotationsBaseImplTest.assertTrue((parameterAnnotations.size() == 1 ? 1 : 0) != 0);
        IAnnotation tempParameterAnnotation = (IAnnotation)parameterAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertEquals((String)tempParameterAnnotation.getPropertyValue("booleanParam"), (String)"true");
        IValue newBV = AnnotationFactory.createBooleanValue((boolean)false);
        HashSet<IParamValuePair> newBPV = new HashSet<IParamValuePair>();
        newBPV.add(AnnotationFactory.createParamValuePairValue((String)"booleanParam", (IValue)newBV));
        AnnotationImpl newParameterAnnotation = new AnnotationImpl("org.eclipse.test.MyParameterAnnotation", newBPV);
        newParameterAnnotation.setAppliedElementWithoutSave((IJavaElement)typeParameter);
        AnnotationWriter.getInstance().update((IAnnotation)newParameterAnnotation);
        parameterAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(typeParameter);
        AnnotationsBaseImplTest.assertNotNull((Object)parameterAnnotations);
        AnnotationsBaseImplTest.assertTrue((parameterAnnotations.size() == 1 ? 1 : 0) != 0);
        tempParameterAnnotation = (IAnnotation)parameterAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertEquals((String)tempParameterAnnotation.getPropertyValue("booleanParam"), (String)"false");
        newBV = AnnotationFactory.createBooleanValue((boolean)true);
        newBPV = new HashSet();
        newBPV.add(AnnotationFactory.createParamValuePairValue((String)"newestBooleanParam", (IValue)newBV));
        newParameterAnnotation = new AnnotationImpl("org.eclipse.test.MyParameterAnnotation", newBPV);
        newParameterAnnotation.setAppliedElementWithoutSave((IJavaElement)typeParameter);
        AnnotationWriter.getInstance().update((IAnnotation)newParameterAnnotation);
        parameterAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(typeParameter);
        AnnotationsBaseImplTest.assertNotNull((Object)parameterAnnotations);
        AnnotationsBaseImplTest.assertTrue((parameterAnnotations.size() == 1 ? 1 : 0) != 0);
        tempParameterAnnotation = (IAnnotation)parameterAnnotations.iterator().next();
        AnnotationsBaseImplTest.assertNull((Object)tempParameterAnnotation.getPropertyValue("booleanParam"));
        AnnotationsBaseImplTest.assertEquals((String)tempParameterAnnotation.getPropertyValue("newestBooleanParam"), (String)"true");
    }

    public void testSetAppliedElementWithoutSave() throws Exception {
        this.setUp();
        IValue qv = AnnotationFactory.createQualifiedNameValue((String)"full.qualified.Name");
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)qv));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint);
        try {
            AnnotationWriter.getInstance().setAppliedElement(ann, null);
            AnnotationsBaseImplTest.fail((String)"NullPointerException was not thrown.");
        }
        catch (NullPointerException nullPointerException) {
            AnnotationsBaseImplTest.assertTrue((boolean)true);
        }
    }

    public void testMultyAddAnnotation() throws Exception {
        this.setUpWitoutRemove();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    IMethod[] methods;
                    HashSet<String> annoSet = new HashSet<String>();
                    annoSet.add("Stateless");
                    AnnotationFactory.removeAnnotations((IJavaElement)AnnotationsBaseImplTest.this.endpoint, annoSet);
                    IValue qv = AnnotationFactory.createQualifiedNameValue((String)"full.qualified.Name");
                    HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
                    pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)qv));
                    IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)AnnotationsBaseImplTest.this.endpoint);
                    AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)AnnotationsBaseImplTest.this.endpoint);
                    IValue sv = AnnotationFactory.createStringValue((String)"StringValue");
                    HashSet<IParamValuePair> spv = new HashSet<IParamValuePair>();
                    spv.add(AnnotationFactory.createParamValuePairValue((String)"stringParam", (IValue)sv));
                    IAnnotation sAnn = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyStringAnnotation", spv, (IJavaElement)AnnotationsBaseImplTest.this.endpoint);
                    AnnotationWriter.getInstance().setAppliedElement(sAnn, (IJavaElement)AnnotationsBaseImplTest.this.endpoint);
                    Collection annotations = AnnotationFactory.createAnnotationInspector((IType)AnnotationsBaseImplTest.this.endpoint).inspectType();
                    AnnotationsBaseImplTest.assertNotNull((Object)annotations);
                    AnnotationsBaseImplTest.assertTrue((annotations.size() == 3 ? 1 : 0) != 0);
                    IAnnotation tmpAnn = (IAnnotation)annotations.iterator().next();
                    AnnotationWriter.getInstance().remove(tmpAnn);
                    annotations = AnnotationFactory.createAnnotationInspector((IType)AnnotationsBaseImplTest.this.endpoint).inspectType();
                    AnnotationsBaseImplTest.assertTrue((annotations.size() == 2 ? 1 : 0) != 0);
                    IMethod[] iMethodArray = methods = AnnotationsBaseImplTest.this.endpoint.getMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        IValue smv = AnnotationFactory.createStringValue((String)"StringValue");
                        HashSet<IParamValuePair> smpv = new HashSet<IParamValuePair>();
                        smpv.add(AnnotationFactory.createParamValuePairValue((String)"stringParam", (IValue)smv));
                        IAnnotation smAnn = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotationMethod", smpv, (IJavaElement)method);
                        AnnotationWriter.getInstance().setAppliedElement(smAnn, (IJavaElement)method);
                        Collection annotationsM = AnnotationFactory.createAnnotationInspector((IType)AnnotationsBaseImplTest.this.endpoint).inspectMethod(method);
                        AnnotationsBaseImplTest.assertNotNull((Object)annotationsM);
                        AnnotationsBaseImplTest.assertTrue((annotationsM.size() == 2 ? 1 : 0) != 0);
                        annotations = AnnotationFactory.createAnnotationInspector((IType)AnnotationsBaseImplTest.this.endpoint).inspectType();
                        AnnotationsBaseImplTest.assertNotNull((Object)annotations);
                        AnnotationsBaseImplTest.assertTrue((annotations.size() == 2 ? 1 : 0) != 0);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    AnnotationsBaseImplTest.fail((String)e.getMessage());
                }
            }
        };
        this.getTestProject().getSourceFolder().getResource().getWorkspace().run(runnable, null);
    }

    public void testEquals() {
        IValue qv = AnnotationFactory.createQualifiedNameValue((String)"full.qualified.Name");
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)qv));
        IAnnotation ann1 = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation1", pv, (IJavaElement)this.endpoint);
        IAnnotation ann2 = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation2", pv, (IJavaElement)this.endpoint);
        IAnnotation ann3 = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation1", pv, (IJavaElement)this.endpoint);
        AnnotationsBaseImplTest.assertTrue((boolean)ann1.equals(ann1));
        AnnotationsBaseImplTest.assertFalse((boolean)ann1.equals(null));
        AnnotationsBaseImplTest.assertFalse((boolean)ann1.equals(qv));
        AnnotationsBaseImplTest.assertFalse((boolean)ann1.equals(ann2));
        AnnotationsBaseImplTest.assertTrue((boolean)ann1.equals(ann3));
    }

    public void testField() throws Exception {
        this.setUp();
        IValue qv = AnnotationFactory.createQualifiedNameValue((String)"full.qualified.Name");
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)qv));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint.getField("field1"));
        AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)this.endpoint.getField("field1"));
        AnnotationsBaseImplTest.assertEquals((Object)ann.getAppliedElement(), (Object)this.endpoint.getField("field1"));
    }

    public void testLocator() throws Exception {
        this.setUpWitoutRemove2();
        IAnnotation inspectedTypeAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType("org.eclipse.demo.MyAnnotation");
        AnnotationsBaseImplTest.assertNotNull((Object)inspectedTypeAnnotation);
        ILocator locator = inspectedTypeAnnotation.getLocator();
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected annotation start position", (int)191, (int)locator.getStartPosition());
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected length", (int)33, (int)locator.getLength());
        Set parmValues = inspectedTypeAnnotation.getParamValuePairs();
        for (IParamValuePair paramValuePair : parmValues) {
            if (!paramValuePair.getParam().equals("myValue")) continue;
            locator = paramValuePair.getLocator();
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected annotation parameter start position", (int)205, (int)locator.getStartPosition());
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected annotation parameter length", (int)18, (int)locator.getLength());
        }
        inspectedTypeAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType("javax.jws.WebService");
        AnnotationsBaseImplTest.assertNotNull((Object)inspectedTypeAnnotation);
        locator = inspectedTypeAnnotation.getLocator();
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected @WebService annotation start position", (int)226, (int)locator.getStartPosition());
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected @WebService annotation length", (int)134, (int)locator.getLength());
        parmValues = inspectedTypeAnnotation.getParamValuePairs();
        for (IParamValuePair paramValuePair : parmValues) {
            if (paramValuePair.getParam().equals("serviceName")) {
                locator = paramValuePair.getLocator();
                AnnotationsBaseImplTest.assertEquals((String)"Unexpected serviceName annotation parameter start position", (int)238, (int)locator.getStartPosition());
                AnnotationsBaseImplTest.assertEquals((String)"Unexpected serviceName annotation parameter length", (int)31, (int)locator.getLength());
            }
            if (paramValuePair.getParam().equals("name")) {
                locator = paramValuePair.getLocator();
                AnnotationsBaseImplTest.assertEquals((String)"Unexpected serviceName annotation parameter start position", (int)271, (int)locator.getStartPosition());
                AnnotationsBaseImplTest.assertEquals((String)"Unexpected serviceName annotation parameter length", (int)17, (int)locator.getLength());
            }
            if (paramValuePair.getParam().equals("targetNamespace")) {
                locator = paramValuePair.getLocator();
                AnnotationsBaseImplTest.assertEquals((String)"Unexpected targetNamespace annotation parameter start position", (int)290, (int)locator.getStartPosition());
                AnnotationsBaseImplTest.assertEquals((String)"Unexpected targetNamespace annotation parameter length", (int)42, (int)locator.getLength());
            }
            if (!paramValuePair.getParam().equals("portName")) continue;
            locator = paramValuePair.getLocator();
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected portName annotation parameter start position", (int)334, (int)locator.getStartPosition());
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected portName annotation parameter length", (int)25, (int)locator.getLength());
        }
        IField field = this.endpoint.getField("field1");
        IAnnotation inspectedFieldAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectField(field, "org.eclipse.demo.MyFieldAnnotation");
        locator = inspectedFieldAnnotation.getLocator();
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected MyFieldAnnotation annotation parameter start position", (int)401, (int)locator.getStartPosition());
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected MyFieldAnnotation annotation parameter length", (int)33, (int)locator.getLength());
        parmValues = inspectedFieldAnnotation.getParamValuePairs();
        for (IParamValuePair paramValuePair : parmValues) {
            if (!paramValuePair.getParam().equals("name")) continue;
            locator = paramValuePair.getLocator();
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter start position", (int)420, (int)locator.getStartPosition());
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter length", (int)13, (int)locator.getLength());
        }
        inspectedFieldAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectField(field, "javax.jws.WebField");
        locator = inspectedFieldAnnotation.getLocator();
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected WebField annotation parameter start position", (int)437, (int)locator.getStartPosition());
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected WebField annotation parameter length", (int)25, (int)locator.getLength());
        parmValues = inspectedFieldAnnotation.getParamValuePairs();
        for (IParamValuePair paramValuePair : parmValues) {
            if (!paramValuePair.getParam().equals("name")) continue;
            locator = paramValuePair.getLocator();
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter start position", (int)447, (int)locator.getStartPosition());
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter length", (int)14, (int)locator.getLength());
        }
        IMethod method = this.endpoint.getMethods()[0];
        IAnnotation inspectedMethodAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method, "org.eclipse.demo.MyMethodAnnotation");
        locator = inspectedMethodAnnotation.getLocator();
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected MyMethodAnnotation annotation parameter start position", (int)492, (int)locator.getStartPosition());
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected MyMethodAnnotation annotation parameter length", (int)43, (int)locator.getLength());
        parmValues = inspectedMethodAnnotation.getParamValuePairs();
        for (IParamValuePair paramValuePair : parmValues) {
            if (!paramValuePair.getParam().equals("name")) continue;
            locator = paramValuePair.getLocator();
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter start position", (int)512, (int)locator.getStartPosition());
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter length", (int)22, (int)locator.getLength());
        }
        inspectedMethodAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method, "javax.jws.WebMethod");
        locator = inspectedMethodAnnotation.getLocator();
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected WebMethod annotation parameter start position", (int)538, (int)locator.getStartPosition());
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected WebMethod annotation parameter length", (int)46, (int)locator.getLength());
        parmValues = inspectedMethodAnnotation.getParamValuePairs();
        for (IParamValuePair paramValuePair : parmValues) {
            if (paramValuePair.getParam().equals("exclude")) {
                locator = paramValuePair.getLocator();
                AnnotationsBaseImplTest.assertEquals((String)"Unexpected exclude annotation parameter start position", (int)549, (int)locator.getStartPosition());
                AnnotationsBaseImplTest.assertEquals((String)"Unexpected exclude annotation parameter length", (int)13, (int)locator.getLength());
            }
            if (!paramValuePair.getParam().equals("operationName")) continue;
            locator = paramValuePair.getLocator();
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected operationName annotation parameter start position", (int)563, (int)locator.getStartPosition());
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected operationName annotation parameter length", (int)20, (int)locator.getLength());
        }
        ITypeParameter typeParameter = method.getTypeParameter("annotatedParam");
        IAnnotation inspectedParamAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(typeParameter, "org.eclipse.demo.MyParamAnnotation");
        locator = inspectedParamAnnotation.getLocator();
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected MyParamAnnotation annotation parameter start position", (int)649, (int)locator.getStartPosition());
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected MyParamAnnotation annotation parameter length", (int)43, (int)locator.getLength());
        parmValues = inspectedParamAnnotation.getParamValuePairs();
        for (IParamValuePair paramValuePair : parmValues) {
            if (!paramValuePair.getParam().equals("name")) continue;
            locator = paramValuePair.getLocator();
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter start position", (int)668, (int)locator.getStartPosition());
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter length", (int)23, (int)locator.getLength());
        }
        inspectedParamAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(typeParameter, "javax.jws.WebParam");
        locator = inspectedParamAnnotation.getLocator();
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected WebParam annotation parameter start position", (int)616, (int)locator.getStartPosition());
        AnnotationsBaseImplTest.assertEquals((String)"Unexpected WebParam annotation parameter length", (int)32, (int)locator.getLength());
        parmValues = inspectedParamAnnotation.getParamValuePairs();
        for (IParamValuePair paramValuePair : parmValues) {
            if (!paramValuePair.getParam().equals("name")) continue;
            locator = paramValuePair.getLocator();
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter start position", (int)626, (int)locator.getStartPosition());
            AnnotationsBaseImplTest.assertEquals((String)"Unexpected name annotation parameter length", (int)21, (int)locator.getLength());
        }
    }
}

