/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.JSONUtil;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Packet;

public class EventPacket
extends Packet {
    public static final String TYPE = "event";
    private final String event;
    private final Map body = Collections.synchronizedMap(new HashMap());

    public EventPacket(String event) {
        super(TYPE);
        this.event = event.intern();
    }

    public EventPacket(Map json) {
        super(json);
        String packetEvent = (String)json.get(TYPE);
        this.event = packetEvent.intern();
        Map packetBody = (Map)json.get("body");
        this.body.putAll(packetBody);
    }

    public String getEvent() {
        return this.event;
    }

    public Map getBody() {
        return this.body;
    }

    public Map toJSON() {
        Map json = super.toJSON();
        json.put(TYPE, this.event);
        json.put("body", this.body);
        return json;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("EventPacket: ").append(JSONUtil.write(this.toJSON()));
        return buffer.toString();
    }
}

