/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedWritablePropertyValueModel<T>
extends PropertyValueModelWrapper<T>
implements WritablePropertyValueModel<T> {
    protected T bufferedValue;
    protected boolean accepting;
    protected final PropertyValueModel<Boolean> triggerHolder;
    protected final PropertyChangeListener triggerChangeListener;
    protected boolean buffering;

    public BufferedWritablePropertyValueModel(WritablePropertyValueModel<T> valueHolder, PropertyValueModel<Boolean> triggerHolder) {
        super(valueHolder);
        if (triggerHolder == null) {
            throw new NullPointerException();
        }
        this.triggerHolder = triggerHolder;
        this.bufferedValue = null;
        this.buffering = false;
        this.accepting = false;
        this.triggerChangeListener = this.buildTriggerChangeListener();
    }

    protected PropertyChangeListener buildTriggerChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                BufferedWritablePropertyValueModel.this.triggerChanged(event);
            }

            public String toString() {
                return "trigger change listener";
            }
        };
    }

    @Override
    public T getValue() {
        return this.buffering ? this.bufferedValue : this.valueHolder.getValue();
    }

    @Override
    public void setValue(T value) {
        if (this.buffering) {
            if (this.valuesAreEqual(value, this.valueHolder.getValue())) {
                this.reset();
            } else {
                T old = this.bufferedValue;
                this.bufferedValue = value;
                this.firePropertyChanged("value", old, value);
            }
        } else if (!this.valuesAreEqual(value, this.valueHolder.getValue())) {
            Object old = this.valueHolder.getValue();
            this.bufferedValue = value;
            this.buffering = true;
            this.firePropertyChanged("value", old, value);
        }
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.triggerHolder.addPropertyChangeListener("value", this.triggerChangeListener);
    }

    @Override
    protected void disengageModel() {
        this.triggerHolder.removePropertyChangeListener("value", this.triggerChangeListener);
        super.disengageModel();
    }

    @Override
    protected void valueChanged(PropertyChangeEvent event) {
        if (!this.accepting) {
            this.valueChanged_(event);
        }
    }

    protected void valueChanged_(PropertyChangeEvent event) {
        if (this.buffering) {
            if (this.valuesAreEqual(event.getNewValue(), this.bufferedValue)) {
                this.reset();
            } else {
                this.handleChangeConflict(event);
            }
        } else {
            this.firePropertyChanged(event.clone(this));
        }
    }

    protected void handleChangeConflict(PropertyChangeEvent event) {
    }

    protected void triggerChanged(PropertyChangeEvent event) {
        if (this.buffering) {
            if (((Boolean)event.getNewValue()).booleanValue()) {
                this.accept();
            } else {
                this.reset();
            }
        }
    }

    protected void accept() {
        this.accepting = true;
        try {
            this.getValueHolder().setValue(this.bufferedValue);
        }
        finally {
            this.bufferedValue = null;
            this.buffering = false;
            this.accepting = false;
        }
    }

    protected void reset() {
        T old = this.bufferedValue;
        this.bufferedValue = null;
        this.buffering = false;
        this.firePropertyChanged("value", old, this.valueHolder.getValue());
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    protected WritablePropertyValueModel<T> getValueHolder() {
        return (WritablePropertyValueModel)this.valueHolder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Trigger
    extends SimplePropertyValueModel<Boolean> {
        @Override
        public Boolean getValue() {
            if (this.value == null) {
                throw new IllegalStateException("The method Trigger.getValue() may only be called during change notification.");
            }
            return (Boolean)this.value;
        }

        @Override
        public void setValue(Boolean value) {
            super.setValue(value);
            this.value = null;
        }

        @Override
        public void setValue(boolean value) {
            this.setValue((Boolean)value);
        }

        public boolean booleanValue() {
            return this.getValue();
        }

        public void accept() {
            this.setValue(true);
        }

        public boolean isAccepted() {
            return this.booleanValue();
        }

        public void reset() {
            this.setValue(false);
        }

        public boolean isReset() {
            return !this.booleanValue();
        }
    }
}

