/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.utility.internal.FileTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewSchemaFileWizardPage
extends WizardNewFileCreationPage {
    protected IDataModel dataModel;
    private IStructuredSelection initialSelection;
    public static String DEFAULT_SCHEMA_NAME = "NewXMLSchema.xsd";

    public NewSchemaFileWizardPage(String pageName, IStructuredSelection selection, IDataModel dataModel, String title, String description) {
        super(pageName, selection);
        this.initialSelection = selection;
        this.init(dataModel);
        this.setTitle(title);
        this.setDescription(description);
    }

    protected void init(IDataModel dataModel) {
        this.dataModel = dataModel;
        IProject project = this.getProjectFromInitialSelection();
        this.dataModel.setProperty("JptFileCreationDataModelProperties.PROJECT", (Object)project);
        IPath containerPath = (IPath)this.dataModel.getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
        if (containerPath != null) {
            this.setContainerFullPath(containerPath);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setAllowExistingResources(true);
        this.setFileName(DEFAULT_SCHEMA_NAME);
    }

    public IProject getProject() {
        return (IProject)this.dataModel.getProperty("JptFileCreationDataModelProperties.PROJECT");
    }

    public IPath getFilePath() {
        return this.getContainerFullPath();
    }

    protected boolean validatePage() {
        this.dataModel.setProperty("JptFileCreationDataModelProperties.PROJECT", (Object)this.getProjectNamed(this.getContainerName()));
        this.dataModel.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getContainerFullPath());
        this.dataModel.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)this.getFileName());
        boolean valid = super.validatePage();
        if (!valid) {
            return valid;
        }
        this.overrideFileExistsWarning();
        valid = this.projectIsJavaProject(this.getProject());
        if (!valid) {
            this.setErrorMessage(JptJaxbUiMessages.NewSchemaFileWizardPage_errorNotJavaProject);
            return valid;
        }
        valid = this.xsdFileNotExists();
        if (!valid) {
            this.setMessage(JptJaxbUiMessages.NewSchemaFileWizardPage_overwriteExistingSchemas, 2);
            return true;
        }
        this.setErrorMessage(null);
        return valid;
    }

    private boolean projectIsJavaProject(IProject project) {
        try {
            return project != null && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private IProject getProjectFromInitialSelection() {
        Object firstElement = this.initialSelection.getFirstElement();
        if (firstElement instanceof IProject) {
            return (IProject)firstElement;
        }
        if (firstElement instanceof IResource) {
            return ((IResource)firstElement).getProject();
        }
        if (firstElement instanceof IJavaElement) {
            return ((IJavaElement)firstElement).getJavaProject().getProject();
        }
        return null;
    }

    private IProject getProjectNamed(String projectName) {
        if (StringTools.stringIsEmpty((String)projectName)) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private String getContainerName() {
        IPath containerPath = this.getContainerFullPath();
        if (containerPath == null) {
            return null;
        }
        String containerName = containerPath.segment(0);
        return containerName;
    }

    private void overrideFileExistsWarning() {
        String existsString = IDEWorkbenchMessages.ResourceGroup_nameExists;
        existsString.toString();
        existsString = existsString.substring("''{0}''".length(), existsString.length());
        String message = this.getMessage();
        if (message != null && message.endsWith(existsString)) {
            this.setMessage(null);
        }
    }

    private boolean xsdFileNotExists() {
        return !this.xsdFileExists(this.getContainerAbsolutePath().toFile());
    }

    private boolean xsdFileExists(File directory) {
        if (directory.listFiles() == null) {
            throw new RuntimeException("Could not find directory: " + directory);
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory() && ".xsd".equalsIgnoreCase(FileTools.extension((File)file))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IPath getContainerAbsolutePath() {
        IPath projectRelativePath = this.getContainerFullPath().makeRelativeTo(this.getProject().getFullPath());
        IProject directory = projectRelativePath.isEmpty() ? this.getProject() : this.getProject().getFile(projectRelativePath);
        return directory.getLocation();
    }
}

