/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.customization;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.customization.Customization;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.customization.Entity;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.customization.EntityCustomizationPropertyComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListComposite
extends Pane<Customization> {
    private WritablePropertyValueModel<Entity> entityHolder;

    public EntityListComposite(Pane<? extends Customization> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initialize() {
        super.initialize();
        this.entityHolder = this.buildEntityHolder();
    }

    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, EclipseLinkUiMessages.CustomizationEntityListComposite_groupTitle);
        new AddRemoveListPane((Pane)this, container, this.buildEntitiesAdapter(), this.buildEntitiesListHolder(), this.entityHolder, this.buildEntityLabelProvider(), "org.eclipse.jpt.jpa.ui.persistence_customization");
        EntityCustomizationPropertyComposite pane = new EntityCustomizationPropertyComposite(this, (PropertyValueModel<Entity>)this.entityHolder, container);
        this.installPaneEnabler(this.entityHolder, pane);
    }

    private AddRemovePane.Adapter buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                EntityListComposite.this.addEntities(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Customization customization = (Customization)EntityListComposite.this.getSubject();
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    Entity entityCustomization = (Entity)item;
                    customization.removeEntity(entityCustomization.getName());
                    ++n2;
                }
            }
        };
    }

    private void addEntities(ObjectListSelectionModel listSelectionModel) {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((Customization)this.getSubject()).entityExists(entityName)) {
                ((Customization)this.getSubject()).addEntity(entityName);
                int index = CollectionTools.indexOf((Iterator)((Customization)this.getSubject()).entityNames(), (Object)entityName);
                Entity entity = (Entity)listSelectionModel.getListModel().getElementAt(index);
                listSelectionModel.setSelectedValue((Object)entity);
                this.entityHolder.setValue((Object)entity);
            }
        }
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        org.eclipse.jpt.jpa.core.context.Entity entity = ((Customization)this.getSubject()).getPersistenceUnit().getEntity(fullyQualifiedTypeName);
        return entity != null ? entity.getName() : null;
    }

    private IType chooseEntity() {
        SelectionDialog typeSelectionDialog;
        IJavaProject javaProject = this.getJavaProject();
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptJpaEclipseLinkUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(EclipseLinkUiMessages.CustomizationEntityListComposite_dialogTitle);
        typeSelectionDialog.setMessage(EclipseLinkUiMessages.CustomizationEntityListComposite_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        return ((Customization)this.getSubject()).getJpaProject().getJavaProject();
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                Entity entityCustomization = (Entity)element;
                return entityCustomization.getName();
            }
        };
    }

    private WritablePropertyValueModel<Entity> buildEntityHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<Entity> buildEntitiesListHolder() {
        return new ListAspectAdapter<Customization, Entity>(this.getSubjectHolder(), new String[]{"entities"}){

            protected ListIterator<Entity> listIterator_() {
                return ((Customization)this.subject).entities();
            }

            protected int size_() {
                return ((Customization)this.subject).entitiesSize();
            }
        };
    }

    private void installPaneEnabler(WritablePropertyValueModel<Entity> entityHolder, EntityCustomizationPropertyComposite pane) {
        new PaneEnabler(this.buildPaneEnablerHolder(entityHolder), (Pane)pane);
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder(WritablePropertyValueModel<Entity> entityHolder) {
        return new TransformationPropertyValueModel<Entity, Boolean>(entityHolder){

            protected Boolean transform_(Entity value) {
                return value.entityNameIsValid();
            }
        };
    }
}

