/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.orm.MappingFileWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class SelectJpaOrmMappingFileDialog
extends ElementTreeSelectionDialog {
    private static final String META_INF = "META-INF";
    private static final String EMPTY = "";
    private static final char SLASH = '/';
    private String xmlName = "";
    private final IProject project;
    private Label messageLabel;
    private Tree treeWidget;

    public SelectJpaOrmMappingFileDialog(Shell parent, IProject project, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setAllowMultiple(false);
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Button newButton = new Button(composite, 8);
        newButton.setText(JptUiMessages.SelectJpaOrmMappingFileDialog_newButton);
        GridData browseButtonData = new GridData(128);
        newButton.setLayoutData((Object)browseButtonData);
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectJpaOrmMappingFileDialog.this.openNewMappingFileWizard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return composite;
    }

    protected Label createMessageArea(Composite composite) {
        this.messageLabel = super.createMessageArea(composite);
        return this.messageLabel;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = super.createTreeViewer(parent);
        this.treeWidget = treeViewer.getTree();
        return treeViewer;
    }

    public String getChosenName() {
        String result = EMPTY;
        Object element = this.getFirstResult();
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            result = String.valueOf(container.getFullPath().toString()) + File.separatorChar + this.xmlName;
        } else {
            IFile f = (IFile)element;
            result = f.getFullPath().toOSString();
        }
        result = this.removeRedundantSegmentFromName(result);
        return result;
    }

    protected void updateOKStatus() {
        super.updateOKStatus();
        TreeSelection selection = (TreeSelection)this.getTreeViewer().getSelection();
        IResource selectedResource = (IResource)selection.getFirstElement();
        if (selectedResource instanceof IFile) {
            this.updateStatus((IStatus)new Status(0, "org.eclipse.jpt.jpa.ui", EMPTY));
        } else {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.jpt.jpa.ui", EMPTY));
        }
    }

    private String removeRedundantSegmentFromName(String input) {
        String output = input.substring(input.indexOf(META_INF));
        output = output.replace(File.separatorChar, '/');
        return output;
    }

    private void openNewMappingFileWizard() {
        IPath path = MappingFileWizard.createNewMappingFile((IStructuredSelection)new StructuredSelection((Object)this.project), null);
        if (path != null) {
            this.messageLabel.setEnabled(true);
            this.treeWidget.setEnabled(true);
            IFile file = JptCommonCorePlugin.getPlatformFile((IProject)this.project, (IPath)path);
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)file), true);
        }
    }
}

