/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.Iterator;
import javax.swing.JList;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ListModelAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCollectionValueModelAdapterTests
extends TestCase {
    private CollectionValueModel<String> adapter;
    private WritablePropertyValueModel<String> wrappedValueHolder;

    public PropertyCollectionValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wrappedValueHolder = new SimplePropertyValueModel();
        this.adapter = new PropertyCollectionValueModelAdapter(this.wrappedValueHolder);
    }

    private Collection<String> wrappedCollection() {
        return CollectionTools.collection((Iterator)new SingleElementIterator((Object)((String)this.wrappedValueHolder.getValue())));
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(){

            public void itemsAdded(CollectionAddEvent e) {
            }
        });
        this.wrappedValueHolder.setValue((Object)"foo");
        HashBag adapterCollection = CollectionTools.collection((Iterator)this.adapter.iterator());
        PropertyCollectionValueModelAdapterTests.assertEquals((int)1, (int)adapterCollection.size());
        PropertyCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
        PropertyCollectionValueModelAdapterTests.assertEquals((String)"foo", (String)((String)adapterCollection.iterator().next()));
    }

    public void testStaleValue() {
        TestListener listener = new TestListener(){

            public void itemsAdded(CollectionAddEvent e) {
            }
        };
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)listener);
        this.wrappedValueHolder.setValue((Object)"foo");
        HashBag adapterCollection = CollectionTools.collection((Iterator)this.adapter.iterator());
        PropertyCollectionValueModelAdapterTests.assertEquals((int)1, (int)adapterCollection.size());
        PropertyCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
        PropertyCollectionValueModelAdapterTests.assertEquals((String)"foo", (String)((String)adapterCollection.iterator().next()));
        this.adapter.removeCollectionChangeListener("values", (CollectionChangeListener)listener);
        adapterCollection = CollectionTools.collection((Iterator)this.adapter.iterator());
        PropertyCollectionValueModelAdapterTests.assertEquals((int)0, (int)adapterCollection.size());
        PropertyCollectionValueModelAdapterTests.assertEquals((Object)new HashBag(), (Object)adapterCollection);
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)listener);
        adapterCollection = CollectionTools.collection((Iterator)this.adapter.iterator());
        PropertyCollectionValueModelAdapterTests.assertEquals((int)1, (int)adapterCollection.size());
        PropertyCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
        PropertyCollectionValueModelAdapterTests.assertEquals((String)"foo", (String)((String)adapterCollection.iterator().next()));
    }

    public void testHasListeners() {
        PropertyCollectionValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>(this.adapter);
        PropertyCollectionValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
        this.adapter.removeCollectionChangeListener("values", synchCollection);
        PropertyCollectionValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
        ChangeAdapter cl = new ChangeAdapter();
        this.adapter.addChangeListener((ChangeListener)cl);
        PropertyCollectionValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
        this.adapter.removeChangeListener((ChangeListener)cl);
        PropertyCollectionValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
    }

    public void testListChangedToEmpty() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(){

            public void itemsAdded(CollectionAddEvent e) {
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
            }
        });
        this.wrappedValueHolder.setValue((Object)"foo");
        JList jList = new JList(new ListModelAdapter(this.adapter));
        this.wrappedValueHolder.setValue(null);
        PropertyCollectionValueModelAdapterTests.assertEquals((int)0, (int)jList.getModel().getSize());
    }

    public void testCollectionChangedFromEmpty() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(){

            public void itemsAdded(CollectionAddEvent e) {
            }
        });
        JList jList = new JList(new ListModelAdapter(this.adapter));
        this.wrappedValueHolder.setValue((Object)"foo");
        PropertyCollectionValueModelAdapterTests.assertEquals((int)1, (int)jList.getModel().getSize());
    }

    public void testCollectionChangedFromEmptyToEmpty() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener());
        JList jList = new JList(new ListModelAdapter(this.adapter));
        this.wrappedValueHolder.setValue(null);
        PropertyCollectionValueModelAdapterTests.assertEquals((int)0, (int)jList.getModel().getSize());
    }

    static class TestListener
    implements CollectionChangeListener {
        TestListener() {
        }

        public void collectionChanged(CollectionChangeEvent event) {
            PropertyCollectionValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void collectionCleared(CollectionClearEvent event) {
            PropertyCollectionValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsAdded(CollectionAddEvent event) {
            PropertyCollectionValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            PropertyCollectionValueModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

