/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagsetRegistry;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationsControllerResources;
import org.eclipse.jst.common.internal.annotations.registry.AttributeValuesHelper;
import org.eclipse.jst.common.internal.annotations.registry.TagAttribSpec;
import org.eclipse.jst.common.internal.annotations.registry.TagsetDescriptor;
import org.osgi.framework.Bundle;

public class TagSpec {
    Bundle bundle;
    protected ResourceBundle resourceBundle;
    private boolean attemptedToFindResourceBundle = false;
    private AttributeValuesHelper validValuesHelper;
    private TagsetDescriptor tagsetDescriptor;
    private String tagName;
    private int scope;
    private int multiplicity;
    private List attributes = new ArrayList();
    private String helpKey;
    public static final int HELP_TEXT = 0;
    public static final int METHOD = 0;
    public static final int TYPE = 1;
    public static final int FIELD = 2;

    public TagSpec(String aName, int aScope, int aMultiplicity) {
        this.tagName = aName;
        this.scope = aScope;
        this.multiplicity = aMultiplicity;
    }

    public static int scopeFromString(String s) throws CoreException {
        if (s != null) {
            if (s.equalsIgnoreCase("type")) {
                return 1;
            }
            if (s.equalsIgnoreCase("field")) {
                return 2;
            }
            if (s.equalsIgnoreCase("method")) {
                return 0;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.common.internal.annotations.controller", 0, String.valueOf(AnnotationsControllerResources.TagSpec_3) + s, null));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.common.internal.annotations.controller", 0, AnnotationsControllerResources.TagSpec_4, null));
    }

    public static int multiplicityFromString(String s) throws CoreException {
        if (s != null) {
            if (s.equalsIgnoreCase("1")) {
                return 1;
            }
            if (s.equalsIgnoreCase("*")) {
                return 2;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.common.internal.annotations.controller", 0, AnnotationsControllerResources.TagSpec_4, null));
        }
        return 1;
    }

    public int getScope() {
        return this.scope;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public String getTagName() {
        return this.tagName;
    }

    public TagsetDescriptor getTagSetDescriptor() {
        if (this.tagsetDescriptor == null) {
            String tagSetName = this.getTagName();
            int index = tagSetName.lastIndexOf(46);
            tagSetName = index == -1 ? "" : tagSetName.substring(index + 1);
            this.tagsetDescriptor = AnnotationTagsetRegistry.INSTANCE.getDescriptor(tagSetName);
        }
        return this.tagsetDescriptor;
    }

    public void setScope(int i) {
        this.scope = i;
    }

    public void setMultiplicity(int i) {
        this.multiplicity = i;
    }

    public void setTagName(String string) {
        this.tagName = string;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addAttribute(TagAttribSpec att) {
        if (att == null) {
            return;
        }
        this.attributes.add(att);
        att.setTagSpec(this);
    }

    public void setAttributes(List lst) {
        if (lst == null) {
            this.attributes.clear();
        } else {
            this.attributes = lst;
            int i = 0;
            while (i < lst.size()) {
                TagAttribSpec tas = (TagAttribSpec)lst.get(i);
                tas.setTagSpec(this);
                ++i;
            }
        }
    }

    public TagAttribSpec attributeNamed(String attName) {
        for (TagAttribSpec tas : this.getAttributes()) {
            if (!attName.equalsIgnoreCase(tas.getAttribName())) continue;
            return tas;
        }
        return null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    protected void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null && !this.attemptedToFindResourceBundle) {
            this.attemptedToFindResourceBundle = true;
            Bundle aBundle = this.getBundle();
            if (aBundle != null) {
                this.resourceBundle = Platform.getResourceBundle((Bundle)this.bundle);
            }
        }
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.attemptedToFindResourceBundle = false;
        this.resourceBundle = resourceBundle;
    }

    public AttributeValuesHelper getValidValuesHelper() {
        if (this.validValuesHelper == null && this.getTagSetDescriptor() != null) {
            this.setValidValuesHelper(this.getTagSetDescriptor().getValidValuesHelper());
        }
        return this.validValuesHelper;
    }

    public void setValidValuesHelper(AttributeValuesHelper validValuesHelper) {
        this.validValuesHelper = validValuesHelper;
    }

    public String getHelpKey() {
        if (this.helpKey == null) {
            this.helpKey = this.computeHelpKey();
        }
        return this.helpKey;
    }

    protected String computeHelpKey() {
        return "tagh." + this.getTagName();
    }

    public void setHelpKey(String helpKey) {
        this.helpKey = helpKey;
    }

    public String lookupTagHelp() throws MissingResourceException {
        ResourceBundle b = this.getResourceBundle();
        if (b == null) {
            return null;
        }
        String key = this.getHelpKey();
        String val = b.getString(this.getHelpKey());
        if (val == key) {
            val = null;
        }
        return val;
    }

    public static interface Multiplicity {
        public static final int ONE = 1;
        public static final int MANY = 2;
    }
}

