/*******************************************************************************
 * Copyright (c) 2001, 2007 Oracle Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Oracle Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.jsf.facesconfig.edit.provider;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;

/**
 * Literal package types
 * 
 * @author cbateman
 *
 */
public interface Literals {
	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ActionListenerTypeImpl <em>Action Listener Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ActionListenerTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getActionListenerType()
	 * @generated
	 */
	EClass ACTION_LISTENER_TYPE = FacesConfigPackage.eINSTANCE.getActionListenerType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ACTION_LISTENER_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getActionListenerType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ACTION_LISTENER_TYPE__ID = FacesConfigPackage.eINSTANCE.getActionListenerType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ApplicationFactoryTypeImpl <em>Application Factory Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ApplicationFactoryTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getApplicationFactoryType()
	 * @generated
	 */
	EClass APPLICATION_FACTORY_TYPE = FacesConfigPackage.eINSTANCE.getApplicationFactoryType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute APPLICATION_FACTORY_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getApplicationFactoryType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute APPLICATION_FACTORY_TYPE__ID = FacesConfigPackage.eINSTANCE.getApplicationFactoryType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ApplicationTypeImpl <em>Application Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ApplicationTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getApplicationType()
	 * @generated
	 */
	EClass APPLICATION_TYPE = FacesConfigPackage.eINSTANCE.getApplicationType();

	/**
	 * The meta object literal for the '<em><b>Action Listener</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__ACTION_LISTENER = FacesConfigPackage.eINSTANCE.getApplicationType_ActionListener();

	/**
	 * The meta object literal for the '<em><b>Default Render Kit Id</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__DEFAULT_RENDER_KIT_ID = FacesConfigPackage.eINSTANCE.getApplicationType_DefaultRenderKitId();

	/**
	 * The meta object literal for the '<em><b>Message Bundle</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__MESSAGE_BUNDLE = FacesConfigPackage.eINSTANCE.getApplicationType_MessageBundle();

	/**
	 * The meta object literal for the '<em><b>Navigation Handler</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__NAVIGATION_HANDLER = FacesConfigPackage.eINSTANCE.getApplicationType_NavigationHandler();

	/**
	 * The meta object literal for the '<em><b>View Handler</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__VIEW_HANDLER = FacesConfigPackage.eINSTANCE.getApplicationType_ViewHandler();

	/**
	 * The meta object literal for the '<em><b>State Manager</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__STATE_MANAGER = FacesConfigPackage.eINSTANCE.getApplicationType_StateManager();

	/**
	 * The meta object literal for the '<em><b>Property Resolver</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__PROPERTY_RESOLVER = FacesConfigPackage.eINSTANCE.getApplicationType_PropertyResolver();

	/**
	 * The meta object literal for the '<em><b>Variable Resolver</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__VARIABLE_RESOLVER = FacesConfigPackage.eINSTANCE.getApplicationType_VariableResolver();

	/**
	 * The meta object literal for the '<em><b>Locale Config</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference APPLICATION_TYPE__LOCALE_CONFIG = FacesConfigPackage.eINSTANCE.getApplicationType_LocaleConfig();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute APPLICATION_TYPE__ID = FacesConfigPackage.eINSTANCE.getApplicationType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.AttributeClassTypeImpl <em>Attribute Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.AttributeClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getAttributeClassType()
	 * @generated
	 */
	EClass ATTRIBUTE_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getAttributeClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ATTRIBUTE_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getAttributeClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ATTRIBUTE_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getAttributeClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.AttributeExtensionTypeImpl <em>Attribute Extension Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.AttributeExtensionTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getAttributeExtensionType()
	 * @generated
	 */
	EClass ATTRIBUTE_EXTENSION_TYPE = FacesConfigPackage.eINSTANCE.getAttributeExtensionType();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.AttributeNameTypeImpl <em>Attribute Name Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.AttributeNameTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getAttributeNameType()
	 * @generated
	 */
	EClass ATTRIBUTE_NAME_TYPE = FacesConfigPackage.eINSTANCE.getAttributeNameType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ATTRIBUTE_NAME_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getAttributeNameType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ATTRIBUTE_NAME_TYPE__ID = FacesConfigPackage.eINSTANCE.getAttributeNameType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.AttributeTypeImpl <em>Attribute Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.AttributeTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getAttributeType()
	 * @generated
	 */
	EClass ATTRIBUTE_TYPE = FacesConfigPackage.eINSTANCE.getAttributeType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ATTRIBUTE_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getAttributeType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ATTRIBUTE_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getAttributeType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ATTRIBUTE_TYPE__ICON = FacesConfigPackage.eINSTANCE.getAttributeType_Icon();

	/**
	 * The meta object literal for the '<em><b>Attribute Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ATTRIBUTE_TYPE__ATTRIBUTE_NAME = FacesConfigPackage.eINSTANCE.getAttributeType_AttributeName();

	/**
	 * The meta object literal for the '<em><b>Attribute Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ATTRIBUTE_TYPE__ATTRIBUTE_CLASS = FacesConfigPackage.eINSTANCE.getAttributeType_AttributeClass();

	/**
	 * The meta object literal for the '<em><b>Default Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ATTRIBUTE_TYPE__DEFAULT_VALUE = FacesConfigPackage.eINSTANCE.getAttributeType_DefaultValue();

	/**
	 * The meta object literal for the '<em><b>Suggested Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ATTRIBUTE_TYPE__SUGGESTED_VALUE = FacesConfigPackage.eINSTANCE.getAttributeType_SuggestedValue();

	/**
	 * The meta object literal for the '<em><b>Attribute Extension</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ATTRIBUTE_TYPE__ATTRIBUTE_EXTENSION = FacesConfigPackage.eINSTANCE.getAttributeType_AttributeExtension();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ATTRIBUTE_TYPE__ID = FacesConfigPackage.eINSTANCE.getAttributeType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentClassTypeImpl <em>Component Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getComponentClassType()
	 * @generated
	 */
	EClass COMPONENT_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getComponentClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute COMPONENT_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getComponentClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute COMPONENT_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getComponentClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentExtensionTypeImpl <em>Component Extension Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentExtensionTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getComponentExtensionType()
	 * @generated
	 */
	EClass COMPONENT_EXTENSION_TYPE = FacesConfigPackage.eINSTANCE.getComponentExtensionType();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentFamilyTypeImpl <em>Component Family Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentFamilyTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getComponentFamilyType()
	 * @generated
	 */
	EClass COMPONENT_FAMILY_TYPE = FacesConfigPackage.eINSTANCE.getComponentFamilyType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute COMPONENT_FAMILY_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getComponentFamilyType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute COMPONENT_FAMILY_TYPE__ID = FacesConfigPackage.eINSTANCE.getComponentFamilyType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentTypeImpl <em>Component Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getComponentType()
	 * @generated
	 */
	EClass COMPONENT_TYPE = FacesConfigPackage.eINSTANCE.getComponentType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getComponentType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getComponentType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__ICON = FacesConfigPackage.eINSTANCE.getComponentType_Icon();

	/**
	 * The meta object literal for the '<em><b>Component Type</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__COMPONENT_TYPE = FacesConfigPackage.eINSTANCE.getComponentType_ComponentType();

	/**
	 * The meta object literal for the '<em><b>Component Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__COMPONENT_CLASS = FacesConfigPackage.eINSTANCE.getComponentType_ComponentClass();

	/**
	 * The meta object literal for the '<em><b>Facet</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__FACET = FacesConfigPackage.eINSTANCE.getComponentType_Facet();

	/**
	 * The meta object literal for the '<em><b>Attribute</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__ATTRIBUTE = FacesConfigPackage.eINSTANCE.getComponentType_Attribute();

	/**
	 * The meta object literal for the '<em><b>Property</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__PROPERTY = FacesConfigPackage.eINSTANCE.getComponentType_Property();

	/**
	 * The meta object literal for the '<em><b>Component Extension</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference COMPONENT_TYPE__COMPONENT_EXTENSION = FacesConfigPackage.eINSTANCE.getComponentType_ComponentExtension();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute COMPONENT_TYPE__ID = FacesConfigPackage.eINSTANCE.getComponentType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentTypeTypeImpl <em>Component Type Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ComponentTypeTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getComponentTypeType()
	 * @generated
	 */
	EClass COMPONENT_TYPE_TYPE = FacesConfigPackage.eINSTANCE.getComponentTypeType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute COMPONENT_TYPE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getComponentTypeType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute COMPONENT_TYPE_TYPE__ID = FacesConfigPackage.eINSTANCE.getComponentTypeType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ConverterClassTypeImpl <em>Converter Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ConverterClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getConverterClassType()
	 * @generated
	 */
	EClass CONVERTER_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getConverterClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute CONVERTER_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getConverterClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute CONVERTER_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getConverterClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ConverterForClassTypeImpl <em>Converter For Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ConverterForClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getConverterForClassType()
	 * @generated
	 */
	EClass CONVERTER_FOR_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getConverterForClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute CONVERTER_FOR_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getConverterForClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute CONVERTER_FOR_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getConverterForClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ConverterIdTypeImpl <em>Converter Id Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ConverterIdTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getConverterIdType()
	 * @generated
	 */
	EClass CONVERTER_ID_TYPE = FacesConfigPackage.eINSTANCE.getConverterIdType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute CONVERTER_ID_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getConverterIdType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute CONVERTER_ID_TYPE__ID = FacesConfigPackage.eINSTANCE.getConverterIdType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ConverterTypeImpl <em>Converter Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ConverterTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getConverterType()
	 * @generated
	 */
	EClass CONVERTER_TYPE = FacesConfigPackage.eINSTANCE.getConverterType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference CONVERTER_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getConverterType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference CONVERTER_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getConverterType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference CONVERTER_TYPE__ICON = FacesConfigPackage.eINSTANCE.getConverterType_Icon();

	/**
	 * The meta object literal for the '<em><b>Converter Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference CONVERTER_TYPE__CONVERTER_ID = FacesConfigPackage.eINSTANCE.getConverterType_ConverterId();

	/**
	 * The meta object literal for the '<em><b>Converter For Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference CONVERTER_TYPE__CONVERTER_FOR_CLASS = FacesConfigPackage.eINSTANCE.getConverterType_ConverterForClass();

	/**
	 * The meta object literal for the '<em><b>Converter Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference CONVERTER_TYPE__CONVERTER_CLASS = FacesConfigPackage.eINSTANCE.getConverterType_ConverterClass();

	/**
	 * The meta object literal for the '<em><b>Attribute</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference CONVERTER_TYPE__ATTRIBUTE = FacesConfigPackage.eINSTANCE.getConverterType_Attribute();

	/**
	 * The meta object literal for the '<em><b>Property</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference CONVERTER_TYPE__PROPERTY = FacesConfigPackage.eINSTANCE.getConverterType_Property();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute CONVERTER_TYPE__ID = FacesConfigPackage.eINSTANCE.getConverterType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.DefaultLocaleTypeImpl <em>Default Locale Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.DefaultLocaleTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getDefaultLocaleType()
	 * @generated
	 */
	EClass DEFAULT_LOCALE_TYPE = FacesConfigPackage.eINSTANCE.getDefaultLocaleType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DEFAULT_LOCALE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getDefaultLocaleType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DEFAULT_LOCALE_TYPE__ID = FacesConfigPackage.eINSTANCE.getDefaultLocaleType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.DefaultRenderKitIdTypeImpl <em>Default Render Kit Id Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.DefaultRenderKitIdTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getDefaultRenderKitIdType()
	 * @generated
	 */
	EClass DEFAULT_RENDER_KIT_ID_TYPE = FacesConfigPackage.eINSTANCE.getDefaultRenderKitIdType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DEFAULT_RENDER_KIT_ID_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getDefaultRenderKitIdType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DEFAULT_RENDER_KIT_ID_TYPE__ID = FacesConfigPackage.eINSTANCE.getDefaultRenderKitIdType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.DefaultValueTypeImpl <em>Default Value Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.DefaultValueTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getDefaultValueType()
	 * @generated
	 */
	EClass DEFAULT_VALUE_TYPE = FacesConfigPackage.eINSTANCE.getDefaultValueType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DEFAULT_VALUE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getDefaultValueType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DEFAULT_VALUE_TYPE__ID = FacesConfigPackage.eINSTANCE.getDefaultValueType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.DescriptionTypeImpl <em>Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.DescriptionTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getDescriptionType()
	 * @generated
	 */
	EClass DESCRIPTION_TYPE = FacesConfigPackage.eINSTANCE.getDescriptionType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DESCRIPTION_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Lang</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DESCRIPTION_TYPE__LANG = FacesConfigPackage.eINSTANCE.getDescriptionType_Lang();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DESCRIPTION_TYPE__ID = FacesConfigPackage.eINSTANCE.getDescriptionType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.DisplayNameTypeImpl <em>Display Name Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.DisplayNameTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getDisplayNameType()
	 * @generated
	 */
	EClass DISPLAY_NAME_TYPE = FacesConfigPackage.eINSTANCE.getDisplayNameType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DISPLAY_NAME_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getDisplayNameType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Lang</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DISPLAY_NAME_TYPE__LANG = FacesConfigPackage.eINSTANCE.getDisplayNameType_Lang();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DISPLAY_NAME_TYPE__ID = FacesConfigPackage.eINSTANCE.getDisplayNameType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.DocumentRootImpl <em>Document Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.DocumentRootImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getDocumentRoot()
	 * @generated
	 */
	EClass DOCUMENT_ROOT = FacesConfigPackage.eINSTANCE.getDocumentRoot();

	/**
	 * The meta object literal for the '<em><b>Mixed</b></em>' attribute list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute DOCUMENT_ROOT__MIXED = FacesConfigPackage.eINSTANCE.getDocumentRoot_Mixed();

	/**
	 * The meta object literal for the '<em><b>XMLNS Prefix Map</b></em>' map feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__XMLNS_PREFIX_MAP = FacesConfigPackage.eINSTANCE.getDocumentRoot_XMLNSPrefixMap();

	/**
	 * The meta object literal for the '<em><b>XSI Schema Location</b></em>' map feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = FacesConfigPackage.eINSTANCE.getDocumentRoot_XSISchemaLocation();

	/**
	 * The meta object literal for the '<em><b>Action Listener</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__ACTION_LISTENER = FacesConfigPackage.eINSTANCE.getDocumentRoot_ActionListener();

	/**
	 * The meta object literal for the '<em><b>Application</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__APPLICATION = FacesConfigPackage.eINSTANCE.getDocumentRoot_Application();

	/**
	 * The meta object literal for the '<em><b>Application Factory</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__APPLICATION_FACTORY = FacesConfigPackage.eINSTANCE.getDocumentRoot_ApplicationFactory();

	/**
	 * The meta object literal for the '<em><b>Attribute</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__ATTRIBUTE = FacesConfigPackage.eINSTANCE.getDocumentRoot_Attribute();

	/**
	 * The meta object literal for the '<em><b>Attribute Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__ATTRIBUTE_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_AttributeClass();

	/**
	 * The meta object literal for the '<em><b>Attribute Extension</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__ATTRIBUTE_EXTENSION = FacesConfigPackage.eINSTANCE.getDocumentRoot_AttributeExtension();

	/**
	 * The meta object literal for the '<em><b>Attribute Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__ATTRIBUTE_NAME = FacesConfigPackage.eINSTANCE.getDocumentRoot_AttributeName();

	/**
	 * The meta object literal for the '<em><b>Component</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__COMPONENT = FacesConfigPackage.eINSTANCE.getDocumentRoot_Component();

	/**
	 * The meta object literal for the '<em><b>Component Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__COMPONENT_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_ComponentClass();

	/**
	 * The meta object literal for the '<em><b>Component Extension</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__COMPONENT_EXTENSION = FacesConfigPackage.eINSTANCE.getDocumentRoot_ComponentExtension();

	/**
	 * The meta object literal for the '<em><b>Component Family</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__COMPONENT_FAMILY = FacesConfigPackage.eINSTANCE.getDocumentRoot_ComponentFamily();

	/**
	 * The meta object literal for the '<em><b>Component Type</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__COMPONENT_TYPE = FacesConfigPackage.eINSTANCE.getDocumentRoot_ComponentType();

	/**
	 * The meta object literal for the '<em><b>Converter</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__CONVERTER = FacesConfigPackage.eINSTANCE.getDocumentRoot_Converter();

	/**
	 * The meta object literal for the '<em><b>Converter Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__CONVERTER_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_ConverterClass();

	/**
	 * The meta object literal for the '<em><b>Converter For Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__CONVERTER_FOR_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_ConverterForClass();

	/**
	 * The meta object literal for the '<em><b>Converter Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__CONVERTER_ID = FacesConfigPackage.eINSTANCE.getDocumentRoot_ConverterId();

	/**
	 * The meta object literal for the '<em><b>Default Locale</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__DEFAULT_LOCALE = FacesConfigPackage.eINSTANCE.getDocumentRoot_DefaultLocale();

	/**
	 * The meta object literal for the '<em><b>Default Render Kit Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__DEFAULT_RENDER_KIT_ID = FacesConfigPackage.eINSTANCE.getDocumentRoot_DefaultRenderKitId();

	/**
	 * The meta object literal for the '<em><b>Default Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__DEFAULT_VALUE = FacesConfigPackage.eINSTANCE.getDocumentRoot_DefaultValue();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__DESCRIPTION = FacesConfigPackage.eINSTANCE.getDocumentRoot_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getDocumentRoot_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Faces Config</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FACES_CONFIG = FacesConfigPackage.eINSTANCE.getDocumentRoot_FacesConfig();

	/**
	 * The meta object literal for the '<em><b>Faces Context Factory</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FACES_CONTEXT_FACTORY = FacesConfigPackage.eINSTANCE.getDocumentRoot_FacesContextFactory();

	/**
	 * The meta object literal for the '<em><b>Facet</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FACET = FacesConfigPackage.eINSTANCE.getDocumentRoot_Facet();

	/**
	 * The meta object literal for the '<em><b>Facet Extension</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FACET_EXTENSION = FacesConfigPackage.eINSTANCE.getDocumentRoot_FacetExtension();

	/**
	 * The meta object literal for the '<em><b>Facet Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FACET_NAME = FacesConfigPackage.eINSTANCE.getDocumentRoot_FacetName();

	/**
	 * The meta object literal for the '<em><b>Factory</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FACTORY = FacesConfigPackage.eINSTANCE.getDocumentRoot_Factory();

	/**
	 * The meta object literal for the '<em><b>From Action</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FROM_ACTION = FacesConfigPackage.eINSTANCE.getDocumentRoot_FromAction();

	/**
	 * The meta object literal for the '<em><b>From Outcome</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FROM_OUTCOME = FacesConfigPackage.eINSTANCE.getDocumentRoot_FromOutcome();

	/**
	 * The meta object literal for the '<em><b>From View Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__FROM_VIEW_ID = FacesConfigPackage.eINSTANCE.getDocumentRoot_FromViewId();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__ICON = FacesConfigPackage.eINSTANCE.getDocumentRoot_Icon();

	/**
	 * The meta object literal for the '<em><b>Key</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__KEY = FacesConfigPackage.eINSTANCE.getDocumentRoot_Key();

	/**
	 * The meta object literal for the '<em><b>Key Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__KEY_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_KeyClass();

	/**
	 * The meta object literal for the '<em><b>Large Icon</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__LARGE_ICON = FacesConfigPackage.eINSTANCE.getDocumentRoot_LargeIcon();

	/**
	 * The meta object literal for the '<em><b>Lifecycle</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__LIFECYCLE = FacesConfigPackage.eINSTANCE.getDocumentRoot_Lifecycle();

	/**
	 * The meta object literal for the '<em><b>Lifecycle Factory</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__LIFECYCLE_FACTORY = FacesConfigPackage.eINSTANCE.getDocumentRoot_LifecycleFactory();

	/**
	 * The meta object literal for the '<em><b>List Entries</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__LIST_ENTRIES = FacesConfigPackage.eINSTANCE.getDocumentRoot_ListEntries();

	/**
	 * The meta object literal for the '<em><b>Locale Config</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__LOCALE_CONFIG = FacesConfigPackage.eINSTANCE.getDocumentRoot_LocaleConfig();

	/**
	 * The meta object literal for the '<em><b>Managed Bean</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__MANAGED_BEAN = FacesConfigPackage.eINSTANCE.getDocumentRoot_ManagedBean();

	/**
	 * The meta object literal for the '<em><b>Managed Bean Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__MANAGED_BEAN_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_ManagedBeanClass();

	/**
	 * The meta object literal for the '<em><b>Managed Bean Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__MANAGED_BEAN_NAME = FacesConfigPackage.eINSTANCE.getDocumentRoot_ManagedBeanName();

	/**
	 * The meta object literal for the '<em><b>Managed Bean Scope</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__MANAGED_BEAN_SCOPE = FacesConfigPackage.eINSTANCE.getDocumentRoot_ManagedBeanScope();

	/**
	 * The meta object literal for the '<em><b>Managed Property</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__MANAGED_PROPERTY = FacesConfigPackage.eINSTANCE.getDocumentRoot_ManagedProperty();

	/**
	 * The meta object literal for the '<em><b>Map Entries</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__MAP_ENTRIES = FacesConfigPackage.eINSTANCE.getDocumentRoot_MapEntries();

	/**
	 * The meta object literal for the '<em><b>Map Entry</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__MAP_ENTRY = FacesConfigPackage.eINSTANCE.getDocumentRoot_MapEntry();

	/**
	 * The meta object literal for the '<em><b>Message Bundle</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__MESSAGE_BUNDLE = FacesConfigPackage.eINSTANCE.getDocumentRoot_MessageBundle();

	/**
	 * The meta object literal for the '<em><b>Navigation Case</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__NAVIGATION_CASE = FacesConfigPackage.eINSTANCE.getDocumentRoot_NavigationCase();

	/**
	 * The meta object literal for the '<em><b>Navigation Handler</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__NAVIGATION_HANDLER = FacesConfigPackage.eINSTANCE.getDocumentRoot_NavigationHandler();

	/**
	 * The meta object literal for the '<em><b>Navigation Rule</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__NAVIGATION_RULE = FacesConfigPackage.eINSTANCE.getDocumentRoot_NavigationRule();

	/**
	 * The meta object literal for the '<em><b>Null Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__NULL_VALUE = FacesConfigPackage.eINSTANCE.getDocumentRoot_NullValue();

	/**
	 * The meta object literal for the '<em><b>Phase Listener</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__PHASE_LISTENER = FacesConfigPackage.eINSTANCE.getDocumentRoot_PhaseListener();

	/**
	 * The meta object literal for the '<em><b>Property</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__PROPERTY = FacesConfigPackage.eINSTANCE.getDocumentRoot_Property();

	/**
	 * The meta object literal for the '<em><b>Property Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__PROPERTY_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_PropertyClass();

	/**
	 * The meta object literal for the '<em><b>Property Extension</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__PROPERTY_EXTENSION = FacesConfigPackage.eINSTANCE.getDocumentRoot_PropertyExtension();

	/**
	 * The meta object literal for the '<em><b>Property Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__PROPERTY_NAME = FacesConfigPackage.eINSTANCE.getDocumentRoot_PropertyName();

	/**
	 * The meta object literal for the '<em><b>Property Resolver</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__PROPERTY_RESOLVER = FacesConfigPackage.eINSTANCE.getDocumentRoot_PropertyResolver();

	/**
	 * The meta object literal for the '<em><b>Redirect</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__REDIRECT = FacesConfigPackage.eINSTANCE.getDocumentRoot_Redirect();

	/**
	 * The meta object literal for the '<em><b>Referenced Bean</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__REFERENCED_BEAN = FacesConfigPackage.eINSTANCE.getDocumentRoot_ReferencedBean();

	/**
	 * The meta object literal for the '<em><b>Referenced Bean Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__REFERENCED_BEAN_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_ReferencedBeanClass();

	/**
	 * The meta object literal for the '<em><b>Referenced Bean Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__REFERENCED_BEAN_NAME = FacesConfigPackage.eINSTANCE.getDocumentRoot_ReferencedBeanName();

	/**
	 * The meta object literal for the '<em><b>Renderer</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__RENDERER = FacesConfigPackage.eINSTANCE.getDocumentRoot_Renderer();

	/**
	 * The meta object literal for the '<em><b>Renderer Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__RENDERER_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_RendererClass();

	/**
	 * The meta object literal for the '<em><b>Renderer Extension</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__RENDERER_EXTENSION = FacesConfigPackage.eINSTANCE.getDocumentRoot_RendererExtension();

	/**
	 * The meta object literal for the '<em><b>Renderer Type</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__RENDERER_TYPE = FacesConfigPackage.eINSTANCE.getDocumentRoot_RendererType();

	/**
	 * The meta object literal for the '<em><b>Render Kit</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__RENDER_KIT = FacesConfigPackage.eINSTANCE.getDocumentRoot_RenderKit();

	/**
	 * The meta object literal for the '<em><b>Render Kit Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__RENDER_KIT_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_RenderKitClass();

	/**
	 * The meta object literal for the '<em><b>Render Kit Factory</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__RENDER_KIT_FACTORY = FacesConfigPackage.eINSTANCE.getDocumentRoot_RenderKitFactory();

	/**
	 * The meta object literal for the '<em><b>Render Kit Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__RENDER_KIT_ID = FacesConfigPackage.eINSTANCE.getDocumentRoot_RenderKitId();

	/**
	 * The meta object literal for the '<em><b>Small Icon</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__SMALL_ICON = FacesConfigPackage.eINSTANCE.getDocumentRoot_SmallIcon();

	/**
	 * The meta object literal for the '<em><b>State Manager</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__STATE_MANAGER = FacesConfigPackage.eINSTANCE.getDocumentRoot_StateManager();

	/**
	 * The meta object literal for the '<em><b>Suggested Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__SUGGESTED_VALUE = FacesConfigPackage.eINSTANCE.getDocumentRoot_SuggestedValue();

	/**
	 * The meta object literal for the '<em><b>Supported Locale</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__SUPPORTED_LOCALE = FacesConfigPackage.eINSTANCE.getDocumentRoot_SupportedLocale();

	/**
	 * The meta object literal for the '<em><b>To View Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__TO_VIEW_ID = FacesConfigPackage.eINSTANCE.getDocumentRoot_ToViewId();

	/**
	 * The meta object literal for the '<em><b>Validator</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__VALIDATOR = FacesConfigPackage.eINSTANCE.getDocumentRoot_Validator();

	/**
	 * The meta object literal for the '<em><b>Validator Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__VALIDATOR_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_ValidatorClass();

	/**
	 * The meta object literal for the '<em><b>Validator Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__VALIDATOR_ID = FacesConfigPackage.eINSTANCE.getDocumentRoot_ValidatorId();

	/**
	 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__VALUE = FacesConfigPackage.eINSTANCE.getDocumentRoot_Value();

	/**
	 * The meta object literal for the '<em><b>Value Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__VALUE_CLASS = FacesConfigPackage.eINSTANCE.getDocumentRoot_ValueClass();

	/**
	 * The meta object literal for the '<em><b>Variable Resolver</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__VARIABLE_RESOLVER = FacesConfigPackage.eINSTANCE.getDocumentRoot_VariableResolver();

	/**
	 * The meta object literal for the '<em><b>View Handler</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference DOCUMENT_ROOT__VIEW_HANDLER = FacesConfigPackage.eINSTANCE.getDocumentRoot_ViewHandler();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigTypeImpl <em>Faces Config Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFacesConfigType()
	 * @generated
	 */
	EClass FACES_CONFIG_TYPE = FacesConfigPackage.eINSTANCE.getFacesConfigType();

	/**
	 * The meta object literal for the '<em><b>Application</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__APPLICATION = FacesConfigPackage.eINSTANCE.getFacesConfigType_Application();

	/**
	 * The meta object literal for the '<em><b>Factory</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__FACTORY = FacesConfigPackage.eINSTANCE.getFacesConfigType_Factory();

	/**
	 * The meta object literal for the '<em><b>Component</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__COMPONENT = FacesConfigPackage.eINSTANCE.getFacesConfigType_Component();

	/**
	 * The meta object literal for the '<em><b>Converter</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__CONVERTER = FacesConfigPackage.eINSTANCE.getFacesConfigType_Converter();

	/**
	 * The meta object literal for the '<em><b>Managed Bean</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__MANAGED_BEAN = FacesConfigPackage.eINSTANCE.getFacesConfigType_ManagedBean();

	/**
	 * The meta object literal for the '<em><b>Navigation Rule</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__NAVIGATION_RULE = FacesConfigPackage.eINSTANCE.getFacesConfigType_NavigationRule();

	/**
	 * The meta object literal for the '<em><b>Referenced Bean</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__REFERENCED_BEAN = FacesConfigPackage.eINSTANCE.getFacesConfigType_ReferencedBean();

	/**
	 * The meta object literal for the '<em><b>Render Kit</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__RENDER_KIT = FacesConfigPackage.eINSTANCE.getFacesConfigType_RenderKit();

	/**
	 * The meta object literal for the '<em><b>Lifecycle</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__LIFECYCLE = FacesConfigPackage.eINSTANCE.getFacesConfigType_Lifecycle();

	/**
	 * The meta object literal for the '<em><b>Validator</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACES_CONFIG_TYPE__VALIDATOR = FacesConfigPackage.eINSTANCE.getFacesConfigType_Validator();

	/**
	 * The meta object literal for the '<em><b>Xmlns</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FACES_CONFIG_TYPE__XMLNS = FacesConfigPackage.eINSTANCE.getFacesConfigType_Xmlns();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FACES_CONFIG_TYPE__ID = FacesConfigPackage.eINSTANCE.getFacesConfigType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FacesContextFactoryTypeImpl <em>Faces Context Factory Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesContextFactoryTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFacesContextFactoryType()
	 * @generated
	 */
	EClass FACES_CONTEXT_FACTORY_TYPE = FacesConfigPackage.eINSTANCE.getFacesContextFactoryType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FACES_CONTEXT_FACTORY_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getFacesContextFactoryType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FACES_CONTEXT_FACTORY_TYPE__ID = FacesConfigPackage.eINSTANCE.getFacesContextFactoryType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FacetExtensionTypeImpl <em>Facet Extension Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacetExtensionTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFacetExtensionType()
	 * @generated
	 */
	EClass FACET_EXTENSION_TYPE = FacesConfigPackage.eINSTANCE.getFacetExtensionType();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FacetNameTypeImpl <em>Facet Name Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacetNameTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFacetNameType()
	 * @generated
	 */
	EClass FACET_NAME_TYPE = FacesConfigPackage.eINSTANCE.getFacetNameType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FACET_NAME_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getFacetNameType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FACET_NAME_TYPE__ID = FacesConfigPackage.eINSTANCE.getFacetNameType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FacetTypeImpl <em>Facet Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacetTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFacetType()
	 * @generated
	 */
	EClass FACET_TYPE = FacesConfigPackage.eINSTANCE.getFacetType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACET_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getFacetType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACET_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getFacetType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACET_TYPE__ICON = FacesConfigPackage.eINSTANCE.getFacetType_Icon();

	/**
	 * The meta object literal for the '<em><b>Facet Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACET_TYPE__FACET_NAME = FacesConfigPackage.eINSTANCE.getFacetType_FacetName();

	/**
	 * The meta object literal for the '<em><b>Facet Extension</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACET_TYPE__FACET_EXTENSION = FacesConfigPackage.eINSTANCE.getFacetType_FacetExtension();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FACET_TYPE__ID = FacesConfigPackage.eINSTANCE.getFacetType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FactoryTypeImpl <em>Factory Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FactoryTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFactoryType()
	 * @generated
	 */
	EClass FACTORY_TYPE = FacesConfigPackage.eINSTANCE.getFactoryType();

	/**
	 * The meta object literal for the '<em><b>Application Factory</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACTORY_TYPE__APPLICATION_FACTORY = FacesConfigPackage.eINSTANCE.getFactoryType_ApplicationFactory();

	/**
	 * The meta object literal for the '<em><b>Faces Context Factory</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACTORY_TYPE__FACES_CONTEXT_FACTORY = FacesConfigPackage.eINSTANCE.getFactoryType_FacesContextFactory();

	/**
	 * The meta object literal for the '<em><b>Lifecycle Factory</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACTORY_TYPE__LIFECYCLE_FACTORY = FacesConfigPackage.eINSTANCE.getFactoryType_LifecycleFactory();

	/**
	 * The meta object literal for the '<em><b>Render Kit Factory</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference FACTORY_TYPE__RENDER_KIT_FACTORY = FacesConfigPackage.eINSTANCE.getFactoryType_RenderKitFactory();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FACTORY_TYPE__ID = FacesConfigPackage.eINSTANCE.getFactoryType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FromActionTypeImpl <em>From Action Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FromActionTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFromActionType()
	 * @generated
	 */
	EClass FROM_ACTION_TYPE = FacesConfigPackage.eINSTANCE.getFromActionType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FROM_ACTION_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getFromActionType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FROM_ACTION_TYPE__ID = FacesConfigPackage.eINSTANCE.getFromActionType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FromOutcomeTypeImpl <em>From Outcome Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FromOutcomeTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFromOutcomeType()
	 * @generated
	 */
	EClass FROM_OUTCOME_TYPE = FacesConfigPackage.eINSTANCE.getFromOutcomeType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FROM_OUTCOME_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getFromOutcomeType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FROM_OUTCOME_TYPE__ID = FacesConfigPackage.eINSTANCE.getFromOutcomeType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.FromViewIdTypeImpl <em>From View Id Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FromViewIdTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getFromViewIdType()
	 * @generated
	 */
	EClass FROM_VIEW_ID_TYPE = FacesConfigPackage.eINSTANCE.getFromViewIdType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FROM_VIEW_ID_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getFromViewIdType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute FROM_VIEW_ID_TYPE__ID = FacesConfigPackage.eINSTANCE.getFromViewIdType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.IconTypeImpl <em>Icon Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.IconTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getIconType()
	 * @generated
	 */
	EClass ICON_TYPE = FacesConfigPackage.eINSTANCE.getIconType();

	/**
	 * The meta object literal for the '<em><b>Small Icon</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ICON_TYPE__SMALL_ICON = FacesConfigPackage.eINSTANCE.getIconType_SmallIcon();

	/**
	 * The meta object literal for the '<em><b>Large Icon</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference ICON_TYPE__LARGE_ICON = FacesConfigPackage.eINSTANCE.getIconType_LargeIcon();

	/**
	 * The meta object literal for the '<em><b>Lang</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ICON_TYPE__LANG = FacesConfigPackage.eINSTANCE.getIconType_Lang();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute ICON_TYPE__ID = FacesConfigPackage.eINSTANCE.getIconType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.KeyClassTypeImpl <em>Key Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.KeyClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getKeyClassType()
	 * @generated
	 */
	EClass KEY_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getKeyClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute KEY_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getKeyClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute KEY_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getKeyClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.KeyTypeImpl <em>Key Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.KeyTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getKeyType()
	 * @generated
	 */
	EClass KEY_TYPE = FacesConfigPackage.eINSTANCE.getKeyType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute KEY_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getKeyType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute KEY_TYPE__ID = FacesConfigPackage.eINSTANCE.getKeyType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.LargeIconTypeImpl <em>Large Icon Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.LargeIconTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getLargeIconType()
	 * @generated
	 */
	EClass LARGE_ICON_TYPE = FacesConfigPackage.eINSTANCE.getLargeIconType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute LARGE_ICON_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getLargeIconType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute LARGE_ICON_TYPE__ID = FacesConfigPackage.eINSTANCE.getLargeIconType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.LifecycleFactoryTypeImpl <em>Lifecycle Factory Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.LifecycleFactoryTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getLifecycleFactoryType()
	 * @generated
	 */
	EClass LIFECYCLE_FACTORY_TYPE = FacesConfigPackage.eINSTANCE.getLifecycleFactoryType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute LIFECYCLE_FACTORY_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getLifecycleFactoryType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute LIFECYCLE_FACTORY_TYPE__ID = FacesConfigPackage.eINSTANCE.getLifecycleFactoryType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.LifecycleTypeImpl <em>Lifecycle Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.LifecycleTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getLifecycleType()
	 * @generated
	 */
	EClass LIFECYCLE_TYPE = FacesConfigPackage.eINSTANCE.getLifecycleType();

	/**
	 * The meta object literal for the '<em><b>Phase Listener</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference LIFECYCLE_TYPE__PHASE_LISTENER = FacesConfigPackage.eINSTANCE.getLifecycleType_PhaseListener();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute LIFECYCLE_TYPE__ID = FacesConfigPackage.eINSTANCE.getLifecycleType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ListEntriesTypeImpl <em>List Entries Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ListEntriesTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getListEntriesType()
	 * @generated
	 */
	EClass LIST_ENTRIES_TYPE = FacesConfigPackage.eINSTANCE.getListEntriesType();

	/**
	 * The meta object literal for the '<em><b>Value Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference LIST_ENTRIES_TYPE__VALUE_CLASS = FacesConfigPackage.eINSTANCE.getListEntriesType_ValueClass();

	/**
	 * The meta object literal for the '<em><b>Null Value</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference LIST_ENTRIES_TYPE__NULL_VALUE = FacesConfigPackage.eINSTANCE.getListEntriesType_NullValue();

	/**
	 * The meta object literal for the '<em><b>Value</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference LIST_ENTRIES_TYPE__VALUE = FacesConfigPackage.eINSTANCE.getListEntriesType_Value();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute LIST_ENTRIES_TYPE__ID = FacesConfigPackage.eINSTANCE.getListEntriesType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.LocaleConfigTypeImpl <em>Locale Config Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.LocaleConfigTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getLocaleConfigType()
	 * @generated
	 */
	EClass LOCALE_CONFIG_TYPE = FacesConfigPackage.eINSTANCE.getLocaleConfigType();

	/**
	 * The meta object literal for the '<em><b>Default Locale</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference LOCALE_CONFIG_TYPE__DEFAULT_LOCALE = FacesConfigPackage.eINSTANCE.getLocaleConfigType_DefaultLocale();

	/**
	 * The meta object literal for the '<em><b>Supported Locale</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference LOCALE_CONFIG_TYPE__SUPPORTED_LOCALE = FacesConfigPackage.eINSTANCE.getLocaleConfigType_SupportedLocale();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute LOCALE_CONFIG_TYPE__ID = FacesConfigPackage.eINSTANCE.getLocaleConfigType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedBeanClassTypeImpl <em>Managed Bean Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedBeanClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getManagedBeanClassType()
	 * @generated
	 */
	EClass MANAGED_BEAN_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getManagedBeanClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MANAGED_BEAN_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getManagedBeanClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MANAGED_BEAN_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getManagedBeanClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedBeanNameTypeImpl <em>Managed Bean Name Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedBeanNameTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getManagedBeanNameType()
	 * @generated
	 */
	EClass MANAGED_BEAN_NAME_TYPE = FacesConfigPackage.eINSTANCE.getManagedBeanNameType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MANAGED_BEAN_NAME_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getManagedBeanNameType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MANAGED_BEAN_NAME_TYPE__ID = FacesConfigPackage.eINSTANCE.getManagedBeanNameType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedBeanScopeTypeImpl <em>Managed Bean Scope Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedBeanScopeTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getManagedBeanScopeType()
	 * @generated
	 */
	EClass MANAGED_BEAN_SCOPE_TYPE = FacesConfigPackage.eINSTANCE.getManagedBeanScopeType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MANAGED_BEAN_SCOPE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getManagedBeanScopeType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MANAGED_BEAN_SCOPE_TYPE__ID = FacesConfigPackage.eINSTANCE.getManagedBeanScopeType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedBeanTypeImpl <em>Managed Bean Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedBeanTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getManagedBeanType()
	 * @generated
	 */
	EClass MANAGED_BEAN_TYPE = FacesConfigPackage.eINSTANCE.getManagedBeanType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getManagedBeanType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getManagedBeanType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__ICON = FacesConfigPackage.eINSTANCE.getManagedBeanType_Icon();

	/**
	 * The meta object literal for the '<em><b>Managed Bean Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__MANAGED_BEAN_NAME = FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanName();

	/**
	 * The meta object literal for the '<em><b>Managed Bean Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__MANAGED_BEAN_CLASS = FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanClass();

	/**
	 * The meta object literal for the '<em><b>Managed Bean Scope</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__MANAGED_BEAN_SCOPE = FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanScope();

	/**
	 * The meta object literal for the '<em><b>Managed Property</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__MANAGED_PROPERTY = FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedProperty();

	/**
	 * The meta object literal for the '<em><b>Map Entries</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__MAP_ENTRIES = FacesConfigPackage.eINSTANCE.getManagedBeanType_MapEntries();

	/**
	 * The meta object literal for the '<em><b>List Entries</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_BEAN_TYPE__LIST_ENTRIES = FacesConfigPackage.eINSTANCE.getManagedBeanType_ListEntries();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MANAGED_BEAN_TYPE__ID = FacesConfigPackage.eINSTANCE.getManagedBeanType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedPropertyTypeImpl <em>Managed Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ManagedPropertyTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getManagedPropertyType()
	 * @generated
	 */
	EClass MANAGED_PROPERTY_TYPE = FacesConfigPackage.eINSTANCE.getManagedPropertyType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getManagedPropertyType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getManagedPropertyType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__ICON = FacesConfigPackage.eINSTANCE.getManagedPropertyType_Icon();

	/**
	 * The meta object literal for the '<em><b>Property Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__PROPERTY_NAME = FacesConfigPackage.eINSTANCE.getManagedPropertyType_PropertyName();

	/**
	 * The meta object literal for the '<em><b>Property Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__PROPERTY_CLASS = FacesConfigPackage.eINSTANCE.getManagedPropertyType_PropertyClass();

	/**
	 * The meta object literal for the '<em><b>Map Entries</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__MAP_ENTRIES = FacesConfigPackage.eINSTANCE.getManagedPropertyType_MapEntries();

	/**
	 * The meta object literal for the '<em><b>Null Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__NULL_VALUE = FacesConfigPackage.eINSTANCE.getManagedPropertyType_NullValue();

	/**
	 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__VALUE = FacesConfigPackage.eINSTANCE.getManagedPropertyType_Value();

	/**
	 * The meta object literal for the '<em><b>List Entries</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MANAGED_PROPERTY_TYPE__LIST_ENTRIES = FacesConfigPackage.eINSTANCE.getManagedPropertyType_ListEntries();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MANAGED_PROPERTY_TYPE__ID = FacesConfigPackage.eINSTANCE.getManagedPropertyType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.MapEntriesTypeImpl <em>Map Entries Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.MapEntriesTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getMapEntriesType()
	 * @generated
	 */
	EClass MAP_ENTRIES_TYPE = FacesConfigPackage.eINSTANCE.getMapEntriesType();

	/**
	 * The meta object literal for the '<em><b>Key Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MAP_ENTRIES_TYPE__KEY_CLASS = FacesConfigPackage.eINSTANCE.getMapEntriesType_KeyClass();

	/**
	 * The meta object literal for the '<em><b>Value Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MAP_ENTRIES_TYPE__VALUE_CLASS = FacesConfigPackage.eINSTANCE.getMapEntriesType_ValueClass();

	/**
	 * The meta object literal for the '<em><b>Map Entry</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MAP_ENTRIES_TYPE__MAP_ENTRY = FacesConfigPackage.eINSTANCE.getMapEntriesType_MapEntry();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MAP_ENTRIES_TYPE__ID = FacesConfigPackage.eINSTANCE.getMapEntriesType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.MapEntryTypeImpl <em>Map Entry Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.MapEntryTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getMapEntryType()
	 * @generated
	 */
	EClass MAP_ENTRY_TYPE = FacesConfigPackage.eINSTANCE.getMapEntryType();

	/**
	 * The meta object literal for the '<em><b>Key</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MAP_ENTRY_TYPE__KEY = FacesConfigPackage.eINSTANCE.getMapEntryType_Key();

	/**
	 * The meta object literal for the '<em><b>Null Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MAP_ENTRY_TYPE__NULL_VALUE = FacesConfigPackage.eINSTANCE.getMapEntryType_NullValue();

	/**
	 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference MAP_ENTRY_TYPE__VALUE = FacesConfigPackage.eINSTANCE.getMapEntryType_Value();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MAP_ENTRY_TYPE__ID = FacesConfigPackage.eINSTANCE.getMapEntryType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.MessageBundleTypeImpl <em>Message Bundle Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.MessageBundleTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getMessageBundleType()
	 * @generated
	 */
	EClass MESSAGE_BUNDLE_TYPE = FacesConfigPackage.eINSTANCE.getMessageBundleType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MESSAGE_BUNDLE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getMessageBundleType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute MESSAGE_BUNDLE_TYPE__ID = FacesConfigPackage.eINSTANCE.getMessageBundleType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.NavigationCaseTypeImpl <em>Navigation Case Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.NavigationCaseTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getNavigationCaseType()
	 * @generated
	 */
	EClass NAVIGATION_CASE_TYPE = FacesConfigPackage.eINSTANCE.getNavigationCaseType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_CASE_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getNavigationCaseType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_CASE_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getNavigationCaseType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_CASE_TYPE__ICON = FacesConfigPackage.eINSTANCE.getNavigationCaseType_Icon();

	/**
	 * The meta object literal for the '<em><b>From Action</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_CASE_TYPE__FROM_ACTION = FacesConfigPackage.eINSTANCE.getNavigationCaseType_FromAction();

	/**
	 * The meta object literal for the '<em><b>From Outcome</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_CASE_TYPE__FROM_OUTCOME = FacesConfigPackage.eINSTANCE.getNavigationCaseType_FromOutcome();

	/**
	 * The meta object literal for the '<em><b>To View Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_CASE_TYPE__TO_VIEW_ID = FacesConfigPackage.eINSTANCE.getNavigationCaseType_ToViewId();

	/**
	 * The meta object literal for the '<em><b>Redirect</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_CASE_TYPE__REDIRECT = FacesConfigPackage.eINSTANCE.getNavigationCaseType_Redirect();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute NAVIGATION_CASE_TYPE__ID = FacesConfigPackage.eINSTANCE.getNavigationCaseType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.NavigationHandlerTypeImpl <em>Navigation Handler Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.NavigationHandlerTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getNavigationHandlerType()
	 * @generated
	 */
	EClass NAVIGATION_HANDLER_TYPE = FacesConfigPackage.eINSTANCE.getNavigationHandlerType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute NAVIGATION_HANDLER_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getNavigationHandlerType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute NAVIGATION_HANDLER_TYPE__ID = FacesConfigPackage.eINSTANCE.getNavigationHandlerType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.NavigationRuleTypeImpl <em>Navigation Rule Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.NavigationRuleTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getNavigationRuleType()
	 * @generated
	 */
	EClass NAVIGATION_RULE_TYPE = FacesConfigPackage.eINSTANCE.getNavigationRuleType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_RULE_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getNavigationRuleType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_RULE_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getNavigationRuleType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_RULE_TYPE__ICON = FacesConfigPackage.eINSTANCE.getNavigationRuleType_Icon();

	/**
	 * The meta object literal for the '<em><b>From View Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_RULE_TYPE__FROM_VIEW_ID = FacesConfigPackage.eINSTANCE.getNavigationRuleType_FromViewId();

	/**
	 * The meta object literal for the '<em><b>Navigation Case</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference NAVIGATION_RULE_TYPE__NAVIGATION_CASE = FacesConfigPackage.eINSTANCE.getNavigationRuleType_NavigationCase();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute NAVIGATION_RULE_TYPE__ID = FacesConfigPackage.eINSTANCE.getNavigationRuleType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.NullValueTypeImpl <em>Null Value Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.NullValueTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getNullValueType()
	 * @generated
	 */
	EClass NULL_VALUE_TYPE = FacesConfigPackage.eINSTANCE.getNullValueType();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute NULL_VALUE_TYPE__ID = FacesConfigPackage.eINSTANCE.getNullValueType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.PhaseListenerTypeImpl <em>Phase Listener Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.PhaseListenerTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getPhaseListenerType()
	 * @generated
	 */
	EClass PHASE_LISTENER_TYPE = FacesConfigPackage.eINSTANCE.getPhaseListenerType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PHASE_LISTENER_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getPhaseListenerType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PHASE_LISTENER_TYPE__ID = FacesConfigPackage.eINSTANCE.getPhaseListenerType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyClassTypeImpl <em>Property Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getPropertyClassType()
	 * @generated
	 */
	EClass PROPERTY_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getPropertyClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PROPERTY_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getPropertyClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PROPERTY_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getPropertyClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyExtensionTypeImpl <em>Property Extension Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyExtensionTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getPropertyExtensionType()
	 * @generated
	 */
	EClass PROPERTY_EXTENSION_TYPE = FacesConfigPackage.eINSTANCE.getPropertyExtensionType();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyNameTypeImpl <em>Property Name Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyNameTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getPropertyNameType()
	 * @generated
	 */
	EClass PROPERTY_NAME_TYPE = FacesConfigPackage.eINSTANCE.getPropertyNameType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PROPERTY_NAME_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getPropertyNameType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PROPERTY_NAME_TYPE__ID = FacesConfigPackage.eINSTANCE.getPropertyNameType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyResolverTypeImpl <em>Property Resolver Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyResolverTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getPropertyResolverType()
	 * @generated
	 */
	EClass PROPERTY_RESOLVER_TYPE = FacesConfigPackage.eINSTANCE.getPropertyResolverType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PROPERTY_RESOLVER_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getPropertyResolverType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PROPERTY_RESOLVER_TYPE__ID = FacesConfigPackage.eINSTANCE.getPropertyResolverType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyTypeImpl <em>Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.PropertyTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getPropertyType()
	 * @generated
	 */
	EClass PROPERTY_TYPE = FacesConfigPackage.eINSTANCE.getPropertyType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference PROPERTY_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getPropertyType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference PROPERTY_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getPropertyType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference PROPERTY_TYPE__ICON = FacesConfigPackage.eINSTANCE.getPropertyType_Icon();

	/**
	 * The meta object literal for the '<em><b>Property Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference PROPERTY_TYPE__PROPERTY_NAME = FacesConfigPackage.eINSTANCE.getPropertyType_PropertyName();

	/**
	 * The meta object literal for the '<em><b>Property Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference PROPERTY_TYPE__PROPERTY_CLASS = FacesConfigPackage.eINSTANCE.getPropertyType_PropertyClass();

	/**
	 * The meta object literal for the '<em><b>Default Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference PROPERTY_TYPE__DEFAULT_VALUE = FacesConfigPackage.eINSTANCE.getPropertyType_DefaultValue();

	/**
	 * The meta object literal for the '<em><b>Suggested Value</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference PROPERTY_TYPE__SUGGESTED_VALUE = FacesConfigPackage.eINSTANCE.getPropertyType_SuggestedValue();

	/**
	 * The meta object literal for the '<em><b>Property Extension</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference PROPERTY_TYPE__PROPERTY_EXTENSION = FacesConfigPackage.eINSTANCE.getPropertyType_PropertyExtension();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute PROPERTY_TYPE__ID = FacesConfigPackage.eINSTANCE.getPropertyType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RedirectTypeImpl <em>Redirect Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RedirectTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRedirectType()
	 * @generated
	 */
	EClass REDIRECT_TYPE = FacesConfigPackage.eINSTANCE.getRedirectType();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute REDIRECT_TYPE__ID = FacesConfigPackage.eINSTANCE.getRedirectType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ReferencedBeanClassTypeImpl <em>Referenced Bean Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ReferencedBeanClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getReferencedBeanClassType()
	 * @generated
	 */
	EClass REFERENCED_BEAN_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getReferencedBeanClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute REFERENCED_BEAN_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getReferencedBeanClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute REFERENCED_BEAN_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getReferencedBeanClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ReferencedBeanNameTypeImpl <em>Referenced Bean Name Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ReferencedBeanNameTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getReferencedBeanNameType()
	 * @generated
	 */
	EClass REFERENCED_BEAN_NAME_TYPE = FacesConfigPackage.eINSTANCE.getReferencedBeanNameType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute REFERENCED_BEAN_NAME_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getReferencedBeanNameType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute REFERENCED_BEAN_NAME_TYPE__ID = FacesConfigPackage.eINSTANCE.getReferencedBeanNameType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ReferencedBeanTypeImpl <em>Referenced Bean Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ReferencedBeanTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getReferencedBeanType()
	 * @generated
	 */
	EClass REFERENCED_BEAN_TYPE = FacesConfigPackage.eINSTANCE.getReferencedBeanType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference REFERENCED_BEAN_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getReferencedBeanType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference REFERENCED_BEAN_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getReferencedBeanType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference REFERENCED_BEAN_TYPE__ICON = FacesConfigPackage.eINSTANCE.getReferencedBeanType_Icon();

	/**
	 * The meta object literal for the '<em><b>Referenced Bean Name</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference REFERENCED_BEAN_TYPE__REFERENCED_BEAN_NAME = FacesConfigPackage.eINSTANCE.getReferencedBeanType_ReferencedBeanName();

	/**
	 * The meta object literal for the '<em><b>Referenced Bean Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference REFERENCED_BEAN_TYPE__REFERENCED_BEAN_CLASS = FacesConfigPackage.eINSTANCE.getReferencedBeanType_ReferencedBeanClass();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute REFERENCED_BEAN_TYPE__ID = FacesConfigPackage.eINSTANCE.getReferencedBeanType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RendererClassTypeImpl <em>Renderer Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RendererClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRendererClassType()
	 * @generated
	 */
	EClass RENDERER_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getRendererClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDERER_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getRendererClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDERER_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getRendererClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RendererExtensionTypeImpl <em>Renderer Extension Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RendererExtensionTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRendererExtensionType()
	 * @generated
	 */
	EClass RENDERER_EXTENSION_TYPE = FacesConfigPackage.eINSTANCE.getRendererExtensionType();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RendererTypeImpl <em>Renderer Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RendererTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRendererType()
	 * @generated
	 */
	EClass RENDERER_TYPE = FacesConfigPackage.eINSTANCE.getRendererType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getRendererType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getRendererType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__ICON = FacesConfigPackage.eINSTANCE.getRendererType_Icon();

	/**
	 * The meta object literal for the '<em><b>Component Family</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__COMPONENT_FAMILY = FacesConfigPackage.eINSTANCE.getRendererType_ComponentFamily();

	/**
	 * The meta object literal for the '<em><b>Renderer Type</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__RENDERER_TYPE = FacesConfigPackage.eINSTANCE.getRendererType_RendererType();

	/**
	 * The meta object literal for the '<em><b>Renderer Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__RENDERER_CLASS = FacesConfigPackage.eINSTANCE.getRendererType_RendererClass();

	/**
	 * The meta object literal for the '<em><b>Facet</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__FACET = FacesConfigPackage.eINSTANCE.getRendererType_Facet();

	/**
	 * The meta object literal for the '<em><b>Attribute</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__ATTRIBUTE = FacesConfigPackage.eINSTANCE.getRendererType_Attribute();

	/**
	 * The meta object literal for the '<em><b>Renderer Extension</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDERER_TYPE__RENDERER_EXTENSION = FacesConfigPackage.eINSTANCE.getRendererType_RendererExtension();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDERER_TYPE__ID = FacesConfigPackage.eINSTANCE.getRendererType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RendererTypeTypeImpl <em>Renderer Type Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RendererTypeTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRendererTypeType()
	 * @generated
	 */
	EClass RENDERER_TYPE_TYPE = FacesConfigPackage.eINSTANCE.getRendererTypeType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDERER_TYPE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getRendererTypeType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDERER_TYPE_TYPE__ID = FacesConfigPackage.eINSTANCE.getRendererTypeType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RenderKitClassTypeImpl <em>Render Kit Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RenderKitClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRenderKitClassType()
	 * @generated
	 */
	EClass RENDER_KIT_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getRenderKitClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDER_KIT_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getRenderKitClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDER_KIT_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getRenderKitClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RenderKitFactoryTypeImpl <em>Render Kit Factory Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RenderKitFactoryTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRenderKitFactoryType()
	 * @generated
	 */
	EClass RENDER_KIT_FACTORY_TYPE = FacesConfigPackage.eINSTANCE.getRenderKitFactoryType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDER_KIT_FACTORY_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getRenderKitFactoryType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDER_KIT_FACTORY_TYPE__ID = FacesConfigPackage.eINSTANCE.getRenderKitFactoryType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RenderKitIdTypeImpl <em>Render Kit Id Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RenderKitIdTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRenderKitIdType()
	 * @generated
	 */
	EClass RENDER_KIT_ID_TYPE = FacesConfigPackage.eINSTANCE.getRenderKitIdType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDER_KIT_ID_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getRenderKitIdType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDER_KIT_ID_TYPE__ID = FacesConfigPackage.eINSTANCE.getRenderKitIdType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.RenderKitTypeImpl <em>Render Kit Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.RenderKitTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getRenderKitType()
	 * @generated
	 */
	EClass RENDER_KIT_TYPE = FacesConfigPackage.eINSTANCE.getRenderKitType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDER_KIT_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getRenderKitType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDER_KIT_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getRenderKitType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDER_KIT_TYPE__ICON = FacesConfigPackage.eINSTANCE.getRenderKitType_Icon();

	/**
	 * The meta object literal for the '<em><b>Render Kit Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDER_KIT_TYPE__RENDER_KIT_ID = FacesConfigPackage.eINSTANCE.getRenderKitType_RenderKitId();

	/**
	 * The meta object literal for the '<em><b>Render Kit Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDER_KIT_TYPE__RENDER_KIT_CLASS = FacesConfigPackage.eINSTANCE.getRenderKitType_RenderKitClass();

	/**
	 * The meta object literal for the '<em><b>Renderer</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference RENDER_KIT_TYPE__RENDERER = FacesConfigPackage.eINSTANCE.getRenderKitType_Renderer();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute RENDER_KIT_TYPE__ID = FacesConfigPackage.eINSTANCE.getRenderKitType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.SmallIconTypeImpl <em>Small Icon Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.SmallIconTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getSmallIconType()
	 * @generated
	 */
	EClass SMALL_ICON_TYPE = FacesConfigPackage.eINSTANCE.getSmallIconType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute SMALL_ICON_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getSmallIconType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute SMALL_ICON_TYPE__ID = FacesConfigPackage.eINSTANCE.getSmallIconType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.StateManagerTypeImpl <em>State Manager Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.StateManagerTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getStateManagerType()
	 * @generated
	 */
	EClass STATE_MANAGER_TYPE = FacesConfigPackage.eINSTANCE.getStateManagerType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute STATE_MANAGER_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getStateManagerType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute STATE_MANAGER_TYPE__ID = FacesConfigPackage.eINSTANCE.getStateManagerType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.SuggestedValueTypeImpl <em>Suggested Value Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.SuggestedValueTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getSuggestedValueType()
	 * @generated
	 */
	EClass SUGGESTED_VALUE_TYPE = FacesConfigPackage.eINSTANCE.getSuggestedValueType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute SUGGESTED_VALUE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getSuggestedValueType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute SUGGESTED_VALUE_TYPE__ID = FacesConfigPackage.eINSTANCE.getSuggestedValueType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.SupportedLocaleTypeImpl <em>Supported Locale Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.SupportedLocaleTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getSupportedLocaleType()
	 * @generated
	 */
	EClass SUPPORTED_LOCALE_TYPE = FacesConfigPackage.eINSTANCE.getSupportedLocaleType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute SUPPORTED_LOCALE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getSupportedLocaleType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute SUPPORTED_LOCALE_TYPE__ID = FacesConfigPackage.eINSTANCE.getSupportedLocaleType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ToViewIdTypeImpl <em>To View Id Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ToViewIdTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getToViewIdType()
	 * @generated
	 */
	EClass TO_VIEW_ID_TYPE = FacesConfigPackage.eINSTANCE.getToViewIdType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute TO_VIEW_ID_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getToViewIdType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute TO_VIEW_ID_TYPE__ID = FacesConfigPackage.eINSTANCE.getToViewIdType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ValidatorClassTypeImpl <em>Validator Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ValidatorClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getValidatorClassType()
	 * @generated
	 */
	EClass VALIDATOR_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getValidatorClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALIDATOR_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getValidatorClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALIDATOR_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getValidatorClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ValidatorIdTypeImpl <em>Validator Id Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ValidatorIdTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getValidatorIdType()
	 * @generated
	 */
	EClass VALIDATOR_ID_TYPE = FacesConfigPackage.eINSTANCE.getValidatorIdType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALIDATOR_ID_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getValidatorIdType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALIDATOR_ID_TYPE__ID = FacesConfigPackage.eINSTANCE.getValidatorIdType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ValidatorTypeImpl <em>Validator Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ValidatorTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getValidatorType()
	 * @generated
	 */
	EClass VALIDATOR_TYPE = FacesConfigPackage.eINSTANCE.getValidatorType();

	/**
	 * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference VALIDATOR_TYPE__DESCRIPTION = FacesConfigPackage.eINSTANCE.getValidatorType_Description();

	/**
	 * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference VALIDATOR_TYPE__DISPLAY_NAME = FacesConfigPackage.eINSTANCE.getValidatorType_DisplayName();

	/**
	 * The meta object literal for the '<em><b>Icon</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference VALIDATOR_TYPE__ICON = FacesConfigPackage.eINSTANCE.getValidatorType_Icon();

	/**
	 * The meta object literal for the '<em><b>Validator Id</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference VALIDATOR_TYPE__VALIDATOR_ID = FacesConfigPackage.eINSTANCE.getValidatorType_ValidatorId();

	/**
	 * The meta object literal for the '<em><b>Validator Class</b></em>' containment reference feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference VALIDATOR_TYPE__VALIDATOR_CLASS = FacesConfigPackage.eINSTANCE.getValidatorType_ValidatorClass();

	/**
	 * The meta object literal for the '<em><b>Attribute</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference VALIDATOR_TYPE__ATTRIBUTE = FacesConfigPackage.eINSTANCE.getValidatorType_Attribute();

	/**
	 * The meta object literal for the '<em><b>Property</b></em>' containment reference list feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EReference VALIDATOR_TYPE__PROPERTY = FacesConfigPackage.eINSTANCE.getValidatorType_Property();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALIDATOR_TYPE__ID = FacesConfigPackage.eINSTANCE.getValidatorType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ValueClassTypeImpl <em>Value Class Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ValueClassTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getValueClassType()
	 * @generated
	 */
	EClass VALUE_CLASS_TYPE = FacesConfigPackage.eINSTANCE.getValueClassType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALUE_CLASS_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getValueClassType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALUE_CLASS_TYPE__ID = FacesConfigPackage.eINSTANCE.getValueClassType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ValueTypeImpl <em>Value Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ValueTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getValueType()
	 * @generated
	 */
	EClass VALUE_TYPE = FacesConfigPackage.eINSTANCE.getValueType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALUE_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getValueType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VALUE_TYPE__ID = FacesConfigPackage.eINSTANCE.getValueType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.VariableResolverTypeImpl <em>Variable Resolver Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.VariableResolverTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getVariableResolverType()
	 * @generated
	 */
	EClass VARIABLE_RESOLVER_TYPE = FacesConfigPackage.eINSTANCE.getVariableResolverType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VARIABLE_RESOLVER_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getVariableResolverType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VARIABLE_RESOLVER_TYPE__ID = FacesConfigPackage.eINSTANCE.getVariableResolverType_Id();

	/**
	 * The meta object literal for the '{@link org.eclipse.jst.jsf.facesconfig.emf.impl.ViewHandlerTypeImpl <em>View Handler Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.ViewHandlerTypeImpl
	 * @see org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigPackageImpl#getViewHandlerType()
	 * @generated
	 */
	EClass VIEW_HANDLER_TYPE = FacesConfigPackage.eINSTANCE.getViewHandlerType();

	/**
	 * The meta object literal for the '<em><b>Text Content</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VIEW_HANDLER_TYPE__TEXT_CONTENT = FacesConfigPackage.eINSTANCE.getViewHandlerType_TextContent();

	/**
	 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EAttribute VIEW_HANDLER_TYPE__ID = FacesConfigPackage.eINSTANCE.getViewHandlerType_Id();

}
