/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSBlockFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableLayout2;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableRowGroupInfo;

public class CSSTRGroupLayout
extends CSSBlockFlowLayout {
    public CSSTRGroupLayout(CSSFigure cssfigure) {
        super(cssfigure);
    }

    public CSSTableLayout2 getTableLayoutContext() {
        LayoutManager parentLayout;
        IFigure parent = this.getCSSFigure().getParent();
        if (parent != null && (parentLayout = parent.getLayoutManager()) instanceof CSSTableLayout2) {
            return (CSSTableLayout2)parentLayout;
        }
        return null;
    }

    public void postValidate() {
        CSSTableLayout2 tableLayout = this.getTableLayoutContext();
        if (tableLayout == null) {
            super.postValidate();
        } else {
            Rectangle r = this.getTRGroupRect(tableLayout);
            if (r != null) {
                this._blockBox.setXYWidthHeight(r);
                this.getCSSFigure().setBounds(r);
                List list = this.getCSSFigure().getChildren();
                int i = 0;
                while (i < list.size()) {
                    ((FlowFigure)((Object)list.get(i))).postValidate();
                    ++i;
                }
            } else {
                super.postValidate();
            }
        }
    }

    private Rectangle getTRGroupRect(CSSTableLayout2 tableLayout) {
        TableRowGroupInfo groupinfo = tableLayout.getGroupInfo(this.getCSSFigure());
        int rowIndex = groupinfo.getRowIndex();
        int rowCount = groupinfo.getRowCount();
        int y = (rowIndex + 1) * tableLayout.getVSpacing();
        int k = 0;
        while (k < rowIndex) {
            y += tableLayout.getRowHeights()[k];
            ++k;
        }
        if (tableLayout.getCaptionInfo() != null && "top".equalsIgnoreCase(tableLayout.getCaptionInfo().getAlign())) {
            y += tableLayout.getCaptionSize().height;
        }
        int height = (rowCount - 1) * tableLayout.getVSpacing();
        int k2 = 0;
        while (k2 < rowCount) {
            height += tableLayout.getRowHeights()[rowIndex + k2];
            ++k2;
        }
        return new Rectangle(tableLayout.getRowX(), y, tableLayout.getRowWidth(), height);
    }

    public boolean useLocalCoordinates() {
        return this.getTableLayoutContext() == null;
    }

    protected void endBlock() {
        if (this.getTableLayoutContext() == null) {
            super.endBlock();
        } else {
            this.layoutLines();
        }
    }

    public boolean handlingBorderForBlock() {
        return false;
    }
}

