/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jst.pagedesigner.commands.single.ChangeStyleCommand;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.properties.celleditors.CSSStyleDeclarationFactory;
import org.eclipse.jst.pagedesigner.properties.celleditors.EditableDialogCellEditor;
import org.eclipse.jst.pagedesigner.ui.dialogs.StyleDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class CSSDialogCellEditor
extends EditableDialogCellEditor {
    private IDOMElement _element;
    private IPropertyPageDescriptor _attr;

    public CSSDialogCellEditor(Composite parent, IPropertyPageDescriptor attr, IDOMElement element) {
        super(parent);
        this._element = element;
        this._attr = attr;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        CSSPropertyContext context;
        ICSSStyleDeclaration styleDeclaration = CSSStyleDeclarationFactory.getInstance().getStyleDeclaration(this._element, this._attr.getAttributeName());
        PreferenceManager manager = new PreferenceManager();
        Shell shell = cellEditorWindow.getShell();
        StyleDialog dialog = new StyleDialog(shell, manager, this._element, context = new CSSPropertyContext(styleDeclaration));
        if (dialog.open() == 0 && context.isModified()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ChangeStyleCommand c = new ChangeStyleCommand(CSSDialogCellEditor.this._element, CSSDialogCellEditor.this._attr.getAttributeName(), context);
                    c.execute();
                }
            });
        }
        String style = this._element == null ? null : this._element.getAttribute(this._attr.getAttributeName());
        return style == null ? "" : style;
    }
}

