/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.contentassist;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            return this.computeCompletionProposals((JavaContentAssistInvocationContext)context);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        CompletionContext completionContext = context.getCoreContext();
        int tokenStart = completionContext.getOffset();
        ICompilationUnit source = context.getCompilationUnit();
        try {
            IJavaElement javaElement = source.getElementAt(tokenStart);
            if (javaElement != null) {
                switch (javaElement.getElementType()) {
                    case 7: 
                    case 8: 
                    case 11: {
                        return this.getCompletionProposalsForJavaElement(AnnotationUtils.getAnnotations((IJavaElement)javaElement), javaElement, tokenStart);
                    }
                    case 9: {
                        ILocalVariable localVariable = AnnotationUtils.getLocalVariable((IMethod)((IMethod)javaElement), (int)tokenStart);
                        if (localVariable != null) {
                            return this.getCompletionProposalsForJavaElement(AnnotationUtils.getAnnotations((IJavaElement)localVariable), (IJavaElement)localVariable, tokenStart);
                        }
                        return this.getCompletionProposalsForJavaElement(AnnotationUtils.getAnnotations((IJavaElement)javaElement), javaElement, tokenStart);
                    }
                }
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> getCompletionProposalsForJavaElement(List<Annotation> annotations, IJavaElement javaElement, int offset) {
        for (Annotation annotation : annotations) {
            SingleMemberAnnotation singleMemberAnnotation;
            NormalAnnotation normalAnnotation;
            MemberValuePair memberValuePair;
            if (annotation instanceof NormalAnnotation && (memberValuePair = this.getMemberValuePairForPosition(normalAnnotation = (NormalAnnotation)annotation, offset)) != null) {
                return this.getCompletionProposalsForJavaElement(normalAnnotation, memberValuePair, javaElement);
            }
            if (!(annotation instanceof SingleMemberAnnotation) || !this.isWithinSingleMemberAnnotationValue(singleMemberAnnotation = (SingleMemberAnnotation)annotation, offset)) continue;
            return this.getCompletionProposalsForJavaElement(singleMemberAnnotation, javaElement);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> getCompletionProposalsForJavaElement(NormalAnnotation annotation, MemberValuePair memberValuePair, IJavaElement javaElement) {
        IAnnotationAttributeInitializer annotationAttributeInitializer = AnnotationsManager.getAnnotationAttributeInitializerForName((Name)annotation.getTypeName());
        if (annotationAttributeInitializer != null) {
            return annotationAttributeInitializer.getCompletionProposalsForMemberValuePair(javaElement, memberValuePair);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> getCompletionProposalsForJavaElement(SingleMemberAnnotation annotation, IJavaElement javaElement) {
        IAnnotationAttributeInitializer annotationAttributeInitializer = AnnotationsManager.getAnnotationAttributeInitializerForName((Name)annotation.getTypeName());
        if (annotationAttributeInitializer != null) {
            return annotationAttributeInitializer.getCompletionProposalsForSingleMemberAnnotation(javaElement, annotation);
        }
        return Collections.emptyList();
    }

    private MemberValuePair getMemberValuePairForPosition(NormalAnnotation normalAnnotation, int offset) {
        List memberValuePairs = normalAnnotation.values();
        for (MemberValuePair memberValuePair : memberValuePairs) {
            Expression value = memberValuePair.getValue();
            int valueStartPosition = value.getStartPosition();
            int valueLength = value.getLength();
            if (offset < valueStartPosition || offset > valueStartPosition + valueLength) continue;
            return memberValuePair;
        }
        return null;
    }

    private boolean isWithinSingleMemberAnnotationValue(SingleMemberAnnotation singleMemberAnnotation, int offset) {
        Expression value = singleMemberAnnotation.getValue();
        if (value != null) {
            int valueStartPosition = value.getStartPosition();
            int valueLength = value.getLength();
            return offset >= valueStartPosition && offset <= valueStartPosition + valueLength;
        }
        return false;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }
}

