/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.PublishAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessServices;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.RegisteredInfo;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.transport.TransportException;

public class LoginAdvancedAction
extends PublishAction {
    public LoginAdvancedAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(0));
        this.propertyTable_.put("queryStyleBusinesses", String.valueOf(1));
        this.propertyTable_.put("advancedBusinessMaxSearchSet", String.valueOf(100));
        this.propertyTable_.put("advancedBusinessMaxResults", String.valueOf(10));
    }

    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String ownedChecked = parser.getParameter("advancedOwned");
        boolean inputsValid = true;
        if (ownedChecked != null) {
            this.propertyTable_.put("advancedBusinessOwned", ownedChecked);
        } else {
            this.removeProperty("advancedBusinessOwned");
        }
        return inputsValid;
    }

    private boolean attemptingDoubleLogin() {
        String userId = (String)this.propertyTable_.get("advancedUserId");
        String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
        Node rootNode = this.regNode_.getNodeManager().getRootNode();
        Vector allNodes = rootNode.getChildNodes();
        int k = 0;
        while (k < allNodes.size()) {
            Node n = (Node)allNodes.get(k);
            if (n instanceof RegistryNode) {
                RegistryElement myElement = (RegistryElement)n.getTreeElement();
                if (n.getNodeId() != this.regNode_.getNodeId() && publishURL.equals(myElement.getPublishURL()) && userId.equals(myElement.getUserId())) {
                    return true;
                }
            }
            ++k;
        }
        return false;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            Vector finalTModelVector;
            int size;
            boolean shouldAddQueryNode = this.propertyTable_.get("overrideAddQueryNode") == null;
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            int maxResults = 300;
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            if (this.attemptingDoubleLogin()) {
                throw new AlreadyBoundException(uddiPerspective.getMessage("MSG_INFO_NO_MULTIPLE_LOGIN"));
            }
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            UDDIProxy proxy = regElement.getProxy();
            BusinessInfos busInfos = null;
            TModelInfos tmInfos = null;
            RegisteredInfo ri = proxy.get_registeredInfo(regElement.getAuthInfoString());
            busInfos = ri.getBusinessInfos();
            tmInfos = ri.getTModelInfos();
            int finalNumberOfBusinessEntities = Math.min(maxResults, busInfos.size());
            Vector<String> businessKeys = new Vector<String>();
            int i = 0;
            while (i < finalNumberOfBusinessEntities) {
                BusinessInfo busInfo = busInfos.get(i);
                businessKeys.addElement(busInfo.getBusinessKey());
                ++i;
            }
            if (finalNumberOfBusinessEntities > 0 && shouldAddQueryNode) {
                Vector beVector = proxy.get_businessDetail(businessKeys).getBusinessEntityVector();
                BusinessEntity be = null;
                BusinessServices bs = null;
                size = beVector.size();
                if (size > 0) {
                    int i2 = 0;
                    while (i2 < size) {
                        be = (BusinessEntity)beVector.elementAt(i2);
                        this.addPublishedItemNode(be, regElement);
                        bs = be.getBusinessServices();
                        if (bs != null) {
                            Vector vServices = bs.getBusinessServiceVector();
                            int services = vServices.size();
                            int j = 0;
                            while (j < services) {
                                this.addPublishedItemNode(bs.get(j), regElement);
                                ++j;
                            }
                        }
                        ++i2;
                    }
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_BUSINESSES_FOUND", String.valueOf(size)));
                }
            }
            int finalNumberOfTModels = Math.min(maxResults, tmInfos.size());
            Vector<String> tModelKeys = new Vector<String>();
            int i3 = 0;
            while (i3 < finalNumberOfTModels) {
                TModelInfo tmInfo = tmInfos.get(i3);
                tModelKeys.addElement(tmInfo.getTModelKey());
                ++i3;
            }
            if (finalNumberOfTModels > 0 && shouldAddQueryNode && (size = (finalTModelVector = proxy.get_tModelDetail(tModelKeys).getTModelVector()).size()) > 0) {
                TModel tm = null;
                int i4 = 0;
                while (i4 < size) {
                    tm = (TModel)finalTModelVector.elementAt(i4);
                    this.addPublishedItemNode(tm, regElement);
                    ++i4;
                }
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_INTERFACES_FOUND", String.valueOf(size)));
            }
            int id = 1;
            RegistryNode regNode = this.getRegistryNode();
            regNode.getLoginTool().setAltText(uddiPerspective.getMessage("ALT_LOGOUT"));
            regNode.getLoginTool().setToLogoutLink();
            String registryName = regElement.getName();
            String[] s = new String[]{registryName, userId};
            regElement.setName(uddiPerspective.getMessage("MSG_INFO_LOGGED_IN_NODE", s));
            if (finalNumberOfBusinessEntities > 0) {
                Node pbeNode = regNode.getChildNode(regElement.getPublishedBusinessesElement());
                id = pbeNode.getNodeId();
            } else if (finalNumberOfTModels > 0) {
                Node psiNode = regNode.getChildNode(regElement.getPublishedServiceInterfacesElement());
                id = psiNode.getNodeId();
            }
            uddiPerspective.getNodeManager().setSelectedNodeId(id);
            uddiPerspective.getNodeManager().makeSelectedNodeVisible();
            if (finalNumberOfBusinessEntities < 1 && finalNumberOfTModels < 1) {
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_NO_BUSINESSES_OR_SERVICE_INTERFACES_FOUND"));
            }
            return true;
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (AlreadyBoundException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("AlreadyBoundException");
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

