/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.RhinoImageRegistry;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching.IncludeEntry;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching.Messages;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.Refactoring;
import org.eclipse.wst.jsdt.debug.internal.ui.dialogs.ScriptSelectionDialog;

public class IncludeTab
extends AbstractLaunchConfigurationTab {
    public static final String TAB_ID = "rhino.include.tab";
    public static final String JS_EXTENSION = "*.js";
    private TreeViewer viewer = null;
    private Button remove = null;
    private Button addexternalscript = null;
    private Button addscript = null;
    private Button defaults = null;
    private Button up = null;
    private Button down = null;
    private Vector includes = new Vector();
    private ILaunchConfiguration backingconfig = null;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (int)2, (int)1, (int)768);
        SWTFactory.createWrapLabel((Composite)comp, (String)Messages.include_path, (int)2);
        Tree tree = new Tree(comp, 67586);
        tree.setLayout((Layout)new GridLayout(1, true));
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TreeViewer(tree);
        this.viewer.setLabelProvider((IBaseLabelProvider)new Labels());
        this.viewer.setContentProvider((IContentProvider)new Contents());
        this.viewer.setInput((Object)this.includes);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IncludeTab.this.updateButtons((IStructuredSelection)event.getSelection());
            }
        });
        Composite lhs = SWTFactory.createComposite((Composite)comp, (Font)comp.getFont(), (int)1, (int)1, (int)1040, (int)0, (int)0);
        this.up = SWTFactory.createPushButton((Composite)lhs, (String)Messages.up_button, null);
        this.up.setEnabled(false);
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.up(((IStructuredSelection)IncludeTab.this.viewer.getSelection()).getFirstElement());
            }
        });
        this.down = SWTFactory.createPushButton((Composite)lhs, (String)Messages.down_button, null);
        this.down.setEnabled(false);
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.down(((IStructuredSelection)IncludeTab.this.viewer.getSelection()).getFirstElement());
            }
        });
        this.remove = SWTFactory.createPushButton((Composite)lhs, (String)Messages.remove_button, null);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.remove((IStructuredSelection)IncludeTab.this.viewer.getSelection());
            }
        });
        this.addscript = SWTFactory.createPushButton((Composite)lhs, (String)Messages.add_script_button, null);
        this.addscript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.addScript();
            }
        });
        this.addexternalscript = SWTFactory.createPushButton((Composite)lhs, (String)Messages.add_ext_script_button, null);
        this.addexternalscript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.addExtScript();
            }
        });
        SWTFactory.createHorizontalSpacer((Composite)lhs, (int)1);
        this.defaults = SWTFactory.createPushButton((Composite)lhs, (String)Messages.defaults_button, null);
        this.defaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.defaults();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.wst.jsdt.debug.rhino.ui.rhino_include_tab_context");
        this.setControl((Control)comp);
    }

    void updateButtons(IStructuredSelection selection) {
        int size = selection.size();
        if (size == 1) {
            Object element = selection.getFirstElement();
            int idx = this.includes.indexOf(element);
            this.up.setEnabled(idx > 0);
            this.down.setEnabled(idx < this.includes.size() - 1);
        } else {
            if (this.up != null) {
                this.up.setEnabled(false);
            }
            if (this.down != null) {
                this.down.setEnabled(false);
            }
        }
        this.remove.setEnabled(size > 0);
    }

    void addScript() {
        ScriptSelectionDialog dialog = new ScriptSelectionDialog(this.getShell(), true, (IContainer)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            Object[] scripts = dialog.getResult();
            IncludeEntry newentry = null;
            int i = 0;
            while (i < scripts.length) {
                newentry = new IncludeEntry(1, ((IFile)scripts[i]).getFullPath().makeAbsolute().toString());
                if (!this.includes.contains(newentry)) {
                    this.includes.add(newentry);
                }
                ++i;
            }
            this.viewer.refresh();
            this.updateLaunchConfigurationDialog();
        }
    }

    void up(Object element) {
        int idx = this.includes.indexOf(element);
        if (idx < 0) {
            return;
        }
        this.includes.remove(idx);
        this.includes.insertElementAt(element, idx - 1);
        this.viewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    void down(Object element) {
        int idx = this.includes.indexOf(element);
        if (idx < 0) {
            return;
        }
        this.includes.remove(idx);
        this.includes.insertElementAt(element, idx + 1);
        this.viewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    void remove(IStructuredSelection selection) {
        this.includes.removeAll(selection.toList());
        this.viewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    void defaults() {
        this.includes.clear();
        this.viewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    void addExtScript() {
        String path;
        String[] names;
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setFilterExtensions(new String[]{JS_EXTENSION});
        dialog.setFilterIndex(0);
        dialog.setText(Messages.select_scripts_to_add);
        if (dialog.open() != null && (names = dialog.getFileNames()) != null && names.length > 0 && (path = dialog.getFilterPath()) != null) {
            boolean added = false;
            int i = 0;
            while (i < names.length) {
                File script = new File(path, names[i]);
                if (script.exists()) {
                    this.includes.add(new IncludeEntry(2, new Path(script.getAbsolutePath()).toString()));
                    added = true;
                }
                ++i;
            }
            if (added) {
                this.viewer.refresh();
                this.updateLaunchConfigurationDialog();
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.backingconfig = configuration;
        this.includes.clear();
        IncludeEntry[] entries = Refactoring.getIncludeEntries(this.backingconfig);
        int i = 0;
        while (i < entries.length) {
            this.includes.add(entries[i]);
            ++i;
        }
        this.viewer.refresh();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.includes.isEmpty()) {
            configuration.removeAttribute("includepath");
        } else {
            ArrayList<String> list = new ArrayList<String>(this.includes.size());
            Iterator i = this.includes.iterator();
            while (i.hasNext()) {
                list.add(((IncludeEntry)i.next()).string());
            }
            configuration.setAttribute("includepath", list);
        }
    }

    public String getName() {
        return Messages.include_tab_name;
    }

    public Image getImage() {
        return RhinoImageRegistry.getSharedImage("IMG_LIBRARY");
    }

    public String getId() {
        return TAB_ID;
    }

    class ContainerFilter
    extends ViewerFilter {
        ContainerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof IContainer && ((IContainer)element).isAccessible();
        }
    }

    class Contents
    implements ITreeContentProvider {
        Contents() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Vector)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class Labels
    extends LabelProvider {
        Labels() {
        }

        public Image getImage(Object element) {
            IncludeEntry entry = (IncludeEntry)element;
            switch (entry.kind) {
                case 1: {
                    return RhinoImageRegistry.getSharedImage("IMG_SCRIPT");
                }
                case 2: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
            }
            return null;
        }

        public String getText(Object element) {
            IncludeEntry entry = (IncludeEntry)element;
            return entry.path;
        }
    }
}

