/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.CancelCounter;
import org.eclipse.wst.jsdt.core.tests.model.Canceler;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class WorkingCopyOwnerTests
extends ModifyingResourceTests {
    IJavaScriptUnit workingCopy = null;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.WorkingCopyOwnerTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return WorkingCopyOwnerTests.buildModelTestSuite(clazz);
    }

    public WorkingCopyOwnerTests(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P");
        this.createFile("P/X.js", "public class X {\n}");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    protected void tearDown() throws Exception {
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
            this.workingCopy = null;
        }
        super.tearDown();
    }

    protected void assertTypeBindingsEqual(String message, String expected, ITypeBinding[] types) {
        StringBuffer buffer = new StringBuffer();
        if (types == null) {
            buffer.append("<null>");
        } else {
            int i = 0;
            int length = types.length;
            while (i < length) {
                buffer.append(types[i].getQualifiedName());
                if (i != length - 1) {
                    buffer.append("\n");
                }
                ++i;
            }
        }
        if (!expected.equals(buffer.toString())) {
            System.out.println(Util.displayString((String)buffer.toString(), (int)2));
        }
        WorkingCopyOwnerTests.assertEquals((String)message, (String)expected, (String)buffer.toString());
    }

    public void testBecomeWorkingCopy1() throws CoreException {
        this.workingCopy = this.getCompilationUnit("P/X.js");
        WorkingCopyOwnerTests.assertTrue((String)"should not be in working copy mode", (!this.workingCopy.isWorkingCopy() ? 1 : 0) != 0);
        this.workingCopy.becomeWorkingCopy(null);
        WorkingCopyOwnerTests.assertTrue((String)"should be in working copy mode", (boolean)this.workingCopy.isWorkingCopy());
    }

    public void testBecomeWorkingCopy2() throws CoreException {
        this.workingCopy = this.getCompilationUnit("P/X.js").getWorkingCopy((WorkingCopyOwner)new TestWorkingCopyOwner(), null);
        WorkingCopyOwnerTests.assertTrue((String)"should be in working copy mode", (boolean)this.workingCopy.isWorkingCopy());
        this.workingCopy.becomeWorkingCopy(null);
        WorkingCopyOwnerTests.assertTrue((String)"should still be in working copy mode", (boolean)this.workingCopy.isWorkingCopy());
    }

    public void testBecomeWorkingCopy3() throws CoreException {
        this.workingCopy = this.getCompilationUnit("P/Y.js");
        this.workingCopy.becomeWorkingCopy(null);
        this.assertSortedElementsEqual("Unexpected children of default package", "X.java [in <default> [in <project root> [in P]]]\n[Working copy] Y.java [in <default> [in <project root> [in P]]]", this.getPackage("/P").getChildren());
    }

    public void testBecomeWorkingCopy4() throws CoreException {
        this.workingCopy = this.getCompilationUnit("P/X.js");
        CancelCounter counter = new CancelCounter();
        this.workingCopy.becomeWorkingCopy((IProgressMonitor)counter);
        this.workingCopy.discardWorkingCopy();
        int i = 0;
        while (i < counter.count) {
            boolean gotException = false;
            try {
                this.workingCopy.becomeWorkingCopy((IProgressMonitor)new Canceler(i));
            }
            catch (OperationCanceledException operationCanceledException) {
                gotException = true;
            }
            WorkingCopyOwnerTests.assertTrue((String)("Should get an OperationCanceledException (" + i + ")"), (boolean)gotException);
            this.workingCopy.discardWorkingCopy();
            ++i;
        }
        this.workingCopy.becomeWorkingCopy((IProgressMonitor)new Canceler(counter.count));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCommitPrimaryWorkingCopy() throws CoreException {
        try {
            IFile file = this.createFile("P/Y.js", "public class Y {\n}");
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.workingCopy.becomeWorkingCopy(null);
            String newContents = "public class Y {\n  void foo() {\n  }\n}";
            this.workingCopy.getBuffer().setContents(newContents);
            this.workingCopy.commitWorkingCopy(false, null);
            this.assertSourceEquals("Unexpected source", newContents, new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)file)));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteFile("P/Y.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteFile("P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaCommitPrimaryWorkingCopy1() throws CoreException {
        try {
            this.createFile("P/Y.js", "public class Y {\n}");
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.workingCopy.becomeWorkingCopy(null);
            this.workingCopy.getBuffer().setContents("public class Y {\n  void foo() {\n  }\n}");
            this.workingCopy.makeConsistent(null);
            this.startDeltas();
            this.workingCopy.commitWorkingCopy(false, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] Y.java[*]: {PRIMARY RESOURCE}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteFile("P/Y.js");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaCommitPrimaryWorkingCopy2() throws CoreException {
        try {
            this.createFile("P/Y.js", "public class Y {\n}");
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.workingCopy.becomeWorkingCopy(null);
            this.workingCopy.getBuffer().setContents("public class Y {\n  void foo() {\n  }\n}");
            this.startDeltas();
            this.workingCopy.commitWorkingCopy(false, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] Y.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tY[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteFile("P/Y.js");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaCreateNonPrimaryWorkingCopy() throws CoreException {
        try {
            this.createFile("P/Y.js", "public class Y {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/Y.js");
            this.startDeltas();
            this.workingCopy = cu.getWorkingCopy(null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] Y.java[+]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteFile("P/Y.js");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaBecomeWorkingCopy1() throws CoreException {
        try {
            this.createFile("P/Y.js", "public class Y {\n}");
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.startDeltas();
            this.workingCopy.becomeWorkingCopy(null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] Y.java[*]: {PRIMARY WORKING COPY}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteFile("P/Y.js");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaBecomeWorkingCopy2() throws CoreException {
        try {
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.startDeltas();
            this.workingCopy.becomeWorkingCopy(null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] Y.java[+]: {PRIMARY WORKING COPY}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaDiscardNonPrimaryWorkingCopy() throws CoreException {
        try {
            this.createFile("P/Y.js", "public class Y {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/Y.js");
            this.workingCopy = cu.getWorkingCopy(null);
            this.startDeltas();
            this.workingCopy.discardWorkingCopy();
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] Y.java[-]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteFile("P/Y.js");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaDiscardPrimaryWorkingCopy1() throws CoreException {
        try {
            this.createFile("P/Y.js", "public class Y {\n}");
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.workingCopy.becomeWorkingCopy(null);
            this.startDeltas();
            this.workingCopy.discardWorkingCopy();
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tY.java[*]: {PRIMARY WORKING COPY}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteFile("P/Y.js");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaDiscardPrimaryWorkingCopy2() throws CoreException {
        try {
            this.createFile("P/Y.js", "public class Y {\n}");
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.workingCopy.becomeWorkingCopy(null);
            this.workingCopy.getType("Y").createField("int x;", null, false, null);
            this.startDeltas();
            this.workingCopy.discardWorkingCopy();
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tY.java[*]: {CHILDREN | FINE GRAINED | PRIMARY WORKING COPY}\n\t\t\t\tY[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tx[-]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteFile("P/Y.js");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaDiscardPrimaryWorkingCopy3() throws CoreException {
        try {
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.workingCopy.becomeWorkingCopy(null);
            this.startDeltas();
            this.workingCopy.discardWorkingCopy();
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tY.java[-]: {PRIMARY WORKING COPY}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeltaDiscardPrimaryWorkingCopy4() throws CoreException {
        try {
            this.workingCopy = this.getCompilationUnit("P/X.js");
            this.workingCopy.becomeWorkingCopy(null);
            this.workingCopy.getBuffer().setContents("/*annotation*/public class X {}");
            this.startDeltas();
            this.workingCopy.discardWorkingCopy();
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CONTENT | FINE GRAINED | PRIMARY WORKING COPY}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    /*
     * Exception decompiling
     */
    public void testDiscardWorkingCopy1() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 75->79)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testDiscardWorkingCopy2() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 135->139)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testDiscardWorkingCopy3() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 285->289)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testDiscardWorkingCopy4() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        this.workingCopy = cu.getWorkingCopy((WorkingCopyOwner)owner, null);
        boolean gotException = false;
        try {
            this.workingCopy.getAllTypes();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            gotException = true;
        }
        WorkingCopyOwnerTests.assertTrue((String)"should not get a JavaScriptModelException before discarding working copy", (!gotException ? 1 : 0) != 0);
        this.workingCopy.discardWorkingCopy();
        gotException = false;
        try {
            this.workingCopy.getAllTypes();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            gotException = true;
        }
        WorkingCopyOwnerTests.assertTrue((String)"should get a JavaScriptModelException after discarding working copy", (boolean)gotException);
    }

    /*
     * Exception decompiling
     */
    public void testDiscardWorkingCopy5() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 64->68)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGetCorrespondingResource() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 61->65)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testGetOwner1() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        this.workingCopy = cu.getWorkingCopy((WorkingCopyOwner)owner, null);
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected owner", (Object)((Object)owner), (Object)this.workingCopy.getOwner());
    }

    public void testGetOwner2() {
        IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected owner", null, (Object)cu.getOwner());
    }

    public void testGetPrimary1() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        this.workingCopy = cu.getWorkingCopy((WorkingCopyOwner)owner, null);
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected compilation unit", (Object)cu, (Object)this.workingCopy.getPrimary());
    }

    public void testGetPrimary2() throws CoreException {
        this.workingCopy = this.getCompilationUnit("P/X.js");
        this.workingCopy.becomeWorkingCopy(null);
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected compilation unit", (Object)this.workingCopy, (Object)this.workingCopy.getPrimary());
    }

    public void testGetPrimaryElement1() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        this.workingCopy = cu.getWorkingCopy((WorkingCopyOwner)owner, null);
        IType element = this.workingCopy.getType("X");
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected element", (Object)cu.getType("X"), (Object)element.getPrimaryElement());
    }

    public void testGetPrimaryElement2() throws CoreException {
        this.workingCopy = this.getCompilationUnit("P/X.js");
        this.workingCopy.becomeWorkingCopy(null);
        IType element = this.workingCopy.getType("X");
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected element", (Object)element, (Object)element.getPrimaryElement());
    }

    public void testGetPrimaryElement3() {
        IPackageFragment pkg = this.getPackage("P");
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected element", (Object)pkg, (Object)pkg.getPrimaryElement());
    }

    public void testGetPrimaryElement4() throws JavaScriptModelException {
        IInitializer initializer = this.getClassFile("P/X.class").getType().getInitializer(1);
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected element", (Object)initializer, (Object)initializer.getPrimaryElement());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetWorkingCopies() throws CoreException {
        IJavaScriptUnit workingCopy21;
        IJavaScriptUnit workingCopy12;
        block6: {
            IJavaScriptUnit workingCopy11 = null;
            workingCopy12 = null;
            workingCopy21 = null;
            try {
                TestWorkingCopyOwner owner1 = new TestWorkingCopyOwner();
                this.assertSortedElementsEqual("Unexpected working copies (1)", "", (IJavaScriptElement[])JavaScriptCore.getWorkingCopies((WorkingCopyOwner)owner1));
                IJavaScriptUnit cu1 = this.getCompilationUnit("P/X.js");
                workingCopy11 = cu1.getWorkingCopy((WorkingCopyOwner)owner1, null);
                this.assertSortedElementsEqual("Unexpected working copies (2)", "[Working copy] X.java [in <default> [in <project root> [in P]]]", (IJavaScriptElement[])JavaScriptCore.getWorkingCopies((WorkingCopyOwner)owner1));
                IJavaScriptUnit cu2 = this.getCompilationUnit("P/Y.js");
                workingCopy12 = cu2.getWorkingCopy((WorkingCopyOwner)owner1, null);
                this.assertSortedElementsEqual("Unexpected working copies (3)", "[Working copy] X.java [in <default> [in <project root> [in P]]]\n[Working copy] Y.java [in <default> [in <project root> [in P]]]", (IJavaScriptElement[])JavaScriptCore.getWorkingCopies((WorkingCopyOwner)owner1));
                TestWorkingCopyOwner owner2 = new TestWorkingCopyOwner();
                workingCopy21 = cu1.getWorkingCopy((WorkingCopyOwner)owner2, null);
                this.assertSortedElementsEqual("Unexpected working copies (4)", "[Working copy] X.java [in <default> [in <project root> [in P]]]", (IJavaScriptElement[])JavaScriptCore.getWorkingCopies((WorkingCopyOwner)owner2));
                this.assertSortedElementsEqual("Unexpected working copies (5)", "[Working copy] X.java [in <default> [in <project root> [in P]]]\n[Working copy] Y.java [in <default> [in <project root> [in P]]]", (IJavaScriptElement[])JavaScriptCore.getWorkingCopies((WorkingCopyOwner)owner1));
                workingCopy11.discardWorkingCopy();
                this.assertSortedElementsEqual("Unexpected working copies (6)", "[Working copy] Y.java [in <default> [in <project root> [in P]]]", (IJavaScriptElement[])JavaScriptCore.getWorkingCopies((WorkingCopyOwner)owner1));
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (workingCopy11 != null) {
                    workingCopy11.discardWorkingCopy();
                }
                if (workingCopy12 != null) {
                    workingCopy12.discardWorkingCopy();
                }
                if (workingCopy21 == null) throw throwable;
                workingCopy21.discardWorkingCopy();
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (workingCopy11 == null) break block6;
            }
            workingCopy11.discardWorkingCopy();
        }
        if (workingCopy12 != null) {
            workingCopy12.discardWorkingCopy();
        }
        if (workingCopy21 == null) return;
        workingCopy21.discardWorkingCopy();
    }

    /*
     * Exception decompiling
     */
    public void testGetWorkingCopy1() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 102->106)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetWorkingCopy2() throws CoreException {
        IJavaScriptUnit workingCopy2;
        block4: {
            IJavaScriptUnit workingCopy1 = null;
            workingCopy2 = null;
            try {
                IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
                TestWorkingCopyOwner owner1 = new TestWorkingCopyOwner();
                workingCopy1 = cu.getWorkingCopy((WorkingCopyOwner)owner1, null);
                TestWorkingCopyOwner owner2 = new TestWorkingCopyOwner();
                workingCopy2 = cu.getWorkingCopy((WorkingCopyOwner)owner2, null);
                WorkingCopyOwnerTests.assertTrue((String)"working copies should be different", (!workingCopy1.equals(workingCopy2) ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (workingCopy1 != null) {
                    workingCopy1.discardWorkingCopy();
                }
                if (workingCopy2 == null) throw throwable;
                workingCopy2.discardWorkingCopy();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (workingCopy1 == null) break block4;
            }
            workingCopy1.discardWorkingCopy();
        }
        if (workingCopy2 == null) return;
        workingCopy2.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testHierarchy() throws CoreException {
        try {
            this.createFile("/P/Y.js", "public class Y extends X {\n}");
            TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
            this.workingCopy = this.getCompilationUnit("/P/Y.js").getWorkingCopy((WorkingCopyOwner)owner, null);
            IType focus = this.getCompilationUnit("/P/X.js").getType("X");
            ITypeHierarchy hierarchy = focus.newTypeHierarchy((WorkingCopyOwner)owner, null);
            IType[] subtypes = hierarchy.getSubclasses(focus);
            this.assertTypesEqual("Unexpected types", "Y\n", subtypes);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteFile("/P/Y.js");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteFile("/P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveWorkingCopy() throws CoreException {
        try {
            this.createFolder("/P/p1");
            this.createFile("/P/p1/Y.js", "package p1;\npublic class Y {\n}");
            this.createFolder("/P/p2");
            this.workingCopy = this.getCompilationUnit("P/p1/Y.js");
            this.workingCopy.becomeWorkingCopy(null);
            this.getPackage("/P/p1").open(null);
            this.workingCopy.move((IJavaScriptElement)this.getPackage("/P/p2"), null, null, false, null);
            this.assertElementDescendants("Unexpected content of /P/p1", "p1", (IJavaScriptElement)this.getPackage("/P/p1"));
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.deleteFolder("P/p1");
            this.deleteFolder("P/p2");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.deleteFolder("P/p1");
        this.deleteFolder("P/p2");
    }

    public void testNewWorkingCopy01() throws JavaScriptModelException {
        this.workingCopy = this.newExternalWorkingCopy("X.js", "public class X {\n}");
        WorkingCopyOwnerTests.assertTrue((String)"Working copy should exist", (boolean)this.workingCopy.exists());
    }

    public void testNewWorkingCopy02() throws CoreException {
        this.workingCopy = this.newExternalWorkingCopy("X.js", "public class X {\n}");
        this.assertElementDescendants("Unexpected children", "[Working copy] X.java\n  class X", (IJavaScriptElement)this.workingCopy);
    }

    public void testNewWorkingCopy03() throws CoreException {
        this.workingCopy = this.newExternalWorkingCopy("X.js", "public class X {\n}");
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected path", (String)"/ /X.js", (String)this.workingCopy.getPath().toString());
    }

    public void testNewWorkingCopy04() throws CoreException {
        this.workingCopy = this.newExternalWorkingCopy("X.js", "public class X {\n}");
        WorkingCopyOwnerTests.assertFalse((String)"Unexpected resource", (boolean)this.workingCopy.getResource().exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testNewWorkingCopy05() throws CoreException {
        this.workingCopy = this.newExternalWorkingCopy("X.js", "public class X {\n}");
        this.workingCopy.getBuffer().setContents("public class X {\n  int field;\n}");
        try {
            this.startDeltas();
            this.workingCopy.reconcile(0, false, null, null);
            this.assertDeltas("Unexpected delta", "X[*]: {CHILDREN | FINE GRAINED}\n\tfield[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    public void testNewWorkingCopy06() throws CoreException {
        this.workingCopy = this.newExternalWorkingCopy("X.js", "public class X {\n}");
        this.workingCopy.getBuffer().setContents("public class X {\n  int field;\n}");
        JavaScriptUnit ast = this.workingCopy.reconcile(3, false, null, null);
        this.assertASTNodeEquals("Unexpected AST", "public class X {\n  int field;\n}\n", (ASTNode)ast);
    }

    public void testNewWorkingCopy07() throws CoreException {
        this.workingCopy = this.newExternalWorkingCopy("X.js", "public class X {\n}");
        this.workingCopy.getBuffer().setContents("public class X {\n  int field;\n}");
        JavaScriptUnit ast = this.workingCopy.reconcile(3, true, null, null);
        TypeDeclaration type = (TypeDeclaration)ast.types().get(0);
        WorkingCopyOwnerTests.assertNull((String)"Unexpected binding", (Object)type.resolveBinding());
    }

    public void testNewWorkingCopy09() throws CoreException {
        this.workingCopy = this.newExternalWorkingCopy("X.js", "public class X {\n}");
        WorkingCopyOwnerTests.assertFalse((String)"Java project named \" \" should not exist", (boolean)this.getJavaProject(" ").exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testParseCompilationUnit1() throws CoreException {
        IJavaScriptUnit workingCopy2;
        block4: {
            IJavaScriptUnit workingCopy1 = null;
            workingCopy2 = null;
            try {
                TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
                workingCopy1 = this.getCompilationUnit("P/X.js").getWorkingCopy((WorkingCopyOwner)owner, null);
                workingCopy1.getBuffer().setContents("public class X implements I {\n}");
                workingCopy1.makeConsistent(null);
                workingCopy2 = this.getCompilationUnit("P/I.js").getWorkingCopy((WorkingCopyOwner)owner, null);
                workingCopy2.getBuffer().setContents("public interface I {\n}");
                workingCopy2.makeConsistent(null);
                ASTParser parser = ASTParser.newParser((int)2);
                parser.setSource(workingCopy1);
                parser.setResolveBindings(true);
                parser.setWorkingCopyOwner((WorkingCopyOwner)owner);
                JavaScriptUnit cu = (JavaScriptUnit)parser.createAST(null);
                List types = cu.types();
                WorkingCopyOwnerTests.assertEquals((String)"Unexpected number of types in AST", (int)1, (int)types.size());
                TypeDeclaration cfr_ignored_0 = (TypeDeclaration)types.get(0);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (workingCopy1 != null) {
                    workingCopy1.discardWorkingCopy();
                }
                if (workingCopy2 == null) throw throwable;
                workingCopy2.discardWorkingCopy();
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (workingCopy1 == null) break block4;
            }
            workingCopy1.discardWorkingCopy();
        }
        if (workingCopy2 == null) return;
        workingCopy2.discardWorkingCopy();
    }

    public void testParseCompilationUnit2() throws CoreException {
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        this.workingCopy = this.getCompilationUnit("P/Y.js").getWorkingCopy((WorkingCopyOwner)owner, null);
        this.workingCopy.getBuffer().setContents("public class Y {\n}");
        this.workingCopy.makeConsistent(null);
        char[] source = "public class Z extends Y {\n}".toCharArray();
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(source);
        parser.setUnitName("Z.js");
        parser.setProject(this.getJavaProject("P"));
        parser.setWorkingCopyOwner((WorkingCopyOwner)owner);
        parser.setResolveBindings(true);
        JavaScriptUnit cu = (JavaScriptUnit)parser.createAST(null);
        List types = cu.types();
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected number of types in AST", (int)1, (int)types.size());
        TypeDeclaration type = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = type.resolveBinding();
        WorkingCopyOwnerTests.assertNotNull((String)"No binding", (Object)typeBinding);
        WorkingCopyOwnerTests.assertEquals((String)"Unexpected super type", (String)"Y", (String)typeBinding.getSuperclass().getQualifiedName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testParseCompilationUnit3() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"}, new String[]{"JCL_LIB", "lib"});
            byte[] byArray = new byte[176];
            byArray[0] = -54;
            byArray[1] = -2;
            byArray[2] = -70;
            byArray[3] = -66;
            byArray[5] = 3;
            byArray[7] = 45;
            byArray[9] = 13;
            byArray[10] = 1;
            byArray[12] = 1;
            byArray[13] = 88;
            byArray[14] = 7;
            byArray[16] = 1;
            byArray[17] = 1;
            byArray[19] = 16;
            byArray[20] = 106;
            byArray[21] = 97;
            byArray[22] = 118;
            byArray[23] = 97;
            byArray[24] = 47;
            byArray[25] = 108;
            byArray[26] = 97;
            byArray[27] = 110;
            byArray[28] = 103;
            byArray[29] = 47;
            byArray[30] = 79;
            byArray[31] = 98;
            byArray[32] = 106;
            byArray[33] = 101;
            byArray[34] = 99;
            byArray[35] = 116;
            byArray[36] = 7;
            byArray[38] = 3;
            byArray[39] = 1;
            byArray[41] = 6;
            byArray[42] = 60;
            byArray[43] = 105;
            byArray[44] = 110;
            byArray[45] = 105;
            byArray[46] = 116;
            byArray[47] = 62;
            byArray[48] = 1;
            byArray[50] = 3;
            byArray[51] = 40;
            byArray[52] = 41;
            byArray[53] = 86;
            byArray[54] = 1;
            byArray[56] = 4;
            byArray[57] = 67;
            byArray[58] = 111;
            byArray[59] = 100;
            byArray[60] = 101;
            byArray[61] = 12;
            byArray[63] = 5;
            byArray[65] = 6;
            byArray[66] = 10;
            byArray[68] = 4;
            byArray[70] = 8;
            byArray[71] = 1;
            byArray[73] = 15;
            byArray[74] = 76;
            byArray[75] = 105;
            byArray[76] = 110;
            byArray[77] = 101;
            byArray[78] = 78;
            byArray[79] = 117;
            byArray[80] = 109;
            byArray[81] = 98;
            byArray[82] = 101;
            byArray[83] = 114;
            byArray[84] = 84;
            byArray[85] = 97;
            byArray[86] = 98;
            byArray[87] = 108;
            byArray[88] = 101;
            byArray[89] = 1;
            byArray[91] = 10;
            byArray[92] = 83;
            byArray[93] = 111;
            byArray[94] = 117;
            byArray[95] = 114;
            byArray[96] = 99;
            byArray[97] = 101;
            byArray[98] = 70;
            byArray[99] = 105;
            byArray[100] = 108;
            byArray[101] = 101;
            byArray[102] = 1;
            byArray[104] = 6;
            byArray[105] = 88;
            byArray[106] = 46;
            byArray[107] = 106;
            byArray[108] = 97;
            byArray[109] = 118;
            byArray[110] = 97;
            byArray[112] = 33;
            byArray[114] = 2;
            byArray[116] = 4;
            byArray[122] = 1;
            byArray[124] = 1;
            byArray[126] = 5;
            byArray[128] = 6;
            byArray[130] = 1;
            byArray[132] = 7;
            byArray[136] = 29;
            byArray[138] = 1;
            byArray[140] = 1;
            byArray[144] = 5;
            byArray[145] = 42;
            byArray[146] = -73;
            byArray[148] = 9;
            byArray[149] = -79;
            byArray[153] = 1;
            byArray[155] = 10;
            byArray[159] = 6;
            byArray[161] = 1;
            byArray[165] = 1;
            byArray[167] = 1;
            byArray[169] = 11;
            byArray[173] = 2;
            byArray[175] = 12;
            byte[] bytes = byArray;
            this.createFile("P1/lib/X.class", bytes);
            this.createFolder("P1/libsrc");
            this.createFile("P1/libsrc/X.js", "public class X extends Y {\n}");
            IPackageFragmentRoot lib = this.getPackageFragmentRoot("P1/lib");
            lib.attachSource((IPath)new Path("/P1/libsrc"), null, null);
            this.createFile("P1/src/Y.js", "");
            TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
            this.workingCopy = this.getCompilationUnit("P1/src/Y.js").getWorkingCopy((WorkingCopyOwner)owner, null);
            this.workingCopy.getBuffer().setContents("public class Y {\n}");
            this.workingCopy.makeConsistent(null);
            IClassFile classFile = this.getClassFile("P1/lib/X.class");
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setSource(classFile);
            parser.setResolveBindings(true);
            parser.setWorkingCopyOwner((WorkingCopyOwner)owner);
            JavaScriptUnit cu = (JavaScriptUnit)parser.createAST(null);
            List types = cu.types();
            WorkingCopyOwnerTests.assertEquals((String)"Unexpected number of types in AST", (int)1, (int)types.size());
            TypeDeclaration type = (TypeDeclaration)types.get(0);
            ITypeBinding typeBinding = type.resolveBinding();
            ITypeBinding superType = typeBinding.getSuperclass();
            WorkingCopyOwnerTests.assertEquals((String)"Unexpected super type", (String)"Y", (String)(superType == null ? "<null>" : superType.getQualifiedName()));
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.deleteProject("P1");
    }

    public void testSearch1() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("P/Y.js");
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        this.workingCopy = cu.getWorkingCopy((WorkingCopyOwner)owner, null);
        this.workingCopy.getBuffer().setContents("public class Y {\n  X field;\n}");
        this.workingCopy.makeConsistent(null);
        SearchPattern pattern = SearchPattern.createPattern((String)"X", (int)0, (int)2, (int)8);
        AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        new SearchEngine((WorkingCopyOwner)owner).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), (SearchRequestor)resultCollector, null);
        WorkingCopyOwnerTests.assertEquals((String)"Y.java Y.field [X]", (String)resultCollector.toString());
    }

    public void testSearch2() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        this.workingCopy = cu.getWorkingCopy((WorkingCopyOwner)owner, null);
        this.workingCopy.getBuffer().setContents("");
        this.workingCopy.makeConsistent(null);
        SearchPattern pattern = SearchPattern.createPattern((String)"X", (int)0, (int)0, (int)8);
        AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        new SearchEngine((WorkingCopyOwner)owner).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), (SearchRequestor)resultCollector, null);
        WorkingCopyOwnerTests.assertEquals((String)"", (String)resultCollector.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSearch3() throws CoreException {
        try {
            this.createFile("/P/Y.js", "");
            this.workingCopy = this.getCompilationUnit("P/Y.js");
            this.workingCopy.becomeWorkingCopy(null);
            this.workingCopy.getBuffer().setContents("public class Y {}");
            this.workingCopy.makeConsistent(null);
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            this.search("Y", 0, 0, SearchEngine.createWorkspaceScope(), (SearchRequestor)resultCollector);
            WorkingCopyOwnerTests.assertEquals((String)"Y.java Y [Y]", (String)resultCollector.toString());
            this.workingCopy.commitWorkingCopy(false, null);
            resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            this.search("Y", 0, 0, SearchEngine.createWorkspaceScope(), (SearchRequestor)resultCollector);
            WorkingCopyOwnerTests.assertEquals((String)"Y.java Y [Y]", (String)resultCollector.toString());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteFile("/P/Y.js");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteFile("/P/Y.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSearch4() throws CoreException {
        block4: {
            IJavaScriptUnit primaryWorkingCopy = null;
            try {
                this.createFolder("P/p");
                this.createFile("/P/p/Y.js", "");
                primaryWorkingCopy = this.getCompilationUnit("P/p/Y.js");
                primaryWorkingCopy.becomeWorkingCopy(null);
                primaryWorkingCopy.getBuffer().setContents("package p;\npublic class Y {\n}");
                primaryWorkingCopy.makeConsistent(null);
                this.workingCopy = this.getCompilationUnit("P/p/X.js").getWorkingCopy(null);
                this.workingCopy.getBuffer().setContents("package p;\npublic class X {\n}");
                this.workingCopy.makeConsistent(null);
                AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
                IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{primaryWorkingCopy.getParent()});
                SearchPattern pattern = SearchPattern.createPattern((String)"*", (int)0, (int)0, (int)10);
                new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)resultCollector, null);
                WorkingCopyOwnerTests.assertEquals((String)"p/X.java p.X [X]\np/Y.java p.Y [Y]", (String)resultCollector.toString());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (primaryWorkingCopy != null) {
                    primaryWorkingCopy.discardWorkingCopy();
                }
                this.deleteFile("/P/p/Y.js");
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (primaryWorkingCopy == null) break block4;
            }
            primaryWorkingCopy.discardWorkingCopy();
        }
        this.deleteFile("/P/p/Y.js");
    }

    public class TestWorkingCopyOwner
    extends WorkingCopyOwner {
        public String toString() {
            return "Test working copy owner";
        }
    }
}

