/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringTools {
    public static final String CR = System.getProperty("line.separator");
    public static final char QUOTE = '\"';
    public static final char OPEN_PARENTHESIS = '(';
    public static final char CLOSE_PARENTHESIS = ')';
    public static final char OPEN_BRACKET = '[';
    public static final char CLOSE_BRACKET = ']';
    public static final char OPEN_BRACE = '{';
    public static final char CLOSE_BRACE = '}';
    public static final char OPEN_CHEVRON = '<';
    public static final char CLOSE_CHEVRON = '>';
    public static final String EMPTY_STRING = "";
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Transformer<String, String> STRING_CAPITALIZER = new Transformer<String, String>(){

        @Override
        public String transform(String string) {
            return StringTools.capitalize(string);
        }
    };
    private static final Transformer<char[], char[]> CHAR_ARRAY_CAPITALIZER = new Transformer<char[], char[]>(){

        @Override
        public char[] transform(char[] string) {
            return StringTools.capitalize(string);
        }
    };
    public static final String EMPTY_JAVA_STRING_LITERAL = "\"\"";
    public static final char[] EMPTY_JAVA_STRING_LITERAL_CHAR_ARRAY = "\"\"".toCharArray();
    private static final Transformer<String, String> STRING_TO_JAVA_STRING_LITERAL_TRANSFORMER = new Transformer<String, String>(){

        @Override
        public String transform(String string) {
            return StringTools.convertToJavaStringLiteral(string);
        }
    };
    private static final Transformer<char[], char[]> CHAR_ARRAY_TO_JAVA_STRING_LITERAL_TRANSFORMER = new Transformer<char[], char[]>(){

        @Override
        public char[] transform(char[] string) {
            return StringTools.convertToJavaStringLiteral(string);
        }
    };

    public static String pad(String string, int length) {
        return StringTools.pad(string, length, ' ');
    }

    public static void padOn(String string, int length, Writer writer) {
        StringTools.padOn(string, length, ' ', writer);
    }

    public static void padOn(String string, int length, StringBuffer sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static void padOn(String string, int length, StringBuilder sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static String pad(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.pad_(string, length, c);
    }

    public static void padOn(String string, int length, char c, Writer writer) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.padOn_(string, length, c, writer);
        }
    }

    public static void padOn(String string, int length, char c, StringBuffer sb) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static void padOn(String string, int length, char c, StringBuilder sb) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static char[] pad(char[] string, int length) {
        return StringTools.pad(string, length, ' ');
    }

    public static void padOn(char[] string, int length, Writer writer) {
        StringTools.padOn(string, length, ' ', writer);
    }

    public static void padOn(char[] string, int length, StringBuffer sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static void padOn(char[] string, int length, StringBuilder sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static char[] pad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.pad_(string, length, c);
    }

    public static void padOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.padOn_(string, length, c, writer);
        }
    }

    public static void padOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static void padOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static String padOrTruncate(String string, int length) {
        return StringTools.padOrTruncate(string, length, ' ');
    }

    public static void padOrTruncateOn(String string, int length, Writer writer) {
        StringTools.padOrTruncateOn(string, length, ' ', writer);
    }

    public static void padOrTruncateOn(String string, int length, StringBuffer sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static void padOrTruncateOn(String string, int length, StringBuilder sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static String padOrTruncate(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(0, length);
        }
        return StringTools.pad_(string, length, c);
    }

    public static void padOrTruncateOn(String string, int length, char c, Writer writer) {
        int stringLength = string.length();
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string.substring(0, length), writer);
        } else {
            StringTools.padOn_(string, length, c, writer);
        }
    }

    public static void padOrTruncateOn(String string, int length, char c, StringBuffer sb) {
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string.substring(0, length));
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static void padOrTruncateOn(String string, int length, char c, StringBuilder sb) {
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string.substring(0, length));
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static char[] padOrTruncate(char[] string, int length) {
        return StringTools.padOrTruncate(string, length, ' ');
    }

    public static void padOrTruncateOn(char[] string, int length, Writer writer) {
        StringTools.padOrTruncateOn(string, length, ' ', writer);
    }

    public static void padOrTruncate(char[] string, int length, StringBuffer sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static void padOrTruncate(char[] string, int length, StringBuilder sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static char[] padOrTruncate(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            char[] result = new char[length];
            System.arraycopy(string, 0, result, 0, length);
            return result;
        }
        return StringTools.pad_(string, length, c);
    }

    public static void padOrTruncateOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string, 0, length, writer);
        } else {
            StringTools.padOn_(string, length, c, writer);
        }
    }

    public static void padOrTruncateOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static void padOrTruncateOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    private static String pad_(String string, int length, char c) {
        return new String(StringTools.pad_(string.toCharArray(), length, c));
    }

    private static void padOn_(String string, int length, char c, Writer writer) {
        StringTools.writeStringOn(string, writer);
        StringTools.fill_(string, length, c, writer);
    }

    private static void fill_(String string, int length, char c, Writer writer) {
        StringTools.fill_(string.length(), length, c, writer);
    }

    private static void fill_(char[] string, int length, char c, Writer writer) {
        StringTools.fill_(string.length, length, c, writer);
    }

    private static void fill_(int stringLength, int length, char c, Writer writer) {
        StringTools.writeStringOn(ArrayTools.fill(new char[length - stringLength], c), writer);
    }

    private static void padOn_(String string, int length, char c, StringBuffer sb) {
        sb.append(string);
        StringTools.fill_(string, length, c, sb);
    }

    private static void fill_(String string, int length, char c, StringBuffer sb) {
        StringTools.fill_(string.length(), length, c, sb);
    }

    private static void fill_(char[] string, int length, char c, StringBuffer sb) {
        StringTools.fill_(string.length, length, c, sb);
    }

    private static void fill_(int stringLength, int length, char c, StringBuffer sb) {
        sb.append(ArrayTools.fill(new char[length - stringLength], c));
    }

    private static void padOn_(String string, int length, char c, StringBuilder sb) {
        sb.append(string);
        StringTools.fill_(string, length, c, sb);
    }

    private static void fill_(String string, int length, char c, StringBuilder sb) {
        StringTools.fill_(string.length(), length, c, sb);
    }

    private static void fill_(char[] string, int length, char c, StringBuilder sb) {
        StringTools.fill_(string.length, length, c, sb);
    }

    private static void fill_(int stringLength, int length, char c, StringBuilder sb) {
        sb.append(ArrayTools.fill(new char[length - stringLength], c));
    }

    private static char[] pad_(char[] string, int length, char c) {
        char[] result = new char[length];
        int stringLength = string.length;
        System.arraycopy(string, 0, result, 0, stringLength);
        Arrays.fill(result, stringLength, length, c);
        return result;
    }

    private static void padOn_(char[] string, int length, char c, Writer writer) {
        StringTools.writeStringOn(string, writer);
        StringTools.fill_(string, length, c, writer);
    }

    private static void padOn_(char[] string, int length, char c, StringBuffer sb) {
        sb.append(string);
        StringTools.fill_(string, length, c, sb);
    }

    private static void padOn_(char[] string, int length, char c, StringBuilder sb) {
        sb.append(string);
        StringTools.fill_(string, length, c, sb);
    }

    public static String zeroPad(String string, int length) {
        return StringTools.frontPad(string, length, '0');
    }

    public static void zeroPadOn(String string, int length, Writer writer) {
        StringTools.frontPadOn(string, length, '0', writer);
    }

    public static void zeroPadOn(String string, int length, StringBuffer sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static void zeroPadOn(String string, int length, StringBuilder sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static String frontPad(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.frontPad_(string, length, c);
    }

    public static void frontPadOn(String string, int length, char c, Writer writer) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.frontPadOn_(string, length, c, writer);
        }
    }

    public static void frontPadOn(String string, int length, char c, StringBuffer sb) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static void frontPadOn(String string, int length, char c, StringBuilder sb) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static char[] zeroPad(char[] string, int length) {
        return StringTools.frontPad(string, length, '0');
    }

    public static void zeroPadOn(char[] string, int length, Writer writer) {
        StringTools.frontPadOn(string, length, '0', writer);
    }

    public static void zeroPadOn(char[] string, int length, StringBuffer sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static void zeroPadOn(char[] string, int length, StringBuilder sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static char[] frontPad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.frontPad_(string, length, c);
    }

    public static void frontPadOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.frontPadOn_(string, length, c, writer);
        }
    }

    public static void frontPadOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static void frontPadOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static String zeroPadOrTruncate(String string, int length) {
        return StringTools.frontPadOrTruncate(string, length, '0');
    }

    public static void zeroPadOrTruncateOn(String string, int length, Writer writer) {
        StringTools.frontPadOrTruncateOn(string, length, '0', writer);
    }

    public static void zeroPadOrTruncateOn(String string, int length, StringBuffer sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static void zeroPadOrTruncateOn(String string, int length, StringBuilder sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static String frontPadOrTruncate(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(stringLength - length);
        }
        return StringTools.frontPad_(string, length, c);
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, Writer writer) {
        int stringLength = string.length();
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string.substring(stringLength - length), writer);
        } else {
            StringTools.frontPadOn_(string, length, c, writer);
        }
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, StringBuffer sb) {
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string.substring(stringLength - length));
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, StringBuilder sb) {
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string.substring(stringLength - length));
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static char[] zeroPadOrTruncate(char[] string, int length) {
        return StringTools.frontPadOrTruncate(string, length, '0');
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, Writer writer) {
        StringTools.frontPadOrTruncateOn(string, length, '0', writer);
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, StringBuffer sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, StringBuilder sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static char[] frontPadOrTruncate(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            char[] result = new char[length];
            System.arraycopy(string, stringLength - length, result, 0, length);
            return result;
        }
        return StringTools.frontPad_(string, length, c);
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string, stringLength - length, length, writer);
        } else {
            StringTools.frontPadOn_(string, length, c, writer);
        }
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    private static String frontPad_(String string, int length, char c) {
        return new String(StringTools.frontPad_(string.toCharArray(), length, c));
    }

    private static char[] frontPad_(char[] string, int length, char c) {
        char[] result = new char[length];
        int stringLength = string.length;
        int padLength = length - stringLength;
        System.arraycopy(string, 0, result, padLength, stringLength);
        Arrays.fill(result, 0, padLength, c);
        return result;
    }

    private static void frontPadOn_(String string, int length, char c, Writer writer) {
        StringTools.fill_(string, length, c, writer);
        StringTools.writeStringOn(string, writer);
    }

    private static void frontPadOn_(char[] string, int length, char c, Writer writer) {
        StringTools.fill_(string, length, c, writer);
        StringTools.writeStringOn(string, writer);
    }

    private static void frontPadOn_(String string, int length, char c, StringBuffer sb) {
        StringTools.fill_(string, length, c, sb);
        sb.append(string);
    }

    private static void frontPadOn_(char[] string, int length, char c, StringBuffer sb) {
        StringTools.fill_(string, length, c, sb);
        sb.append(string);
    }

    private static void frontPadOn_(String string, int length, char c, StringBuilder sb) {
        StringTools.fill_(string, length, c, sb);
        sb.append(string);
    }

    private static void frontPadOn_(char[] string, int length, char c, StringBuilder sb) {
        StringTools.fill_(string, length, c, sb);
        sb.append(string);
    }

    public static String separate(String string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int len = string.length();
        return len <= segmentSize ? string : new String(StringTools.separate(string.toCharArray(), separator, segmentSize, len));
    }

    public static void separateOn(String string, char separator, int segmentSize, Writer writer) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        if (string.length() <= segmentSize) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.separateOn_(string.toCharArray(), separator, segmentSize, writer);
        }
    }

    public static void separateOn(String string, char separator, int segmentSize, StringBuffer sb) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        if (string.length() <= segmentSize) {
            sb.append(string);
        } else {
            StringTools.separateOn_(string.toCharArray(), separator, segmentSize, sb);
        }
    }

    public static void separateOn(String string, char separator, int segmentSize, StringBuilder sb) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        if (string.length() <= segmentSize) {
            sb.append(string);
        } else {
            StringTools.separateOn_(string.toCharArray(), separator, segmentSize, sb);
        }
    }

    public static char[] separate(char[] string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int len = string.length;
        return len <= segmentSize ? string : StringTools.separate(string, separator, segmentSize, len);
    }

    private static char[] separate(char[] string, char separator, int segmentSize, int len) {
        int resultLen = len + len / segmentSize;
        if (len % segmentSize == 0) {
            --resultLen;
        }
        char[] result = new char[resultLen];
        int j = 0;
        int segCount = 0;
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (segCount == segmentSize) {
                result[j++] = separator;
                segCount = 0;
            }
            ++segCount;
            result[j++] = c;
            ++n2;
        }
        return result;
    }

    public static void separateOn(char[] string, char separator, int segmentSize, Writer writer) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        if (string.length <= segmentSize) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.separateOn_(string, separator, segmentSize, writer);
        }
    }

    private static void separateOn_(char[] string, char separator, int segmentSize, Writer writer) {
        int segCount = 0;
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (segCount == segmentSize) {
                StringTools.writeCharOn(separator, writer);
                segCount = 0;
            }
            ++segCount;
            StringTools.writeCharOn(c, writer);
            ++n2;
        }
    }

    public static void separateOn(char[] string, char separator, int segmentSize, StringBuffer sb) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        if (string.length <= segmentSize) {
            sb.append(string);
        } else {
            StringTools.separateOn_(string, separator, segmentSize, sb);
        }
    }

    private static void separateOn_(char[] string, char separator, int segmentSize, StringBuffer sb) {
        int segCount = 0;
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (segCount == segmentSize) {
                sb.append(separator);
                segCount = 0;
            }
            ++segCount;
            sb.append(c);
            ++n2;
        }
    }

    public static void separateOn(char[] string, char separator, int segmentSize, StringBuilder sb) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        if (string.length <= segmentSize) {
            sb.append(string);
        } else {
            StringTools.separateOn_(string, separator, segmentSize, sb);
        }
    }

    private static void separateOn_(char[] string, char separator, int segmentSize, StringBuilder sb) {
        int segCount = 0;
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (segCount == segmentSize) {
                sb.append(separator);
                segCount = 0;
            }
            ++segCount;
            sb.append(c);
            ++n2;
        }
    }

    public static String quote(String string) {
        return StringTools.delimit(string, '\"');
    }

    public static void quoteOn(String string, Writer writer) {
        StringTools.delimitOn(string, '\"', writer);
    }

    public static void quoteOn(String string, StringBuffer sb) {
        StringTools.delimitOn(string, '\"', sb);
    }

    public static void quoteOn(String string, StringBuilder sb) {
        StringTools.delimitOn(string, '\"', sb);
    }

    public static Iterator<String> quote(Iterator<String> strings) {
        return StringTools.delimit(strings, '\"');
    }

    public static String delimit(String string, char delimiter) {
        return new String(StringTools.delimit(string.toCharArray(), delimiter));
    }

    public static void delimitOn(String string, char delimiter, Writer writer) {
        StringTools.delimitOn(string.toCharArray(), delimiter, writer);
    }

    public static void delimitOn(String string, char delimiter, StringBuffer sb) {
        StringTools.delimitOn(string.toCharArray(), delimiter, sb);
    }

    public static void delimitOn(String string, char delimiter, StringBuilder sb) {
        StringTools.delimitOn(string.toCharArray(), delimiter, sb);
    }

    public static Iterable<String> delimit(Iterable<String> strings, char delimiter) {
        return new TransformationIterable<String, String>(strings, new CharStringDelimiter(delimiter));
    }

    public static Iterator<String> delimit(Iterator<String> strings, char delimiter) {
        return new TransformationIterator<String, String>(strings, new CharStringDelimiter(delimiter));
    }

    public static String delimit(String string, String delimiter) {
        if (delimiter.length() == 1) {
            return StringTools.delimit(string, delimiter.charAt(0));
        }
        return new String(StringTools.delimit(string.toCharArray(), delimiter.toCharArray()));
    }

    public static void delimitOn(String string, String delimiter, Writer writer) {
        if (delimiter.length() == 1) {
            StringTools.delimitOn(string, delimiter.charAt(0), writer);
        } else {
            StringTools.delimitOn(string.toCharArray(), delimiter.toCharArray(), writer);
        }
    }

    public static void delimitOn(String string, String delimiter, StringBuffer sb) {
        if (delimiter.length() == 1) {
            StringTools.delimitOn(string, delimiter.charAt(0), sb);
        } else {
            StringTools.delimitOn(string.toCharArray(), delimiter.toCharArray(), sb);
        }
    }

    public static void delimitOn(String string, String delimiter, StringBuilder sb) {
        if (delimiter.length() == 1) {
            StringTools.delimitOn(string, delimiter.charAt(0), sb);
        } else {
            StringTools.delimitOn(string.toCharArray(), delimiter.toCharArray(), sb);
        }
    }

    public static Iterable<String> delimit(Iterable<String> strings, String delimiter) {
        return delimiter.length() == 1 ? StringTools.delimit(strings, delimiter.charAt(0)) : new TransformationIterable<String, String>(strings, new StringStringDelimiter(delimiter));
    }

    public static Iterator<String> delimit(Iterator<String> strings, String delimiter) {
        return delimiter.length() == 1 ? StringTools.delimit(strings, delimiter.charAt(0)) : new TransformationIterator<String, String>(strings, new StringStringDelimiter(delimiter));
    }

    public static char[] quote(char[] string) {
        return StringTools.delimit(string, '\"');
    }

    public static void quoteOn(char[] string, Writer writer) {
        StringTools.delimitOn(string, '\"', writer);
    }

    public static void quoteOn(char[] string, StringBuffer sb) {
        StringTools.delimitOn(string, '\"', sb);
    }

    public static void quoteOn(char[] string, StringBuilder sb) {
        StringTools.delimitOn(string, '\"', sb);
    }

    public static Iterator<char[]> quoteCharArrays(Iterator<char[]> strings) {
        return StringTools.delimitCharArrays(strings, '\"');
    }

    public static char[] delimit(char[] string, char delimiter) {
        StringBuilder sb = new StringBuilder(string.length + 2);
        StringTools.delimitOn(string, delimiter, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void delimitOn(char[] string, char delimiter, Writer writer) {
        StringTools.writeCharOn(delimiter, writer);
        StringTools.writeStringOn(string, delimiter, writer);
        StringTools.writeCharOn(delimiter, writer);
    }

    public static void delimitOn(char[] string, char delimiter, StringBuffer sb) {
        sb.append(delimiter);
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == delimiter) {
                sb.append(c);
            }
            sb.append(c);
            ++n2;
        }
        sb.append(delimiter);
    }

    public static void delimitOn(char[] string, char delimiter, StringBuilder sb) {
        sb.append(delimiter);
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == delimiter) {
                sb.append(c);
            }
            sb.append(c);
            ++n2;
        }
        sb.append(delimiter);
    }

    public static Iterable<char[]> delimitCharArrays(Iterable<char[]> strings, char delimiter) {
        return new TransformationIterable<char[], char[]>(strings, new CharCharArrayDelimiter(delimiter));
    }

    public static Iterator<char[]> delimitCharArrays(Iterator<char[]> strings, char delimiter) {
        return new TransformationIterator<char[], char[]>(strings, new CharCharArrayDelimiter(delimiter));
    }

    public static char[] delimit(char[] string, char[] delimiter) {
        int delimiterLength = delimiter.length;
        if (delimiterLength == 1) {
            return StringTools.delimit(string, delimiter[0]);
        }
        int stringLength = string.length;
        char[] result = new char[stringLength + 2 * delimiterLength];
        System.arraycopy(delimiter, 0, result, 0, delimiterLength);
        System.arraycopy(string, 0, result, delimiterLength, stringLength);
        System.arraycopy(delimiter, 0, result, stringLength + delimiterLength, delimiterLength);
        return result;
    }

    public static void delimitOn(char[] string, char[] delimiter, Writer writer) {
        if (delimiter.length == 1) {
            StringTools.delimitOn(string, delimiter[0], writer);
        } else {
            StringTools.writeStringOn(delimiter, writer);
            StringTools.writeStringOn(string, writer);
            StringTools.writeStringOn(delimiter, writer);
        }
    }

    public static void delimitOn(char[] string, char[] delimiter, StringBuffer sb) {
        if (delimiter.length == 1) {
            StringTools.delimitOn(string, delimiter[0], sb);
        } else {
            sb.append(delimiter);
            sb.append(string);
            sb.append(delimiter);
        }
    }

    public static void delimitOn(char[] string, char[] delimiter, StringBuilder sb) {
        if (delimiter.length == 1) {
            StringTools.delimitOn(string, delimiter[0], sb);
        } else {
            sb.append(delimiter);
            sb.append(string);
            sb.append(delimiter);
        }
    }

    public static Iterable<char[]> delimitCharArrays(Iterable<char[]> strings, char[] delimiter) {
        return new TransformationIterable<char[], char[]>(strings, new CharArrayCharArrayDelimiter(delimiter));
    }

    public static Iterator<char[]> delimitCharArrays(Iterator<char[]> strings, char[] delimiter) {
        return new TransformationIterator<char[], char[]>(strings, new CharArrayCharArrayDelimiter(delimiter));
    }

    public static boolean stringIsQuoted(String string) {
        return StringTools.stringIsDelimited(string, '\"');
    }

    public static boolean stringIsParenthetical(String string) {
        return StringTools.stringIsDelimited(string, '(', ')');
    }

    public static boolean stringIsBracketed(String string) {
        return StringTools.stringIsDelimited(string, '[', ']');
    }

    public static boolean stringIsBraced(String string) {
        return StringTools.stringIsDelimited(string, '{', '}');
    }

    public static boolean stringIsChevroned(String string) {
        return StringTools.stringIsDelimited(string, '<', '>');
    }

    public static boolean stringIsDelimited(String string, char c) {
        return StringTools.stringIsDelimited(string, c, c);
    }

    public static boolean stringIsDelimited(String string, char start, char end) {
        int len = string.length();
        if (len < 2) {
            return false;
        }
        return StringTools.stringIsDelimited(string.toCharArray(), start, end, len);
    }

    public static boolean stringIsQuoted(char[] string) {
        return StringTools.stringIsDelimited(string, '\"');
    }

    public static boolean stringIsParenthetical(char[] string) {
        return StringTools.stringIsDelimited(string, '(', ')');
    }

    public static boolean stringIsBracketed(char[] string) {
        return StringTools.stringIsDelimited(string, '[', ']');
    }

    public static boolean stringIsBraced(char[] string) {
        return StringTools.stringIsDelimited(string, '{', '}');
    }

    public static boolean stringIsChevroned(char[] string) {
        return StringTools.stringIsDelimited(string, '<', '>');
    }

    public static boolean stringIsDelimited(char[] string, char c) {
        return StringTools.stringIsDelimited(string, c, c);
    }

    public static boolean stringIsDelimited(char[] string, char start, char end) {
        int len = string.length;
        if (len < 2) {
            return false;
        }
        return StringTools.stringIsDelimited(string, start, end, len);
    }

    private static boolean stringIsDelimited(char[] s, char start, char end, int len) {
        return s[0] == start && s[len - 1] == end;
    }

    public static String undelimit(String string) {
        int len = string.length() - 2;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (len == 0) {
            return EMPTY_STRING;
        }
        return new String(StringTools.undelimit_(string.toCharArray(), len));
    }

    public static String undelimit(String string, int count) {
        int len = string.length() - 2 * count;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (len == 0) {
            return EMPTY_STRING;
        }
        return new String(StringTools.undelimit(string.toCharArray(), len, count));
    }

    public static char[] undelimit(char[] string) {
        int len = string.length - 2;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (len == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        return StringTools.undelimit_(string, len);
    }

    private static char[] undelimit_(char[] string, int length) {
        StringBuilder sb = new StringBuilder(length);
        StringTools.undelimitOn_(string, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static char[] undelimit(char[] string, int count) {
        int len = string.length - 2 * count;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (len == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        return StringTools.undelimit(string, len, count);
    }

    private static char[] undelimit(char[] string, int len, int count) {
        char[] result = new char[len];
        System.arraycopy(string, count, result, 0, len);
        return result;
    }

    public static void undelimitOn(String string, Writer writer) {
        StringTools.undelimitOn(string.toCharArray(), writer);
    }

    public static void undelimitOn(String string, int count, Writer writer) {
        int len = string.length() - 2 * count;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (len == 0) {
            return;
        }
        StringTools.writeStringOn(string, count, len, writer);
    }

    public static void undelimitOn(String string, StringBuffer sb) {
        StringTools.undelimitOn(string.toCharArray(), sb);
    }

    public static void undelimitOn(String string, int count, StringBuffer sb) {
        int len = string.length() - 2 * count;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (len == 0) {
            return;
        }
        sb.append(string, count, count + len);
    }

    public static void undelimitOn(String string, StringBuilder sb) {
        StringTools.undelimitOn(string.toCharArray(), sb);
    }

    public static void undelimitOn(String string, int count, StringBuilder sb) {
        int len = string.length() - 2 * count;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (len == 0) {
            return;
        }
        sb.append(string, count, count + len);
    }

    public static void undelimitOn(char[] string, Writer writer) {
        int len = string.length - 2;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (len == 0) {
            return;
        }
        StringTools.undelimitOn_(string, writer);
    }

    private static void undelimitOn_(char[] string, Writer writer) {
        char delimiter = string[0];
        char c = string[0];
        char next = string[1];
        int i = 1;
        int last = string.length - 1;
        do {
            c = next;
            StringTools.writeCharOn(c, writer);
            next = string[++i];
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string[++i];
        } while (i != last);
    }

    public static void undelimitOn(char[] string, int count, Writer writer) {
        int len = string.length - 2 * count;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (len == 0) {
            return;
        }
        StringTools.writeStringOn(string, count, len, writer);
    }

    public static void undelimitOn(char[] string, StringBuffer sb) {
        int len = string.length - 2;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (len == 0) {
            return;
        }
        StringTools.undelimitOn_(string, sb);
    }

    private static void undelimitOn_(char[] string, StringBuffer sb) {
        char delimiter = string[0];
        char c = string[0];
        char next = string[1];
        int i = 1;
        int last = string.length - 1;
        do {
            c = next;
            sb.append(c);
            next = string[++i];
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string[++i];
        } while (i != last);
    }

    public static void undelimitOn(char[] string, int count, StringBuffer sb) {
        int len = string.length - 2 * count;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (len == 0) {
            return;
        }
        sb.append(string, count, len);
    }

    public static void undelimitOn(char[] string, StringBuilder sb) {
        int len = string.length - 2;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (len == 0) {
            return;
        }
        StringTools.undelimitOn_(string, sb);
    }

    private static void undelimitOn_(char[] string, StringBuilder sb) {
        char delimiter = string[0];
        char c = string[0];
        char next = string[1];
        int i = 1;
        int last = string.length - 1;
        do {
            c = next;
            sb.append(c);
            next = string[++i];
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string[++i];
        } while (i != last);
    }

    public static void undelimitOn(char[] string, int count, StringBuilder sb) {
        int len = string.length - 2 * count;
        if (len < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (len == 0) {
            return;
        }
        sb.append(string, count, len);
    }

    public static String removeFirstOccurrence(String string, char c) {
        int index = string.indexOf(c);
        if (index == -1) {
            return string;
        }
        if (index == 0) {
            return string.substring(1);
        }
        int last = string.length() - 1;
        if (index == last) {
            return string.substring(0, last);
        }
        return string.substring(0, index).concat(string.substring(index + 1));
    }

    public static void removeFirstOccurrenceOn(String string, char c, Writer writer) {
        int index = string.indexOf(c);
        if (index == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeCharAtIndexOn(string.toCharArray(), index, writer);
        }
    }

    public static void removeFirstOccurrenceOn(String string, char c, StringBuffer sb) {
        int index = string.indexOf(c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringTools.removeCharAtIndexOn(string.toCharArray(), index, sb);
        }
    }

    public static void removeFirstOccurrenceOn(String string, char c, StringBuilder sb) {
        int index = string.indexOf(c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringTools.removeCharAtIndexOn(string.toCharArray(), index, sb);
        }
    }

    public static char[] removeFirstOccurrence(char[] string, char c) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            return string;
        }
        int last = string.length - 1;
        char[] result = new char[last];
        if (index == 0) {
            System.arraycopy(string, 1, result, 0, last);
        } else if (index == last) {
            System.arraycopy(string, 0, result, 0, last);
        } else {
            System.arraycopy(string, 0, result, 0, index);
            System.arraycopy(string, index + 1, result, index, last - index);
        }
        return result;
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, Writer writer) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeCharAtIndexOn(string, index, writer);
        }
    }

    private static void removeCharAtIndexOn(char[] string, int index, Writer writer) {
        int last = string.length - 1;
        if (index == 0) {
            StringTools.writeStringOn(string, 1, last, writer);
        } else if (index == last) {
            StringTools.writeStringOn(string, 0, last, writer);
        } else {
            StringTools.writeStringOn(string, 0, index, writer);
            StringTools.writeStringOn(string, index + 1, last - index, writer);
        }
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, StringBuffer sb) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringTools.removeCharAtIndexOn(string, index, sb);
        }
    }

    private static void removeCharAtIndexOn(char[] string, int index, StringBuffer sb) {
        int last = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, last);
        } else if (index == last) {
            sb.append(string, 0, last);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, last - index);
        }
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, StringBuilder sb) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringTools.removeCharAtIndexOn(string, index, sb);
        }
    }

    private static void removeCharAtIndexOn(char[] string, int index, StringBuilder sb) {
        int last = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, last);
        } else if (index == last) {
            sb.append(string, 0, last);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, last - index);
        }
    }

    public static String removeAllOccurrences(String string, char c) {
        int first = string.indexOf(c);
        return first == -1 ? string : new String(StringTools.removeAllOccurrences_(string.toCharArray(), c, first));
    }

    public static void removeAllOccurrencesOn(String string, char c, Writer writer) {
        int first = string.indexOf(c);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeAllOccurrencesOn_(string.toCharArray(), c, first, writer);
        }
    }

    public static void removeAllOccurrencesOn(String string, char c, StringBuffer sb) {
        int first = string.indexOf(c);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllOccurrencesOn_(string.toCharArray(), c, first, sb);
        }
    }

    public static void removeAllOccurrencesOn(String string, char c, StringBuilder sb) {
        int first = string.indexOf(c);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllOccurrencesOn_(string.toCharArray(), c, first, sb);
        }
    }

    public static char[] removeAllOccurrences(char[] string, char c) {
        int first = ArrayTools.indexOf(string, c);
        return first == -1 ? string : StringTools.removeAllOccurrences_(string, c, first);
    }

    private static char[] removeAllOccurrences_(char[] string, char c, int first) {
        StringBuilder sb = new StringBuilder(string.length);
        StringTools.removeAllOccurrencesOn_(string, c, first, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void removeAllOccurrencesOn(char[] string, char c, Writer writer) {
        int first = ArrayTools.indexOf(string, c);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeAllOccurrencesOn_(string, c, first, writer);
        }
    }

    private static void removeAllOccurrencesOn_(char[] string, char c, int first, Writer writer) {
        StringTools.writeStringOn(string, 0, first, writer);
        int len = string.length;
        int i = first;
        while (i < len) {
            char d = string[i];
            if (d != c) {
                StringTools.writeCharOn(d, writer);
            }
            ++i;
        }
    }

    public static void removeAllOccurrencesOn(char[] string, char c, StringBuffer sb) {
        int first = ArrayTools.indexOf(string, c);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllOccurrencesOn_(string, c, first, sb);
        }
    }

    private static void removeAllOccurrencesOn_(char[] string, char c, int first, StringBuffer sb) {
        sb.append(string, 0, first);
        int len = string.length;
        int i = first;
        while (i < len) {
            char d = string[i];
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static void removeAllOccurrencesOn(char[] string, char c, StringBuilder sb) {
        int first = ArrayTools.indexOf(string, c);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllOccurrencesOn_(string, c, first, sb);
        }
    }

    private static void removeAllOccurrencesOn_(char[] string, char c, int first, StringBuilder sb) {
        sb.append(string, 0, first);
        int len = string.length;
        int i = first;
        while (i < len) {
            char d = string[i];
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static String removeAllSpaces(String string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static void removeAllSpacesOn(String string, Writer writer) {
        StringTools.removeAllOccurrencesOn(string, ' ', writer);
    }

    public static void removeAllSpacesOn(String string, StringBuffer sb) {
        StringTools.removeAllOccurrencesOn(string, ' ', sb);
    }

    public static void removeAllSpacesOn(String string, StringBuilder sb) {
        StringTools.removeAllOccurrencesOn(string, ' ', sb);
    }

    public static char[] removeAllSpaces(char[] string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static void removeAllSpacesOn(char[] string, Writer writer) {
        StringTools.removeAllOccurrencesOn(string, ' ', writer);
    }

    public static void removeAllSpacesOn(char[] string, StringBuffer sb) {
        StringTools.removeAllOccurrencesOn(string, ' ', sb);
    }

    public static void removeAllSpacesOn(char[] string, StringBuilder sb) {
        StringTools.removeAllOccurrencesOn(string, ' ', sb);
    }

    public static String removeAllWhitespace(String string) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        return first == -1 ? string : new String(StringTools.removeAllWhitespace_(string2, first));
    }

    public static void removeAllWhitespaceOn(String string, Writer writer) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeAllWhitespaceOn_(string2, first, writer);
        }
    }

    public static void removeAllWhitespaceOn(String string, StringBuffer sb) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllWhitespaceOn_(string2, first, sb);
        }
    }

    public static void removeAllWhitespaceOn(String string, StringBuilder sb) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllWhitespaceOn_(string2, first, sb);
        }
    }

    public static char[] removeAllWhitespace(char[] string) {
        int first = StringTools.indexOfWhitespace_(string);
        return first == -1 ? string : StringTools.removeAllWhitespace_(string, first);
    }

    private static int indexOfWhitespace_(char[] string) {
        int len = string.length;
        int i = 0;
        while (i < len) {
            if (Character.isWhitespace(string[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static char[] removeAllWhitespace_(char[] string, int first) {
        StringBuilder sb = new StringBuilder(string.length);
        StringTools.removeAllWhitespaceOn_(string, first, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void removeAllWhitespaceOn(char[] string, Writer writer) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeAllWhitespaceOn_(string, first, writer);
        }
    }

    private static void removeAllWhitespaceOn_(char[] string, int first, Writer writer) {
        StringTools.writeStringOn(string, 0, first, writer);
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                StringTools.writeCharOn(c, writer);
            }
            ++i;
        }
    }

    public static void removeAllWhitespaceOn(char[] string, StringBuffer sb) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllWhitespaceOn_(string, first, sb);
        }
    }

    private static void removeAllWhitespaceOn_(char[] string, int first, StringBuffer sb) {
        sb.append(string, 0, first);
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static void removeAllWhitespaceOn(char[] string, StringBuilder sb) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllWhitespaceOn_(string, first, sb);
        }
    }

    private static void removeAllWhitespaceOn_(char[] string, int first, StringBuilder sb) {
        sb.append(string, 0, first);
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static String compressWhitespace(String string) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        return first == -1 ? string : new String(StringTools.compressWhitespace_(string2, first));
    }

    public static void compressWhitespaceOn(String string, Writer writer) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.compressWhitespaceOn_(string2, first, writer);
        }
    }

    public static void compressWhitespaceOn(String string, StringBuffer sb) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.compressWhitespaceOn_(string2, first, sb);
        }
    }

    public static void compressWhitespaceOn(String string, StringBuilder sb) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.compressWhitespaceOn_(string2, first, sb);
        }
    }

    public static char[] compressWhitespace(char[] string) {
        int first = StringTools.indexOfWhitespace_(string);
        return first == -1 ? string : StringTools.compressWhitespace_(string, first);
    }

    private static char[] compressWhitespace_(char[] string, int first) {
        StringBuilder sb = new StringBuilder(string.length);
        StringTools.compressWhitespaceOn_(string, first, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void compressWhitespaceOn(char[] string, Writer writer) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.compressWhitespaceOn_(string, first, writer);
        }
    }

    private static void compressWhitespaceOn_(char[] string, int first, Writer writer) {
        StringTools.writeStringOn(string, 0, first, writer);
        boolean spaceWritten = false;
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (Character.isWhitespace(c)) {
                if (!spaceWritten) {
                    spaceWritten = true;
                    StringTools.writeCharOn(' ', writer);
                }
            } else {
                spaceWritten = false;
                StringTools.writeCharOn(c, writer);
            }
            ++i;
        }
    }

    public static void compressWhitespaceOn(char[] string, StringBuffer sb) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.compressWhitespaceOn_(string, first, sb);
        }
    }

    private static void compressWhitespaceOn_(char[] string, int first, StringBuffer sb) {
        sb.append(string, 0, first);
        boolean spaceWritten = false;
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (Character.isWhitespace(c)) {
                if (!spaceWritten) {
                    spaceWritten = true;
                    sb.append(' ');
                }
            } else {
                spaceWritten = false;
                sb.append(c);
            }
            ++i;
        }
    }

    public static void compressWhitespaceOn(char[] string, StringBuilder sb) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.compressWhitespaceOn_(string, first, sb);
        }
    }

    private static void compressWhitespaceOn_(char[] string, int first, StringBuilder sb) {
        sb.append(string, 0, first);
        boolean spaceWritten = false;
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (Character.isWhitespace(c)) {
                if (!spaceWritten) {
                    spaceWritten = true;
                    sb.append(' ');
                }
            } else {
                spaceWritten = false;
                sb.append(c);
            }
            ++i;
        }
    }

    public static int commonPrefixLength(String s1, String s2) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray());
    }

    public static int commonPrefixLength(char[] s1, char[] s2) {
        return StringTools.commonPrefixLength_(s1, s2, Math.min(s1.length, s2.length));
    }

    public static int commonPrefixLength(String s1, String s2, int max) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray(), max);
    }

    public static int commonPrefixLength(char[] s1, char[] s2, int max) {
        return StringTools.commonPrefixLength_(s1, s2, Math.min(max, Math.min(s1.length, s2.length)));
    }

    private static int commonPrefixLength_(char[] s1, char[] s2, int max) {
        int i = 0;
        while (i < max) {
            if (s1[i] != s2[i]) {
                return i;
            }
            ++i;
        }
        return max;
    }

    private static char[] capitalize_(char[] string) {
        string[0] = Character.toUpperCase(string[0]);
        return string;
    }

    public static char[] capitalize(char[] string) {
        if (string.length == 0 || Character.isUpperCase(string[0])) {
            return string;
        }
        return StringTools.capitalize_(string);
    }

    public static String capitalize(String string) {
        if (string.length() == 0 || Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return new String(StringTools.capitalize_(string.toCharArray()));
    }

    public static Iterable<String> capitalize(Iterable<String> strings) {
        return new TransformationIterable<String, String>(strings, STRING_CAPITALIZER);
    }

    public static Iterator<String> capitalize(Iterator<String> strings) {
        return new TransformationIterator<String, String>(strings, STRING_CAPITALIZER);
    }

    public static Iterable<char[]> capitalizeCharArrays(Iterable<char[]> strings) {
        return new TransformationIterable<char[], char[]>(strings, CHAR_ARRAY_CAPITALIZER);
    }

    public static Iterator<char[]> capitalizeCharArrays(Iterator<char[]> strings) {
        return new TransformationIterator<char[], char[]>(strings, CHAR_ARRAY_CAPITALIZER);
    }

    private static void capitalizeOn_(char[] string, StringBuffer sb) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void capitalizeOn(char[] string, StringBuffer sb) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringTools.capitalizeOn_(string, sb);
        }
    }

    public static void capitalizeOn(String string, StringBuffer sb) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringTools.capitalizeOn_(string.toCharArray(), sb);
        }
    }

    private static void capitalizeOn_(char[] string, StringBuilder sb) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void capitalizeOn(char[] string, StringBuilder sb) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringTools.capitalizeOn_(string, sb);
        }
    }

    public static void capitalizeOn(String string, StringBuilder sb) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringTools.capitalizeOn_(string.toCharArray(), sb);
        }
    }

    private static void capitalizeOn_(char[] string, Writer writer) {
        StringTools.writeCharOn(Character.toUpperCase(string[0]), writer);
        StringTools.writeStringOn(string, 1, string.length - 1, writer);
    }

    public static void capitalizeOn(char[] string, Writer writer) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOn_(string, writer);
        }
    }

    public static void capitalizeOn(String string, Writer writer) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOn_(string.toCharArray(), writer);
        }
    }

    private static char[] uncapitalize_(char[] string) {
        string[0] = Character.toLowerCase(string[0]);
        return string;
    }

    private static boolean stringNeedNotBeUncapitalized_(char[] string) {
        if (string.length == 0) {
            return true;
        }
        if (Character.isLowerCase(string[0])) {
            return true;
        }
        return string.length > 1 && Character.isUpperCase(string[1]) && Character.isUpperCase(string[0]);
    }

    public static char[] uncapitalize(char[] string) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            return string;
        }
        return StringTools.uncapitalize_(string);
    }

    private static boolean stringNeedNotBeUncapitalized_(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (Character.isLowerCase(string.charAt(0))) {
            return true;
        }
        return string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0));
    }

    public static String uncapitalize(String string) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            return string;
        }
        return new String(StringTools.uncapitalize_(string.toCharArray()));
    }

    private static void uncapitalizeOn_(char[] string, StringBuffer sb) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalizeOn(char[] string, StringBuffer sb) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOn_(string, sb);
        }
    }

    public static void uncapitalizeOn(String string, StringBuffer sb) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOn_(string.toCharArray(), sb);
        }
    }

    private static void uncapitalizeOn_(char[] string, StringBuilder sb) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalizeOn(char[] string, StringBuilder sb) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOn_(string, sb);
        }
    }

    public static void uncapitalizeOn(String string, StringBuilder sb) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOn_(string.toCharArray(), sb);
        }
    }

    private static void uncapitalizeOn_(char[] string, Writer writer) {
        StringTools.writeCharOn(Character.toLowerCase(string[0]), writer);
        StringTools.writeStringOn(string, 1, string.length - 1, writer);
    }

    public static void uncapitalizeOn(char[] string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOn_(string, writer);
        }
    }

    public static void uncapitalizeOn(String string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOn_(string.toCharArray(), writer);
        }
    }

    public static String buildToStringFor(Object o, Object additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn(o, sb);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String buildToStringFor(Object o) {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn(o, sb);
        return sb.toString();
    }

    public static void buildSimpleToStringOn(Object o, StringBuffer sb) {
        sb.append(StringTools.buildToStringClassName(o.getClass()));
        sb.append('[');
        StringTools.separateOn(StringTools.buildHashCode(o), '-', 2, sb);
        sb.append(']');
    }

    private static String buildHashCode(Object o) {
        return StringTools.zeroPad(Integer.toHexString(System.identityHashCode(o)).toUpperCase(), 8);
    }

    public static void buildSimpleToStringOn(Object o, StringBuilder sb) {
        sb.append(StringTools.buildToStringClassName(o.getClass()));
        sb.append('[');
        StringTools.separateOn(StringTools.buildHashCode(o), '-', 2, sb);
        sb.append(']');
    }

    public static String buildToStringClassName(Class<?> javaClass) {
        String simpleName = javaClass.getSimpleName();
        return simpleName.equals(EMPTY_STRING) ? StringTools.buildToStringClassName(javaClass.getSuperclass()) : simpleName;
    }

    public static <T> String append(StringBuilder sb, T[] array) {
        return StringTools.append(sb, new ArrayListIterator<T>(array));
    }

    public static <T> String append(StringBuilder sb, Iterable<T> iterable) {
        return StringTools.append(sb, iterable.iterator());
    }

    public static <T> String append(StringBuilder sb, Iterator<T> iterator) {
        sb.append('[');
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public static boolean stringIsEmpty(String string) {
        if (string == null) {
            return true;
        }
        int len = string.length();
        if (len == 0) {
            return true;
        }
        return StringTools.stringIsEmpty_(string.toCharArray(), len);
    }

    public static boolean stringIsEmpty(char[] string) {
        if (string == null) {
            return true;
        }
        int len = string.length;
        if (len == 0) {
            return true;
        }
        return StringTools.stringIsEmpty_(string, len);
    }

    private static boolean stringIsEmpty_(char[] s, int len) {
        int i = len;
        while (i-- > 0) {
            if (Character.isWhitespace(s[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringIsNotEmpty(String string) {
        return !StringTools.stringIsEmpty(string);
    }

    public static boolean stringIsNotEmpty(char[] string) {
        return !StringTools.stringIsEmpty(string);
    }

    public static boolean stringsAreEqual(String s1, String s2) {
        return Tools.valuesAreEqual(s1, s2);
    }

    public static boolean stringsAreEqual(char[] s1, char[] s2) {
        return s1 == null ? s2 == null : s2 != null && StringTools.stringsAreEqual_(s1, s2);
    }

    private static boolean stringsAreEqual_(char[] s1, char[] s2) {
        int len = s1.length;
        if (len != s2.length) {
            return false;
        }
        int i = len;
        while (i-- > 0) {
            if (s1[i] == s2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsAreEqualIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s2 != null && s1.equalsIgnoreCase(s2);
    }

    public static boolean stringsAreEqualIgnoreCase(char[] s1, char[] s2) {
        return s1 == null ? s2 == null : s2 != null && StringTools.stringsAreEqualIgnoreCase_(s1, s2);
    }

    private static boolean stringsAreEqualIgnoreCase_(char[] s1, char[] s2) {
        int len = s1.length;
        if (len != s2.length) {
            return false;
        }
        int i = len;
        while (i-- > 0) {
            if (StringTools.charactersAreEqualIgnoreCase(s1[i], s2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringStartsWithIgnoreCase(char[] string, char[] prefix) {
        int prefixLength = prefix.length;
        if (string.length < prefixLength) {
            return false;
        }
        int i = prefixLength;
        while (i-- > 0) {
            if (StringTools.charactersAreEqualIgnoreCase(string[i], prefix[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringStartsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean charactersAreEqualIgnoreCase(char c1, char c2) {
        return c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    public static boolean stringIsUppercase(String string) {
        return string.length() == 0 ? false : StringTools.stringIsUppercase_(string);
    }

    public static boolean stringIsUppercase(char[] string) {
        return string.length == 0 ? false : StringTools.stringIsUppercase_(new String(string));
    }

    private static boolean stringIsUppercase_(String string) {
        return string.equals(string.toUpperCase());
    }

    public static boolean stringIsLowercase(String string) {
        return string.length() == 0 ? false : StringTools.stringIsLowercase_(string);
    }

    public static boolean stringIsLowercase(char[] string) {
        return string.length == 0 ? false : StringTools.stringIsLowercase_(new String(string));
    }

    private static boolean stringIsLowercase_(String string) {
        return string.equals(string.toLowerCase());
    }

    public static String convertCamelCaseToAllCaps(String camelCaseString) {
        int len = camelCaseString.length();
        if (len == 0) {
            return camelCaseString;
        }
        return new String(StringTools.convertCamelCaseToAllCaps_(camelCaseString.toCharArray(), len));
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString) {
        int len = camelCaseString.length;
        if (len == 0) {
            return camelCaseString;
        }
        return StringTools.convertCamelCaseToAllCaps_(camelCaseString, len);
    }

    private static char[] convertCamelCaseToAllCaps_(char[] camelCaseString, int len) {
        StringBuilder sb = new StringBuilder(len * 2);
        StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, StringBuffer sb) {
        int len = camelCaseString.length();
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, StringBuffer sb) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, StringBuilder sb) {
        int len = camelCaseString.length();
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, StringBuilder sb) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, Writer writer) {
        int len = camelCaseString.length();
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), len, writer);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, Writer writer) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, len, writer);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                StringTools.writeCharOn('_', writer);
            }
            StringTools.writeCharOn(Character.toUpperCase(c), writer);
            prev = c;
            ++i;
        }
    }

    public static String convertCamelCaseToAllCaps(String camelCaseString, int maxLength) {
        int len = camelCaseString.length();
        if (len == 0 || maxLength == 0) {
            return camelCaseString;
        }
        return new String(StringTools.convertCamelCaseToAllCaps_(camelCaseString.toCharArray(), maxLength, len));
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString, int maxLength) {
        int len = camelCaseString.length;
        if (len == 0 || maxLength == 0) {
            return camelCaseString;
        }
        return StringTools.convertCamelCaseToAllCaps_(camelCaseString, maxLength, len);
    }

    private static char[] convertCamelCaseToAllCaps_(char[] camelCaseString, int maxLength, int len) {
        StringBuilder sb = new StringBuilder(maxLength);
        StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, maxLength, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, StringBuffer sb) {
        int len = camelCaseString.length();
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), maxLength, len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, StringBuffer sb) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, maxLength, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int maxLength, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, StringBuilder sb) {
        int len = camelCaseString.length();
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), maxLength, len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, StringBuilder sb) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, maxLength, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int maxLength, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, Writer writer) {
        int len = camelCaseString.length();
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), maxLength, len, writer);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, Writer writer) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, maxLength, len, writer);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int maxLength, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int writerLength = 0;
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                StringTools.writeCharOn('_', writer);
                if (++writerLength == maxLength) {
                    return;
                }
            }
            StringTools.writeCharOn(Character.toUpperCase(c), writer);
            if (++writerLength == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    private static boolean camelCaseWordBreak_(char prev, char c, char next) {
        if (prev == '\u0000') {
            return false;
        }
        if (Character.isLowerCase(c)) {
            return false;
        }
        if (Character.isLowerCase(prev)) {
            return true;
        }
        if (next == '\u0000') {
            return false;
        }
        return Character.isLowerCase(next);
    }

    public static String convertUnderscoresToCamelCase(String underscoreString) {
        return StringTools.convertUnderscoresToCamelCase(underscoreString, true);
    }

    public static char[] convertUnderscoresToCamelCase(char[] underscoreString) {
        return StringTools.convertUnderscoresToCamelCase(underscoreString, true);
    }

    public static String convertUnderscoresToCamelCase(String underscoreString, boolean capitalizeFirstLetter) {
        int len = underscoreString.length();
        if (len == 0) {
            return underscoreString;
        }
        return new String(StringTools.convertUnderscoresToCamelCase_(underscoreString.toCharArray(), capitalizeFirstLetter, len));
    }

    public static char[] convertUnderscoresToCamelCase(char[] underscoreString, boolean capitalizeFirstLetter) {
        int len = underscoreString.length;
        if (len == 0) {
            return underscoreString;
        }
        return StringTools.convertUnderscoresToCamelCase_(underscoreString, capitalizeFirstLetter, len);
    }

    private static char[] convertUnderscoresToCamelCase_(char[] underscoreString, boolean capitalizeFirstLetter, int len) {
        StringBuilder sb = new StringBuilder(len);
        StringTools.convertUnderscoresToCamelCaseOn_(underscoreString, capitalizeFirstLetter, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, StringBuffer sb) {
        int len = underscoreString.length();
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString.toCharArray(), capitalizeFirstLetter, len, sb);
        }
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, StringBuffer sb) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString, capitalizeFirstLetter, len, sb);
        }
    }

    private static void convertUnderscoresToCamelCaseOn_(char[] underscoreString, boolean capitalizeFirstLetter, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    sb.append(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    sb.append(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, StringBuilder sb) {
        int len = underscoreString.length();
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString.toCharArray(), capitalizeFirstLetter, len, sb);
        }
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, StringBuilder sb) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString, capitalizeFirstLetter, len, sb);
        }
    }

    private static void convertUnderscoresToCamelCaseOn_(char[] underscoreString, boolean capitalizeFirstLetter, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    sb.append(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    sb.append(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, Writer writer) {
        int len = underscoreString.length();
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString.toCharArray(), capitalizeFirstLetter, len, writer);
        }
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, Writer writer) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString, capitalizeFirstLetter, len, writer);
        }
    }

    private static void convertUnderscoresToCamelCaseOn_(char[] underscoreString, boolean capitalizeFirstLetter, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    StringTools.writeCharOn(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c), writer);
                } else {
                    StringTools.writeCharOn(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c), writer);
                }
            }
            ++i;
        }
    }

    public static String convertToJavaStringLiteral(String string) {
        int len = string.length();
        if (len == 0) {
            return EMPTY_JAVA_STRING_LITERAL;
        }
        StringBuilder sb = new StringBuilder(len + 5);
        StringTools.convertToJavaStringLiteralOn_(string.toCharArray(), sb, len);
        return sb.toString();
    }

    public static char[] convertToJavaStringLiteral(char[] string) {
        int len = string.length;
        if (len == 0) {
            return EMPTY_JAVA_STRING_LITERAL_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(len + 5);
        StringTools.convertToJavaStringLiteralOn_(string, sb, len);
        len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    public static Iterable<String> convertToJavaStringLiterals(Iterable<String> strings) {
        return new TransformationIterable<String, String>(strings, STRING_TO_JAVA_STRING_LITERAL_TRANSFORMER);
    }

    public static Iterator<String> convertToJavaStringLiterals(Iterator<String> strings) {
        return new TransformationIterator<String, String>(strings, STRING_TO_JAVA_STRING_LITERAL_TRANSFORMER);
    }

    public static Iterable<char[]> convertToJavaCharArrayLiterals(Iterable<char[]> strings) {
        return new TransformationIterable<char[], char[]>(strings, CHAR_ARRAY_TO_JAVA_STRING_LITERAL_TRANSFORMER);
    }

    public static Iterator<char[]> convertToJavaCharArrayLiterals(Iterator<char[]> strings) {
        return new TransformationIterator<char[], char[]>(strings, CHAR_ARRAY_TO_JAVA_STRING_LITERAL_TRANSFORMER);
    }

    public static void convertToJavaStringLiteralOn(String string, StringBuffer sb) {
        int len = string.length();
        if (len == 0) {
            sb.append(EMPTY_JAVA_STRING_LITERAL);
        } else {
            StringTools.convertToJavaStringLiteralOn_(string.toCharArray(), sb, len);
        }
    }

    public static void convertToJavaStringLiteralOn(char[] string, StringBuffer sb) {
        int len = string.length;
        if (len == 0) {
            sb.append(EMPTY_JAVA_STRING_LITERAL);
        } else {
            StringTools.convertToJavaStringLiteralOn_(string, sb, len);
        }
    }

    private static void convertToJavaStringLiteralOn_(char[] string, StringBuffer sb, int len) {
        sb.ensureCapacity(sb.length() + len + 5);
        sb.append('\"');
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++n2;
        }
        sb.append('\"');
    }

    public static void convertToJavaStringLiteralOn(String string, StringBuilder sb) {
        int len = string.length();
        if (len == 0) {
            sb.append(EMPTY_JAVA_STRING_LITERAL);
        } else {
            StringTools.convertToJavaStringLiteralOn_(string.toCharArray(), sb, len);
        }
    }

    public static void convertToJavaStringLiteralOn(char[] string, StringBuilder sb) {
        int len = string.length;
        if (len == 0) {
            sb.append(EMPTY_JAVA_STRING_LITERAL);
        } else {
            StringTools.convertToJavaStringLiteralOn_(string, sb, len);
        }
    }

    private static void convertToJavaStringLiteralOn_(char[] string, StringBuilder sb, int len) {
        sb.ensureCapacity(sb.length() + len + 5);
        sb.append('\"');
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++n2;
        }
        sb.append('\"');
    }

    public static void convertToJavaStringLiteralOn(String string, Writer writer) {
        if (string.length() == 0) {
            StringTools.writeStringOn(EMPTY_JAVA_STRING_LITERAL, writer);
        } else {
            StringTools.convertToJavaStringLiteralOn_(string.toCharArray(), writer);
        }
    }

    public static void convertToJavaStringLiteralOn(char[] string, Writer writer) {
        if (string.length == 0) {
            StringTools.writeStringOn(EMPTY_JAVA_STRING_LITERAL, writer);
        } else {
            StringTools.convertToJavaStringLiteralOn_(string, writer);
        }
    }

    private static void convertToJavaStringLiteralOn_(char[] string, Writer writer) {
        StringTools.writeCharOn('\"', writer);
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\b': {
                    StringTools.writeStringOn("\\b", writer);
                    break;
                }
                case '\t': {
                    StringTools.writeStringOn("\\t", writer);
                    break;
                }
                case '\n': {
                    StringTools.writeStringOn("\\n", writer);
                    break;
                }
                case '\f': {
                    StringTools.writeStringOn("\\f", writer);
                    break;
                }
                case '\r': {
                    StringTools.writeStringOn("\\r", writer);
                    break;
                }
                case '\"': {
                    StringTools.writeStringOn("\\\"", writer);
                    break;
                }
                case '\\': {
                    StringTools.writeStringOn("\\\\", writer);
                    break;
                }
                default: {
                    StringTools.writeCharOn(c, writer);
                }
            }
            ++n2;
        }
        StringTools.writeCharOn('\"', writer);
    }

    public static char[] convertToCharArray(StringBuffer sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    public static char[] convertToCharArray(StringBuilder sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    private static void writeStringOn(char[] string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(char[] string, char escape, Writer writer) {
        try {
            char[] cArray = string;
            int n = string.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == escape) {
                    writer.write(c);
                }
                writer.write(c);
                ++n2;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(char[] string, int off, int len, Writer writer) {
        try {
            writer.write(string, off, len);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(String string, int off, int len, Writer writer) {
        try {
            writer.write(string, off, len);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(String string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeCharOn(char c, Writer writer) {
        try {
            writer.write(c);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private StringTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharArrayCharArrayDelimiter
    implements Transformer<char[], char[]> {
        private char[] delimiter;

        CharArrayCharArrayDelimiter(char[] delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public char[] transform(char[] string) {
            return StringTools.delimit(string, this.delimiter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharCharArrayDelimiter
    implements Transformer<char[], char[]> {
        private char delimiter;

        CharCharArrayDelimiter(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public char[] transform(char[] string) {
            return StringTools.delimit(string, this.delimiter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharStringDelimiter
    implements Transformer<String, String> {
        private char delimiter;

        CharStringDelimiter(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public String transform(String string) {
            return StringTools.delimit(string, this.delimiter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringStringDelimiter
    implements Transformer<String, String> {
        private String delimiter;

        StringStringDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public String transform(String string) {
            return StringTools.delimit(string, this.delimiter);
        }
    }
}

