/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.PredefinedColoredAreas;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaMappedSuperclass;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IAddEntityContext;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddJPAEntityFeature
extends AbstractAddShapeFeature {
    private IPeUtilFacade facade;
    private static ContainerShape primaryShape;
    private static ContainerShape relationShape;
    private static ContainerShape basicShape;

    public AddJPAEntityFeature(IFeatureProvider fp) {
        super(fp);
        this.facade = new PeUtilFacade();
    }

    public AddJPAEntityFeature(IFeatureProvider fp, IPeUtilFacade facade) {
        super(fp);
        this.facade = facade;
    }

    public boolean canAdd(IAddContext context) {
        Object newObj = context.getNewObject();
        if (newObj instanceof JavaPersistentType) {
            if (context.getTargetContainer() instanceof Diagram) {
                JavaPersistentType jpt = (JavaPersistentType)newObj;
                return this.checkJPTForAdding(jpt);
            }
        } else if (newObj instanceof ICompilationUnit && context.getTargetContainer() instanceof Diagram) {
            ICompilationUnit cu = (ICompilationUnit)newObj;
            JavaPersistentType jpt = JPAEditorUtil.getJPType(cu);
            return this.checkJPTForAdding(jpt);
        }
        if (newObj instanceof SourceType && context.getTargetContainer() instanceof Diagram) {
            ICompilationUnit cu = ((SourceType)newObj).getCompilationUnit();
            JavaPersistentType jpt = JPAEditorUtil.getJPType(cu);
            return this.checkJPTForAdding(jpt);
        }
        return false;
    }

    private boolean checkJPTForAdding(JavaPersistentType jpt) {
        if (jpt == null) {
            return false;
        }
        PictogramElement[] pictograms = this.getFeatureProvider().getAllPictogramElementsForBusinessObject(jpt);
        JpaProject proj = ModelIntegrationUtil.getProjectByDiagram(this.getDiagram());
        if (proj != null && proj != jpt.getJpaProject()) {
            return false;
        }
        return pictograms == null || pictograms.length == 0;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public PictogramElement add(IAddContext context) {
        ICompilationUnit cu;
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        Object newObj = context.getNewObject();
        JavaPersistentType jpt = null;
        if (newObj instanceof JavaPersistentType) {
            jpt = (JavaPersistentType)newObj;
            if (jpt.getMapping() instanceof JavaMappedSuperclass) {
                jpt = this.createEntityFromExistingMappedSuperclass(fp, jpt);
            }
        } else if (newObj instanceof ICompilationUnit) {
            cu = (ICompilationUnit)newObj;
            jpt = JPAEditorUtil.getJPType(cu);
            if (jpt.getMapping() instanceof JavaMappedSuperclass) {
                jpt = this.createEntityFromExistingMappedSuperclass(fp, jpt);
            }
        } else if (newObj instanceof SourceType) {
            cu = ((SourceType)newObj).getCompilationUnit();
            jpt = JPAEditorUtil.getJPType(cu);
        }
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        ContainerShape entityShape = this.facade.createContainerShape(targetDiagram, true);
        AddJPAEntityFeature.createEntityRectangle(context, entityShape, this.getFeatureProvider().getDiagramTypeProvider().getDiagram());
        this.link((PictogramElement)entityShape, jpt);
        Shape shape = Graphiti.getPeService().createShape(entityShape, false);
        int[] nArray = new int[4];
        nArray[1] = 30;
        nArray[2] = 120;
        nArray[3] = 30;
        Polyline headerBottomLine = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)shape, nArray);
        headerBottomLine.setForeground(this.manageColor(JPAEditorConstants.ENTITY_BORDER_COLOR));
        headerBottomLine.setLineWidth(Integer.valueOf(2));
        this.addHeader(jpt, entityShape, 120);
        this.createCompartments(context, jpt, entityShape);
        this.fillCompartments(jpt, entityShape);
        String key = fp.getKeyForBusinessObject(jpt);
        if (fp.getBusinessObjectForKey(key) == null) {
            fp.putKeyToBusinessObject(key, jpt);
        }
        Graphiti.getPeService().createChopboxAnchor((AnchorContainer)entityShape);
        entityShape.setVisible(true);
        this.layoutPictogramElement((PictogramElement)entityShape);
        UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(fp);
        updateFeature.reconnect(jpt);
        return entityShape;
    }

    private JavaPersistentType createEntityFromExistingMappedSuperclass(IJPAEditorFeatureProvider fp, JavaPersistentType jpt) {
        Object obj;
        CreateContext cont = new CreateContext();
        String packageName = null;
        try {
            packageName = this.getMappedSuperclassPackageDeclaration(fp, jpt, packageName);
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError(e);
        }
        boolean hasPrimaryKey = this.hasMappedSuperclassPrimaryKeyAttribute(jpt);
        CreateJPAEntityFeature createFeature = new CreateJPAEntityFeature(fp, true, jpt.getName(), packageName, hasPrimaryKey);
        Object[] objects = createFeature.create((ICreateContext)cont);
        if (objects.length != 0 && (obj = objects[0]) instanceof JavaPersistentType) {
            jpt = (JavaPersistentType)obj;
        }
        return jpt;
    }

    private boolean hasMappedSuperclassPrimaryKeyAttribute(JavaPersistentType jpt) {
        Iterator iter = ((JavaMappedSuperclass)jpt.getMapping()).allAttributeMappings();
        while (iter.hasNext()) {
            AttributeMapping map = (AttributeMapping)iter.next();
            if (map.getPrimaryKeyColumnName() == null) continue;
            return true;
        }
        return false;
    }

    private String getMappedSuperclassPackageDeclaration(IJPAEditorFeatureProvider fp, JavaPersistentType jpt, String packageName) throws JavaModelException {
        IPackageDeclaration[] packages = fp.getCompilationUnit(jpt).getPackageDeclarations();
        if (packages.length > 0) {
            IPackageDeclaration packageDecl = packages[0];
            packageName = packageDecl.getElementName();
        }
        return packageName;
    }

    private void createCompartments(IAddContext context, JavaPersistentType jpt, ContainerShape entityShape) {
        primaryShape = this.createCompartmentRectangle(entityShape, 30, JPAEditorMessages.AddJPAEntityFeature_primaryKeysShape);
        relationShape = this.createCompartmentRectangle(entityShape, GraphicsUpdater.getNextCompartmentY(primaryShape) + 2, JPAEditorMessages.AddJPAEntityFeature_relationAttributesShapes);
        basicShape = this.createCompartmentRectangle(entityShape, GraphicsUpdater.getNextCompartmentY(relationShape) + 2, JPAEditorMessages.AddJPAEntityFeature_basicAttributesShapes);
        if (IAddEntityContext.class.isInstance(context)) {
            IAddEntityContext entityContext = (IAddEntityContext)context;
            GraphicsUpdater.setCollapsed(primaryShape, entityContext.isPrimaryCollapsed());
            GraphicsUpdater.setCollapsed(basicShape, entityContext.isBasicCollapsed());
            GraphicsUpdater.setCollapsed(relationShape, entityContext.isRelationCollapsed());
        } else {
            GraphicsUpdater.setCollapsed(primaryShape, false);
            GraphicsUpdater.setCollapsed(basicShape, false);
            GraphicsUpdater.setCollapsed(relationShape, false);
        }
    }

    private void fillCompartments(JavaPersistentType jpt, ContainerShape entityShape) {
        String[] relationAnnotations;
        String[] primaryKeyAnnotations;
        String[] stringArray = primaryKeyAnnotations = new String[]{"Id", "EmbeddedId"};
        int n = primaryKeyAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            this.addCompartmentChildren(primaryShape, jpt, annotation);
            ++n2;
        }
        String[] stringArray2 = relationAnnotations = new String[]{"ManyToMany", "ManyToOne", "OneToMany", "OneToOne"};
        int n3 = relationAnnotations.length;
        n = 0;
        while (n < n3) {
            String annotation = stringArray2[n];
            this.addCompartmentChildren(relationShape, jpt, annotation);
            ++n;
        }
        this.addBasicAttributes(basicShape, jpt);
        GraphicsUpdater.updateEntityShape(entityShape);
    }

    private ContainerShape createCompartmentRectangle(ContainerShape entityShape, int y, String attribTxt) {
        int width = entityShape.getGraphicsAlgorithm().getWidth();
        ContainerShape containerShape = Graphiti.getPeService().createContainerShape(entityShape, false);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, JPAEditorConstants.PROP_SHAPE_TYPE, JPAEditorConstants.ShapeType.COMPARTMENT.toString());
        Rectangle rect = this.addCompartmentRectangle(y, width, containerShape);
        this.addCompartmentHeaderText(attribTxt, width, rect);
        UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(this.getFeatureProvider());
        updateFeature.addSeparatorsToShape(containerShape);
        return containerShape;
    }

    private Rectangle addCompartmentRectangle(int y, int width, ContainerShape containerShape) {
        Rectangle rect = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)containerShape);
        rect.setFilled(Boolean.valueOf(false));
        rect.setLineVisible(Boolean.valueOf(false));
        rect.setHeight(0);
        rect.setWidth(width);
        rect.setX(0);
        rect.setY(y);
        containerShape.setActive(true);
        return rect;
    }

    private void addCompartmentHeaderText(String attribTxt, int width, Rectangle rect) {
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        Text text = UpdateAttributeFeature.addText(fp, rect, attribTxt);
        text.getFont().setSize(7);
        text.getFont().setItalic(true);
        text.getFont().setBold(false);
        Graphiti.getGaService().setWidth((GraphicsAlgorithm)text, width);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)text, 0, 2, width, 13);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
    }

    private void addCompartmentChildren(ContainerShape containerShape, JavaPersistentType jpt, String attributeAnnotations) {
        ArrayList<JavaPersistentAttribute> attributes = new ArrayList<JavaPersistentAttribute>();
        ListIterator attributesIterator = jpt.attributes();
        while (attributesIterator.hasNext()) {
            JavaPersistentAttribute attribute = (JavaPersistentAttribute)attributesIterator.next();
            HashSet<String> annotations = JpaArtifactFactory.instance().getAnnotationNames(attribute);
            if (!annotations.contains(attributeAnnotations)) continue;
            attributes.add(attribute);
        }
        this.addAttributes(containerShape, attributes);
    }

    private void addBasicAttributes(ContainerShape containerShape, JavaPersistentType jpt) {
        ArrayList<JavaPersistentAttribute> attributes = new ArrayList<JavaPersistentAttribute>();
        ListIterator attributesIterator = jpt.attributes();
        while (attributesIterator.hasNext()) {
            JavaPersistentAttribute attribute = (JavaPersistentAttribute)attributesIterator.next();
            HashSet<String> annotations = JpaArtifactFactory.instance().getAnnotationNames(attribute);
            if ((annotations.contains("Id") || annotations.contains("EmbeddedId") || annotations.contains("ManyToMany") || annotations.contains("ManyToOne") || annotations.contains("OneToMany") || annotations.contains("OneToOne")) && !annotations.isEmpty()) continue;
            attributes.add(attribute);
        }
        this.addAttributes(containerShape, attributes);
    }

    private void addAttributes(ContainerShape entityShape, List<JavaPersistentAttribute> attributes) {
        int i = 0;
        while (i < attributes.size()) {
            JavaPersistentAttribute jpa = attributes.get(i);
            this.addAttribute(jpa, entityShape);
            ++i;
        }
    }

    public static RoundedRectangle createEntityRectangle(IAddContext context, ContainerShape entityShape, Diagram diagram) {
        RoundedRectangle entityRectangle = Graphiti.getGaService().createRoundedRectangle((GraphicsAlgorithmContainer)entityShape, 6, 6);
        entityRectangle.setForeground(Graphiti.getGaService().manageColor(diagram, JPAEditorConstants.ENTITY_BORDER_COLOR));
        entityRectangle.setBackground(Graphiti.getGaService().manageColor(diagram, JPAEditorConstants.ENTITY_BACKGROUND));
        Graphiti.getGaService().setRenderingStyle((AbstractStyle)entityRectangle.getPictogramElement().getGraphicsAlgorithm(), PredefinedColoredAreas.getAdaptedGradientColoredAreas((String)"blue-white-gloss"));
        entityRectangle.setLineWidth(Integer.valueOf(2));
        entityRectangle.setLineStyle(LineStyle.SOLID);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)entityRectangle, context.getX(), context.getY(), context.getWidth() == -1 ? 120 : context.getWidth(), context.getHeight() == -1 ? 70 : context.getHeight());
        return entityRectangle;
    }

    private ContainerShape addHeader(JavaPersistentType addedWrapper, ContainerShape entityShape, int width) {
        ContainerShape headerIconShape = Graphiti.getPeService().createContainerShape(entityShape, false);
        Rectangle iconRect = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)headerIconShape);
        iconRect.setFilled(Boolean.valueOf(false));
        iconRect.setLineVisible(Boolean.valueOf(false));
        iconRect.setHeight(20);
        iconRect.setX(0);
        iconRect.setWidth(24);
        iconRect.setHeight(24);
        iconRect.setY(0);
        Image headerIcon = Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.entity");
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)headerIcon, 7, 7, 16, 16);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)headerIconShape, JPAEditorConstants.PROP_SHAPE_TYPE, JPAEditorConstants.ShapeType.ICON.toString());
        ContainerShape entityHeaderTextShape = Graphiti.getPeService().createContainerShape(entityShape, false);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)entityHeaderTextShape, JPAEditorConstants.PROP_SHAPE_TYPE, JPAEditorConstants.ShapeType.HEADER.toString());
        Rectangle headerRect = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)entityHeaderTextShape);
        headerRect.setFilled(Boolean.valueOf(false));
        headerRect.setLineVisible(Boolean.valueOf(false));
        headerRect.setWidth(width - 25);
        headerRect.setHeight(21);
        headerRect.setY(2);
        headerRect.setX(25);
        String headerTextString = JPAEditorUtil.getText(addedWrapper);
        ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(addedWrapper);
        JPAEditorUtil.becomeWorkingCopy(cu);
        headerTextString = JPAEditorUtil.returnSimpleName(headerTextString);
        try {
            if (cu.hasUnsavedChanges()) {
                headerTextString = "* " + headerTextString;
            }
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot check compilation unit for unsaved changes", e);
        }
        Text headerTextObj = Graphiti.getGaService().createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)headerRect, headerTextString);
        headerTextObj.setForeground(this.manageColor(JPAEditorConstants.ENTITY_TEXT_FOREGROUND));
        headerTextObj.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        headerTextObj.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
        headerTextObj.getFont().setBold(true);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)headerTextObj, 1, 2, width, 20);
        return entityHeaderTextShape;
    }

    private void addAttribute(JavaPersistentAttribute pa, ContainerShape compartmentShape) {
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        fp.putKeyToBusinessObject(fp.getKeyForBusinessObject(pa), pa);
        JavaPersistentType jpt = (JavaPersistentType)pa.getParent();
        String key = fp.getKeyForBusinessObject(jpt);
        if (fp.getBusinessObjectForKey(key) == null) {
            fp.putKeyToBusinessObject(key, jpt);
        }
        UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(fp);
        updateFeature.addAttributes(compartmentShape.getContainer(), pa);
        updateFeature = null;
    }

    public static interface IPeUtilFacade {
        public ContainerShape createContainerShape(Diagram var1, boolean var2);
    }

    private static class PeUtilFacade
    implements IPeUtilFacade {
        private PeUtilFacade() {
        }

        public ContainerShape createContainerShape(Diagram diagram, boolean b) {
            return Graphiti.getPeService().createContainerShape((ContainerShape)diagram, true);
        }
    }
}

