/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RenameEntityWithoutUIFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class DirectEditJPAEntityFeature
extends AbstractDirectEditingFeature {
    private static String allowed = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_";

    public DirectEditJPAEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        return true;
    }

    public String getInitialValue(IDirectEditingContext context) {
        Shape sh = (Shape)context.getPictogramElement();
        ContainerShape csh = sh.getContainer();
        JavaPersistentType jpt = (JavaPersistentType)this.getBusinessObjectForPictogramElement((PictogramElement)csh);
        return JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(jpt));
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        ContainerShape csh = ((Shape)pe).getContainer();
        JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)csh);
        String packageName = Signature.getQualifier((String)jpt.getName());
        PersistenceUnit unit = jpt.getPersistenceUnit();
        Iterator classRefs = unit.classRefs();
        while (classRefs.hasNext()) {
            ClassRef classRef = (ClassRef)classRefs.next();
            if (!classRef.getClassName().equals(String.valueOf(packageName) + '.' + value) || JPAEditorUtil.getText(jpt).equals(value)) continue;
            return MessageFormat.format(JPAEditorMessages.DirectEditJPAEntityFeature_duplicateEntityName, String.valueOf(packageName) + value);
        }
        if (value.length() < 1) {
            return JPAEditorMessages.DirectEditJPAEntityFeature_classNameMsg;
        }
        if (value.contains(" ")) {
            return JPAEditorMessages.DirectEditJPAEntityFeature_scpacesNotAllowedMsg;
        }
        if (value.contains("\n")) {
            return JPAEditorMessages.DirectEditJPAEntityFeature_lineBreaksNotAllowedMsg;
        }
        if (value.contains("{") || value.contains("}")) {
            return JPAEditorMessages.DirectEditJPAEntityFeature_bracesNotAllowedMsg;
        }
        int i = 0;
        while (i < value.length()) {
            if (allowed.indexOf(value.charAt(i)) < 0) {
                return MessageFormat.format(JPAEditorMessages.DirectEditJPAEntityFeature_invalidSymbolsMsg, value);
            }
            ++i;
        }
        return null;
    }

    public void setValue(final String value, IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        ContainerShape csh = ((Shape)pe).getContainer();
        JavaPersistentType jpt = (JavaPersistentType)this.getBusinessObjectForPictogramElement((PictogramElement)csh);
        Properties props = JPADiagramPropertyPage.loadProperties(jpt.getJpaProject().getProject());
        String specifiedEntityMappingName = JpaArtifactFactory.instance().getSpecifiedEntityName(jpt);
        if (specifiedEntityMappingName == null) {
            RenameEntityWithoutUIFeature ft = new RenameEntityWithoutUIFeature(this.getFeatureProvider(), value);
            ft.execute(jpt);
            return;
        }
        JpaArtifactFactory.instance().renameEntity(jpt, value);
        if (JPADiagramPropertyPage.doesDirecteEditingAffectClassNameByDefault(jpt.getJpaProject().getProject(), props)) {
            RenameEntityWithoutUIFeature ft = new RenameEntityWithoutUIFeature(this.getFeatureProvider(), value);
            ft.execute(jpt);
            return;
        }
        final GraphicsAlgorithm alg = (GraphicsAlgorithm)pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)alg);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                ((Text)alg).setValue(value);
            }
        });
        Set<JavaPersistentAttribute> ats = JpaArtifactFactory.instance().getRelatedAttributes(jpt);
        for (JavaPersistentAttribute at : ats) {
            PictogramElement pel = this.getFeatureProvider().getPictogramElementForBusinessObject(at);
            String newAtName = JPAEditorUtil.decapitalizeFirstLetter(value);
            if (JpaArtifactFactory.instance().isMethodAnnotated(at)) {
                newAtName = JPAEditorUtil.produceValidAttributeName(newAtName);
            }
            newAtName = JpaArtifactFactory.instance().renameAttribute(at, newAtName, jpt.getName(), this.getFeatureProvider()).getName();
            final GraphicsAlgorithm algo = (GraphicsAlgorithm)pel.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            final String attName = newAtName;
            TransactionalEditingDomain tedit = TransactionUtil.getEditingDomain((EObject)algo);
            tedit.getCommandStack().execute((Command)new RecordingCommand(tedit){

                protected void doExecute() {
                    ((Text)algo).setValue(attName);
                }
            });
        }
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }
}

