/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.AbstractRelation;

public class RemoveRelationFeature
extends AbstractFeature
implements IRemoveFeature {
    private static final String NAME = Messages.DefaultRemoveFeature_0_xfld;

    public RemoveRelationFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canRemove(IRemoveContext context) {
        return true;
    }

    public boolean canExecute(IContext context) {
        return true;
    }

    public void preRemove(IRemoveContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractRelation) {
            AbstractRelation rel = (AbstractRelation)bo;
            this.getFeatureProvider().remove(rel.getId());
        }
    }

    public final void remove(final IRemoveContext context) {
        if (!this.getUserDecision()) {
            return;
        }
        this.preRemove(context);
        final PictogramElement pe = context.getPictogramElement();
        if (pe == null) {
            return;
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pe);
        RecordingCommand rc = new RecordingCommand(ted){

            protected void doExecute() {
                if (pe instanceof Shape) {
                    Shape shape = (Shape)pe;
                    RemoveRelationFeature.this.removeAllConnections(shape);
                }
                Graphiti.getPeService().deletePictogramElement(pe);
                RemoveRelationFeature.this.postRemove(context);
            }
        };
        ted.getCommandStack().execute((Command)rc);
    }

    protected void removeAllConnections(Shape shape) {
        IJPAEditorFeatureProvider featureProvider = this.getFeatureProvider();
        for (Anchor anchor : shape.getAnchors()) {
            for (Connection connection : Graphiti.getPeService().getAllConnections(anchor)) {
                ConnectionDecorator[] decorators;
                RemoveContext rc;
                IRemoveFeature removeFeature;
                if (connection.eResource() == null || (removeFeature = featureProvider.getRemoveFeature((IRemoveContext)(rc = new RemoveContext((PictogramElement)connection)))) == null) continue;
                ConnectionDecorator[] connectionDecoratorArray = decorators = (ConnectionDecorator[])connection.getConnectionDecorators().toArray((Object[])new ConnectionDecorator[0]);
                int n = decorators.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionDecorator decorator = connectionDecoratorArray[n2];
                    if (decorator != null && decorator.eResource() != null) {
                        EcoreUtil.delete((EObject)decorator, (boolean)true);
                    }
                    ++n2;
                }
                removeFeature.remove((IRemoveContext)rc);
            }
        }
    }

    public void postRemove(IRemoveContext context) {
    }

    public String getName() {
        return NAME;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void execute(IContext context) {
        if (context instanceof IRemoveContext) {
            this.remove((IRemoveContext)context);
        }
    }
}

