/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.WeakHashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorDiagramTypeProvider;

public class ModelIntegrationUtil {
    public static final String DIAGRAM_FILE_EXTENSION = "xmi";
    public static final String DIAGRAM_XML_FILE_EXTENSION = "xml";
    public static final String JPA_DIAGRAM_TYPE = "JPA Diagram";
    public static final String DEFAULT_RES_FOLDER = "src";
    private static WeakHashMap<Diagram, WeakReference<JpaProject>> diagramsToProjects = new WeakHashMap();
    private static WeakHashMap<Diagram, WeakReference<JPAEditorDiagramTypeProvider>> diagramsToProviders = new WeakHashMap();
    private static HashMap<Diagram, Resource> diagramsToResources = new HashMap();
    private static boolean xmiExists = false;

    public static IPath createDiagramPath(PersistenceUnit persistenceUnit) throws CoreException {
        IProject project = persistenceUnit.getJpaProject().getProject();
        String diagramName = persistenceUnit.getName();
        IPath newXMIFilePath = ModelIntegrationUtil.getDiagramsFolderPath(project).append(diagramName).addFileExtension(DIAGRAM_FILE_EXTENSION);
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        IFileStore newXMIFile = fileSystem.getStore(newXMIFilePath);
        IPath folderPath = ModelIntegrationUtil.copyExistingXMIContentAndDeleteFile(project, diagramName, newXMIFile);
        if (folderPath != null) {
            Path path = new Path(folderPath.segment(0));
            int i = 1;
            while (i < folderPath.segmentCount()) {
                path = path.append(folderPath.segment(i));
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                ++i;
            }
            IFile diagramXMLFile = ResourcesPlugin.getWorkspace().getRoot().getFile(folderPath.append(diagramName).addFileExtension(DIAGRAM_XML_FILE_EXTENSION));
            String content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<entities>\n</entities>\n";
            if (diagramXMLFile == null || !diagramXMLFile.exists()) {
                ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
                diagramXMLFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                try {
                    if (diagramXMLFile.getContents().read() == -1) {
                        diagramXMLFile.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), true, false, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (IOException e) {
                    JPADiagramEditorPlugin.logError(JPAEditorMessages.ModelIntegrationUtil_CannotSetFileContentErrorMSG, e);
                }
            }
        }
        return newXMIFilePath;
    }

    private static IPath copyExistingXMIContent(IContainer container, String xmiFileName, IFileStore newXMIFile) throws JavaModelException, CoreException {
        IResource[] resources;
        IPath folderPath = null;
        IResource[] iResourceArray = resources = container.members();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFolder) {
                folderPath = ((IFolder)res).getFullPath();
                IFile existingXMIFile = ((IFolder)res).getFile(xmiFileName);
                if (existingXMIFile != null && existingXMIFile.exists()) {
                    IFileStore folder = EFS.getLocalFileSystem().getStore(existingXMIFile.getLocationURI());
                    folder.copy(newXMIFile, 2, null);
                    existingXMIFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    ModelIntegrationUtil.setXmiExists(true);
                    return folderPath;
                }
            }
            if (res instanceof IContainer) {
                ModelIntegrationUtil.copyExistingXMIContent((IContainer)res, xmiFileName, newXMIFile);
            }
            ++n2;
        }
        return null;
    }

    private static IPath copyExistingXMIContentAndDeleteFile(IProject project, String diagramName, IFileStore newXMIFile) throws JavaModelException, CoreException {
        String xmiFileName = String.valueOf(diagramName) + "." + DIAGRAM_FILE_EXTENSION;
        IPath folderPath = ModelIntegrationUtil.copyExistingXMIContent((IContainer)project, xmiFileName, newXMIFile);
        if (folderPath != null) {
            return folderPath;
        }
        IPath projectPath = project.getFullPath();
        folderPath = projectPath.append(ModelIntegrationUtil.getDiagramsXMLFolderPath(project));
        IFileStore xmlFileStore = EFS.getLocalFileSystem().getStore(folderPath.append(diagramName).addFileExtension(DIAGRAM_XML_FILE_EXTENSION));
        IFileInfo info = xmlFileStore.fetchInfo();
        if (!info.exists()) {
            xmlFileStore.mkdir(0, null);
        }
        return folderPath;
    }

    public static Diagram createDiagram(PersistenceUnit persistenceUnit, int grid, boolean snap) throws CoreException {
        IPath path = ModelIntegrationUtil.createDiagramPath(persistenceUnit);
        Diagram d = ModelIntegrationUtil.createDiagram(persistenceUnit.getJpaProject().getProject(), path, persistenceUnit.getName(), grid, snap);
        return d;
    }

    public static TransactionalEditingDomain getTransactionalEditingDomain(Diagram diagram) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        return editingDomain;
    }

    public static ResourceSet getResourceSet(Diagram diagram) {
        WeakReference<JpaProject> ref = diagramsToProjects.get(diagram);
        TransactionalEditingDomain defaultTransEditDomain = (TransactionalEditingDomain)((JpaProject)ref.get()).getProject().getAdapter(TransactionalEditingDomain.class);
        ResourceSet resourceSet = defaultTransEditDomain.getResourceSet();
        return resourceSet;
    }

    public static Diagram createDiagram(IProject project, IPath diagramFileName, String diagramName, int grid, boolean snap) {
        TransactionalEditingDomain defaultTransEditDomain = DiagramEditorFactory.createResourceSetAndEditingDomain();
        ResourceSet resourceSet = defaultTransEditDomain.getResourceSet();
        String pathName = diagramFileName.toString();
        URI resourceURI = URI.createFileURI((String)pathName);
        final Resource resource = resourceSet.createResource(resourceURI);
        defaultTransEditDomain.getCommandStack().execute((Command)new RecordingCommand(defaultTransEditDomain){

            protected void doExecute() {
                try {
                    resource.load(null);
                }
                catch (IOException e) {
                    JPADiagramEditorPlugin.logInfo("The diagram file does not exist. It will be created");
                    JPADiagramEditorPlugin.logInfo(e.getLocalizedMessage());
                }
            }
        });
        if (!resource.isLoaded()) {
            return ModelIntegrationUtil.createNewDiagram(defaultTransEditDomain, resourceSet, resource, diagramName, grid, snap);
        }
        EList objs = resource.getContents();
        if (objs == null) {
            return ModelIntegrationUtil.createNewDiagram(defaultTransEditDomain, resourceSet, resource, diagramName, grid, snap);
        }
        for (EObject obj : objs) {
            if (obj == null && !Diagram.class.isInstance(obj)) continue;
            Diagram d = (Diagram)obj;
            diagramsToResources.put(d, resource);
            defaultTransEditDomain.getCommandStack().flush();
            return d;
        }
        return ModelIntegrationUtil.createNewDiagram(defaultTransEditDomain, resourceSet, resource, diagramName, grid, snap);
    }

    private static Diagram createNewDiagram(TransactionalEditingDomain editingDomain, ResourceSet resourceSet, final Resource resource, final String diagramName, final int grid, final boolean snap) {
        final Wrp wrp = new Wrp();
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                Diagram diagram = Graphiti.getPeService().createDiagram(ModelIntegrationUtil.JPA_DIAGRAM_TYPE, diagramName, grid, snap);
                wrp.setObject(diagram);
                resource.getContents().add((Object)diagram);
                try {
                    resource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    JPADiagramEditorPlugin.logError("Cannot create new diagram", e);
                }
            }
        });
        editingDomain.getCommandStack().flush();
        ModelIntegrationUtil.mapDiagramToProject((Diagram)wrp.getObject(), resource);
        return (Diagram)wrp.getObject();
    }

    public static IPath getResourceFolderPath(IProject project) {
        return ModelIntegrationUtil.getEMFResourceFolderPath(project);
    }

    public static IPath getEMFResourceFolderPath(IProject project) {
        return project.getProjectRelativePath().append(DEFAULT_RES_FOLDER);
    }

    public static IPath getDiagramsXMLFolderPath(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return new Path(JPADiagramPropertyPage.getDefaultFolder(project, props));
    }

    public static IPath getDiagramsFolderPath(IProject project) {
        return JPADiagramEditorPlugin.getDefault().getStateLocation();
    }

    public static void mapDiagramToProject(Diagram diagram, JpaProject project) {
        diagramsToProjects.put(diagram, new WeakReference<JpaProject>(project));
    }

    public static void mapDiagramToProject(Diagram diagram, Resource resource) {
        diagramsToResources.put(diagram, resource);
    }

    public static JpaProject removeDiagramProjectMapping(Diagram diagram) {
        WeakReference<JpaProject> ref = diagramsToProjects.remove(diagram);
        diagramsToProviders.remove(diagram);
        if (ref == null) {
            return null;
        }
        return (JpaProject)ref.get();
    }

    public static Resource removeDiagramResourceMapping(Diagram diagram) {
        return diagramsToResources.remove(diagram);
    }

    public static JpaProject getProjectByDiagram(Diagram diagram) {
        WeakReference<JpaProject> ref = diagramsToProjects.get(diagram);
        if (ref == null) {
            return null;
        }
        return (JpaProject)ref.get();
    }

    public static Resource getResourceByDiagram(Diagram diagram) {
        return diagramsToResources.get(diagram);
    }

    public static JPAEditorDiagramTypeProvider getProviderByDiagram(Diagram diagram) {
        WeakReference<JPAEditorDiagramTypeProvider> ref = diagramsToProviders.get(diagram);
        if (ref == null) {
            return null;
        }
        return (JPAEditorDiagramTypeProvider)((Object)ref.get());
    }

    public static void mapDiagramToProvider(Diagram diagram, JPAEditorDiagramTypeProvider provider) {
        diagramsToProviders.put(diagram, new WeakReference<JPAEditorDiagramTypeProvider>(provider));
    }

    public static boolean isXmiExists() {
        return xmiExists;
    }

    public static void setXmiExists(boolean xmiExists) {
        ModelIntegrationUtil.xmiExists = xmiExists;
    }

    private static class Wrp {
        private Object o;

        private Wrp() {
        }

        public Object getObject() {
            return this.o;
        }

        public void setObject(Object o) {
            this.o = o;
        }
    }
}

