/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.preferences;

import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JPAEditorPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String FICTIVE_PROJECT_NAME = "PROJECT NAME";
    private static final String COLLECTIION_TYPE = "java.util.Collection";
    private static final String LIST_TYPE = "java.util.List";
    private static final String SET_TYPE = "java.util.Set";
    private static final String MAP_TYPE = "java.util.Map";
    private StringFieldEditor fDefaultDiagramFolderField;
    private StringFieldEditor fDefaultEntityPackageField;
    private StringFieldEditor fDefaultTableNamePrefix;
    private JPABooleanFieldEditor directEditAffectsClass;
    private RadioGroupFieldEditor entityAccessTypeChooser;
    private RadioGroupFieldEditor defaultCollectionTypeChooser;
    private JPABooleanFieldEditor oneToManyOldStyle;

    public JPAEditorPreferencesPage() {
        super(1);
        this.setPreferenceStore(JPADiagramEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(JPAEditorMessages.JPAEditorPreferencesPage_pageDescription);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.createFolderField(parent);
        this.createEntityPackageField(parent);
        this.createTableNameField(parent);
        this.directEditAffectsClass = new JPABooleanFieldEditor("", JPAEditorMessages.JPAEditorPreferencesPage_directEditAffectsClass, 0, parent);
        this.directEditAffectsClass.setPreferenceName("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultDirectEditClassName");
        this.directEditAffectsClass.getCheckBox(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_directEditAffectsClassTooltip);
        this.addField((FieldEditor)this.directEditAffectsClass);
        this.entityAccessTypeChooser = new RadioGroupFieldEditor("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultEntityAccessType", JPAEditorMessages.JPAEditorPreferencesPage_entityAccessTypeButtonGroupLabel, 1, (String[][])new String[][]{{JPAEditorMessages.JPAEditorPreferencesPage_entityFieldBasedAccessButtonLabel, "field"}, {JPAEditorMessages.JPAEditorPreferencesPage_entityPropertyBasedAccessButtonLabel, "property"}}, parent, true);
        this.entityAccessTypeChooser.setPreferenceStore(this.getPreferenceStore());
        this.entityAccessTypeChooser.getRadioBoxControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_entityAccessTypeButtonGroupTooltip);
        this.addField((FieldEditor)this.entityAccessTypeChooser);
        this.defaultCollectionTypeChooser = new RadioGroupFieldEditor("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultCollectionType", JPAEditorMessages.JPAEditorPreferencesPage_DefaultCollectionTypeSectionTittle, 1, (String[][])new String[][]{{COLLECTIION_TYPE, "collection"}, {LIST_TYPE, "list"}, {SET_TYPE, "set"}, {MAP_TYPE, "map"}}, parent, true);
        this.defaultCollectionTypeChooser.setPreferenceStore(this.getPreferenceStore());
        this.defaultCollectionTypeChooser.getRadioBoxControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultCollectionTypeSectionDescription);
        this.addField((FieldEditor)this.defaultCollectionTypeChooser);
        this.oneToManyOldStyle = new JPABooleanFieldEditor("", JPAEditorMessages.JPAEditorPreferencesPage_oneToManyOldStyle, 0, parent);
        this.oneToManyOldStyle.setPreferenceName("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultOneToManyOldStyle");
        this.oneToManyOldStyle.getCheckBox(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_oneToManyOldStyleTooltip);
        this.addField((FieldEditor)this.oneToManyOldStyle);
    }

    protected void createFolderField(Composite parent) {
        this.fDefaultDiagramFolderField = new CustomStringFieldEditor("org.eclipse.jpt.jpadiagrameditor.ui.diagramfolder", JPAEditorMessages.JPAEditorPreferencesPage_defaultFolderControlLabel, this.getFieldEditorParent()){

            protected IStatus validateValue() {
                return JPAEditorPreferencesPage.validateDefaultFolder("/PROJECT NAME/" + JPAEditorPreferencesPage.this.fDefaultDiagramFolderField.getStringValue().trim(), JPAEditorPreferencesPage.FICTIVE_PROJECT_NAME);
            }
        };
        this.fDefaultDiagramFolderField.getTextControl(parent).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPAEditorPreferencesPage.this.validatePage();
            }
        });
        this.fDefaultDiagramFolderField.getLabelControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_defaultFolderControlTooltip);
        this.addField((FieldEditor)this.fDefaultDiagramFolderField);
        this.fDefaultEntityPackageField = new CustomStringFieldEditor("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultPackage", JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageToUse, this.getFieldEditorParent()){

            protected IStatus validateValue() {
                return JPAEditorPreferencesPage.validateDefaultPackage(JPAEditorPreferencesPage.this.fDefaultEntityPackageField.getStringValue().trim());
            }
        };
    }

    protected void createEntityPackageField(Composite parent) {
        this.fDefaultEntityPackageField.getTextControl(parent).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPAEditorPreferencesPage.this.validatePage();
            }
        });
        this.fDefaultEntityPackageField.getLabelControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        this.addField((FieldEditor)this.fDefaultEntityPackageField);
    }

    protected void createTableNameField(Composite parent) {
        this.fDefaultTableNamePrefix = new CustomStringFieldEditor("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultTableNamePrefix", JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNameLabel, this.getFieldEditorParent()){

            protected IStatus validateValue() {
                return JPAEditorPreferencesPage.validateTableNamePrefix(JPAEditorPreferencesPage.this.fDefaultTableNamePrefix.getStringValue().trim());
            }
        };
        this.fDefaultTableNamePrefix.getTextControl(parent).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPAEditorPreferencesPage.this.validatePage();
            }
        });
        this.fDefaultTableNamePrefix.getLabelControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        this.addField((FieldEditor)this.fDefaultTableNamePrefix);
        this.fDefaultTableNamePrefix.getTextControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
    }

    public static IStatus validateDefaultFolder(String defaultFolder, String projectName) {
        if (StringTools.stringIsEmpty((String)(defaultFolder = defaultFolder.trim()))) {
            return new Status(4, "org.eclipse.jpt.jpadiagrameditor.ui", JPAEditorMessages.JPAEditorPreferencesPage_emptyFolder);
        }
        defaultFolder = String.valueOf('/') + projectName + '/' + defaultFolder;
        if (!defaultFolder.startsWith(String.valueOf('/') + projectName + '/')) {
            return new Status(4, "org.eclipse.jpt.jpadiagrameditor.ui", MessageFormat.format(JPAEditorMessages.JPAEditorPreferencesPage_invalidFolder, String.valueOf('/') + projectName + '/'));
        }
        IStatus res = ResourcesPlugin.getWorkspace().validatePath(defaultFolder, 2);
        return res;
    }

    public static IStatus validateDefaultPackage(String defaultPackage) {
        IStatus validateDefaultPackageStatus = JavaConventions.validatePackageName((String)defaultPackage, (String)"1.5", (String)"1.5");
        if (validateDefaultPackageStatus.getSeverity() != 0) {
            return validateDefaultPackageStatus;
        }
        return new Status(0, "org.eclipse.jpt.jpadiagrameditor.ui", null);
    }

    public static IStatus validateTableNamePrefix(String tableNamePrefix) {
        String s = tableNamePrefix;
        if (StringTools.stringIsEmpty((String)s)) {
            return new Status(0, "org.eclipse.jpt.jpadiagrameditor.ui", null);
        }
        if (Character.isDigit(s.charAt(0))) {
            String message = MessageFormat.format(JPAEditorMessages.JPAEditorPreferencesPage_invalidTableNamePrefix, tableNamePrefix);
            return new Status(4, "org.eclipse.jpt.jpadiagrameditor.ui", message);
        }
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '_') {
                String message = MessageFormat.format(JPAEditorMessages.JPAEditorPreferencesPage_invalidTableNamePrefix, tableNamePrefix);
                return new Status(4, "org.eclipse.jpt.jpadiagrameditor.ui", message);
            }
            ++i;
        }
        return new Status(0, "org.eclipse.jpt.jpadiagrameditor.ui", null);
    }

    protected synchronized void validatePage() {
        IStatus statFolder = JPAEditorPreferencesPage.validateDefaultFolder(this.fDefaultDiagramFolderField.getTextControl(this.getFieldEditorParent()).getText().trim(), FICTIVE_PROJECT_NAME);
        IStatus statPack = JPAEditorPreferencesPage.validateDefaultPackage(this.fDefaultEntityPackageField.getTextControl(this.getFieldEditorParent()).getText().trim());
        IStatus statPref = JPAEditorPreferencesPage.validateTableNamePrefix(this.fDefaultTableNamePrefix.getTextControl(this.getFieldEditorParent()).getText().trim());
        if (statFolder.getSeverity() == 4) {
            this.setErrorMessage(statFolder.getMessage());
            this.setValid(false);
            return;
        }
        if (statPack.getSeverity() == 4) {
            this.setErrorMessage(statPack.getMessage());
            this.setValid(false);
            return;
        }
        if (statPref.getSeverity() == 4) {
            this.setErrorMessage(statPref.getMessage());
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
        if (statPack.getSeverity() == 2) {
            this.setMessage(statPack.getMessage(), 2);
            return;
        }
        if (statPref.getSeverity() == 2) {
            this.setMessage(statPref.getMessage(), 2);
            return;
        }
        this.setMessage(null, 0);
    }

    public abstract class CustomStringFieldEditor
    extends StringFieldEditor {
        String msg;
        String prefixMsg;

        public CustomStringFieldEditor(String propertyName, String labelName, Composite fieldEditorParent) {
            super(propertyName, labelName, fieldEditorParent);
        }

        protected boolean checkState() {
            IStatus stat = this.validateValue();
            if (stat.getSeverity() == 4) {
                return false;
            }
            if (stat.getSeverity() == 2) {
                return true;
            }
            return true;
        }

        protected boolean doCheckState() {
            return true;
        }

        protected abstract IStatus validateValue();
    }

    public class JPABooleanFieldEditor
    extends BooleanFieldEditor {
        public JPABooleanFieldEditor(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public Button getCheckBox(Composite parent) {
            return this.getChangeControl(parent);
        }
    }
}

