/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.util;

import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;

public class GraphicsUpdater {
    private static final int PRIMARY_SHAPE_INDEX = 3;
    private static final int RELATION_SHAPE_CONSTANT = 4;
    private static final int BASIC_SHAPE_INDEX = 5;

    public static int increaseCompartmentHeigth(ContainerShape containerShape, int height) {
        for (Shape shape : containerShape.getChildren()) {
            Iterator iterator = shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof Text)) continue;
                height += 20;
            }
        }
        return height;
    }

    public static void updateContainer(ContainerShape containerShape, int childrenSizeBefore, int containerHeightBefore) {
        int childrenSizeAfter = containerShape.getChildren().size();
        int containerHeightAfter = 0;
        if (childrenSizeBefore == 2) {
            containerHeightBefore = 18;
        }
        containerHeightAfter = containerHeightBefore + (childrenSizeAfter - childrenSizeBefore) / 2 * 20;
        if (!GraphicsUpdater.isCollapsed(containerShape)) {
            containerShape.getGraphicsAlgorithm().setHeight(containerHeightAfter);
        } else {
            containerShape.getGraphicsAlgorithm().setHeight(13);
        }
    }

    public static void updateEntityShape(ContainerShape entityShape) {
        ContainerShape primaryShape = GraphicsUpdater.getPrimaryShape(entityShape);
        ContainerShape relationShape = GraphicsUpdater.getRelationShape(entityShape);
        ContainerShape basicShape = GraphicsUpdater.getBasicShape(entityShape);
        primaryShape.setVisible(!GraphicsUpdater.isEmptyCompartment(primaryShape));
        basicShape.setVisible(!GraphicsUpdater.isEmptyCompartment(basicShape));
        relationShape.setVisible(!GraphicsUpdater.isEmptyCompartment(relationShape));
        relationShape.getGraphicsAlgorithm().setY(GraphicsUpdater.getNextCompartmentY(primaryShape));
        basicShape.getGraphicsAlgorithm().setY(GraphicsUpdater.getNextCompartmentY(relationShape));
    }

    private static boolean isEmptyCompartment(ContainerShape primaryShape) {
        return primaryShape.getChildren().size() <= 2;
    }

    public static void updateEntityHeigth(ContainerShape entityShape) {
        ContainerShape primaryShape = GraphicsUpdater.getPrimaryShape(entityShape);
        ContainerShape relationShape = GraphicsUpdater.getRelationShape(entityShape);
        ContainerShape basicShape = GraphicsUpdater.getBasicShape(entityShape);
        entityShape.getGraphicsAlgorithm().setHeight(30 + primaryShape.getGraphicsAlgorithm().getHeight() + relationShape.getGraphicsAlgorithm().getHeight() + basicShape.getGraphicsAlgorithm().getHeight() + 2);
    }

    public static int getNextCompartmentY(ContainerShape compartmentShape) {
        if (GraphicsUpdater.isEmptyCompartment(compartmentShape)) {
            return compartmentShape.getGraphicsAlgorithm().getY();
        }
        return compartmentShape.getGraphicsAlgorithm().getY() + compartmentShape.getGraphicsAlgorithm().getHeight();
    }

    public static ContainerShape getPrimaryShape(ContainerShape entityShape) {
        EList children = entityShape.getChildren();
        if (children.size() < 4) {
            return null;
        }
        GraphicsAlgorithm alg = ((Shape)children.get(3)).getGraphicsAlgorithm();
        ContainerShape primaryShape = (ContainerShape)Graphiti.getPeService().getActiveContainerPe(alg);
        return primaryShape;
    }

    public static ContainerShape getCompartmentSeparatorShape(ContainerShape compartmentShape) {
        GraphicsAlgorithm alg = ((Shape)compartmentShape.getChildren().get(0)).getGraphicsAlgorithm();
        ContainerShape primarySeparatorShape = (ContainerShape)Graphiti.getPeService().getActiveContainerPe(alg);
        return primarySeparatorShape;
    }

    public static ContainerShape getRelationShape(ContainerShape entityShape) {
        EList children = entityShape.getChildren();
        if (children.size() < 5) {
            return null;
        }
        GraphicsAlgorithm alg = ((Shape)children.get(4)).getGraphicsAlgorithm();
        ContainerShape relationShape = (ContainerShape)Graphiti.getPeService().getActiveContainerPe(alg);
        return relationShape;
    }

    public static ContainerShape getBasicShape(ContainerShape entityShape) {
        EList children = entityShape.getChildren();
        if (children.size() < 6) {
            return null;
        }
        GraphicsAlgorithm alg = ((Shape)children.get(5)).getGraphicsAlgorithm();
        ContainerShape basicShape = (ContainerShape)Graphiti.getPeService().getActiveContainerPe(alg);
        return basicShape;
    }

    public static boolean isCollapsed(ContainerShape compartmentShape) {
        ContainerShape container = compartmentShape.getContainer();
        String result = null;
        if (compartmentShape.equals(GraphicsUpdater.getPrimaryShape(container))) {
            result = Graphiti.getPeService().getPropertyValue((PropertyContainer)container, "primary collapsed");
        } else if (compartmentShape.equals(GraphicsUpdater.getBasicShape(container))) {
            result = Graphiti.getPeService().getPropertyValue((PropertyContainer)container, "basic collapsed");
        } else if (compartmentShape.equals(GraphicsUpdater.getRelationShape(container))) {
            result = Graphiti.getPeService().getPropertyValue((PropertyContainer)container, "relation collapsed");
        }
        return Boolean.toString(true).equals(result);
    }

    public static boolean setCollapsed(ContainerShape compartmentShape, boolean collapsed) {
        ContainerShape container = compartmentShape.getContainer();
        if (compartmentShape.equals(GraphicsUpdater.getPrimaryShape(container))) {
            Graphiti.getPeService().setPropertyValue((PropertyContainer)container, "primary collapsed", Boolean.toString(collapsed));
            return true;
        }
        if (compartmentShape.equals(GraphicsUpdater.getBasicShape(container))) {
            Graphiti.getPeService().setPropertyValue((PropertyContainer)container, "basic collapsed", Boolean.toString(collapsed));
            return true;
        }
        if (compartmentShape.equals(GraphicsUpdater.getRelationShape(container))) {
            Graphiti.getPeService().setPropertyValue((PropertyContainer)container, "relation collapsed", Boolean.toString(collapsed));
            return true;
        }
        return false;
    }

    public static void updateHeader(ContainerShape entityShape, final String newHeader) {
        if (entityShape == null) {
            return;
        }
        EList shapes = entityShape.getChildren();
        Iterator shIt = shapes.iterator();
        Shape headerShape = null;
        while (shIt.hasNext()) {
            headerShape = (Shape)shIt.next();
            String shapeType = Graphiti.getPeService().getPropertyValue((PropertyContainer)headerShape, JPAEditorConstants.PROP_SHAPE_TYPE);
            if (JPAEditorConstants.ShapeType.HEADER.toString().equals(shapeType)) break;
            headerShape = null;
        }
        if (headerShape == null) {
            return;
        }
        GraphicsAlgorithm ga = headerShape.getGraphicsAlgorithm();
        if (ga == null) {
            return;
        }
        final Text txt = (Text)ga.getGraphicsAlgorithmChildren().get(0);
        if (!txt.getValue().equals(newHeader)) {
            TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)txt);
            RecordingCommand rc = new RecordingCommand(ted){

                protected void doExecute() {
                    txt.setValue(newHeader);
                }
            };
            ted.getCommandStack().execute((Command)rc);
        }
    }
}

