/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.internal.SimpleJavaType;
import org.eclipse.jpt.common.utility.internal.SimpleMethodSignature;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class MethodSignatureTests
extends TestCase {
    public MethodSignatureTests(String name) {
        super(name);
    }

    public void testInvalidNameNull() throws Exception {
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature(null);
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidNameEmpty() throws Exception {
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature("");
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidParameterTypesNull() throws Exception {
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature("foo", null);
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidParameterTypesNullItem() throws Exception {
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature("foo", new JavaType[1]);
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidParameterTypesVoidItem() throws Exception {
        SimpleJavaType jt = new SimpleJavaType(Void.TYPE.getName());
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature("foo", new JavaType[]{jt});
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidParameterTypeNamesNull() throws Exception {
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature("foo", null);
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidParameterTypeNamesNullItem() throws Exception {
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature("foo", new String[1]);
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidParameterJavaClassesNull() throws Exception {
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature("foo", null);
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidParameterJavaClassesNullItem() throws Exception {
        boolean exCaught = false;
        try {
            SimpleMethodSignature methodSignature = new SimpleMethodSignature("foo", new Class[1]);
            MethodSignatureTests.fail((String)("invalid MethodSignature: " + methodSignature));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MethodSignatureTests.assertTrue((boolean)exCaught);
    }

    public void testGetSignature0() throws Exception {
        SimpleMethodSignature ms = new SimpleMethodSignature(this.getMethod("method0"));
        MethodSignatureTests.assertEquals((String)"method0()", (String)ms.getSignature());
    }

    public void testGetSignature1() throws Exception {
        SimpleMethodSignature ms = new SimpleMethodSignature(this.getMethod("method1"));
        MethodSignatureTests.assertEquals((String)"method1(int)", (String)ms.getSignature());
    }

    public void testGetSignature2() throws Exception {
        SimpleMethodSignature ms = new SimpleMethodSignature(this.getMethod("method2"));
        MethodSignatureTests.assertEquals((String)"method2(int, java.lang.String)", (String)ms.getSignature());
    }

    public void testGetSignature3() throws Exception {
        SimpleMethodSignature ms = new SimpleMethodSignature(this.getMethod("method3"));
        MethodSignatureTests.assertEquals((String)"method3(int, java.lang.String, java.lang.Object[][])", (String)ms.getSignature());
    }

    public void testGetName() throws Exception {
        SimpleMethodSignature ms = new SimpleMethodSignature(this.getMethod("method2"));
        MethodSignatureTests.assertEquals((String)"method2", (String)ms.getName());
    }

    public void testGetParameterTypes() throws Exception {
        SimpleMethodSignature ms = new SimpleMethodSignature(this.getMethod("method3"));
        Object[] expected = new JavaType[]{new SimpleJavaType("int"), new SimpleJavaType("java.lang.String"), new SimpleJavaType("java.lang.Object", 2)};
        MethodSignatureTests.assertTrue((boolean)Arrays.equals(expected, ms.getParameterTypes()));
    }

    public void testEquals() throws Exception {
        SimpleMethodSignature ms1 = new SimpleMethodSignature(this.getMethod("method3"));
        SimpleMethodSignature ms2 = new SimpleMethodSignature(this.getMethod("method3"));
        MethodSignatureTests.assertNotSame((Object)ms1, (Object)ms2);
        MethodSignatureTests.assertEquals((Object)ms1, (Object)ms1);
        MethodSignatureTests.assertEquals((Object)ms1, (Object)ms2);
        MethodSignatureTests.assertEquals((int)ms1.hashCode(), (int)ms2.hashCode());
        SimpleMethodSignature ms3 = new SimpleMethodSignature(this.getMethod("method2"));
        MethodSignatureTests.assertNotSame((Object)ms1, (Object)ms3);
        MethodSignatureTests.assertFalse((boolean)ms1.equals(ms3));
    }

    public void testClone() throws Exception {
        SimpleMethodSignature ms1 = new SimpleMethodSignature(this.getMethod("method3"));
        SimpleMethodSignature ms2 = (SimpleMethodSignature)ms1.clone();
        MethodSignatureTests.assertNotSame((Object)ms1, (Object)ms2);
        MethodSignatureTests.assertEquals((Object)ms1, (Object)ms2);
    }

    public void testSerialization() throws Exception {
        SimpleMethodSignature ms1 = new SimpleMethodSignature(this.getMethod("method3"));
        SimpleMethodSignature ms2 = TestTools.serialize(ms1);
        MethodSignatureTests.assertNotSame((Object)ms1, (Object)ms2);
        MethodSignatureTests.assertEquals((Object)ms1, (Object)ms2);
    }

    private Method getMethod(String methodName) {
        Method[] methodArray = ((Object)((Object)this)).getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return method;
            }
            ++n2;
        }
        throw new IllegalArgumentException("method not found: " + methodName);
    }

    public void method0() {
    }

    public void method1(int foo) {
    }

    public void method2(int foo, String bar) {
    }

    public void method3(int foo, String bar, Object[][] baz) {
    }

    public void methodA(int foo, String bar) {
    }

    public void methodA(int foo, String bar, String baz) {
    }

    public void methodB(int foo, Object bar) {
    }

    public void methodB(int foo, String bar) {
    }
}

