/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterators;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterators.EnumerationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationIteratorTests
extends TestCase {
    public EnumerationIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        EnumerationIteratorTests.assertEquals((int)this.buildVector().size(), (int)i);
    }

    public void testHasNextUpcast() {
        int i = 0;
        Iterator<Object> stream = this.buildIteratorUpcast();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        EnumerationIteratorTests.assertEquals((int)this.buildVector().size(), (int)i);
    }

    public void testNext() {
        Enumeration<String> enumeration = this.buildEnumeration();
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            EnumerationIteratorTests.assertEquals((String)"bogus element", (String)enumeration.nextElement(), (String)stream.next());
        }
    }

    public void testNextUpcast() {
        Enumeration<String> enumeration = this.buildEnumeration();
        Iterator<Object> stream = this.buildIteratorUpcast();
        while (stream.hasNext()) {
            EnumerationIteratorTests.assertEquals((String)"bogus element", (Object)enumeration.nextElement(), (Object)stream.next());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EnumerationIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        EnumerationIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private Iterator<String> buildIterator() {
        return this.buildIterator(this.buildEnumeration());
    }

    private Iterator<String> buildIterator(Enumeration<String> enumeration) {
        return new EnumerationIterator(enumeration);
    }

    private Enumeration<String> buildEnumeration() {
        return this.buildVector().elements();
    }

    private Vector<String> buildVector() {
        Vector<String> v = new Vector<String>();
        v.addElement("one");
        v.addElement("two");
        v.addElement("three");
        v.addElement("four");
        v.addElement("five");
        v.addElement("six");
        v.addElement("seven");
        v.addElement("eight");
        return v;
    }

    private Iterator<Object> buildIteratorUpcast() {
        return this.buildIteratorUpcast(this.buildEnumeration());
    }

    private Iterator<Object> buildIteratorUpcast(Enumeration<String> enumeration) {
        return new EnumerationIterator(enumeration);
    }
}

