/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal;

import java.io.File;
import java.util.NoSuchElementException;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.editor.EditorTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature.AddAttributeFeatureTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature.AddJPAEntityFeatureTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature.AddRelationFeatureTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature.DeleteRelationFeatureTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature.DirectEditAttributeFeatureTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature.LayoutEntityFeatureTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.modelintegration.util.ModelIntegrationUtilTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.preferences.JPAEditorPreferenceInitializerTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.preferences.JPAEditorPreferencesPageTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.provider.JPAEditorToolBehaviorProviderTest;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.util.JPASolverTest;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={JPAEditorPreferenceInitializerTest.class, JPAEditorPreferencesPageTest.class, AddJPAEntityFeatureTest.class, DirectEditAttributeFeatureTest.class, EditorTest.class, JPAEditorToolBehaviorProviderTest.class, JPASolverTest.class, AddRelationFeatureTest.class, AddAttributeFeatureTest.class, ModelIntegrationUtilTest.class, LayoutEntityFeatureTest.class, DeleteRelationFeatureTest.class})
public class AllJpaEditorTests {
    @BeforeClass
    public static void verifyRequiredJarsExists() throws NoSuchElementException {
        AllJpaEditorTests.verifyJpaJarExists();
        AllJpaEditorTests.verifyEclipseLinkJarExists();
    }

    private static void verifyJpaJarExists() throws NoSuchElementException {
        AllJpaEditorTests.verifyRequiredPropertyExists("org.eclipse.jpt.jpa.jar");
        AllJpaEditorTests.verifyRequiredFileExists("org.eclipse.jpt.jpa.jar");
    }

    private static void verifyEclipseLinkJarExists() throws NoSuchElementException {
        AllJpaEditorTests.verifyRequiredPropertyExists("org.eclipse.jpt.eclipselink.jar");
        AllJpaEditorTests.verifyRequiredFileExists("org.eclipse.jpt.eclipselink.jar");
    }

    private static void verifyRequiredPropertyExists(String propertyName) throws NoSuchElementException {
        if (JPACreateFactory.getSystemProperty(propertyName) == null) {
            throw new NoSuchElementException(AllJpaEditorTests.errorMissingProperty(propertyName));
        }
    }

    private static void verifyRequiredFileExists(String propertyName) throws NoSuchElementException {
        String fileName = JPACreateFactory.getSystemProperty(propertyName);
        if (!new File(fileName).exists()) {
            throw new NoSuchElementException(AllJpaEditorTests.errorJarFileDoesNotExist(fileName));
        }
    }

    private static String errorMissingProperty(String propertyName) {
        return "Missing Java system property: \"" + propertyName + "\"";
    }

    private static String errorJarFileDoesNotExist(String fileName) {
        return "JAR file doesn't exist: \"" + fileName + "\"";
    }
}

