/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.util;

import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPASolver;
import org.junit.Before;
import org.junit.Test;

public class JPASolverTest {
    private IEclipseFacade eclipseFacade;

    @Before
    public void setUp() throws Exception {
        this.eclipseFacade = this.createEclipseFacade();
    }

    @Test
    public void testResourceListenerRegistered() {
        IWorkspace workspace = (IWorkspace)EasyMock.createMock(IWorkspace.class);
        workspace.addResourceChangeListener((IResourceChangeListener)EasyMock.isA(IResourceChangeListener.class), EasyMock.eq((int)22));
        EasyMock.replay((Object[])new Object[]{workspace});
        IEclipseFacade facade = (IEclipseFacade)EasyMock.createMock(IEclipseFacade.class);
        EasyMock.expect((Object)facade.getWorkspace()).andStubReturn((Object)workspace);
        EasyMock.replay((Object[])new Object[]{facade});
        new JPASolver(facade, null);
        EasyMock.verify((Object[])new Object[]{workspace, facade});
    }

    private IFile replayFile() {
        IFile file = (IFile)EasyMock.createMock(IFile.class);
        URI uri = URI.create("file://project//aaa");
        EasyMock.expect((Object)file.getLocationURI()).andStubReturn((Object)uri);
        EasyMock.expect((Object)file.exists()).andStubReturn((Object)true);
        IProject proj = (IProject)EasyMock.createMock(IProject.class);
        EasyMock.expect((Object)proj.getType()).andStubReturn((Object)4);
        EasyMock.expect((Object)file.getType()).andStubReturn((Object)1);
        EasyMock.expect((Object)file.getFullPath()).andStubReturn((Object)new Path("C:\\project\\aaa"));
        IFile clsPath = (IFile)EasyMock.createMock(IFile.class);
        EasyMock.expect((Object)proj.getFile(".classpath")).andStubReturn((Object)clsPath);
        try {
            EasyMock.expect((Object)proj.hasNature("org.eclipse.jdt.core.javanature")).andStubReturn((Object)true);
        }
        catch (CoreException coreException) {}
        EasyMock.expect((Object)file.getProject()).andStubReturn((Object)proj);
        EasyMock.replay((Object[])new Object[]{file, proj});
        return file;
    }

    private JavaPersistentType createJptForResource(IFile file, String name) {
        JavaPersistentType jpt = (JavaPersistentType)EasyMock.createNiceMock(JavaPersistentType.class);
        JpaProject jpaProject = (JpaProject)EasyMock.createNiceMock(JpaProject.class);
        JavaTypeMapping m = (JavaTypeMapping)EasyMock.createNiceMock(JavaTypeMapping.class);
        EasyMock.expect((Object)jpt.getResource()).andStubReturn((Object)file);
        EasyMock.expect((Object)jpt.getJpaProject()).andStubReturn((Object)jpaProject);
        EasyMock.expect((Object)jpt.getMapping()).andStubReturn((Object)m);
        if (name != null) {
            EasyMock.expect((Object)jpt.getName()).andStubReturn((Object)name);
        }
        EasyMock.replay((Object[])new Object[]{jpt, jpaProject});
        return jpt;
    }

    private IEclipseFacade createEclipseFacade() {
        IEclipseFacade facade = (IEclipseFacade)EasyMock.createMock(IEclipseFacade.class);
        return facade;
    }

    private void configureForWorkspace(IEclipseFacade facade) {
        IWorkspace workspace = (IWorkspace)EasyMock.createMock(IWorkspace.class);
        workspace.addResourceChangeListener((IResourceChangeListener)EasyMock.isA(IResourceChangeListener.class), EasyMock.eq((int)16));
        EasyMock.replay((Object[])new Object[]{workspace});
        EasyMock.expect((Object)facade.getWorkspace()).andStubReturn((Object)workspace);
    }

    private IJPAEditorFeatureProvider configureRefreshEditorProvider() {
        IDiagramEditor editor = (IDiagramEditor)EasyMock.createMock(IDiagramEditor.class);
        editor.refresh();
        EasyMock.replay((Object[])new Object[]{editor});
        IDiagramTypeProvider diagramProvider = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)diagramProvider.getDiagramEditor()).andStubReturn((Object)editor);
        EasyMock.replay((Object[])new Object[]{diagramProvider});
        IJPAEditorFeatureProvider provider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)provider.getDiagramTypeProvider()).andStubReturn((Object)diagramProvider);
        return provider;
    }

    private IMarkerDelta replayDelta(IResource resource) {
        IMarkerDelta delta = (IMarkerDelta)EasyMock.createMock(IMarkerDelta.class);
        EasyMock.expect((Object)delta.getResource()).andStubReturn((Object)resource);
        EasyMock.replay((Object[])new Object[]{delta});
        return delta;
    }

    private JPASolver createSolver(IEclipseFacade facade, IJPAEditorUtil util) {
        return new JPASolver(facade, util);
    }

    public static IResourceChangeListener eqResourceListener(IArgumentMatcher matcher) {
        EasyMock.reportMatcher((IArgumentMatcher)matcher);
        return null;
    }

    private IResourceChangeEvent replayEvent(IResource resource) {
        IResourceChangeEvent event = (IResourceChangeEvent)EasyMock.createMock(IResourceChangeEvent.class);
        EasyMock.expect((Object)event.findMarkerDeltas(null, true)).andStubReturn((Object)new IMarkerDelta[]{this.replayDelta(resource)});
        EasyMock.replay((Object[])new Object[]{event});
        return event;
    }

    private IResourceChangeEvent replayEmptyEvent() {
        IResourceChangeEvent event = (IResourceChangeEvent)EasyMock.createMock(IResourceChangeEvent.class);
        EasyMock.expect((Object)event.findMarkerDeltas(null, true)).andStubReturn((Object)new IMarkerDelta[0]);
        EasyMock.replay((Object[])new Object[]{event});
        return event;
    }
}

