/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import org.eclipse.jpt.common.utility.Command;
import org.eclipse.jpt.common.utility.CommandExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalCommandExecutor
implements CommandExecutor {
    protected final ThreadLocal<CommandExecutor> threadLocal;
    protected final CommandExecutor defaultCommandExecutor;

    public ThreadLocalCommandExecutor() {
        this(CommandExecutor.Default.instance());
    }

    public ThreadLocalCommandExecutor(CommandExecutor defaultCommandExecutor) {
        this.defaultCommandExecutor = defaultCommandExecutor;
        this.threadLocal = this.buildThreadLocal();
    }

    protected ThreadLocal<CommandExecutor> buildThreadLocal() {
        return new ThreadLocal<CommandExecutor>();
    }

    @Override
    public void execute(Command command) {
        this.getThreadLocalCommandExecutor().execute(command);
    }

    protected CommandExecutor getThreadLocalCommandExecutor() {
        CommandExecutor ce = this.threadLocal.get();
        return ce != null ? ce : this.defaultCommandExecutor;
    }

    public void set(CommandExecutor commandExecutor) {
        this.threadLocal.set(commandExecutor);
    }

    public String toString() {
        return this.getThreadLocalCommandExecutor().toString();
    }
}

