/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.internal.wizards.JavaProjectWizardPage;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.SchemaLibrary;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorExtensionOptions;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorOptions;
import org.eclipse.jpt.jaxb.core.internal.gen.GenerateJaxbClassesJob;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorExtensionOptionsWizardPage;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorOptionsWizardPage;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorWizardPage;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.SchemaWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDSchema;

public class ClassesGeneratorWizard
extends Wizard
implements IWorkbenchWizard {
    private IJavaProject javaProject;
    private IFile preselectedXsdFile;
    protected IStructuredSelection selection;
    private String destinationFolder;
    private String targetPackage;
    private String catalog;
    private boolean usesMoxy;
    private String[] bindingsFileNames;
    private ClassesGeneratorOptions generatorOptions;
    private ClassesGeneratorExtensionOptions generatorExtensionOptions;
    private JavaProjectWizardPage projectWizardPage;
    private SchemaWizardPage schemaWizardPage;
    private ClassesGeneratorWizardPage settingsPage;
    private ClassesGeneratorOptionsWizardPage optionsPage;
    private ClassesGeneratorExtensionOptionsWizardPage extensionOptionsPage;
    private boolean performsGeneration;

    public ClassesGeneratorWizard() {
        this.performsGeneration = true;
    }

    public ClassesGeneratorWizard(IJavaProject javaProject, IFile xsdFile) {
        this.javaProject = javaProject;
        this.preselectedXsdFile = xsdFile;
        this.performsGeneration = false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(JptJaxbUiMessages.ClassesGeneratorWizard_title);
        this.setDefaultPageImageDescriptor(JptJaxbUiPlugin.getImageDescriptor("full/wizban/newclass_wiz"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        if (this.selection != null) {
            this.javaProject = this.getJavaProjectFromSelection(this.selection);
            this.projectWizardPage = new JavaProjectWizardPage(this.javaProject);
            this.projectWizardPage.setTitle(JptJaxbUiMessages.ClassesGeneratorProjectWizardPage_title);
            this.projectWizardPage.setDescription(JptJaxbUiMessages.ClassesGeneratorProjectWizardPage_desc);
            this.projectWizardPage.setDestinationLabel(JptJaxbUiMessages.JavaProjectWizardPage_destinationProject);
            this.addPage((IWizardPage)this.projectWizardPage);
            if (this.preselectedXsdFile == null) {
                this.preselectedXsdFile = SchemaWizardPage.getSourceSchemaFromSelection(this.selection);
            }
            if (this.preselectedXsdFile == null) {
                this.schemaWizardPage = new SchemaWizardPage(this.selection);
                this.addPage((IWizardPage)this.schemaWizardPage);
            }
        }
        this.settingsPage = this.buildClassesGeneratorPage();
        this.optionsPage = this.buildClassesGeneratorOptionsPage();
        this.extensionOptionsPage = this.buildExtensionOptionsPage();
        this.addPage((IWizardPage)this.settingsPage);
        this.addPage((IWizardPage)this.optionsPage);
        this.addPage((IWizardPage)this.extensionOptionsPage);
    }

    public boolean canFinish() {
        return this.settingsPage.isPageComplete() && this.optionsPage.isPageComplete() && this.extensionOptionsPage.isPageComplete();
    }

    public boolean performFinish() {
        WizardPage currentPage = (WizardPage)this.getContainer().getCurrentPage();
        if (currentPage != null) {
            if (!currentPage.isPageComplete()) {
                return false;
            }
            this.retrieveGeneratorSettings();
            this.retrieveGeneratorOptions();
            this.retrieveGeneratorExtensionOptions();
            IFolder folder = this.getJavaProject().getProject().getFolder(this.destinationFolder);
            this.createFolderIfNotExist(folder);
        }
        if (this.performsGeneration && this.displayOverridingClassesWarning(this.generatorOptions)) {
            this.generateJaxbClasses();
            this.addSchemaToLibrary();
        }
        return true;
    }

    public IJavaProject getJavaProject() {
        if (this.projectWizardPage != null) {
            this.javaProject = this.projectWizardPage.getJavaProject();
        }
        return this.javaProject;
    }

    private JaxbProject getJaxbProject() {
        return JptJaxbCorePlugin.getJaxbProject((IProject)this.getJavaProject().getProject());
    }

    public URI getLocalSchemaUri() {
        if (this.preselectedXsdFile != null) {
            return URI.createFileURI((String)this.preselectedXsdFile.getLocation().toString());
        }
        if (this.schemaWizardPage != null) {
            return this.schemaWizardPage.getLocalSchemaURI();
        }
        return null;
    }

    public String getSchemaLocation() {
        if (this.preselectedXsdFile != null) {
            return URI.createPlatformResourceURI((String)this.preselectedXsdFile.getFullPath().toString(), (boolean)false).toString();
        }
        if (this.schemaWizardPage != null) {
            return this.schemaWizardPage.getSchemaLocation();
        }
        return null;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public boolean usesMoxy() {
        return this.usesMoxy;
    }

    public String[] getBindingsFileNames() {
        return this.bindingsFileNames;
    }

    public ClassesGeneratorOptions getGeneratorOptions() {
        return this.generatorOptions;
    }

    public ClassesGeneratorExtensionOptions getGeneratorExtensionOptions() {
        return this.generatorExtensionOptions;
    }

    public IJavaProject getJavaProjectFromSelection(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IJavaProject) {
            return (IJavaProject)firstElement;
        }
        if (firstElement instanceof IResource) {
            IProject project = ((IResource)firstElement).getProject();
            return this.getJavaProjectFrom(project);
        }
        if (firstElement instanceof IJavaElement) {
            return ((IJavaElement)firstElement).getJavaProject();
        }
        return null;
    }

    private ClassesGeneratorWizardPage buildClassesGeneratorPage() {
        return new ClassesGeneratorWizardPage();
    }

    private ClassesGeneratorOptionsWizardPage buildClassesGeneratorOptionsPage() {
        return new ClassesGeneratorOptionsWizardPage();
    }

    private ClassesGeneratorExtensionOptionsWizardPage buildExtensionOptionsPage() {
        return new ClassesGeneratorExtensionOptionsWizardPage();
    }

    public IJavaProject getJavaProjectFrom(IProject project) {
        return (IJavaProject)((IJavaElement)project.getAdapter(IJavaElement.class));
    }

    private boolean displayOverridingClassesWarning(ClassesGeneratorOptions generatorOptions) {
        if (!this.isOverridingClasses(generatorOptions)) {
            return true;
        }
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)JptJaxbUiMessages.ClassesGeneratorUi_generatingClassesWarningTitle, (String)JptJaxbUiMessages.ClassesGeneratorUi_generatingClassesWarningMessage);
    }

    private boolean isOverridingClasses(ClassesGeneratorOptions generatorOptions) {
        if (generatorOptions == null) {
            throw new NullPointerException();
        }
        return !generatorOptions.showsVersion() && !generatorOptions.showsHelp();
    }

    private void retrieveGeneratorSettings() {
        this.destinationFolder = this.settingsPage.getTargetFolder();
        this.targetPackage = this.settingsPage.getTargetPackage();
        this.catalog = this.settingsPage.getCatalog();
        this.usesMoxy = this.settingsPage.usesMoxy();
        this.bindingsFileNames = this.settingsPage.getBindingsFileNames();
    }

    private void retrieveGeneratorOptions() {
        this.generatorOptions = new ClassesGeneratorOptions();
        this.generatorOptions.setProxy(this.optionsPage.getProxy());
        this.generatorOptions.setProxyFile(this.optionsPage.getProxyFile());
        this.generatorOptions.setUsesStrictValidation(this.optionsPage.usesStrictValidation());
        this.generatorOptions.setMakesReadOnly(this.optionsPage.makesReadOnly());
        this.generatorOptions.setSuppressesPackageInfoGen(this.optionsPage.suppressesPackageInfoGen());
        this.generatorOptions.setSuppressesHeaderGen(this.optionsPage.suppressesHeaderGen());
        this.generatorOptions.setIsVerbose(this.optionsPage.isVerbose());
        this.generatorOptions.setIsQuiet(this.optionsPage.isQuiet());
        this.generatorOptions.setTreatsAsXmlSchema(this.optionsPage.treatsAsXmlSchema());
        this.generatorOptions.setTreatsAsRelaxNg(this.optionsPage.treatsAsRelaxNg());
        this.generatorOptions.setTreatsAsRelaxNgCompact(this.optionsPage.treatsAsRelaxNgCompact());
        this.generatorOptions.setTreatsAsDtd(this.optionsPage.treatsAsDtd());
        this.generatorOptions.setTreatsAsWsdl(this.optionsPage.treatsAsWsdl());
        this.generatorOptions.setShowsVersion(this.optionsPage.showsVersion());
        this.generatorOptions.setShowsHelp(this.optionsPage.showsHelp());
    }

    private void retrieveGeneratorExtensionOptions() {
        this.generatorExtensionOptions = new ClassesGeneratorExtensionOptions();
        this.generatorExtensionOptions.setAllowsExtensions(this.extensionOptionsPage.allowsExtensions());
        this.generatorExtensionOptions.setClasspath(this.extensionOptionsPage.getClasspath());
        this.generatorExtensionOptions.setAdditionalArgs(this.extensionOptionsPage.getAdditionalArgs());
    }

    private void createFolderIfNotExist(IFolder folder) {
        if (folder.exists()) {
            return;
        }
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            JptJaxbUiPlugin.log(e);
            this.logError(NLS.bind((String)JptJaxbUiMessages.ClassesGeneratorWizard_couldNotCreate, (Object)folder.getProjectRelativePath().toOSString()));
        }
    }

    private void generateJaxbClasses() {
        try {
            GenerateJaxbClassesJob job = new GenerateJaxbClassesJob(this.getJavaProject(), this.getLocalSchemaUri().toString(), this.destinationFolder, this.targetPackage, this.catalog, this.usesMoxy, this.bindingsFileNames, this.generatorOptions, this.generatorExtensionOptions);
            job.schedule();
        }
        catch (RuntimeException re) {
            JptJaxbUiPlugin.log(re);
            String msg = re.getMessage();
            String message = msg == null ? re.toString() : msg;
            this.logError(message);
        }
    }

    private void addSchemaToLibrary() {
        JaxbProject jaxbProject = this.getJaxbProject();
        if (jaxbProject == null) {
            return;
        }
        String schemaLocation = this.getSchemaLocation();
        String resolvedUri = XsdUtil.getResolvedUri(null, (String)schemaLocation);
        XSDSchema schema = XSDImpl.buildXSDModel((String)resolvedUri);
        if (schema != null) {
            String schemaNamespace = schema.getTargetNamespace() == null ? "" : schema.getTargetNamespace();
            SchemaLibrary schemaLib = jaxbProject.getSchemaLibrary();
            HashMap<String, String> schemas = new HashMap<String, String>(schemaLib.getSchemaLocations());
            schemas.put(schemaNamespace, schemaLocation);
            schemaLib.setSchemaLocations(schemas);
        }
    }

    protected void logError(String message) {
        this.displayError(message);
    }

    private void displayError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)JptJaxbUiMessages.ClassesGeneratorWizard_errorDialogTitle, (String)message);
    }
}

