/*******************************************************************************
 * Copyright (c) 2010 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.jpa.ui.internal.jpa2;

import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;

/**
 * Flag indicating whether the JPA project supports JPA 2.0.
 */
public class Jpa2_0ProjectFlagModel<T extends JpaNode>
	extends TransformationPropertyValueModel<T, Boolean>
{
	public Jpa2_0ProjectFlagModel(PropertyValueModel<T> jpaProjectModel) { 
		super(jpaProjectModel);
	}

	@Override
	protected Boolean transform_(T value) {
		return Boolean.valueOf(JptJpaCorePlugin.nodeIsJpa2_0Compatible(value));
	}
}
