/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.persistence.details;

import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceUnitMappingFilesComposite
extends Pane<PersistenceUnit> {
    public PersistenceUnitMappingFilesComposite(Pane<? extends PersistenceUnit> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void addMappingFilesList(Composite container) {
        new AddRemoveListPane<PersistenceUnit>((Pane)this, container, this.buildAdapter(), this.buildItemListHolder(), this.buildSelectedItemHolder(), this.buildLabelProvider(), "org.eclipse.jpt.jpa.ui.persistence_general"){

            protected Composite addContainer(Composite parent) {
                parent = super.addContainer(parent);
                PersistenceUnitMappingFilesComposite.this.updateGridData(parent);
                return parent;
            }

            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                PersistenceUnitMappingFilesComposite.this.updateGridData(this.getContainer());
            }
        };
    }

    private void addJPAMappingDescriptor(ObjectListSelectionModel listSelectionModel) {
        IProject project = ((PersistenceUnit)this.getSubject()).getJpaProject().getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator(this.buildValidator());
        dialog.setTitle(JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_mappingFileDialog_title);
        dialog.setMessage(JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_mappingFileDialog_message);
        dialog.addFilter((ViewerFilter)new XmlMappingFileViewerFilter(((PersistenceUnit)this.getSubject()).getJpaProject()));
        dialog.setInput((Object)project);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        SWTUtil.show((Dialog)dialog, this.buildSelectionDialogPostExecution(listSelectionModel));
    }

    private AddRemovePane.Adapter buildAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                PersistenceUnitMappingFilesComposite.this.addJPAMappingDescriptor(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((PersistenceUnit)PersistenceUnitMappingFilesComposite.this.getSubject()).removeSpecifiedMappingFileRef((MappingFileRef)item);
                    ++n2;
                }
            }
        };
    }

    protected Composite addContainer(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        Composite container = this.addPane(parent, (Layout)layout);
        this.updateGridData(container);
        return container;
    }

    private ListValueModel<MappingFileRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"fileName"});
    }

    private ILabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return JptJpaUiPlugin.getImage("full/obj16/jpa-file");
            }

            public String getText(Object element) {
                MappingFileRef mappingFileRef = (MappingFileRef)element;
                String name = mappingFileRef.getFileName();
                if (name == null) {
                    name = JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_ormNoName;
                }
                return name;
            }
        };
    }

    private ListValueModel<MappingFileRef> buildListHolder() {
        return new ListAspectAdapter<PersistenceUnit, MappingFileRef>(this.getSubjectHolder(), new String[]{"specifiedMappingFileRefs"}){

            protected ListIterator<MappingFileRef> listIterator_() {
                return ((PersistenceUnit)this.subject).specifiedMappingFileRefs();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).specifiedMappingFileRefsSize();
            }
        };
    }

    private WritablePropertyValueModel<MappingFileRef> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private PostExecution<ElementTreeSelectionDialog> buildSelectionDialogPostExecution(final ObjectListSelectionModel listSelectionModel) {
        return new PostExecution<ElementTreeSelectionDialog>(){

            public void execute(ElementTreeSelectionDialog dialog) {
                if (dialog.getReturnCode() == 1) {
                    return;
                }
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object result = objectArray[n2];
                    IFile file = (IFile)result;
                    IProject project = file.getProject();
                    IPath runtimePath = JptCommonCorePlugin.getResourceLocator((IProject)project).getRuntimePath(project, file.getFullPath());
                    String fileName = runtimePath.toPortableString();
                    if (!PersistenceUnitMappingFilesComposite.this.mappingFileRefExists(fileName)) {
                        MappingFileRef mappingFileRef = ((PersistenceUnit)PersistenceUnitMappingFilesComposite.this.getSubject()).addSpecifiedMappingFileRef(fileName);
                        listSelectionModel.addSelectedValue((Object)mappingFileRef);
                    }
                    ++n2;
                }
            }
        };
    }

    private boolean mappingFileRefExists(String fileName) {
        ListIterator i = ((PersistenceUnit)this.getSubject()).specifiedMappingFileRefs();
        while (i.hasNext()) {
            MappingFileRef mappingFileRef = (MappingFileRef)i.next();
            if (!mappingFileRef.getFileName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private ISelectionStatusValidator buildValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.jpt.jpa.ui", "");
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof IFolder) {
                        return new Status(4, "org.eclipse.jpt.jpa.ui", "");
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.jpt.jpa.ui", "");
            }
        };
    }

    private void updateGridData(Composite container) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        container.setLayoutData((Object)gridData);
    }
}

