/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.preferences.HTMLUIPreferenceNames;
import org.eclipse.wst.sse.ui.contentassist.StructuredContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationPresenter;

public class JSPStructuredContentAssistProcessor
extends StructuredContentAssistProcessor {
    private char[] fCompletionProposalAutoActivationCharacters;
    private String fAutoActivationEnabledPropertyKey;
    private String fAutoActivationCharactersPropertyKey;
    private String fAutoActivationDelayKey;
    private IContextInformationValidator fContextInformationValidator;

    public JSPStructuredContentAssistProcessor(ContentAssistant assistant, String partitionTypeID, ITextViewer viewer) {
        super(assistant, partitionTypeID, viewer, JSPStructuredContentAssistProcessor.isJavaPartitionType(partitionTypeID) ? PreferenceConstants.getPreferenceStore() : HTMLUIPlugin.getDefault().getPreferenceStore());
        if (JSPStructuredContentAssistProcessor.isJavaPartitionType(partitionTypeID)) {
            this.fAutoActivationEnabledPropertyKey = "content_assist_autoactivation";
            this.fAutoActivationCharactersPropertyKey = "content_assist_autoactivation_triggers_java";
        } else {
            this.fAutoActivationEnabledPropertyKey = HTMLUIPreferenceNames.AUTO_PROPOSE;
            this.fAutoActivationCharactersPropertyKey = HTMLUIPreferenceNames.AUTO_PROPOSE_CODE;
        }
        this.fAutoActivationDelayKey = "autoProposeDelay";
        this.getAutoActivationCharacterPreferences();
        this.updateAutoActivationDelay();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fContextInformationValidator == null) {
            this.fContextInformationValidator = new AttributeContextInformationPresenter();
        }
        return this.fContextInformationValidator;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return super.getCompletionProposalAutoActivationCharacters() != null ? super.getCompletionProposalAutoActivationCharacters() : this.fCompletionProposalAutoActivationCharacters;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(this.fAutoActivationEnabledPropertyKey) || property.equals(this.fAutoActivationCharactersPropertyKey)) {
            this.getAutoActivationCharacterPreferences();
        } else if (property.equals(this.fAutoActivationDelayKey)) {
            this.updateAutoActivationDelay();
        }
    }

    private void updateAutoActivationDelay() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean doAuto = store.getBoolean(this.fAutoActivationEnabledPropertyKey);
        if (doAuto) {
            this.setAutoActivationDelay(store.getInt(this.fAutoActivationDelayKey));
        }
    }

    private void getAutoActivationCharacterPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean doAuto = store.getBoolean(this.fAutoActivationEnabledPropertyKey);
        this.fCompletionProposalAutoActivationCharacters = (char[])(doAuto ? store.getString(this.fAutoActivationCharactersPropertyKey).toCharArray() : null);
    }

    private static boolean isJavaPartitionType(String partitionTypeID) {
        return "org.eclipse.jst.jsp.SCRIPT.JAVA".equals(partitionTypeID) || "org.eclipse.jst.jsp.SCRIPT.JSP_EL".equals(partitionTypeID) || "org.eclipse.jst.jsp.SCRIPT.JSP_EL2".equals(partitionTypeID);
    }
}

