/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.ui.internal.project.facet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProvider;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderFrameworkUi;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryproviderconfig.JAXRSLibraryProviderUtil;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrssharedlibraryconfig.SharedLibraryConfiguratorUtil;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.IJAXRSFacetInstallDataModelProperties;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSSharedLibraryProviderInstallOperationConfig;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSUserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.ws.jaxrs.ui.internal.JAXRSUIPlugin;
import org.eclipse.jst.ws.jaxrs.ui.internal.Messages;
import org.eclipse.jst.ws.jaxrs.ui.internal.project.facet.ServletInformationGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;

public class JAXRSFacetInstallPage
extends DataModelWizardPage
implements IJAXRSFacetInstallDataModelProperties,
IFacetWizardPage {
    private ServletInformationGroup servletInfoGroup;
    private IDialogSettings dialogSettings;
    private IDataModel webAppDataModel;
    private String sEARProject = null;
    private String sWEBProject = null;
    private IWizardContext context;
    private String sTargetRuntime = null;
    private IRuntime targetRuntime = null;
    private boolean bAddToEAR = false;
    private static final String SETTINGS_SERVLET = "servletName";
    private static final String SETTINGS_SERVLET_CLASSNAME = "servletClassname";
    private static final String SETTINGS_URL_MAPPINGS = "urlMappings";
    private static final String SETTINGS_URL_PATTERN = "pattern";
    private Button updateDDCheckBox;
    private Composite composite = null;
    private List<IProject> earProjects = null;
    private IPreset selectedPreset = null;
    private ILibraryProvider currentlySelectedLibraryType;
    private boolean isProjectCreationMode = true;

    public JAXRSFacetInstallPage() {
        super(DataModelFactory.createDataModel((IDataModelProvider)new AbstractDataModelProvider(){}), "jaxrs.facet.install.page");
        this.setTitle(Messages.JAXRSFacetInstallPage_title);
        this.setDescription(Messages.JAXRSFacetInstallPage_description);
        this.dialogSettings = JAXRSUIPlugin.getDefault().getDialogSettings();
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.composite = new Composite(parent, 0);
        GridLayout jaxrsCompositeLayout = new GridLayout(1, false);
        jaxrsCompositeLayout.marginTop = 0;
        jaxrsCompositeLayout.marginBottom = 0;
        jaxrsCompositeLayout.marginRight = 0;
        jaxrsCompositeLayout.marginLeft = 0;
        this.composite.setLayout((Layout)jaxrsCompositeLayout);
        LibraryInstallDelegate librariesInstallDelegate = (LibraryInstallDelegate)this.getDataModel().getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        this.currentlySelectedLibraryType = librariesInstallDelegate == null ? null : librariesInstallDelegate.getLibraryProvider();
        librariesInstallDelegate.getLibraryProviders();
        List providers = librariesInstallDelegate.getLibraryProviders();
        if (providers != null) {
            for (ILibraryProvider provider : providers) {
                JAXRSUserLibraryProviderInstallOperationConfig customConfig;
                if (provider == null || !(provider instanceof LibraryProvider) || provider.isAbstract()) continue;
                LibraryProviderOperationConfig config = librariesInstallDelegate.getLibraryProviderOperationConfig(provider);
                if (config instanceof JAXRSUserLibraryProviderInstallOperationConfig) {
                    customConfig = (JAXRSUserLibraryProviderInstallOperationConfig)config;
                    customConfig.setModel(this.getDataModel());
                    continue;
                }
                if (!(config instanceof JAXRSSharedLibraryProviderInstallOperationConfig)) continue;
                customConfig = (JAXRSSharedLibraryProviderInstallOperationConfig)config;
                customConfig.setModel(this.getDataModel());
            }
        }
        Control librariesComposite = LibraryProviderFrameworkUi.createInstallLibraryPanel((Composite)this.composite, (LibraryInstallDelegate)librariesInstallDelegate, (String)Messages.JAXRSFacetInstallPage_JAXRSImplementationLibrariesFrame);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        librariesComposite.setLayoutData((Object)gd);
        this.updateDDCheckBox = new Button(this.composite, 32);
        this.updateDDCheckBox.setText(Messages.JAXRSFacetInstallPage_UpdateDD);
        this.updateDDCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JAXRSFacetInstallPage.this.servletInfoGroup.setFieldsEnabled(JAXRSFacetInstallPage.this.updateDDCheckBox.getSelection());
            }
        });
        this.servletInfoGroup = new ServletInformationGroup(this.composite, 0);
        this.servletInfoGroup.setDataModel(this.model);
        this.updateUpdateDDState(librariesInstallDelegate.getLibraryProvider().getId());
        this.addModificationListeners();
        return this.composite;
    }

    private void updateUpdateDDState(String libraryProviderID) {
        boolean bUserLibrary = libraryProviderID.equals("jaxrs-user-library-provider");
        if (bUserLibrary) {
            this.updateDDCheckBox.setVisible(this.isJEE6orGreater());
        } else {
            this.updateDDCheckBox.setVisible(this.showUpdateDDCheckBox(libraryProviderID));
        }
        if (this.updateDDCheckBox.getVisible()) {
            boolean selected = !bUserLibrary ? this.getUpdateDDCheckBoxSelected(libraryProviderID) : true;
            this.servletInfoGroup.setFieldsEnabled(selected);
            this.updateDDCheckBox.setSelection(selected);
            this.updateDDCheckBox.getSelection();
        }
        if (this.updateDDCheckBox.getVisible()) {
            this.model.setBooleanProperty("IJAXRSFacetInstallDataModelProperties.UPDATEDD", this.updateDDCheckBox.getSelection());
        } else {
            this.model.setBooleanProperty("IJAXRSFacetInstallDataModelProperties.UPDATEDD", true);
        }
    }

    private boolean isJEE6orGreater() {
        this.sWEBProject = this.context.getProjectName();
        Iterator it = this.context.getSelectedProjectFacets().iterator();
        Object webFacetVersion = null;
        while (it.hasNext()) {
            IProjectFacetVersion pfv = (IProjectFacetVersion)it.next();
            if (!pfv.getProjectFacet().getId().equals("jst.web")) continue;
            webFacetVersion = pfv;
            break;
        }
        return webFacetVersion != null && webFacetVersion.equals(WebUtilities.DYNAMIC_WEB_30);
    }

    private boolean getUpdateDDCheckBoxSelected(String libraryProviderID) {
        return JAXRSLibraryProviderUtil.isUpdateDDCheckBoxSelectedByDefault((String)libraryProviderID);
    }

    private boolean showUpdateDDCheckBox(String libraryProviderID) {
        if (libraryProviderID.equals("jaxrs-user-library-provider")) {
            return true;
        }
        return JAXRSLibraryProviderUtil.isUpdateDDCheckBoxSupportAvailable((String)libraryProviderID);
    }

    private void initializeValues() {
        IDialogSettings root = this.dialogSettings.getSection("org.eclipse.jst.ws.jaxrs.ui.jaxrsFacetInstall");
        if (!this.isProjectCreationMode) {
            IProject[] earProjects;
            String earName;
            IProject webProject = SharedLibraryConfiguratorUtil.getWebProject((IDataModel)this.model);
            if (webProject != null) {
                try {
                    IRuntime runtime;
                    IFacetedProject fProject = ProjectFacetsManager.create((IProject)webProject);
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = fProject.getPrimaryRuntime();
                    if (facetRuntime != null && (runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetRuntime)) != null) {
                        IRuntimeType rtType = runtime.getRuntimeType();
                        if (rtType != null) {
                            this.sTargetRuntime = rtType.getId();
                        }
                        this.model.setStringProperty("IJAXRSFacetInstallDataModelProperties.TARGETRUNTIME", this.sTargetRuntime);
                    }
                }
                catch (CoreException coreException) {}
            }
            if (((earName = this.model.getStringProperty("IJAXRSFacetInstallDataModelProperties.EARPROJECT_NAME")) == null || earName.equals("")) && webProject != null && (earProjects = EarUtilities.getReferencingEARProjects((IProject)webProject)).length > 0) {
                earName = earProjects[0].getName();
                this.bAddToEAR = true;
                this.sEARProject = earName;
                this.model.setBooleanProperty("IJAXRSFacetInstallDataModelProperties.ADD_TO_EAR", true);
                this.model.setStringProperty("IJAXRSFacetInstallDataModelProperties.EARPROJECT_NAME", earName);
            }
        }
        String servletName = null;
        if (root != null) {
            servletName = root.get(SETTINGS_SERVLET);
        }
        if (servletName == null || servletName.equals("")) {
            servletName = (String)this.model.getDefaultProperty("IJAXRSFacetInstallDataModelProperties.SERVLET_NAME");
        }
        this.servletInfoGroup.txtJAXRSServletName.setText(servletName);
        String servletClassname = null;
        String libraryProviderID = "";
        LibraryInstallDelegate librariesInstallDelegate = (LibraryInstallDelegate)this.getDataModel().getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        if (librariesInstallDelegate != null && librariesInstallDelegate.getLibraryProvider() != null) {
            libraryProviderID = librariesInstallDelegate.getLibraryProvider().getId();
        }
        if (root != null) {
            servletClassname = root.get(String.valueOf(libraryProviderID) + SETTINGS_SERVLET_CLASSNAME);
        }
        if (servletClassname == null && (servletClassname = JAXRSLibraryProviderUtil.getServletClassName((String)libraryProviderID)) == null) {
            servletClassname = (String)this.model.getDefaultProperty("IJAXRSFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        }
        this.servletInfoGroup.txtJAXRSServletClassName.setText(servletClassname);
        this.loadURLMappingPatterns(root);
    }

    private void saveSettings() {
        DialogSettings root = new DialogSettings("org.eclipse.jst.ws.jaxrs.ui.jaxrsFacetInstall");
        this.dialogSettings.addSection((IDialogSettings)root);
        root.put(SETTINGS_SERVLET, this.getJAXRSServletName());
        LibraryInstallDelegate librariesInstallDelegate = (LibraryInstallDelegate)this.getDataModel().getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        root.put(new String(String.valueOf(librariesInstallDelegate.getLibraryProvider().getId()) + SETTINGS_SERVLET_CLASSNAME), this.getJAXRSServletClassname());
        DialogSettings mappings = new DialogSettings(SETTINGS_URL_MAPPINGS);
        root.addSection((IDialogSettings)mappings);
        mappings.put(SETTINGS_URL_PATTERN, this.getJAXRSPatterns());
    }

    private String getJAXRSServletName() {
        return this.servletInfoGroup.txtJAXRSServletName.getText().trim();
    }

    private String getJAXRSServletClassname() {
        return this.servletInfoGroup.txtJAXRSServletClassName.getText().trim();
    }

    private String[] getJAXRSPatterns() {
        return this.servletInfoGroup.lstJAXRSServletURLPatterns.getItems();
    }

    public void setConfig(Object config) {
        this.model.removeListener((IDataModelListener)this);
        this.synchHelper.dispose();
        this.model = (IDataModel)config;
        this.model.addListener((IDataModelListener)this);
        this.synchHelper = this.initializeSynchHelper(this.model);
        this.model.setStringProperty("IJAXRSFacetInstallDataModelProperties.EARPROJECT_NAME", this.sEARProject);
        this.model.setStringProperty("IJAXRSFacetInstallDataModelProperties.WEBPROJECT_NAME", this.sWEBProject);
        this.model.setStringProperty("IJAXRSFacetInstallDataModelProperties.TARGETRUNTIME", this.sTargetRuntime);
        this.model.setBooleanProperty("IJAXRSFacetInstallDataModelProperties.ADD_TO_EAR", this.bAddToEAR);
        this.model.setProperty("IJAXRSFacetInstallDataModelProperties.SERVER_IRUNTIME", (Object)this.targetRuntime);
        this.model.setProperty("IJAXRSFacetInstallDataModelProperties.CONFIGURATION_PRESET", (Object)this.selectedPreset);
        this.model.setProperty("IJAXRSFacetInstallDataModelProperties.EARPROJECTS", this.earProjects);
    }

    public void transferStateToConfig() {
        this.saveSettings();
    }

    private void addModificationListeners() {
        this.synchHelper.synchText(this.servletInfoGroup.txtJAXRSServletName, "IJAXRSFacetInstallDataModelProperties.SERVLET_NAME", null);
        this.synchHelper.synchText(this.servletInfoGroup.txtJAXRSServletClassName, "IJAXRSFacetInstallDataModelProperties.SERVLET_CLASSNAME", null);
        this.synchHelper.synchList(this.servletInfoGroup.lstJAXRSServletURLPatterns, "IJAXRSFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", null);
        this.synchHelper.synchCheckbox(this.updateDDCheckBox, "IJAXRSFacetInstallDataModelProperties.UPDATEDD", null);
    }

    private void loadURLMappingPatterns(IDialogSettings root) {
        this.servletInfoGroup.lstJAXRSServletURLPatterns.removeAll();
        IDialogSettings mappings = null;
        if (root != null) {
            mappings = root.getSection(SETTINGS_URL_MAPPINGS);
        }
        String[] patterns = null;
        if (mappings != null) {
            patterns = mappings.getArray(SETTINGS_URL_PATTERN);
        }
        if (patterns == null || patterns.length == 0) {
            patterns = (String[])this.model.getDefaultProperty("IJAXRSFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        }
        int i = 0;
        while (i < patterns.length) {
            this.addItemToList(patterns[i], false);
            ++i;
        }
    }

    private void addItemToList(String pattern, boolean selectMe) {
        this.servletInfoGroup.lstJAXRSServletURLPatterns.add(pattern == null ? "" : pattern);
        if (pattern == null && selectMe) {
            this.servletInfoGroup.lstJAXRSServletURLPatterns.setSelection(this.servletInfoGroup.lstJAXRSServletURLPatterns.getItemCount() - 1);
        }
        this.updateModelForURLPattern();
    }

    private void removeItemFromList(String[] selection) {
        int i = 0;
        while (i < selection.length) {
            String sel = selection[i];
            this.servletInfoGroup.lstJAXRSServletURLPatterns.remove(sel);
            ++i;
        }
        this.updateModelForURLPattern();
    }

    private void updateModelForURLPattern() {
        this.model.setProperty("IJAXRSFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", (Object)this.servletInfoGroup.lstJAXRSServletURLPatterns.getItems());
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJAXRSFacetInstallDataModelProperties.SERVLET_NAME", "IJAXRSFacetInstallDataModelProperties.SERVLET_CLASSNAME", "IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE", "IJAXRSFacetInstallDataModelProperties.UPDATEDD"};
    }

    public void setWizardContext(IWizardContext context) {
        this.context = context;
        this.sWEBProject = context.getProjectName();
        Iterator it = context.getSelectedProjectFacets().iterator();
        IProjectFacetVersion webFacetVersion = null;
        while (it.hasNext()) {
            IProjectFacetVersion pfv = (IProjectFacetVersion)it.next();
            if (!pfv.getProjectFacet().getId().equals("jst.web")) continue;
            webFacetVersion = pfv;
            break;
        }
        if (webFacetVersion != null) {
            try {
                this.webAppDataModel = (IDataModel)context.getConfig(webFacetVersion, IFacetedProject.Action.Type.INSTALL, context.getProjectName());
                if (this.webAppDataModel == null) {
                    IRuntime runtime;
                    this.isProjectCreationMode = false;
                    IProject webProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.sWEBProject);
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt = ProjectFacetsManager.create((IProject)webProject).getPrimaryRuntime();
                    if (rt != null && (runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt)) != null) {
                        this.targetRuntime = runtime;
                        IRuntimeType rtType = runtime.getRuntimeType();
                        if (rtType != null) {
                            this.sTargetRuntime = rtType.getId();
                        }
                        if (webProject != null) {
                            IProject[] referencingEARProjects = EarUtilities.getReferencingEARProjects((IProject)webProject);
                            int size = referencingEARProjects.length;
                            if (size == 1) {
                                String earName = referencingEARProjects[0].getName();
                                this.bAddToEAR = true;
                                this.sEARProject = earName;
                            } else if (size > 1) {
                                String earName;
                                this.bAddToEAR = true;
                                this.earProjects = new ArrayList<IProject>();
                                this.sEARProject = earName = referencingEARProjects[0].getName();
                                int i = 0;
                                while (i < size) {
                                    this.earProjects.add(referencingEARProjects[i]);
                                    ++i;
                                }
                            }
                        }
                    }
                } else {
                    IRuntimeType rtType;
                    IRuntime runtime;
                    BridgedRuntime br;
                    Object oAddToEAR = this.webAppDataModel.getProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR");
                    Object oTargetRuntime = this.webAppDataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    if (oAddToEAR != null && ((Boolean)oAddToEAR).booleanValue()) {
                        this.bAddToEAR = true;
                        Object oEARProjectName = this.webAppDataModel.getProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
                        if (oEARProjectName != null) {
                            this.sEARProject = (String)oEARProjectName;
                        }
                    }
                    if (oTargetRuntime != null && oTargetRuntime instanceof BridgedRuntime && (br = (BridgedRuntime)oTargetRuntime) != null && (runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)br)) != null && (rtType = runtime.getRuntimeType()) != null) {
                        this.sTargetRuntime = rtType.getId();
                    }
                }
                if (this.webAppDataModel != null) {
                    this.webAppDataModel.addListener((IDataModelListener)this);
                }
            }
            catch (CoreException e) {
                JAXRSUIPlugin.log(4, Messages.JAXRSFacetInstallPage_ErrorNoWebAppDataModel, e);
            }
        }
    }

    public void propertyChanged(DataModelEvent event) {
        if (this.webAppDataModel != null) {
            String propertyName = event.getPropertyName();
            if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
                this.model.setStringProperty("IJAXRSFacetInstallDataModelProperties.WEBCONTENT_DIR", event.getProperty().toString());
            } else if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
                this.model.setBooleanProperty("IJAXRSFacetInstallDataModelProperties.ADD_TO_EAR", ((Boolean)event.getProperty()).booleanValue());
            } else if (propertyName.equals("IFacetDataModelProperties.FACET_PROJECT_NAME")) {
                this.model.setStringProperty("IJAXRSFacetInstallDataModelProperties.WEBPROJECT_NAME", event.getProperty().toString());
            } else if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME")) {
                this.model.setStringProperty("IJAXRSFacetInstallDataModelProperties.EARPROJECT_NAME", event.getProperty().toString());
            } else if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE") && event.getProperty() != null) {
                LibraryInstallDelegate librariesInstallDelegate = (LibraryInstallDelegate)this.getDataModel().getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
                String libraryProviderID = librariesInstallDelegate.getLibraryProvider().getId();
                ILibraryProvider thisProvider = librariesInstallDelegate.getLibraryProvider();
                try {
                    if (this.currentlySelectedLibraryType != thisProvider) {
                        this.currentlySelectedLibraryType = thisProvider;
                        this.updateUpdateDDState(libraryProviderID);
                        this.updateServletClassName(libraryProviderID);
                    }
                }
                catch (Exception exception) {}
            }
        }
        super.propertyChanged(event);
    }

    private void updateServletClassName(String libraryProviderID) {
        this.servletInfoGroup.txtJAXRSServletClassName.setText(JAXRSLibraryProviderUtil.getServletClassName((String)libraryProviderID));
    }

    public void dispose() {
        if (this.webAppDataModel != null) {
            this.webAppDataModel.removeListener((IDataModelListener)this);
        }
        super.dispose();
    }

    protected void restoreDefaultSettings() {
        this.initializeValues();
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    public boolean isPageComplete() {
        LibraryInstallDelegate librariesInstallDelegate = (LibraryInstallDelegate)this.getDataModel().getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        if (librariesInstallDelegate == null) {
            throw new IllegalArgumentException("LibraryInstallDelegate is expected to be non-null");
        }
        return super.isPageComplete() && librariesInstallDelegate.validate().getSeverity() != 4;
    }

    private void setChildrenEnabled(Composite parentComposite, boolean enabled) {
        Control[] wsdlControls = parentComposite.getChildren();
        int i = 0;
        while (i < wsdlControls.length) {
            wsdlControls[i].setEnabled(enabled);
            ++i;
        }
    }
}

