/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.rhino.tests.RequestTest;
import org.eclipse.wst.jsdt.debug.rhino.tests.TestEventHandler;
import org.eclipse.wst.jsdt.debug.rhino.tests.Util;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;

public class FrameRequestTests
extends RequestTest {
    public void testFramesAndFrameLookup() throws Exception {
        this.eventHandler.addSubhandler(new RequestTest.SetBreakpointHandler((RequestTest)this, new int[]{6}));
        this.eventHandler.addSubhandler(new RequestTest.FrameCheckHandler(this));
        String script = Util.getTestSource("scripts", "script1.js");
        FrameRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        this.evalScript(script, 2);
    }

    public void testFramesAndFrameLookupAndEvaluate() throws Exception {
        this.eventHandler.addSubhandler(new RequestTest.SetBreakpointHandler((RequestTest)this, new int[]{6}));
        TestEventHandler.Subhandler frameCheckHandler = new TestEventHandler.Subhandler(){

            public String testName() {
                return FrameRequestTests.this.getName();
            }

            public boolean handleEvent(DebugSession debugSession, EventPacket event) {
                if (event.getEvent().equals("break")) {
                    Number threadId = (Number)event.getBody().get("threadId");
                    Number contextId = (Number)event.getBody().get("contextId");
                    RhinoRequest request = new RhinoRequest("frames");
                    request.getArguments().put("threadId", threadId);
                    try {
                        debugSession.send((Packet)request);
                        Response response = debugSession.receiveResponse(request.getSequence(), 10000);
                        FrameRequestTests.assertTrue((boolean)response.isSuccess());
                        Collection frames = (Collection)response.getBody().get("frames");
                        Iterator iterator = frames.iterator();
                        while (iterator.hasNext()) {
                            Number frameId = (Number)iterator.next();
                            request = new RhinoRequest("evaluate");
                            request.getArguments().put("threadId", threadId);
                            request.getArguments().put("contextId", contextId);
                            request.getArguments().put("frameId", frameId);
                            request.getArguments().put("expression", "this");
                            debugSession.send((Packet)request);
                            response = debugSession.receiveResponse(request.getSequence(), 10000);
                            FrameRequestTests.assertTrue((boolean)response.isSuccess());
                            FrameRequestTests.assertTrue((boolean)response.getBody().containsKey("evaluate"));
                        }
                    }
                    catch (DisconnectedException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return false;
            }
        };
        this.eventHandler.addSubhandler(frameCheckHandler);
        String script = Util.getTestSource("scripts", "script1.js");
        FrameRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        this.evalScript(script, 2);
    }
}

