/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkMutableAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaBasicMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasic() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("@Mutable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasicDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkJavaBasicMappingTests(String name) {
        super(name);
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)basicMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"class-instance", (String)((EclipseLinkConvert)basicMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.TemporalType.TIME, (Object)temporal.getValue());
        basicMapping.setConverter(null);
        EclipseLinkJavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)basicMapping.getConverter()).getConverterName());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        EclipseLinkJavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        mutableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutable.getSpecifiedMutable());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutable.getSpecifiedMutable());
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
    }

    public void testSetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(null);
        mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation);
        mutable.setSpecifiedMutable(Boolean.FALSE);
        mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
    }

    public void testIsDefaultMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
    }

    public void testIsDefaultMutableForDate() throws Exception {
        this.createTestEntityWithMutableBasicDate();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
    }

    public void testIsMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
    }
}

