/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmTypeConverterTests
extends EclipseLinkOrmContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @TypeConverter");
            }
        });
    }

    public EclipseLinkOrmTypeConverterTests(String name) {
        super(name);
    }

    public void testUpdateDataType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkTypeConverter.class);
        EclipseLinkTypeConverter ormConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        converterResource.setDataType("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getDataType());
        converterResource.setDataType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        BasicMapping virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        ormConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)virtualBasicMapping.getConverter()).getConverter();
        EclipseLinkTypeConverter javaConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)javaBasicMapping.getConverter()).getConverter();
        javaConverter.setDataType("bar");
        EclipseLinkOrmTypeConverterTests.assertNull((Object)ormConverter);
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getDataType());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmTypeConverterTests.assertNull((Object)virtualBasicMapping.getConverter().getType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getDataType());
    }

    public void testModifyDataType() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkTypeConverter.class);
        EclipseLinkTypeConverter ormConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        ormConverter.setDataType("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getDataType());
        ormConverter.setDataType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
    }

    public void testUpdateObjectType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkTypeConverter.class);
        EclipseLinkTypeConverter ormConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        converterResource.setObjectType("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getObjectType());
        converterResource.setObjectType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        BasicMapping virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        ormConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)virtualBasicMapping.getConverter()).getConverter();
        EclipseLinkTypeConverter javaConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)javaBasicMapping.getConverter()).getConverter();
        javaConverter.setObjectType("bar");
        EclipseLinkOrmTypeConverterTests.assertNull((Object)ormConverter);
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getObjectType());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmTypeConverterTests.assertNull((Object)virtualBasicMapping.getConverter().getType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getObjectType());
    }

    public void testModifyObjectType() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkTypeConverter.class);
        EclipseLinkTypeConverter ormConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        ormConverter.setObjectType("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getObjectType());
        ormConverter.setObjectType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkTypeConverter.class);
        OrmEclipseLinkTypeConverter ormConverter = (OrmEclipseLinkTypeConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        BasicMapping virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkTypeConverter virtualConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)virtualBasicMapping.getConverter()).getConverter();
        EclipseLinkTypeConverter javaConverter = (EclipseLinkTypeConverter)((EclipseLinkConvert)javaBasicMapping.getConverter()).getConverter();
        javaConverter.setName("bar");
        EclipseLinkOrmTypeConverterTests.assertNull((Object)virtualConverter);
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmTypeConverterTests.assertNull((Object)virtualBasicMapping.getConverter().getType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkTypeConverter.class);
        OrmEclipseLinkTypeConverter ormConverter = (OrmEclipseLinkTypeConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
    }
}

