/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaVersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkVersionMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkVersionMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlVersion;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmVersionMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmVersionMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithVersionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableVersionDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public void testUpdateMutable() throws Exception {
        this.createTestEntityWithVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "id");
        OrmEclipseLinkVersionMapping contextVersion = (OrmEclipseLinkVersionMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlVersion resourceVersion = (XmlVersion)resourceEntity.getAttributes().getVersions().get(0);
        EclipseLinkVersionMapping javaVersionMapping = (EclipseLinkVersionMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        javaVersionMapping.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)javaVersionMapping.getMutable().isMutable());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        EclipseLinkVersionMapping virtualContextVersion = (EclipseLinkVersionMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)virtualContextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualContextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)virtualContextVersion.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)javaVersionMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        EclipseLinkBasicMapping contextBasic = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)javaVersionMapping.getMutable().isMutable());
    }

    public void testUpdateMutableDate() throws Exception {
        this.createTestEntityWithMutableVersionDate();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "myDate");
        OrmEclipseLinkVersionMapping contextVersion = (OrmEclipseLinkVersionMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlVersion resourceVersion = (XmlVersion)resourceEntity.getAttributes().getVersions().get(0);
        EclipseLinkVersionMapping javaVersionMapping = (EclipseLinkVersionMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("myDate").getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        javaVersionMapping.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)javaVersionMapping.getMutable().isMutable());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("myDate");
        EclipseLinkVersionMapping virtualContextVersion = (EclipseLinkVersionMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)virtualContextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)virtualContextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)virtualContextVersion.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)javaVersionMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("myDate");
        EclipseLinkBasicMapping contextBasic = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)javaVersionMapping.getMutable().isMutable());
    }

    public void testModifyMutable() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "basic");
        OrmEclipseLinkVersionMapping contextVersion = (OrmEclipseLinkVersionMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlVersion resourceVersion = (XmlVersion)resourceEntity.getAttributes().getVersions().get(0);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        contextVersion.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        contextVersion.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        contextVersion.getMutable().setSpecifiedMutable(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
    }

    public void testUpdateConvert() throws Exception {
        this.createTestEntityWithVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "id");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion basicResource = (XmlVersion)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        JavaVersionMapping javaVersionMapping = (JavaVersionMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        basicResource.setConvert("myConvert");
        EclipseLinkOrmVersionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"myConvert", (String)basicResource.getConvert());
        basicResource.setConvert(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        javaVersionMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)javaVersionMapping.getConverter()).setSpecifiedConverterName("foo");
        EclipseLinkOrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)javaVersionMapping.getConverter()).getSpecifiedConverterName());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        VersionMapping virtualVersionMapping = (VersionMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmVersionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)virtualVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)virtualVersionMapping.getConverter()).getSpecifiedConverterName());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)javaVersionMapping.getConverter()).getSpecifiedConverterName());
        ((EclipseLinkConvert)javaVersionMapping.getConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmVersionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)virtualVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)virtualVersionMapping.getConverter()).getSpecifiedConverterName());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)javaVersionMapping.getConverter()).getSpecifiedConverterName());
        javaVersionMapping.setConverter(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)virtualVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)javaVersionMapping.getConverter().getType());
    }

    public void testModifyConvert() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "basicMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion basicResource = (XmlVersion)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)basicResource.getConvert());
        ormVersionMapping.setConverter(EclipseLinkConvert.class);
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"", (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormVersionMapping.getConverter().getType());
        ((EclipseLinkConvert)ormVersionMapping.getConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"bar", (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)ormVersionMapping.getConverter()).getSpecifiedConverterName());
        ((EclipseLinkConvert)ormVersionMapping.getConverter()).setSpecifiedConverterName(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormVersionMapping.setConverter(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)basicResource.getConvert());
    }
}

