/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.customization;

import java.util.ListIterator;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.customization.Customization;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.customization.Entity;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.customization.Profiler;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.customization.Weaving;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.customization.EclipseLinkCustomization;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class EclipseLinkCustomizationTests
extends EclipseLinkPersistenceUnitTestCase {
    private Customization customization;
    private ListEvent entitiesEvent;
    private ListEvent sessionCustomizersEvent;
    public static final String ENTITY_TEST = "Employee";
    public static final String ENTITY_TEST_2 = "Address";
    public static final String THROW_EXCEPTIONS_KEY = "eclipselink.orm.throw.exceptions";
    public static final Boolean THROW_EXCEPTIONS_TEST_VALUE = false;
    public static final Boolean THROW_EXCEPTIONS_TEST_VALUE_2 = THROW_EXCEPTIONS_TEST_VALUE == false;
    public static final String WEAVING_LAZY_KEY = "eclipselink.weaving.lazy";
    public static final Boolean WEAVING_LAZY_TEST_VALUE = false;
    public static final Boolean WEAVING_LAZY_TEST_VALUE_2 = WEAVING_LAZY_TEST_VALUE == false;
    public static final String WEAVING_CHANGE_TRACKING_KEY = "eclipselink.weaving.changetracking";
    public static final Boolean WEAVING_CHANGE_TRACKING_TEST_VALUE = false;
    public static final Boolean WEAVING_CHANGE_TRACKING_TEST_VALUE_2 = WEAVING_CHANGE_TRACKING_TEST_VALUE == false;
    public static final String WEAVING_FETCH_GROUPS_KEY = "eclipselink.weaving.fetchgroups";
    public static final Boolean WEAVING_FETCH_GROUPS_TEST_VALUE = false;
    public static final Boolean WEAVING_FETCH_GROUPS_TEST_VALUE_2 = WEAVING_FETCH_GROUPS_TEST_VALUE == false;
    public static final String WEAVING_INTERNAL_KEY = "eclipselink.weaving.internal";
    public static final Boolean WEAVING_INTERNAL_TEST_VALUE = false;
    public static final Boolean WEAVING_INTERNAL_TEST_VALUE_2 = WEAVING_INTERNAL_TEST_VALUE == false;
    public static final String WEAVING_EAGER_KEY = "eclipselink.weaving.eager";
    public static final Boolean WEAVING_EAGER_TEST_VALUE = true;
    public static final Boolean WEAVING_EAGER_TEST_VALUE_2 = WEAVING_EAGER_TEST_VALUE == false;
    public static final String VALIDATION_ONLY_KEY = "eclipselink.validation-only";
    public static final Boolean VALIDATION_ONLY_TEST_VALUE = false;
    public static final Boolean VALIDATION_ONLY_TEST_VALUE_2 = VALIDATION_ONLY_TEST_VALUE == false;
    public static final String VALIDATE_SCHEMA_KEY = "eclipselink.orm.validate.schema";
    public static final Boolean VALIDATE_SCHEMA_TEST_VALUE = true;
    public static final Boolean VALIDATE_SCHEMA_TEST_VALUE_2 = VALIDATE_SCHEMA_TEST_VALUE == false;
    private static final String SESSION_CUSTOMIZER_KEY = "eclipselink.session.customizer";
    private static final String SESSION_CUSTOMIZER_TEST_VALUE = "java.lang.String";
    private static final String SESSION_CUSTOMIZER_TEST_VALUE_2 = "java.lang.Boolean";
    public static final String WEAVING_KEY = "eclipselink.weaving";
    public static final Weaving WEAVING_TEST_VALUE = Weaving.false_;
    public static final Weaving WEAVING_TEST_VALUE_2 = Weaving.static_;
    public static final String CUSTOMIZER_KEY = "eclipselink.descriptor.customizer.Employee";
    public static final String CUSTOMIZER_TEST_VALUE = "acme.sessions.DescriptorCustomizer";
    public static final String CUSTOMIZER_TEST_VALUE_2 = "acme.sessions.Customizer";
    private static final String PROFILER_KEY = "eclipselink.profiler";
    private static final Profiler PROFILER_TEST_VALUE = Profiler.query_monitor;
    private static final String PROFILER_TEST_VALUE_2 = "custom.profiler.test";
    public static final String EXCEPTION_HANDLER_KEY = "eclipselink.exception-handler";
    public static final String EXCEPTION_HANDLER_TEST_VALUE = "acme.CustomSessionEventListener";
    public static final String EXCEPTION_HANDLER_TEST_VALUE_2 = "oracle.sessions.CustomSessionEventListener";

    public EclipseLinkCustomizationTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.customization = this.subject.getCustomization();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.customization.addPropertyChangeListener("throwExceptions", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingLazy", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingChangeTracking", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingFetchGroups", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingInternal", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingEager", propertyChangeListener);
        this.customization.addPropertyChangeListener("weaving", propertyChangeListener);
        this.customization.addPropertyChangeListener("validationOnly", propertyChangeListener);
        this.customization.addPropertyChangeListener("validateSchema", propertyChangeListener);
        this.customization.addPropertyChangeListener("descriptorCustomizer", propertyChangeListener);
        this.customization.addPropertyChangeListener("sessionCustomizer", propertyChangeListener);
        this.customization.addPropertyChangeListener("profiler", propertyChangeListener);
        this.customization.addPropertyChangeListener("exceptionHandler", propertyChangeListener);
        ListChangeListener sessionCustomizersChangeListener = this.buildSessionCustomizersChangeListener();
        this.customization.addListChangeListener("sessionCustomizers", sessionCustomizersChangeListener);
        ListChangeListener entitiesChangeListener = this.buildEntitiesChangeListener();
        this.customization.addListChangeListener("entities", entitiesChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 13;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitSetProperty("misc.property.1", "value.1");
        this.persistenceUnitSetProperty(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(WEAVING_INTERNAL_KEY, WEAVING_INTERNAL_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(WEAVING_EAGER_KEY, WEAVING_EAGER_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(VALIDATION_ONLY_KEY, VALIDATION_ONLY_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(VALIDATE_SCHEMA_KEY, VALIDATE_SCHEMA_TEST_VALUE.toString());
        this.persistenceUnitSetProperty("misc.property.2", "value.2");
        this.persistenceUnitSetProperty(SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(WEAVING_KEY, WEAVING_TEST_VALUE);
        this.persistenceUnitSetProperty("misc.property.3", "value.3");
        this.persistenceUnitSetProperty("misc.property.4", "value.4");
        this.persistenceUnitSetProperty(CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE);
        this.persistenceUnitSetProperty(PROFILER_KEY, PROFILER_TEST_VALUE);
        this.persistenceUnitSetProperty(EXCEPTION_HANDLER_KEY, EXCEPTION_HANDLER_TEST_VALUE);
    }

    private ListChangeListener buildEntitiesChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
                EclipseLinkCustomizationTests.this.entityAdded(e);
            }

            public void itemsRemoved(ListRemoveEvent e) {
                EclipseLinkCustomizationTests.this.entityRemoved(e);
            }

            public void itemsReplaced(ListReplaceEvent e) {
                EclipseLinkCustomizationTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void itemsMoved(ListMoveEvent e) {
                EclipseLinkCustomizationTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void listCleared(ListClearEvent e) {
                EclipseLinkCustomizationTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void listChanged(ListChangeEvent e) {
                EclipseLinkCustomizationTests.this.throwUnsupportedOperationException((ListEvent)e);
            }
        };
    }

    private ListChangeListener buildSessionCustomizersChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
                EclipseLinkCustomizationTests.this.sessionCustomizerAdded(e);
            }

            public void itemsRemoved(ListRemoveEvent e) {
                EclipseLinkCustomizationTests.this.sessionCustomizerRemoved(e);
            }

            public void itemsReplaced(ListReplaceEvent e) {
                EclipseLinkCustomizationTests.this.sessionCustomizerReplaced(e);
            }

            public void itemsMoved(ListMoveEvent e) {
                EclipseLinkCustomizationTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void listCleared(ListClearEvent e) {
                EclipseLinkCustomizationTests.this.sessionCustomizerListCleared(e);
            }

            public void listChanged(ListChangeEvent e) {
                EclipseLinkCustomizationTests.this.throwUnsupportedOperationException((ListEvent)e);
            }
        };
    }

    protected void clearEvent() {
        super.clearEvent();
        this.entitiesEvent = null;
        this.sessionCustomizersEvent = null;
    }

    void entityAdded(ListAddEvent e) {
        this.entitiesEvent = e;
    }

    void entityRemoved(ListRemoveEvent e) {
        this.entitiesEvent = e;
    }

    void sessionCustomizerAdded(ListAddEvent e) {
        this.sessionCustomizersEvent = e;
    }

    void sessionCustomizerRemoved(ListRemoveEvent e) {
        this.sessionCustomizersEvent = e;
    }

    void sessionCustomizerReplaced(ListReplaceEvent e) {
        this.sessionCustomizersEvent = e;
    }

    void sessionCustomizerListCleared(ListClearEvent e) {
        this.sessionCustomizersEvent = e;
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("throwExceptions")) {
            this.customization.setThrowExceptions((Boolean)newValue);
        } else if (propertyName.equals("weavingLazy")) {
            this.customization.setWeavingLazy((Boolean)newValue);
        } else if (propertyName.equals("weavingChangeTracking")) {
            this.customization.setWeavingChangeTracking((Boolean)newValue);
        } else if (propertyName.equals("weavingFetchGroups")) {
            this.customization.setWeavingFetchGroups((Boolean)newValue);
        } else if (propertyName.equals("weavingInternal")) {
            this.customization.setWeavingInternal((Boolean)newValue);
        } else if (propertyName.equals("weavingEager")) {
            this.customization.setWeavingEager((Boolean)newValue);
        } else if (propertyName.equals("validationOnly")) {
            this.customization.setValidationOnly((Boolean)newValue);
        } else if (propertyName.equals("validateSchema")) {
            this.customization.setValidateSchema((Boolean)newValue);
        } else if (propertyName.equals("exceptionHandler")) {
            this.customization.setExceptionHandler((String)newValue);
        } else if (propertyName.equals("sessionCustomizer")) {
            this.customization.addSessionCustomizer((String)newValue);
        } else if (propertyName.equals("weaving")) {
            this.customization.setWeaving((Weaving)newValue);
        } else if (propertyName.equals("profiler")) {
            if (newValue.getClass().isEnum()) {
                this.customization.setProfiler((Profiler)newValue);
            } else {
                this.customization.setProfiler((String)newValue);
            }
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("throwExceptions")) {
            modelValue = this.customization.getThrowExceptions();
        } else if (propertyName.equals("weaving")) {
            modelValue = this.customization.getWeaving();
        } else if (propertyName.equals("weavingLazy")) {
            modelValue = this.customization.getWeavingLazy();
        } else if (propertyName.equals("weavingChangeTracking")) {
            modelValue = this.customization.getWeavingChangeTracking();
        } else if (propertyName.equals("weavingFetchGroups")) {
            modelValue = this.customization.getWeavingFetchGroups();
        } else if (propertyName.equals("weavingInternal")) {
            modelValue = this.customization.getWeavingInternal();
        } else if (propertyName.equals("weavingEager")) {
            modelValue = this.customization.getWeavingEager();
        } else if (propertyName.equals("validationOnly")) {
            modelValue = this.customization.getValidationOnly();
        } else if (propertyName.equals("validateSchema")) {
            modelValue = this.customization.getValidateSchema();
        } else if (propertyName.equals("exceptionHandler")) {
            modelValue = this.customization.getExceptionHandler();
        } else if (propertyName.equals("profiler")) {
            modelValue = this.customization.getProfiler();
        } else if (propertyName.equals("sessionCustomizer")) {
            ListIterator iterator = this.customization.sessionCustomizers();
            if (iterator.hasNext()) {
                modelValue = iterator.next();
            }
        } else if (propertyName.equals("descriptorCustomizer")) {
            modelValue = this.customization.getDescriptorCustomizerOf(ENTITY_TEST);
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected void verifyPutProperty(String propertyName, Object expectedValue) throws Exception {
        Object expectedValue_ = expectedValue;
        if (propertyName.equals("profiler")) {
            expectedValue_ = expectedValue != null && expectedValue.getClass().isEnum() ? this.getPropertyStringValueOf(PROFILER_TEST_VALUE) : expectedValue;
        }
        super.verifyPutProperty(propertyName, expectedValue_);
    }

    protected PersistenceUnitProperties getModel() {
        return this.customization;
    }

    public void testEntitiesList() throws Exception {
        this.clearEvent();
        this.customization.addEntity(ENTITY_TEST_2);
        EclipseLinkCustomizationTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        EclipseLinkCustomizationTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getListName(), (String)"entities");
        this.clearEvent();
        this.customization.removeEntity(ENTITY_TEST_2);
        EclipseLinkCustomizationTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        EclipseLinkCustomizationTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getListName(), (String)"entities");
    }

    public void testSessionCustomizersList() throws Exception {
        this.clearEvent();
        String className = this.customization.addSessionCustomizer(SESSION_CUSTOMIZER_TEST_VALUE_2);
        EclipseLinkCustomizationTests.assertNotNull((String)"No Event Fired.", (Object)this.sessionCustomizersEvent);
        EclipseLinkCustomizationTests.assertEquals((String)"Wrong Event.", (String)this.sessionCustomizersEvent.getListName(), (String)"sessionCustomizers");
        this.clearEvent();
        this.customization.removeSessionCustomizer(className);
        EclipseLinkCustomizationTests.assertNotNull((String)"No Event Fired.", (Object)this.sessionCustomizersEvent);
        EclipseLinkCustomizationTests.assertEquals((String)"Wrong Event.", (String)this.sessionCustomizersEvent.getListName(), (String)"sessionCustomizers");
    }

    public void testSetThrowExceptions() throws Exception {
        this.verifyModelInitialized(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE);
        this.verifySetProperty(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE, THROW_EXCEPTIONS_TEST_VALUE_2);
    }

    public void testAddRemoveThrowExceptions() throws Exception {
        this.verifyAddRemoveProperty(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE, THROW_EXCEPTIONS_TEST_VALUE_2);
    }

    public void testSetWeavingLazy() throws Exception {
        this.verifyModelInitialized(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE);
        this.verifySetProperty(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE, WEAVING_LAZY_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingLazy() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE, WEAVING_LAZY_TEST_VALUE_2);
    }

    public void testSetWeavingChangeTracking() throws Exception {
        this.verifyModelInitialized(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE);
        this.verifySetProperty(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE, WEAVING_CHANGE_TRACKING_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingChangeTracking() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE, WEAVING_CHANGE_TRACKING_TEST_VALUE_2);
    }

    public void testSetWeavingFetchGroups() throws Exception {
        this.verifyModelInitialized(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE);
        this.verifySetProperty(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE, WEAVING_FETCH_GROUPS_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingFetchGroups() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE, WEAVING_FETCH_GROUPS_TEST_VALUE_2);
    }

    public void testSetWeavingInternal() throws Exception {
        this.verifyModelInitialized(WEAVING_INTERNAL_KEY, WEAVING_INTERNAL_TEST_VALUE);
        this.verifySetProperty(WEAVING_INTERNAL_KEY, WEAVING_INTERNAL_TEST_VALUE, WEAVING_INTERNAL_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingInternal() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_INTERNAL_KEY, WEAVING_INTERNAL_TEST_VALUE, WEAVING_INTERNAL_TEST_VALUE_2);
    }

    public void testSetWeavingEager() throws Exception {
        this.verifyModelInitialized(WEAVING_EAGER_KEY, WEAVING_EAGER_TEST_VALUE);
        this.verifySetProperty(WEAVING_EAGER_KEY, WEAVING_EAGER_TEST_VALUE, WEAVING_EAGER_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingEager() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_EAGER_KEY, WEAVING_EAGER_TEST_VALUE, WEAVING_EAGER_TEST_VALUE_2);
    }

    public void testSetSessionCustomizer() throws Exception {
        this.verifyModelInitialized(SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE);
        this.verifySetSessionCustomizationProperty("sessionCustomizer", SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE, SESSION_CUSTOMIZER_TEST_VALUE_2);
    }

    public void testAddRemoveSessionCustomizer() throws Exception {
        this.verifyAddRemoveSessionCustomizationProperty("sessionCustomizer", SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE, SESSION_CUSTOMIZER_TEST_VALUE_2);
    }

    public void testSetWeaving() throws Exception {
        this.verifyModelInitialized(WEAVING_KEY, WEAVING_TEST_VALUE);
        this.verifySetProperty(WEAVING_KEY, WEAVING_TEST_VALUE, WEAVING_TEST_VALUE_2);
    }

    public void testAddRemoveWeaving() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_KEY, WEAVING_TEST_VALUE, WEAVING_TEST_VALUE_2);
    }

    public void testSetValidationOnly() throws Exception {
        this.verifyModelInitialized(VALIDATION_ONLY_KEY, VALIDATION_ONLY_TEST_VALUE);
        this.verifySetProperty(VALIDATION_ONLY_KEY, VALIDATION_ONLY_TEST_VALUE, VALIDATION_ONLY_TEST_VALUE_2);
    }

    public void testAddRemoveValidationOnly() throws Exception {
        this.verifyAddRemoveProperty(VALIDATION_ONLY_KEY, VALIDATION_ONLY_TEST_VALUE, VALIDATION_ONLY_TEST_VALUE_2);
    }

    public void testSetValidateSchema() throws Exception {
        this.verifyModelInitialized(VALIDATE_SCHEMA_KEY, VALIDATE_SCHEMA_TEST_VALUE);
        this.verifySetProperty(VALIDATE_SCHEMA_KEY, VALIDATE_SCHEMA_TEST_VALUE, VALIDATE_SCHEMA_TEST_VALUE_2);
    }

    public void testAddRemoveValidateSchema() throws Exception {
        this.verifyAddRemoveProperty(VALIDATE_SCHEMA_KEY, VALIDATE_SCHEMA_TEST_VALUE, VALIDATE_SCHEMA_TEST_VALUE_2);
    }

    public void testSetExceptionHandler() throws Exception {
        this.verifyModelInitialized(EXCEPTION_HANDLER_KEY, EXCEPTION_HANDLER_TEST_VALUE);
        this.verifySetProperty(EXCEPTION_HANDLER_KEY, EXCEPTION_HANDLER_TEST_VALUE, EXCEPTION_HANDLER_TEST_VALUE_2);
    }

    public void testAddRemoveExceptionHandler() throws Exception {
        this.verifyAddRemoveProperty(EXCEPTION_HANDLER_KEY, EXCEPTION_HANDLER_TEST_VALUE, EXCEPTION_HANDLER_TEST_VALUE_2);
    }

    public void testSetCustomization() throws Exception {
        this.verifyModelInitialized(CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE);
        this.verifySetCustomizationProperty("descriptorCustomizer", CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE, CUSTOMIZER_TEST_VALUE_2);
    }

    public void testAddRemoveCustomization() throws Exception {
        this.verifyAddRemoveCustomizationProperty("descriptorCustomizer", CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE, CUSTOMIZER_TEST_VALUE_2);
    }

    public void testSetProfiler() throws Exception {
        this.verifyModelInitialized(PROFILER_KEY, this.getPropertyStringValueOf(PROFILER_TEST_VALUE));
        this.verifySetProperty(PROFILER_KEY, PROFILER_TEST_VALUE, PROFILER_TEST_VALUE_2);
        this.verifySetProfiler(PROFILER_KEY, PROFILER_TEST_VALUE, PROFILER_TEST_VALUE_2);
    }

    public void testAddRemoveProfiler() throws Exception {
        this.verifyAddRemoveProperty(PROFILER_KEY, PROFILER_TEST_VALUE, PROFILER_TEST_VALUE_2);
    }

    protected void verifySetProfiler(String elKey, Object testValue1, Object testValue2) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(elKey);
        String propertyName = this.getModel().propertyIdOf(property);
        this.clearEvent();
        this.setProperty(propertyName, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
        this.clearEvent();
        this.customization.setProfiler(null);
        EclipseLinkCustomizationTests.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, null);
        this.clearEvent();
        this.setProperty(propertyName, testValue1.toString());
        EclipseLinkCustomizationTests.assertNotNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, this.getPropertyStringValueOf(testValue1));
        this.clearEvent();
        this.customization.setProfiler(null);
        EclipseLinkCustomizationTests.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, null);
    }

    protected void verifySetSessionCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        this.persistenceUnitSetProperty(key, testValue2, true);
        ++this.propertiesTotal;
        this.verifyPutSessionCustomizerProperty(propertyName, testValue1);
    }

    protected void verifyAddRemoveSessionCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.getPersistenceUnit().removeProperty(key, (String)testValue1);
        EclipseLinkCustomizationTests.assertFalse((boolean)this.customization.sessionCustomizerExists(key));
        EclipseLinkCustomizationTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitSetProperty(key, testValue1, true);
        this.verifyPutSessionCustomizerProperty(propertyName, testValue1);
    }

    protected void verifyPutSessionCustomizerProperty(String propertyName, Object expectedValue) throws Exception {
        EclipseLinkCustomizationTests.assertNotNull((String)"No Event Fired.", (Object)this.sessionCustomizersEvent);
        this.verifySessionCustomizerEvent(propertyName, expectedValue);
    }

    protected void verifySessionCustomizerEvent(String propertyName, Object expectedValue) throws Exception {
        EclipseLinkCustomization customization = (EclipseLinkCustomization)this.sessionCustomizersEvent.getSource();
        EclipseLinkCustomizationTests.assertTrue((boolean)customization.sessionCustomizerExists((String)expectedValue));
    }

    protected void verifySetCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        this.persistenceUnitSetProperty(key, testValue2);
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue2);
        this.clearEvent();
        this.setCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
    }

    protected void verifyAddRemoveCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.getPersistenceUnit().removeProperty(key);
        EclipseLinkCustomizationTests.assertNull((Object)this.getPersistenceUnit().getProperty(key));
        EclipseLinkCustomizationTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, null);
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitSetProperty(key, testValue1);
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
        this.persistenceUnitSetProperty(key, testValue2);
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue2);
    }

    protected void verifyPutCustomizationProperty(String propertyName, String entityName, Object expectedValue) throws Exception {
        this.verifyEvent(propertyName);
        this.verifyCustomizationEvent(propertyName, entityName, expectedValue);
    }

    protected void verifyCustomizationEvent(String propertyName, String entityName, Object expectedValue) throws Exception {
        Entity entity = (Entity)this.propertyChangedEvent.getNewValue();
        if (propertyName.equals("descriptorCustomizer")) {
            EclipseLinkCustomizationTests.assertEquals((Object)expectedValue, (Object)entity.getParent().getDescriptorCustomizerOf(entityName));
            EclipseLinkCustomizationTests.assertEquals((Object)expectedValue, (Object)this.customization.getDescriptorCustomizerOf(entityName));
        } else {
            this.throwMissingDefinition("verifyCustomizationEvent", propertyName);
        }
    }

    protected void setCustomizationProperty(String propertyName, String entityName, Object newValue) throws NoSuchFieldException {
        if (propertyName.equals("descriptorCustomizer")) {
            this.customization.setDescriptorCustomizerOf(entityName, (String)newValue);
        } else {
            this.throwMissingDefinition("setCustomizationProperty", propertyName);
        }
    }
}

