/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.options;

import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.options.Options;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsValueModelTests
extends EclipseLinkPersistenceUnitTestCase {
    private Options options;
    private WritablePropertyValueModel<Boolean> includeDescriptorQueriesHolder;
    private PropertyChangeListener includeDescriptorQueriesListener;
    private PropertyChangeEvent includeDescriptorQueriesEvent;
    public static final Boolean INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE = Boolean.FALSE;

    public OptionsValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.options = this.subject.getOptions();
        SimplePropertyValueModel optionsHolder = new SimplePropertyValueModel((Object)this.options);
        this.includeDescriptorQueriesHolder = this.buildIncludeDescriptorQueriesAA((PropertyValueModel<Options>)optionsHolder);
        this.includeDescriptorQueriesListener = this.buildIncludeDescriptorQueriesChangeListener();
        this.includeDescriptorQueriesHolder.addPropertyChangeListener("value", this.includeDescriptorQueriesListener);
        this.includeDescriptorQueriesEvent = null;
    }

    public void testHasListeners() {
        AbstractModel subjectOptions = (AbstractModel)this.options;
        PropertyAspectAdapter includeDescriptorQueriesAA = (PropertyAspectAdapter)this.includeDescriptorQueriesHolder;
        OptionsValueModelTests.assertTrue((boolean)includeDescriptorQueriesAA.hasAnyPropertyChangeListeners("value"));
        OptionsValueModelTests.assertTrue((boolean)subjectOptions.hasAnyPropertyChangeListeners("includeDescriptorQueriesy"));
        includeDescriptorQueriesAA.removePropertyChangeListener("value", this.includeDescriptorQueriesListener);
        OptionsValueModelTests.assertFalse((boolean)subjectOptions.hasAnyPropertyChangeListeners("includeDescriptorQueriesy"));
        OptionsValueModelTests.assertFalse((boolean)includeDescriptorQueriesAA.hasAnyPropertyChangeListeners("value"));
    }

    protected void populatePu() {
        this.persistenceUnitSetProperty("eclipselink.session.include.descriptor.queries", INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE);
    }

    protected PersistenceUnitProperties getModel() {
        return this.options;
    }

    private WritablePropertyValueModel<Boolean> buildIncludeDescriptorQueriesAA(PropertyValueModel<Options> subjectHolder) {
        return new PropertyAspectAdapter<Options, Boolean>(subjectHolder, new String[]{"includeDescriptorQueriesy"}){

            protected Boolean buildValue_() {
                return ((Options)this.subject).getIncludeDescriptorQueries();
            }

            protected void setValue_(Boolean enumValue) {
                ((Options)this.subject).setIncludeDescriptorQueries(enumValue);
            }
        };
    }

    private PropertyChangeListener buildIncludeDescriptorQueriesChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                OptionsValueModelTests.this.includeDescriptorQueriesEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyIncludeDescriptorQueriesAAValue(INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE);
        OptionsValueModelTests.assertEquals((Object)Options.DEFAULT_SESSION_INCLUDE_DESCRIPTOR_QUERIES, (Object)this.options.getDefaultIncludeDescriptorQueries());
    }

    public void testSetValue() throws Exception {
        this.includeDescriptorQueriesEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.includeDescriptorQueriesHolder, "value");
        Boolean newIncludeDescriptorQueries = INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE == false;
        this.includeDescriptorQueriesHolder.setValue((Object)newIncludeDescriptorQueries);
        this.verifyIncludeDescriptorQueriesAAValue(newIncludeDescriptorQueries);
        OptionsValueModelTests.assertNotNull((Object)this.includeDescriptorQueriesEvent);
    }

    public void testSetNullValue() {
        String notDeleted = "Property not deleted";
        this.includeDescriptorQueriesEvent = null;
        this.includeDescriptorQueriesHolder.setValue(null);
        this.verifyIncludeDescriptorQueriesAAValue(null);
        OptionsValueModelTests.assertNotNull((Object)this.includeDescriptorQueriesEvent);
        this.verifyPuHasNotProperty("eclipselink.session.include.descriptor.queries", notDeleted);
    }

    protected void verifyIncludeDescriptorQueriesAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.options.getIncludeDescriptorQueries(), (PropertyValueModel)this.includeDescriptorQueriesHolder, "eclipselink.session.include.descriptor.queries");
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

