/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v1_1.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v1_1.context.orm.EclipseLink1_1OrmContextModelTestCase;

public class EclipseLink1_1OrmTransientMappingTests
extends EclipseLink1_1OrmContextModelTestCase {
    public EclipseLink1_1OrmTransientMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithTransientMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Transient"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transient").append(CR);
            }
        });
    }

    public void testCreateTransientMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmTransientMappingTests.assertTrue((boolean)persistentAttribute.isVirtual());
        EclipseLink1_1OrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute.getMappingKey());
        ormPersistentType.addSpecifiedAttribute("transient", "id");
        persistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmTransientMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink1_1OrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute.getMappingKey());
        EclipseLink1_1OrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute.getMapping().getKey());
    }
}

